/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.site;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureImport;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.isite.ISite;
import org.eclipse.pde.internal.core.isite.ISiteBuildFeature;
import org.eclipse.pde.internal.core.isite.ISiteBuildModel;
import org.eclipse.pde.internal.core.isite.ISiteFeature;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.core.site.WorkspaceSiteBuildModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.build.BuildSiteJob;
import org.eclipse.pde.internal.ui.editor.ModelDataTransfer;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.site.BuiltFeaturesWizard;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.TablePart;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class FeatureSection
extends TableSection {
    private TableViewer fFeaturesViewer;
    private ISiteModel fModel;
    private ISiteBuildModel fBuildModel;
    private TablePart fFeaturesTablePart;

    public FeatureSection(PDEFormPage formPage, Composite parent) {
        super(formPage, parent, 128, new String[]{PDEPlugin.getResourceString("SiteEditor.add"), PDEPlugin.getResourceString("SiteEditor.buildAll")});
        this.getSection().setText(PDEPlugin.getResourceString("SiteEditor.FeatureSection.header"));
        this.getSection().setDescription(PDEPlugin.getResourceString("SiteEditor.FeatureSection.desc"));
        PDEPlugin.getDefault().getLabelProvider().connect(this);
    }

    public void dispose() {
        super.dispose();
        this.fModel.removeModelChangedListener((IModelChangedListener)this);
        if (this.fBuildModel != null) {
            this.fBuildModel.removeModelChangedListener((IModelChangedListener)this);
        }
        PDEPlugin.getDefault().getLabelProvider().disconnect(this);
    }

    public void createClient(Section section, FormToolkit toolkit) {
        this.fModel = (ISiteModel)this.getPage().getModel();
        this.fModel.addModelChangedListener((IModelChangedListener)this);
        this.fBuildModel = this.fModel.getBuildModel();
        if (this.fBuildModel != null) {
            this.fBuildModel.addModelChangedListener((IModelChangedListener)this);
        }
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.createViewerPartControl(container, 2, 2, toolkit);
        this.fFeaturesTablePart = this.getTablePart();
        this.fFeaturesViewer = this.fFeaturesTablePart.getTableViewer();
        this.fFeaturesViewer.setContentProvider((IContentProvider)new FeatureContentProvider());
        this.fFeaturesViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.fFeaturesViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                ISiteBuildFeature f1 = (ISiteBuildFeature)e1;
                ISiteBuildFeature f2 = (ISiteBuildFeature)e2;
                int compare = super.compare(viewer, (Object)f1.getId(), (Object)f2.getId());
                return compare == 0 ? super.compare(viewer, (Object)f1.getVersion(), (Object)f2.getVersion()) : compare;
            }
        });
        Transfer[] transfers = new Transfer[]{ModelDataTransfer.getInstance()};
        this.fFeaturesViewer.addDragSupport(4, transfers, new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                ISelection selection = FeatureSection.this.fFeaturesViewer.getSelection();
                if (selection == null || selection.isEmpty()) {
                    event.doit = false;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                IStructuredSelection ssel = (IStructuredSelection)FeatureSection.this.fFeaturesViewer.getSelection();
                event.data = ssel.toArray();
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
        this.fFeaturesViewer.setInput((Object)this.fBuildModel);
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        this.refresh();
    }

    public void fillContextMenu(IMenuManager manager) {
        final ISelection selection = this.fFeaturesViewer.getSelection();
        if (selection != null && !selection.isEmpty()) {
            manager.add((IAction)new Action(PDEPlugin.getResourceString("SiteEditor.publish")){

                public void run() {
                    Object[] selected = ((IStructuredSelection)selection).toArray();
                    int i = 0;
                    while (i < selected.length) {
                        ISiteBuildFeature sbFeature = (ISiteBuildFeature)selected[i];
                        ISiteFeature feature = FeatureSection.findMatchingSiteFeature(FeatureSection.this.fModel, sbFeature);
                        try {
                            if (feature == null) {
                                FeatureSection.this.fModel.getSite().addFeatures(new ISiteFeature[]{FeatureSection.createSiteFeature(FeatureSection.this.fModel, sbFeature)});
                            }
                        }
                        catch (CoreException coreException) {}
                        ++i;
                    }
                }
            });
            manager.add((IAction)new Action(PDEPlugin.getResourceString("SiteEditor.build")){

                public void run() {
                    List list = ((IStructuredSelection)selection).toList();
                    FeatureSection.this.handleBuild(list.toArray(new ISiteBuildFeature[list.size()]));
                }
            });
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)new Action(PDEPlugin.getResourceString("SiteEditor.remove")){

                public void run() {
                    FeatureSection.this.doGlobalAction(ActionFactory.DELETE.getId());
                }
            });
        }
        manager.add(this.getPage().getPDEEditor().getContributor().getGlobalAction(ActionFactory.COPY.getId()));
        manager.add(this.getPage().getPDEEditor().getContributor().getGlobalAction(ActionFactory.PASTE.getId()));
        manager.add((IContributionItem)new Separator());
        manager.add(this.getPage().getPDEEditor().getContributor().getRevertAction());
        manager.add(this.getPage().getPDEEditor().getContributor().getSaveAction());
    }

    public void refresh() {
        this.fFeaturesViewer.refresh();
        int featureCount = this.fFeaturesViewer.getTable().getItemCount();
        this.fFeaturesTablePart.setButtonEnabled(1, featureCount > 0);
        super.refresh();
    }

    public void modelChanged(IModelChangedEvent event) {
        this.markStale();
    }

    public void commit(boolean onSave) {
        if (onSave && this.fBuildModel instanceof WorkspaceSiteBuildModel && ((WorkspaceSiteBuildModel)this.fBuildModel).isDirty()) {
            ((WorkspaceSiteBuildModel)this.fBuildModel).save();
        }
        super.commit(onSave);
    }

    public boolean canPaste(Clipboard clipboard) {
        return false;
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.handleRemoveFeature();
            return false;
        }
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleRemoveFeature();
            return true;
        }
        return false;
    }

    public void handleNewFeature() {
        Table control = this.fFeaturesViewer.getTable();
        BusyIndicator.showWhile((Display)control.getDisplay(), (Runnable)new Runnable((Control)control){
            private final /* synthetic */ Control val$control;
            {
                this.val$control = control;
            }

            public void run() {
                BuiltFeaturesWizard wizard = new BuiltFeaturesWizard(FeatureSection.this.fBuildModel);
                WizardDialog dialog = new WizardDialog(this.val$control.getShell(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    FeatureSection.this.markDirty();
                }
            }
        });
    }

    private boolean handleRemoveFeature() {
        try {
            IStructuredSelection ssel = (IStructuredSelection)this.fFeaturesViewer.getSelection();
            if (ssel != null && ssel.size() > 0) {
                ISiteBuildFeature[] sbFeatures = ssel.toList().toArray(new ISiteBuildFeature[ssel.size()]);
                int i = 0;
                while (i < sbFeatures.length) {
                    ISiteFeature feature = FeatureSection.findMatchingSiteFeature(this.fModel, sbFeatures[i]);
                    if (feature != null) {
                        ISite site = this.fModel.getSite();
                        site.removeFeatures(new ISiteFeature[]{feature});
                    }
                    ++i;
                }
                this.fBuildModel.getSiteBuild().removeFeatures(sbFeatures);
                this.markDirty();
                return true;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public static ISiteFeature findMatchingSiteFeature(ISiteModel model, ISiteBuildFeature sbfeature) {
        ISiteFeature[] sfeatures = model.getSite().getFeatures();
        int j = 0;
        while (j < sfeatures.length) {
            ISiteFeature sfeature = sfeatures[j];
            if (FeatureSection.matches(sfeature, sbfeature)) {
                return sfeature;
            }
            ++j;
        }
        return null;
    }

    private static boolean matches(ISiteFeature sfeature, ISiteBuildFeature sbfeature) {
        return sbfeature.getId().equals(sfeature.getId()) && sbfeature.getVersion().equals(sfeature.getVersion());
    }

    public static ISiteFeature createSiteFeature(ISiteModel model, ISiteBuildFeature sbfeature) throws CoreException {
        ISiteFeature sfeature = model.getFactory().createFeature();
        sfeature.setId(sbfeature.getId());
        sfeature.setVersion(sbfeature.getVersion());
        sfeature.setURL(model.getBuildModel().getSiteBuild().getFeatureLocation() + "/" + sbfeature.getId() + "_" + sbfeature.getVersion() + ".jar");
        IFeature refFeature = sbfeature.getReferencedFeature();
        sfeature.setOS(refFeature.getOS());
        sfeature.setWS(refFeature.getWS());
        sfeature.setArch(refFeature.getArch());
        sfeature.setNL(refFeature.getNL());
        sfeature.setIsPatch(FeatureSection.isFeaturePatch(refFeature));
        return sfeature;
    }

    private static boolean isFeaturePatch(IFeature feature) {
        IFeatureImport[] imports = feature.getImports();
        int i = 0;
        while (i < imports.length) {
            if (imports[i].isPatch()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void selectionChanged(IStructuredSelection selection) {
        this.getPage().getPDEEditor().setSelection((ISelection)selection);
    }

    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleNewFeature();
                break;
            }
            case 1: {
                this.handleBuild(this.fBuildModel.getSiteBuild().getFeatures());
            }
        }
    }

    private void handleBuild(ISiteBuildFeature[] sbFeatures) {
        if (sbFeatures.length == 0) {
            return;
        }
        IFeatureModel[] models = this.getFeatureModels(sbFeatures);
        if (models.length == 0) {
            return;
        }
        BuildSiteJob job = new BuildSiteJob(models, this.fModel.getUnderlyingResource().getProject(), this.fBuildModel);
        job.setUser(true);
        job.schedule();
    }

    private IFeatureModel[] getFeatureModels(ISiteBuildFeature[] sbFeatures) {
        ArrayList<IFeatureModel> list = new ArrayList<IFeatureModel>();
        int i = 0;
        while (i < sbFeatures.length) {
            IFeatureModel model;
            IFeature feature = sbFeatures[i].getReferencedFeature();
            if (feature != null && (model = feature.getModel()) != null && model.getUnderlyingResource() != null) {
                list.add(model);
            }
            ++i;
        }
        return list.toArray(new IFeatureModel[list.size()]);
    }

    public boolean isDirty() {
        if (this.fBuildModel != null && ((WorkspaceSiteBuildModel)this.fBuildModel).isDirty()) {
            return true;
        }
        return super.isDirty();
    }

    class FeatureContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        FeatureContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ISiteBuildModel model = (ISiteBuildModel)inputElement;
            return model.getSiteBuild().getFeatures();
        }
    }
}

