/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import java.util.Vector;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.ui.editor.ModifiedTextPropertyDescriptor;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public abstract class SchemaObjectPropertySource
implements IPropertySource {
    private Object sourceObject;

    public SchemaObjectPropertySource(Object object) {
        this.sourceObject = object;
    }

    protected PropertyDescriptor createComboBoxPropertyDescriptor(String id, String name, String[] choices) {
        if (this.isEditable()) {
            return new ComboBoxPropertyDescriptor((Object)id, name, choices);
        }
        return new PropertyDescriptor((Object)id, name);
    }

    protected PropertyDescriptor createTextPropertyDescriptor(String id, String name) {
        if (this.isEditable()) {
            return new ModifiedTextPropertyDescriptor(id, name);
        }
        return new PropertyDescriptor((Object)id, name);
    }

    protected Object getNonzeroValue(Object value) {
        if (value != null) {
            return value;
        }
        return "";
    }

    public Object getSourceObject() {
        return this.sourceObject;
    }

    public boolean isEditable() {
        ISchemaObject schemaObject = (ISchemaObject)this.getSourceObject();
        ISchema schema = schemaObject.getSchema();
        return schema != null ? schema.isEditable() : false;
    }

    public void setSourceObject(Object newSourceObject) {
        this.sourceObject = newSourceObject;
    }

    protected IPropertyDescriptor[] toDescriptorArray(Vector result) {
        Object[] array = new IPropertyDescriptor[result.size()];
        result.copyInto(array);
        return array;
    }

    class ComboProvider
    extends LabelProvider {
        private String property;
        private String[] table;

        public ComboProvider(String property, String[] table) {
            this.property = property;
            this.table = table;
        }

        public String getText(Object obj) {
            Integer index = (Integer)SchemaObjectPropertySource.this.getPropertyValue(this.property);
            return this.table[index];
        }
    }
}

