/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;

public class SchemaDoubleClickStrategy
implements ITextDoubleClickStrategy {
    protected ITextViewer fText;
    protected int fPos;
    protected int fStartPos;
    protected int fEndPos;
    protected static char[] fgBrackets = new char[]{'(', ')', '\"', '\"'};

    public void doubleClicked(ITextViewer part) {
        this.fPos = part.getSelectedRange().x;
        if (this.fPos < 0) {
            return;
        }
        this.fText = part;
        if (!this.selectComment()) {
            this.selectWord();
        }
    }

    protected boolean matchComment() {
        IDocument doc = this.fText.getDocument();
        try {
            int pos = this.fPos;
            char c = ' ';
            while (pos >= 0) {
                c = doc.getChar(pos);
                if (Character.isWhitespace(c) || c == '\"') break;
                --pos;
            }
            if (c != '\"') {
                return false;
            }
            this.fStartPos = pos;
            pos = this.fPos;
            int length = doc.getLength();
            c = ' ';
            while (pos < length) {
                c = doc.getChar(pos);
                if (Character.isWhitespace(c) || c == '\"') break;
                ++pos;
            }
            if (c != '\"') {
                return false;
            }
            this.fEndPos = pos;
            return true;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    protected boolean matchWord() {
        IDocument doc = this.fText.getDocument();
        try {
            char c;
            int pos = this.fPos;
            while (pos >= 0) {
                c = doc.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
                --pos;
            }
            this.fStartPos = pos;
            pos = this.fPos;
            int length = doc.getLength();
            while (pos < length) {
                c = doc.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
                ++pos;
            }
            this.fEndPos = pos;
            return true;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    protected boolean selectComment() {
        if (this.matchComment()) {
            this.fText.setSelectedRange(this.fStartPos + 1, this.fEndPos);
            return true;
        }
        return false;
    }

    protected void selectWord() {
        if (this.matchWord()) {
            this.fText.setSelectedRange(this.fStartPos + 1, this.fEndPos);
        }
    }
}

