/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin.rows;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.IContextPart;
import org.eclipse.pde.internal.ui.editor.plugin.rows.ReferenceAttributeRow;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ResourceAttributeRow
extends ReferenceAttributeRow {
    public ResourceAttributeRow(IContextPart part, ISchemaAttribute att) {
        super(part, att);
    }

    protected boolean isReferenceModel() {
        return !this.part.getPage().getModel().isEditable();
    }

    protected void openReference() {
        IFile file = this.getFile();
        if (file != null && file.exists()) {
            try {
                IDE.openEditor((IWorkbenchPage)PDEPlugin.getActivePage(), (IFile)file, (boolean)true);
            }
            catch (PartInitException e) {
                PDEPlugin.logException(e);
            }
        } else {
            Display.getCurrent().beep();
        }
    }

    private IFile getFile() {
        String value = this.text.getText();
        if (value.length() == 0) {
            return null;
        }
        IPath path = this.getProject().getFullPath().append(value);
        return this.getProject().getWorkspace().getRoot().getFile(path);
    }

    protected void browse() {
        final IProject project = this.part.getPage().getPDEEditor().getCommonProject();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setInput((Object)project.getWorkspace());
        IFile file = this.getFile();
        if (file != null) {
            dialog.setInitialSelection((Object)file);
        }
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IProject) {
                    return ((IProject)element).equals((Object)project);
                }
                return true;
            }
        });
        dialog.setAllowMultiple(false);
        dialog.setTitle(PDEPlugin.getResourceString("ResourceAttributeCellEditor.title"));
        dialog.setMessage(PDEPlugin.getResourceString("ResourceAttributeCellEditor.message"));
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection != null && selection.length > 0 && selection[0] instanceof IFile) {
                    return new Status(0, PDEPlugin.getPluginId(), 0, "", null);
                }
                return new Status(4, PDEPlugin.getPluginId(), 4, "", null);
            }
        });
        if (dialog.open() == 0) {
            file = (IFile)dialog.getFirstResult();
            String value = file.getProjectRelativePath().toString();
            this.text.setText(value);
        }
    }
}

