/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangeProvider;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginReference;
import org.eclipse.pde.internal.core.plugin.ImportObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.parts.ComboPart;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IPartSelectionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class MatchSection
extends PDESection
implements IPartSelectionListener {
    private FormEntry versionText;
    private Button reexportButton;
    private Button optionalButton;
    private Label matchLabel;
    private ComboPart matchCombo;
    protected IPluginReference currentImport;
    protected IStructuredSelection multiSelection;
    private boolean blockChanges = false;
    private boolean addReexport = true;
    private boolean osgiMode = false;
    public static final String KEY_OPTIONAL = "ManifestEditor.MatchSection.optional";
    public static final String KEY_REEXPORT = "ManifestEditor.MatchSection.reexport";
    public static final String KEY_VERSION = "ManifestEditor.MatchSection.version";
    public static final String KEY_RULE = "ManifestEditor.MatchSection.rule";
    public static final String KEY_NONE = "ManifestEditor.MatchSection.none";
    public static final String KEY_PERFECT = "ManifestEditor.MatchSection.perfect";
    public static final String KEY_EQUIVALENT = "ManifestEditor.MatchSection.equivalent";
    public static final String KEY_COMPATIBLE = "ManifestEditor.MatchSection.compatible";
    public static final String KEY_GREATER = "ManifestEditor.MatchSection.greater";
    public static final String KEY_VERSION_FORMAT = "ManifestEditor.PluginSpecSection.versionFormat";
    public static final String KEY_VERSION_TITLE = "ManifestEditor.PluginSpecSection.versionTitle";

    public MatchSection(PDEFormPage formPage, Composite parent, boolean addReexport) {
        super(formPage, parent, 128);
        this.getSection().setText(PDEPlugin.getResourceString("MatchSection.title"));
        this.getSection().setDescription(PDEPlugin.getResourceString("MatchSection.desc"));
        this.addReexport = addReexport;
        this.createClient(this.getSection(), formPage.getEditor().getToolkit());
    }

    public MatchSection(PDEFormPage formPage, Composite parent) {
        this(formPage, parent, true);
    }

    public void commit(boolean onSave) {
        if (!this.isDirty()) {
            return;
        }
        if ((this.currentImport != null || this.multiSelection != null) && this.versionText.getText().isEnabled()) {
            this.versionText.commit();
            String value = this.versionText.getValue();
            int match = 0;
            if (value != null && value.length() > 0) {
                this.applyVersion(value);
                match = this.getMatch();
            }
            this.applyMatch(match);
        }
        super.commit(onSave);
    }

    public void cancelEdit() {
        this.versionText.cancelEdit();
        super.cancelEdit();
    }

    public void createClient(Section section, FormToolkit toolkit) {
        Composite container = toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 9;
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        container.setLayout((Layout)layout);
        if (this.addReexport) {
            this.createOptionalButton(toolkit, container);
            this.createReexportButton(toolkit, container);
        }
        this.versionText = new FormEntry(container, toolkit, PDEPlugin.getResourceString(KEY_VERSION), null, false);
        this.versionText.setFormEntryListener(new FormEntryAdapter(this, this.getPage().getEditor().getEditorSite().getActionBars()){

            public void textValueChanged(FormEntry text) {
                try {
                    String value = text.getValue();
                    if (value != null && value.length() > 0) {
                        if (!MatchSection.this.isOsgiMode()) {
                            PluginVersionIdentifier pvi = new PluginVersionIdentifier(text.getValue());
                            String formatted = pvi.toString();
                            text.setValue(formatted, true);
                            MatchSection.this.applyVersion(formatted);
                        } else {
                            MatchSection.this.applyVersion(value);
                        }
                    } else {
                        MatchSection.this.applyVersion(null);
                    }
                }
                catch (Throwable throwable) {
                    text.setValue(MatchSection.this.currentImport.getVersion(), true);
                    String message = PDEPlugin.getResourceString(MatchSection.KEY_VERSION_FORMAT);
                    MessageDialog.openError((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEPlugin.getResourceString(MatchSection.KEY_VERSION_TITLE), (String)message);
                }
            }

            public void textDirty(FormEntry text) {
                if (MatchSection.this.blockChanges) {
                    return;
                }
                MatchSection.this.markDirty();
                MatchSection.this.blockChanges = true;
                if (!MatchSection.this.isOsgiMode()) {
                    MatchSection.this.resetMatchCombo(MatchSection.this.currentImport);
                }
                MatchSection.this.blockChanges = false;
            }
        });
        this.matchLabel = toolkit.createLabel(container, PDEPlugin.getResourceString(KEY_RULE));
        this.matchLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.matchCombo = new ComboPart();
        this.matchCombo.createControl(container, toolkit, 8);
        this.matchCombo.add(PDEPlugin.getResourceString(KEY_NONE));
        this.matchCombo.add(PDEPlugin.getResourceString(KEY_EQUIVALENT));
        this.matchCombo.add(PDEPlugin.getResourceString(KEY_COMPATIBLE));
        this.matchCombo.add(PDEPlugin.getResourceString(KEY_PERFECT));
        this.matchCombo.add(PDEPlugin.getResourceString(KEY_GREATER));
        this.matchCombo.getControl().setLayoutData((Object)new GridData(768));
        this.matchCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!MatchSection.this.blockChanges) {
                    MatchSection.this.applyMatch(MatchSection.this.matchCombo.getSelectionIndex());
                }
            }
        });
        toolkit.paintBordersFor(container);
        this.initialize();
        this.update((IPluginReference)null);
        section.setClient((Control)container);
    }

    private void createReexportButton(FormToolkit toolkit, Composite container) {
        this.reexportButton = toolkit.createButton(container, PDEPlugin.getResourceString(KEY_REEXPORT), 32);
        this.reexportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MatchSection.this.blockChanges) {
                    return;
                }
                if (!(MatchSection.this.currentImport instanceof IPluginImport)) {
                    return;
                }
                if (MatchSection.this.currentImport != null) {
                    try {
                        IPluginImport iimport = (IPluginImport)MatchSection.this.currentImport;
                        iimport.setReexported(MatchSection.this.reexportButton.getSelection());
                    }
                    catch (CoreException ex) {
                        PDEPlugin.logException(ex);
                    }
                }
            }
        });
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.reexportButton.setLayoutData((Object)gd);
    }

    private void createOptionalButton(FormToolkit toolkit, Composite container) {
        this.optionalButton = toolkit.createButton(container, PDEPlugin.getResourceString(KEY_OPTIONAL), 32);
        this.optionalButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MatchSection.this.blockChanges) {
                    return;
                }
                if (!(MatchSection.this.currentImport instanceof IPluginImport)) {
                    return;
                }
                if (MatchSection.this.currentImport != null) {
                    try {
                        IPluginImport iimport = (IPluginImport)MatchSection.this.currentImport;
                        iimport.setOptional(MatchSection.this.optionalButton.getSelection());
                    }
                    catch (CoreException ex) {
                        PDEPlugin.logException(ex);
                    }
                }
            }
        });
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.optionalButton.setLayoutData((Object)gd);
    }

    private void applyVersion(String version) {
        try {
            if (this.currentImport != null) {
                this.currentImport.setVersion(version);
            } else if (this.multiSelection != null) {
                Iterator iter = this.multiSelection.iterator();
                while (iter.hasNext()) {
                    IPluginReference reference = (IPluginReference)iter.next();
                    reference.setVersion(version);
                }
            }
        }
        catch (CoreException ex) {
            PDEPlugin.logException(ex);
        }
    }

    private void applyMatch(int match) {
        try {
            if (this.currentImport != null) {
                this.currentImport.setMatch(match);
            } else if (this.multiSelection != null) {
                Iterator iter = this.multiSelection.iterator();
                while (iter.hasNext()) {
                    IPluginReference reference = (IPluginReference)iter.next();
                    reference.setMatch(match);
                }
            }
        }
        catch (CoreException ex) {
            PDEPlugin.logException(ex);
        }
    }

    private int getMatch() {
        return this.matchCombo.getSelectionIndex();
    }

    public boolean canPaste(Clipboard clipboard) {
        TransferData[] types = clipboard.getAvailableTypes();
        Transfer[] transfers = new Transfer[]{TextTransfer.getInstance(), RTFTransfer.getInstance()};
        int i = 0;
        while (i < types.length) {
            int j = 0;
            while (j < transfers.length) {
                if (transfers[j].isSupportedType(types[i])) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public void dispose() {
        IModel model = (IModel)this.getPage().getModel();
        if (model instanceof IModelChangeProvider) {
            ((IModelChangeProvider)model).removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    private void initialize() {
        IBaseModel model = this.getPage().getModel();
        if (model instanceof IModelChangeProvider) {
            ((IModelChangeProvider)model).addModelChangedListener((IModelChangedListener)this);
        }
        this.updateMode();
    }

    public void modelChanged(IModelChangedEvent e) {
        Object object;
        if (e.getChangeType() == 2) {
            Object obj = e.getChangedObjects()[0];
            if (obj.equals(this.currentImport)) {
                this.update((IPluginReference)null);
            }
        } else if (e.getChangeType() == 3 && (object = e.getChangedObjects()[0]).equals(this.currentImport)) {
            this.update(this.currentImport);
        }
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        IStructuredSelection ssel = (IStructuredSelection)selection;
        if (ssel.size() == 1) {
            Object changeObject = ((IStructuredSelection)selection).getFirstElement();
            IPluginImport input = null;
            if (changeObject instanceof ImportObject) {
                input = ((ImportObject)changeObject).getImport();
            } else if (changeObject instanceof IPluginReference) {
                input = (IPluginReference)changeObject;
            }
            this.update((IPluginReference)input);
        } else {
            this.update(ssel);
        }
    }

    private void resetMatchCombo(IPluginReference iimport) {
        String text = this.versionText.getText().getText();
        boolean enable = this.isEditable() && text.length() > 0;
        this.matchCombo.getControl().setEnabled(enable);
        this.setMatchCombo(iimport);
    }

    private void setMatchCombo(IPluginReference iimport) {
        int match = iimport != null ? iimport.getMatch() : 0;
        this.matchCombo.select(match);
    }

    protected void update(IStructuredSelection selection) {
        this.blockChanges = true;
        this.currentImport = null;
        int size = selection.size();
        if (size == 0) {
            this.versionText.setValue(null, true);
            boolean enableState = false;
            this.versionText.getText().setEditable(enableState);
            this.matchCombo.getControl().setEnabled(enableState);
            this.matchCombo.setText("");
            this.blockChanges = false;
            return;
        }
        if (this.multiSelection != null && !this.multiSelection.equals(selection) && this.isEditable()) {
            this.commit(false);
        }
        this.multiSelection = selection;
        this.versionText.getText().setEditable(this.isEditable());
        if (size == 1) {
            IPluginReference ref = (IPluginReference)selection.getFirstElement();
            this.versionText.setValue(ref.getVersion());
            this.resetMatchCombo(ref);
        } else {
            this.versionText.setValue("");
            this.matchCombo.getControl().setEnabled(true);
            this.setMatchCombo(null);
        }
        this.blockChanges = false;
    }

    protected void update(IPluginReference iimport) {
        this.blockChanges = true;
        if (iimport == null) {
            if (this.addReexport) {
                this.optionalButton.setSelection(false);
                this.optionalButton.setEnabled(false);
                this.reexportButton.setSelection(false);
                this.reexportButton.setEnabled(false);
            }
            this.versionText.setValue(null, true);
            boolean enableState = false;
            this.versionText.getText().setEditable(enableState);
            this.matchCombo.getControl().setEnabled(enableState);
            this.matchCombo.setText("");
            this.currentImport = null;
            this.blockChanges = false;
            return;
        }
        if (this.currentImport != null && !iimport.equals(this.currentImport) && this.isEditable()) {
            this.commit(false);
        }
        this.currentImport = iimport;
        if (this.currentImport instanceof IPluginImport) {
            IPluginImport pimport = (IPluginImport)this.currentImport;
            this.optionalButton.setEnabled(this.isEditable());
            this.optionalButton.setSelection(pimport.isOptional());
            this.reexportButton.setEnabled(this.isEditable());
            this.reexportButton.setSelection(pimport.isReexported());
        }
        this.versionText.getText().setEditable(this.isEditable());
        this.versionText.setValue(this.currentImport.getVersion());
        this.resetMatchCombo(this.currentImport);
        this.blockChanges = false;
    }

    public boolean isOsgiMode() {
        return this.osgiMode;
    }

    public void setOsgiMode(boolean osgiMode) {
        this.osgiMode = osgiMode;
        this.updateMode();
    }

    private void updateMode() {
        this.matchLabel.setVisible(!this.isOsgiMode());
        this.matchCombo.getControl().setVisible(!this.isOsgiMode());
    }
}

