/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.build;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.BuildScriptGenerator;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatform;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.ui.build.BaseBuildAction;
import org.eclipse.pde.internal.ui.build.ClasspathHelper;

public class BuildFeatureAction
extends BaseBuildAction {
    private IFeatureModel model;

    protected void makeScripts(IProgressMonitor monitor) throws InvocationTargetException, CoreException {
        ArrayList<String> paths = new ArrayList<String>();
        IFeatureModel[] models = PDECore.getDefault().getWorkspaceModelManager().getFeatureModels();
        int i = 0;
        while (i < models.length) {
            paths.add(String.valueOf(models[i].getInstallLocation()) + '/' + "feature.xml");
            if (models[i].getUnderlyingResource().equals((Object)this.fManifestFile)) {
                this.model = models[i];
            }
            ++i;
        }
        String[] plugins = TargetPlatform.createPluginPath();
        String[] features = paths.toArray(new String[paths.size()]);
        String[] all = new String[plugins.length + paths.size()];
        System.arraycopy(plugins, 0, all, 0, plugins.length);
        System.arraycopy(features, 0, all, plugins.length, features.length);
        BuildScriptGenerator generator = new BuildScriptGenerator();
        generator.setBuildingOSGi(PDECore.getDefault().getModelManager().isOSGiRuntime());
        generator.setChildren(true);
        BuildScriptGenerator.setEmbeddedSource((boolean)AbstractScriptGenerator.getDefaultEmbeddedSource());
        String url = ClasspathHelper.getDevEntriesProperties(String.valueOf(this.fManifestFile.getProject().getLocation().addTrailingSeparator().toString()) + "dev.properties", false);
        generator.setDevEntries(url);
        generator.setWorkingDirectory(this.fManifestFile.getProject().getLocation().toOSString());
        BuildScriptGenerator.setOutputFormat((String)AbstractScriptGenerator.getDefaultOutputFormat());
        BuildScriptGenerator.setConfigInfo((String)AbstractScriptGenerator.getDefaultConfigInfos());
        generator.setElements(new String[]{"feature@" + this.model.getFeature().getId()});
        generator.setPluginPath(all);
        generator.setGenerateAssembleScript(false);
        generator.generate();
    }

    private void refreshLocal(IFeature feature, IProgressMonitor monitor) throws CoreException {
        IFeaturePlugin[] references = feature.getPlugins();
        int i = 0;
        while (i < references.length) {
            IPluginModelBase refmodel = feature.getReferencedModel(references[i]);
            if (refmodel != null) {
                refmodel.getUnderlyingResource().getProject().refreshLocal(1, monitor);
            }
            ++i;
        }
    }

    protected void refreshLocal(IProgressMonitor monitor) throws CoreException {
        super.refreshLocal(monitor);
        this.refreshLocal(this.model.getFeature(), monitor);
    }
}

