/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.browser;

import java.io.IOException;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.browser.IBrowser;
import org.eclipse.help.browser.IBrowserFactory;
import org.eclipse.help.internal.base.HelpBaseResources;
import org.eclipse.help.internal.browser.MozillaBrowserAdapter;
import org.eclipse.help.internal.browser.StreamConsumer;

public class MozillaFactory
implements IBrowserFactory,
IExecutableExtension {
    private String executable;
    private String executableName;
    private String osList;
    private MozillaBrowserAdapter browserInstance = null;

    public boolean isAvailable() {
        if (!this.isSupportedOS(System.getProperty("os.name"))) {
            return false;
        }
        try {
            Process pr = Runtime.getRuntime().exec("which " + this.executable);
            StreamConsumer outputs = new StreamConsumer(pr.getInputStream());
            outputs.start();
            StreamConsumer errors = new StreamConsumer(pr.getErrorStream());
            errors.start();
            pr.waitFor();
            int ret = pr.exitValue();
            if (ret == 0) {
                return !this.errorsInOutput(outputs, errors);
            }
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (IOException iOException) {
            return true;
        }
    }

    private boolean errorsInOutput(StreamConsumer outputs, StreamConsumer errors) {
        try {
            outputs.join(1000L);
            if (outputs.getLastLine() != null && outputs.getLastLine().indexOf("no " + this.executable + " in") >= 0) {
                return true;
            }
            errors.join(1000L);
            if (errors.getLastLine() != null && errors.getLastLine().indexOf("no " + this.executable + " in") >= 0) {
                return true;
            }
        }
        catch (InterruptedException interruptedException) {}
        return false;
    }

    public IBrowser createBrowser() {
        if (this.browserInstance == null) {
            this.browserInstance = new MozillaBrowserAdapter(this.executable, this.executableName);
        }
        return this.browserInstance;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        try {
            Hashtable params = (Hashtable)data;
            this.executable = (String)params.get("executable");
            this.executableName = (String)params.get("executableName");
            this.osList = (String)params.get("os");
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.help.base", 0, HelpBaseResources.getString("MozillaFactory.dataMissing"), (Throwable)e));
        }
    }

    private boolean isSupportedOS(String os) {
        if (this.osList == null || this.osList.length() <= 0) {
            return false;
        }
        String[] OSes = this.osList.split(",\\s*");
        int i = 0;
        while (i < OSes.length) {
            if (os.toLowerCase().startsWith(OSes[i].toLowerCase())) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

