/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring.participants;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.ISharableParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.internal.core.refactoring.Assert;
import org.eclipse.ltk.internal.core.refactoring.ParticipantDescriptor;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;

class ParticipantExtensionPoint {
    private String fName;
    private String fParticipantID;
    private List fParticipants;
    private Class fParticipantClass;

    public ParticipantExtensionPoint(String name, String participantId, Class clazz) {
        Assert.isNotNull(name);
        Assert.isNotNull(participantId);
        Assert.isNotNull(clazz);
        this.fName = name;
        this.fParticipantID = participantId;
        this.fParticipantClass = clazz;
    }

    public String getName() {
        return this.fName;
    }

    public RefactoringParticipant[] getParticipants(RefactoringStatus status, RefactoringProcessor processor, Object element, RefactoringArguments arguments, String[] affectedNatures, SharableParticipants shared) {
        if (this.fParticipants == null) {
            this.init();
        }
        EvaluationContext evalContext = ParticipantExtensionPoint.createEvaluationContext(processor, element, affectedNatures);
        ArrayList<RefactoringParticipant> result = new ArrayList<RefactoringParticipant>();
        Iterator iter = this.fParticipants.iterator();
        while (iter.hasNext()) {
            ParticipantDescriptor descriptor = (ParticipantDescriptor)iter.next();
            if (!descriptor.isEnabled()) {
                iter.remove();
                continue;
            }
            try {
                if (!descriptor.matches((IEvaluationContext)evalContext)) continue;
                RefactoringParticipant participant = shared.get(descriptor);
                if (participant != null) {
                    ((ISharableParticipant)((Object)participant)).addElement(element, arguments);
                    continue;
                }
                try {
                    participant = descriptor.createParticipant();
                    if (!this.fParticipantClass.isInstance((Object)participant)) {
                        throw new ClassCastException();
                    }
                    if (!participant.initialize(processor, element, arguments)) continue;
                    participant.setDescriptor(descriptor);
                    result.add(participant);
                    if (!(participant instanceof ISharableParticipant)) continue;
                    shared.put(descriptor, participant);
                }
                catch (ClassCastException classCastException) {
                    status.addError(RefactoringCoreMessages.getFormattedString("ParticipantExtensionPoint.participant_removed", descriptor.getName()));
                    RefactoringCorePlugin.logErrorMessage(RefactoringCoreMessages.getFormattedString("ParticipantExtensionPoint.wrong_type", new String[]{descriptor.getName(), this.fParticipantClass.getName()}));
                    iter.remove();
                }
            }
            catch (CoreException e) {
                status.addError(RefactoringCoreMessages.getFormattedString("ParticipantExtensionPoint.participant_removed", descriptor.getName()));
                RefactoringCorePlugin.logRemovedParticipant(descriptor, e);
                iter.remove();
            }
        }
        return result.toArray(new RefactoringParticipant[result.size()]);
    }

    private void init() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] ces = registry.getConfigurationElementsFor(RefactoringCorePlugin.getPluginId(), this.fParticipantID);
        this.fParticipants = new ArrayList(ces.length);
        int i = 0;
        while (i < ces.length) {
            ParticipantDescriptor descriptor = new ParticipantDescriptor(ces[i]);
            IStatus status = descriptor.checkSyntax();
            switch (status.getSeverity()) {
                case 4: {
                    RefactoringCorePlugin.log(status);
                    break;
                }
                case 1: 
                case 2: {
                    RefactoringCorePlugin.log(status);
                }
                default: {
                    this.fParticipants.add(descriptor);
                }
            }
            ++i;
        }
    }

    private static EvaluationContext createEvaluationContext(RefactoringProcessor processor, Object element, String[] affectedNatures) {
        EvaluationContext result = new EvaluationContext(null, element);
        result.addVariable("element", element);
        result.addVariable("affectedNatures", Arrays.asList(affectedNatures));
        result.addVariable("processorIdentifier", (Object)processor.getIdentifier());
        return result;
    }
}

