/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.internal.ui.SearchDialog;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.WorkingSetComparator;
import org.eclipse.search.internal.ui.util.PixelConverter;
import org.eclipse.search.internal.ui.util.SWTUtil;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;

public class ScopePart {
    private static final String DIALOG_SETTINGS_KEY = "SearchDialog.ScopePart";
    private static final String STORE_SCOPE = "scope";
    private static final String STORE_LRU_WORKING_SET_NAME = "lastUsedWorkingSetName";
    private static final String STORE_LRU_WORKING_SET_NAMES = "lastUsedWorkingSetNames";
    private static IDialogSettings fgSettingsStore = SearchPlugin.getDefault().getDialogSettings().getSection("SearchDialog.ScopePart");
    private Group fPart;
    private Button fUseWorkspace;
    private Button fUseSelection;
    private Button fUseProject;
    private Button fUseWorkingSet;
    private int fScope;
    private boolean fCanSearchEnclosingProjects;
    private Text fWorkingSetText;
    private IWorkingSet[] fWorkingSets;
    private ISearchPageContainer fSearchPageContainer;

    static {
        if (fgSettingsStore == null) {
            fgSettingsStore = SearchPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS_KEY);
        }
    }

    public ScopePart(ISearchPageContainer searchPageContainer, boolean searchEnclosingProjects) {
        int initialScope = ScopePart.getStoredScope();
        Assert.isLegal((initialScope >= 0 && initialScope <= 3 ? 1 : 0) != 0);
        this.fScope = initialScope;
        this.fCanSearchEnclosingProjects = searchEnclosingProjects;
        if (!this.fCanSearchEnclosingProjects && this.fScope == 3) {
            this.fScope = 0;
        }
        this.fSearchPageContainer = searchPageContainer;
        this.restoreState();
    }

    private static int getStoredScope() {
        int scope;
        try {
            scope = fgSettingsStore.getInt(STORE_SCOPE);
        }
        catch (NumberFormatException numberFormatException) {
            scope = 0;
        }
        if (scope != 2 && scope != 1 && scope != 3 && scope != 0) {
            scope = 0;
        }
        return scope;
    }

    private void restoreState() {
        String[] lruWorkingSetNames = fgSettingsStore.getArray(STORE_LRU_WORKING_SET_NAMES);
        if (lruWorkingSetNames != null) {
            HashSet<IWorkingSet> existingWorkingSets = new HashSet<IWorkingSet>(lruWorkingSetNames.length);
            int i = 0;
            while (i < lruWorkingSetNames.length) {
                String name = lruWorkingSetNames[i];
                IWorkingSet workingSet = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(name);
                if (workingSet != null) {
                    existingWorkingSets.add(workingSet);
                }
                ++i;
            }
            if (!existingWorkingSets.isEmpty()) {
                this.fWorkingSets = existingWorkingSets.toArray(new IWorkingSet[existingWorkingSets.size()]);
            }
        } else {
            IWorkingSet workingSet;
            String workingSetName = fgSettingsStore.get(STORE_LRU_WORKING_SET_NAME);
            if (workingSetName != null && (workingSet = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(workingSetName)) != null) {
                this.fWorkingSets = new IWorkingSet[]{workingSet};
                this.saveState();
            }
        }
    }

    public int getSelectedScope() {
        return this.fScope;
    }

    public void setSelectedScope(int scope) {
        Assert.isLegal((scope >= 0 && scope <= 3 ? 1 : 0) != 0);
        Assert.isNotNull((Object)this.fUseWorkspace);
        Assert.isNotNull((Object)this.fUseSelection);
        Assert.isNotNull((Object)this.fUseWorkingSet);
        Assert.isNotNull((Object)this.fUseProject);
        this.fScope = scope;
        if (this.fScope == 3) {
            if (!this.fCanSearchEnclosingProjects) {
                SearchPlugin.log((IStatus)new Status(2, "org.eclipse.search", 2, "Enclosing projects scope set on search page that does not support it", null));
                this.fScope = 0;
            } else if (!this.fUseProject.isEnabled()) {
                this.fScope = 0;
            }
        } else if (this.fScope == 1 && !this.fUseSelection.isEnabled()) {
            this.fScope = 0;
        }
        switch (this.fScope) {
            case 0: {
                this.fUseWorkspace.setSelection(true);
                this.fUseSelection.setSelection(false);
                this.fUseProject.setSelection(false);
                this.fUseWorkingSet.setSelection(false);
                break;
            }
            case 1: {
                this.fUseWorkspace.setSelection(false);
                this.fUseSelection.setSelection(true);
                this.fUseProject.setSelection(false);
                this.fUseWorkingSet.setSelection(false);
                break;
            }
            case 2: {
                this.fUseWorkspace.setSelection(false);
                this.fUseSelection.setSelection(false);
                this.fUseProject.setSelection(false);
                this.fUseWorkingSet.setSelection(true);
                break;
            }
            case 3: {
                this.fUseWorkspace.setSelection(false);
                this.fUseSelection.setSelection(false);
                this.fUseProject.setSelection(true);
                this.fUseWorkingSet.setSelection(false);
            }
        }
        this.updateSearchPageContainerActionPerformedEnablement();
        fgSettingsStore.put(STORE_SCOPE, this.fScope);
    }

    private void updateSearchPageContainerActionPerformedEnablement() {
        boolean newState;
        boolean bl = newState = this.fScope != 2 || this.fWorkingSets != null;
        if (this.fSearchPageContainer instanceof SearchDialog) {
            ((SearchDialog)this.fSearchPageContainer).setPerformActionEnabledFromScopePart(newState);
        } else if (this.fSearchPageContainer != null) {
            this.fSearchPageContainer.setPerformActionEnabled(newState);
        }
    }

    public IWorkingSet[] getSelectedWorkingSets() {
        if (this.getSelectedScope() == 2) {
            return this.fWorkingSets;
        }
        return null;
    }

    public void setSelectedWorkingSets(IWorkingSet[] workingSets) {
        Assert.isNotNull((Object)workingSets);
        this.setSelectedScope(2);
        this.fWorkingSets = null;
        HashSet<IWorkingSet> existingWorkingSets = new HashSet<IWorkingSet>(workingSets.length);
        int i = 0;
        while (i < workingSets.length) {
            String name = workingSets[i].getName();
            IWorkingSet workingSet = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(name);
            if (workingSet != null) {
                existingWorkingSets.add(workingSet);
            }
            ++i;
        }
        if (!existingWorkingSets.isEmpty()) {
            this.fWorkingSets = existingWorkingSets.toArray(new IWorkingSet[existingWorkingSets.size()]);
        }
        this.saveState();
        if (this.fWorkingSetText != null) {
            this.fWorkingSetText.setText(ScopePart.toString(this.fWorkingSets));
        }
    }

    private void saveState() {
        if (this.fWorkingSets != null && this.fWorkingSets.length > 0) {
            String[] existingWorkingSetNames = new String[this.fWorkingSets.length];
            int i = 0;
            while (i < existingWorkingSetNames.length) {
                existingWorkingSetNames[i] = this.fWorkingSets[i].getName();
                ++i;
            }
            fgSettingsStore.put(STORE_LRU_WORKING_SET_NAMES, existingWorkingSetNames);
        }
    }

    public Composite createPart(Composite parent) {
        this.fPart = new Group(parent, 0);
        this.fPart.setText(SearchMessages.getString("ScopePart.group.text"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        this.fPart.setLayout((Layout)layout);
        this.fPart.setLayoutData((Object)new GridData(768));
        this.fUseWorkspace = new Button((Composite)this.fPart, 16);
        this.fUseWorkspace.setData((Object)new Integer(0));
        this.fUseWorkspace.setText(SearchMessages.getString("ScopePart.workspaceScope.text"));
        this.fUseSelection = new Button((Composite)this.fPart, 16);
        this.fUseSelection.setData((Object)new Integer(1));
        this.fUseSelection.setText(SearchMessages.getString("ScopePart.selectedResourcesScope.text"));
        ISelection selection = this.fSearchPageContainer.getSelection();
        this.fUseSelection.setEnabled(selection instanceof IStructuredSelection && !this.fSearchPageContainer.getSelection().isEmpty());
        GridData gd = new GridData(32);
        gd.horizontalIndent = 8;
        this.fUseSelection.setLayoutData((Object)gd);
        this.fUseProject = new Button((Composite)this.fPart, 16);
        this.fUseProject.setData((Object)new Integer(3));
        this.fUseProject.setText(SearchMessages.getString("ScopePart.enclosingProjectsScope.text"));
        this.fUseProject.setEnabled(selection instanceof IStructuredSelection && !this.fSearchPageContainer.getSelection().isEmpty() || this.hasFocusEditor());
        gd = new GridData(32);
        gd.horizontalSpan = 2;
        gd.horizontalIndent = 8;
        this.fUseProject.setLayoutData((Object)gd);
        if (!this.fCanSearchEnclosingProjects) {
            this.fUseProject.setVisible(false);
        }
        this.fUseWorkingSet = new Button((Composite)this.fPart, 16);
        this.fUseWorkingSet.setData((Object)new Integer(2));
        this.fUseWorkingSet.setText(SearchMessages.getString("ScopePart.workingSetScope.text"));
        this.fWorkingSetText = new Text((Composite)this.fPart, 2060);
        Button chooseWorkingSet = new Button((Composite)this.fPart, 8);
        chooseWorkingSet.setLayoutData((Object)new GridData());
        chooseWorkingSet.setText(SearchMessages.getString("ScopePart.workingSetChooseButton.text"));
        SWTUtil.setButtonDimensionHint(chooseWorkingSet);
        chooseWorkingSet.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ScopePart.this.handleChooseWorkingSet()) {
                    ScopePart.this.setSelectedScope(2);
                }
            }
        });
        gd = new GridData(768);
        gd.horizontalIndent = 8;
        gd.horizontalSpan = 2;
        gd.widthHint = new PixelConverter((Control)this.fWorkingSetText).convertWidthInCharsToPixels(30);
        this.fWorkingSetText.setLayoutData((Object)gd);
        SelectionAdapter scopeChangedLister = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScopePart.this.handleScopeChanged(e);
            }
        };
        this.fUseWorkspace.addSelectionListener((SelectionListener)scopeChangedLister);
        this.fUseSelection.addSelectionListener((SelectionListener)scopeChangedLister);
        this.fUseProject.addSelectionListener((SelectionListener)scopeChangedLister);
        this.fUseWorkingSet.addSelectionListener((SelectionListener)scopeChangedLister);
        this.setSelectedScope(this.fScope);
        if (this.fWorkingSets != null) {
            this.fWorkingSetText.setText(ScopePart.toString(this.fWorkingSets));
        }
        return this.fPart;
    }

    private boolean hasFocusEditor() {
        IWorkbenchPage activePage = SearchPlugin.getActivePage();
        if (activePage == null) {
            return false;
        }
        return activePage.getActivePart() instanceof IEditorPart;
    }

    private void handleScopeChanged(SelectionEvent e) {
        Button button;
        Object source = e.getSource();
        if (source instanceof Button && (button = (Button)source).getSelection()) {
            this.setSelectedScope((Integer)button.getData());
        }
    }

    private boolean handleChooseWorkingSet() {
        IWorkingSetSelectionDialog dialog = PlatformUI.getWorkbench().getWorkingSetManager().createWorkingSetSelectionDialog(this.fUseSelection.getShell(), true);
        if (this.fWorkingSets != null) {
            dialog.setSelection(this.fWorkingSets);
        }
        if (dialog.open() == 0) {
            IWorkingSet[] result = dialog.getSelection();
            if (result.length > 0) {
                this.setSelectedWorkingSets(result);
                return true;
            }
            this.fWorkingSetText.setText("");
            this.fWorkingSets = null;
            if (this.fScope == 2) {
                this.setSelectedScope(0);
            }
            return false;
        }
        if (this.fWorkingSets != null) {
            int i = 0;
            while (i < this.fWorkingSets.length) {
                if (PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(this.fWorkingSets[i].getName()) == null) break;
                ++i;
            }
            if (i < this.fWorkingSets.length) {
                this.fWorkingSetText.setText("");
                this.fWorkingSets = null;
                this.updateSearchPageContainerActionPerformedEnablement();
            }
        }
        return false;
    }

    void setVisible(boolean state) {
        this.fPart.setVisible(state);
    }

    public static String toString(IWorkingSet[] workingSets) {
        String result = "";
        if (workingSets != null && workingSets.length > 0) {
            Arrays.sort(workingSets, new WorkingSetComparator());
            boolean firstFound = false;
            int i = 0;
            while (i < workingSets.length) {
                String workingSetName = workingSets[i].getName();
                if (firstFound) {
                    result = SearchMessages.getFormattedString("ScopePart.workingSetConcatenation", new String[]{result, workingSetName});
                } else {
                    result = workingSetName;
                    firstFound = true;
                }
                ++i;
            }
        }
        return result;
    }
}

