/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.update.core.BaseInstallHandler;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureContentConsumer;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.PluginEntry;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.operations.UpdateUtils;

public class DeltaInstallHandler
extends BaseInstallHandler {
    private static final String PLUGIN_XML = "plugin.xml";
    private static final String FRAGMENT_XML = "fragment.xml";
    private static final String META_MANIFEST = "META-INF/MANIFEST.MF";
    protected IFeature oldFeature;

    public void completeInstall(IFeatureContentConsumer consumer) throws CoreException {
        if (this.pluginEntries == null) {
            return;
        }
        if (!this.feature.isPatch()) {
            IFeature[] oldFeatures = UpdateUtils.getInstalledFeatures(this.feature);
            if (oldFeatures.length == 0) {
                return;
            }
            this.oldFeature = oldFeatures[0];
        } else {
            this.oldFeature = UpdateUtils.getPatchedFeature(this.feature);
            if (this.oldFeature == null) {
                return;
            }
        }
        IPluginEntry[] oldPlugins = this.oldFeature.getPluginEntries();
        int i = 0;
        while (i < this.pluginEntries.length) {
            IPluginEntry newPlugin = this.pluginEntries[i];
            IPluginEntry oldPlugin = this.getPluginEntry(oldPlugins, newPlugin.getVersionedIdentifier().getIdentifier());
            if (oldPlugin != null) {
                try {
                    this.overlayPlugin(oldPlugin, newPlugin, consumer);
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, UpdateUtils.getPluginId(), 1, "", (Throwable)e));
                }
            }
            ++i;
        }
    }

    protected IPluginEntry getPluginEntry(IPluginEntry[] plugins, String id) {
        int i = 0;
        while (i < plugins.length) {
            if (plugins[i].getVersionedIdentifier().getIdentifier().equals(id)) {
                return plugins[i];
            }
            ++i;
        }
        return null;
    }

    protected boolean referenceExists(ContentReference[] references, ContentReference ref) {
        String id = ref.getIdentifier();
        if (id == null) {
            return false;
        }
        int i = 0;
        while (i < references.length) {
            if (id.equals(references[i].getIdentifier())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void overlayPlugin(IPluginEntry oldPlugin, IPluginEntry newPlugin, IFeatureContentConsumer consumer) throws CoreException, IOException {
        if (newPlugin instanceof PluginEntry && !((PluginEntry)newPlugin).isUnpack()) {
            return;
        }
        ContentReference[] oldReferences = this.oldFeature.getFeatureContentProvider().getPluginEntryContentReferences(oldPlugin, null);
        ContentReference[] newReferences = this.feature.getFeatureContentProvider().getPluginEntryContentReferences(newPlugin, null);
        URL newURL = new URL(consumer.getFeature().getSite().getURL(), "plugins/" + newPlugin.getVersionedIdentifier().toString());
        String pluginPath = newURL.getFile();
        int i = 0;
        while (true) {
            block13: {
                Object var11_11;
                if (i >= oldReferences.length) {
                    return;
                }
                if (this.isPluginManifest(oldReferences[i]) || this.referenceExists(newReferences, oldReferences[i])) break block13;
                InputStream input = null;
                try {
                    try {
                        input = oldReferences[i].getInputStream();
                        File targetFile = new File(pluginPath, oldReferences[i].getIdentifier());
                        UpdateManagerUtils.copyToLocal(input, targetFile.getAbsolutePath(), null);
                        UpdateManagerUtils.checkPermissions(oldReferences[i], pluginPath);
                    }
                    catch (IOException iOException) {
                        var11_11 = null;
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (IOException iOException2) {}
                        }
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    var11_11 = null;
                    if (input == null) throw throwable;
                    try {}
                    catch (IOException iOException) {}
                    input.close();
                    throw throwable;
                    throw throwable;
                }
                {
                    var11_11 = null;
                    if (input == null) break block13;
                }
                try {}
                catch (IOException iOException) {}
                input.close();
            }
            ++i;
        }
    }

    protected boolean isPluginManifest(ContentReference ref) {
        String id = ref.getIdentifier();
        return PLUGIN_XML.equals(id) || FRAGMENT_XML.equals(id) || META_MANIFEST.equals(id);
    }
}

