/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.console;

import org.eclipse.jface.text.TypedRegion;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.MessageConsoleStream;

public class MessageConsolePartition
extends TypedRegion {
    private MessageConsoleStream fStream;
    public static final String MESSAGE_PARTITION_TYPE = String.valueOf(ConsolePlugin.getUniqueIdentifier()) + ".MESSAGE_PARTITION_TYPE";

    public MessageConsolePartition(MessageConsoleStream stream, int offset, int length) {
        super(offset, length, MESSAGE_PARTITION_TYPE);
        this.fStream = stream;
    }

    public boolean equals(Object partition) {
        if (super.equals(partition)) {
            this.fStream.equals(((MessageConsolePartition)((Object)partition)).getStream());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() + this.fStream.hashCode();
    }

    public MessageConsoleStream getStream() {
        return this.fStream;
    }

    public boolean canBeCombinedWith(MessageConsolePartition partition) {
        boolean overlap;
        int start = this.getOffset();
        int end = start + this.getLength();
        int otherStart = partition.getOffset();
        int otherEnd = otherStart + partition.getLength();
        boolean bl = overlap = otherStart >= start && otherStart <= end || start >= otherStart && start <= otherEnd;
        return overlap && this.getType().equals(partition.getType()) && this.getStream().equals(partition.getStream());
    }

    public MessageConsolePartition combineWith(MessageConsolePartition partition) {
        int start = this.getOffset();
        int end = start + this.getLength();
        int otherStart = partition.getOffset();
        int otherEnd = otherStart + partition.getLength();
        int theStart = Math.min(start, otherStart);
        int theEnd = Math.max(end, otherEnd);
        return this.createNewPartition(theStart, theEnd - theStart);
    }

    public MessageConsolePartition createNewPartition(int offset, int length) {
        return new MessageConsolePartition(this.getStream(), offset, length);
    }
}

