/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.usage.transmogrify;

import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.Definition;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.IDefinition;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ReferenceTool;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.SymTabAST;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.SymbolTable;
import java.util.Set;
import java.util.TreeSet;

public class ReferenceThreshold
extends ReferenceTool {
    private Set _underreferencedDefinitions;
    private int _threshold;

    public ReferenceThreshold(SymbolTable table, int threshold) {
        super(table.getTree());
        this._threshold = threshold;
        this._underreferencedDefinitions = new TreeSet();
        this.go();
    }

    private void go() {
        this.collectUnderreferencedDefinitions();
    }

    private void collectUnderreferencedDefinitions() {
        this.handleNode(this._tree);
    }

    protected void handleNode(SymTabAST node) {
        IDefinition def;
        if (node.isMeaningful() && (def = node.getDefinition()) != null && def.getNumReferences() <= this._threshold && def instanceof Definition && def.getQualifiedName().indexOf("test") < 0 && def.getQualifiedName().indexOf("main") < 0) {
            this._underreferencedDefinitions.add(def);
        }
        this.walkChildren(node);
    }

    public Set getUnderreferencedDefinitions() {
        return this._underreferencedDefinitions;
    }
}

