/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.usage.transmogrify;

import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ClassManager;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.DefaultConstructor;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.DefaultScope;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ExternalClass;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.IClass;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.IMethod;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.IPackage;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ISignature;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.IVariable;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.MethodDef;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.MethodSpecificityComparator;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.Scope;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.SymTabAST;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.VariableDef;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;

public class ClassDef
extends DefaultScope
implements IClass {
    private long id = 0L;
    private IClass superclass = null;
    private List interfaces = new Vector();
    private List subclasses = new Vector();
    private List implementors = new Vector();
    private Set importedPackages = new HashSet();
    private Set methods = new HashSet();
    private Hashtable imports = new Hashtable();
    private Vector unprocessedImports = null;
    protected MethodDef _defaultConstructor = new DefaultConstructor(this);

    public ClassDef(String name, Scope parentScope, SymTabAST node) {
        super(name, parentScope, node);
        this.addDefinition(this._defaultConstructor);
    }

    public long getNextAnonymousId() {
        return ++this.id;
    }

    public void setSuperclass(IClass superclass) {
        this.superclass = superclass;
    }

    public IClass getSuperclass() {
        return this.superclass;
    }

    public void addUnprocessedImports(Vector imports) {
        this.unprocessedImports = (Vector)imports.clone();
    }

    public Vector getUnprocessedImports() {
        return this.unprocessedImports;
    }

    public void importPackage(IPackage pkg) {
        this.importedPackages.add(pkg);
    }

    public void importClass(IClass imported) {
        this.imports.put(imported.getName(), imported);
    }

    public void addDefinition(MethodDef method) {
        if (method.getName().equals(this.getName())) {
            this.methods.remove(this._defaultConstructor);
        }
        this.methods.add(method);
    }

    protected Enumeration getDefinitions() {
        Vector allElements = new Vector();
        allElements.addAll(this.elements.values());
        allElements.addAll(this.methods);
        allElements.addAll(this.labels.values());
        allElements.addAll(this.classes.values());
        return allElements.elements();
    }

    public IClass getClassDefinition(String name) {
        IClass result = null;
        result = (ClassDef)this.classes.get(name);
        if (result == null) {
            result = (IClass)this.imports.get(name);
        }
        if (result == null) {
            Iterator it = this.importedPackages.iterator();
            while (it.hasNext() && result == null) {
                IPackage pkg = (IPackage)it.next();
                result = pkg.getClass(name);
            }
        }
        if (result == null) {
            result = this.getParentScope().getClassDefinition(name);
        }
        if (result == null) {
            String packageName = this.getParentScope().getQualifiedName();
            String fullName = packageName + "." + name;
            Class<?> theClass = null;
            try {
                theClass = ClassManager.getClassLoader().loadClass(fullName);
                result = new ExternalClass(theClass);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        return result;
    }

    public IMethod getMethodDefinition(String name, ISignature signature) {
        IMethod result = null;
        result = this.getDeclaredMethod(name, signature);
        if (result == null) {
            result = this.getMostCompatibleMethod(name, signature);
        }
        if (result == null && this.superclass != null) {
            result = this.superclass.getMethodDefinition(name, signature);
        }
        if (result == null) {
            IClass[] interfaces = this.getInterfaces();
            for (int index = 0; index < interfaces.length && result == null; ++index) {
                result = interfaces[index].getMethodDefinition(name, signature);
            }
        }
        if (result == null && this.getParentScope() != null) {
            result = this.getParentScope().getMethodDefinition(name, signature);
        }
        return result;
    }

    public IMethod getMostCompatibleMethod(String name, ISignature signature) {
        IMethod result = null;
        TreeSet<MethodDef> compatibleMethods = new TreeSet<MethodDef>(new MethodSpecificityComparator());
        Iterator it = this.methods.iterator();
        while (it.hasNext()) {
            MethodDef method = (MethodDef)it.next();
            if (!name.equals(method.getName()) || !method.hasCompatibleSignature(signature)) continue;
            compatibleMethods.add(method);
        }
        if (!compatibleMethods.isEmpty()) {
            result = (IMethod)compatibleMethods.first();
        }
        return result;
    }

    public IMethod getDeclaredMethod(String name, ISignature signature) {
        MethodDef result = null;
        Iterator it = this.methods.iterator();
        while (it.hasNext()) {
            MethodDef method = (MethodDef)it.next();
            if (!name.equals(method.getName()) || !method.hasSameSignature(signature)) continue;
            result = method;
            break;
        }
        return result;
    }

    public IVariable getVariableDefinition(String name) {
        IVariable result = null;
        result = (VariableDef)this.elements.get(name);
        if (result == null) {
            IClass[] superinterfaces = this.getInterfaces();
            for (int i = 0; i < superinterfaces.length && result == null; ++i) {
                result = superinterfaces[i].getVariableDefinition(name);
            }
        }
        if (result == null && this.superclass != null) {
            result = this.superclass.getVariableDefinition(name);
        }
        if (result == null && this.getParentScope() != null) {
            result = this.getParentScope().getVariableDefinition(name);
        }
        return result;
    }

    public void addInterface(IClass implemented) {
        this.interfaces.add(implemented);
    }

    public IClass[] getInterfaces() {
        IClass[] type = new IClass[]{};
        return this.interfaces.toArray(type);
    }

    public ClassDef getEnclosingClass() {
        return this;
    }

    public void addSubclass(ClassDef subclass) {
        this.subclasses.add(subclass);
    }

    public List getSubclasses() {
        return this.subclasses;
    }

    public void addImplementor(ClassDef implementor) {
        this.implementors.add(implementor);
    }

    public List getImplementors() {
        return this.implementors;
    }

    public IClass[] getInnerClasses() {
        Iterator it = this.getClasses();
        ArrayList result = new ArrayList();
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result.toArray(new IClass[0]);
    }

    public boolean isSuperclassOf(IClass possibleChild) {
        boolean result = this.subclasses.contains(possibleChild);
        return result;
    }

    public boolean isCompatibleWith(IClass type) {
        boolean result = false;
        if (type.equals(this)) {
            result = true;
        } else if (this.superclass != null && this.superclass.isCompatibleWith(type)) {
            result = true;
        } else if (!this.interfaces.isEmpty()) {
            Iterator it = this.interfaces.iterator();
            while (it.hasNext() && !result) {
                IClass current = (IClass)it.next();
                if (!current.isCompatibleWith(type)) continue;
                result = true;
            }
        }
        return result;
    }

    public boolean isPrimitive() {
        return false;
    }

    private SymTabAST getObjblock() {
        return this.getTreeNode().findFirstToken(6);
    }
}

