/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.usage.transmogrify;

import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ClassManager;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.DefaultScope;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ExternalClass;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.IClass;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.IPackage;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.LiteralResolver;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.SymbolTable;

public class BaseScope
extends DefaultScope {
    private SymbolTable table;

    public BaseScope(SymbolTable symbolTable) {
        super("~BASE~", null, null);
        this.table = symbolTable;
    }

    public boolean isBaseScope() {
        return true;
    }

    public void addDefinition(IPackage def) {
        this.elements.put(def.getName(), def);
    }

    public IPackage getPackageDefinition(String fullyQualifiedName) {
        return (IPackage)this.table.getPackages().get(fullyQualifiedName);
    }

    public IClass getClassDefinition(String name) {
        int lastDot;
        IClass result = null;
        result = LiteralResolver.getDefinition(name);
        if (result == null && (lastDot = name.lastIndexOf(".")) > 0) {
            String packageName = name.substring(0, lastDot);
            String className = name.substring(lastDot + 1);
            IPackage pkg = this.getPackageDefinition(packageName);
            if (pkg != null) {
                result = pkg.getClass(className);
            }
        }
        if (result == null) {
            Class<?> theClass = null;
            try {
                theClass = ClassManager.getClassLoader().loadClass(name);
                result = new ExternalClass(theClass);
            }
            catch (ClassNotFoundException e) {
            }
            catch (NoClassDefFoundError e) {
                // empty catch block
            }
        }
        return result;
    }
}

