/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.j2ee;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.j2ee.BeanMethodChecker;
import com.puppycrawl.tools.checkstyle.checks.j2ee.EntityBeanCheck;
import com.puppycrawl.tools.checkstyle.checks.j2ee.Utils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class EntityBeanMethodChecker
extends BeanMethodChecker {
    private final Set mEjbCreates = new HashSet();
    private final Set mEjbPostCreates = new HashSet();

    public EntityBeanMethodChecker(EntityBeanCheck aCheck) {
        super(aCheck);
    }

    public void checkMethods(DetailAST aAST) {
        this.mEjbCreates.clear();
        this.mEjbPostCreates.clear();
        super.checkMethods(aAST);
        this.checkCreateMatch();
    }

    protected void checkCreateMatch() {
        Iterator it = this.mEjbCreates.iterator();
        while (it.hasNext()) {
            DetailAST createMethod = (DetailAST)it.next();
            DetailAST nameAST = createMethod.findFirstToken(58);
            String name = nameAST.getText();
            String method = name.substring("ejbCreate".length());
            boolean match = false;
            Iterator itPostCreate = this.mEjbPostCreates.iterator();
            while (!match && itPostCreate.hasNext()) {
                DetailAST postCreateMethod = (DetailAST)itPostCreate.next();
                DetailAST postCreateNameAST = postCreateMethod.findFirstToken(58);
                String postCreateName = postCreateNameAST.getText();
                if (!postCreateName.equals("ejbPostCreate" + method)) continue;
                match = Utils.sameParameters(createMethod, postCreateMethod);
            }
            if (match) continue;
            String suffix = name.substring("ejbCreate".length());
            String postCreateName = "ejbPostCreate" + suffix;
            this.logName(createMethod, "unmatchedejbcreate.bean", new Object[]{postCreateName});
        }
    }

    public void checkMethod(DetailAST aMethodAST) {
        super.checkMethod(aMethodAST);
        DetailAST nameAST = aMethodAST.findFirstToken(58);
        String name = nameAST.getText();
        if (name.startsWith("ejbHome")) {
            this.checkHomeMethod(aMethodAST);
        } else if (name.startsWith("ejbPostCreate")) {
            this.checkPostCreateMethod(aMethodAST);
        }
    }

    protected void checkCreateMethod(DetailAST aMethodAST) {
        super.checkCreateMethod(aMethodAST);
        this.mEjbCreates.add(aMethodAST);
        if (Utils.isVoid(aMethodAST)) {
            this.logName(aMethodAST, "voidmethod.bean", new Object[0]);
        }
    }

    protected void checkHomeMethod(DetailAST aMethodAST) {
        this.checkMethod(aMethodAST, true);
        this.checkNotThrows(aMethodAST, "java.rmi.RemoteException");
    }

    protected void checkPostCreateMethod(DetailAST aMethodAST) {
        this.checkMethod(aMethodAST, false);
        this.mEjbPostCreates.add(aMethodAST);
        if (!Utils.isVoid(aMethodAST)) {
            this.logName(aMethodAST, "nonvoidmethod.bean", new Object[0]);
        }
    }
}

