/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.filters;

import com.puppycrawl.tools.checkstyle.api.AbstractLoader;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.FilterSet;
import com.puppycrawl.tools.checkstyle.filters.SuppressElement;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.regexp.RESyntaxException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class SuppressionsLoader
extends AbstractLoader {
    private static final String DTD_PUBLIC_ID = "-//Puppy Crawl//DTD Suppressions 1.0//EN";
    private static final String DTD_RESOURCE_NAME = "com/puppycrawl/tools/checkstyle/suppressions_1_0.dtd";
    private final FilterSet mFilterChain = new FilterSet();

    private SuppressionsLoader() throws ParserConfigurationException, SAXException {
        super(DTD_PUBLIC_ID, DTD_RESOURCE_NAME);
    }

    public FilterSet getFilterChain() {
        return this.mFilterChain;
    }

    public void startElement(String aNamespaceURI, String aLocalName, String aQName, Attributes aAtts) throws SAXException {
        if (aQName.equals("suppress")) {
            String columns;
            SuppressElement suppress;
            String files = aAtts.getValue("files");
            if (files == null) {
                throw new SAXException("missing files attribute");
            }
            String checks = aAtts.getValue("checks");
            if (checks == null) {
                throw new SAXException("missing checks attribute");
            }
            try {
                suppress = new SuppressElement(files, checks);
            }
            catch (RESyntaxException e) {
                throw new SAXException("invalid files or checks format");
            }
            String lines = aAtts.getValue("lines");
            if (lines != null) {
                suppress.setLines(lines);
            }
            if ((columns = aAtts.getValue("columns")) != null) {
                suppress.setColumns(columns);
            }
            this.mFilterChain.addFilter(suppress);
        }
    }

    public static FilterSet loadSuppressions(String aFilename) throws CheckstyleException {
        FileReader reader = null;
        try {
            reader = new FileReader(aFilename);
        }
        catch (FileNotFoundException e) {
            throw new CheckstyleException("unable to find " + aFilename, e);
        }
        InputSource source = new InputSource(reader);
        return SuppressionsLoader.loadSuppressions(source, aFilename);
    }

    private static FilterSet loadSuppressions(InputSource aSource, String aSourceName) throws CheckstyleException {
        try {
            SuppressionsLoader suppressionsLoader = new SuppressionsLoader();
            suppressionsLoader.parseInputSource(aSource);
            return suppressionsLoader.getFilterChain();
        }
        catch (FileNotFoundException e) {
            throw new CheckstyleException("unable to find " + aSourceName, e);
        }
        catch (ParserConfigurationException e) {
            throw new CheckstyleException("unable to parse " + aSourceName, e);
        }
        catch (SAXException e) {
            throw new CheckstyleException("unable to parse " + aSourceName + " - " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new CheckstyleException("unable to read " + aSourceName, e);
        }
        catch (NumberFormatException e) {
            throw new CheckstyleException("number format exception " + aSourceName + " - " + e.getMessage(), e);
        }
    }
}

