/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.checks.CheckUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class CovariantEqualsCheck
extends Check {
    private Set mEqualsMethods = new HashSet();
    private boolean mHasEqualsObject;

    public int[] getDefaultTokens() {
        return new int[]{14, 136};
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST aAST) {
        this.mEqualsMethods.clear();
        this.mHasEqualsObject = false;
        DetailAST objBlock = aAST.findFirstToken(6);
        if (objBlock != null) {
            for (DetailAST child = (DetailAST)objBlock.getFirstChild(); child != null; child = (DetailAST)child.getNextSibling()) {
                if (child.getType() != 9 || !CheckUtils.isEqualsMethod(child)) continue;
                if (this.hasObjectParameter(child)) {
                    this.mHasEqualsObject = true;
                    continue;
                }
                this.mEqualsMethods.add(child);
            }
            if (!this.mHasEqualsObject) {
                Iterator it = this.mEqualsMethods.iterator();
                while (it.hasNext()) {
                    DetailAST equalsAST = (DetailAST)it.next();
                    DetailAST nameNode = equalsAST.findFirstToken(58);
                    this.log(nameNode.getLineNo(), nameNode.getColumnNo(), "covariant.equals");
                }
            }
        }
    }

    private boolean hasObjectParameter(DetailAST aAST) {
        DetailAST paramsNode = aAST.findFirstToken(20);
        if (paramsNode.getChildCount() != 1) {
            return false;
        }
        DetailAST paramNode = paramsNode.findFirstToken(21);
        DetailAST typeNode = paramNode.findFirstToken(13);
        FullIdent fullIdent = FullIdent.createFullIdentBelow(typeNode);
        String name = fullIdent.getText();
        return name.equals("Object") || name.equals("java.lang.Object");
    }
}

