/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import antlr.collections.AST;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class EqualsHashCodeCheck
extends Check {
    private final Map mObjBlockEquals = new HashMap();
    private final Set mObjBlockWithHashCode = new HashSet();

    public int[] getDefaultTokens() {
        return new int[]{9};
    }

    public void beginTree(DetailAST aRootAST) {
        this.mObjBlockEquals.clear();
        this.mObjBlockWithHashCode.clear();
    }

    public void visitToken(DetailAST aAST) {
        DetailAST modifiers = (DetailAST)aAST.getFirstChild();
        AST type = modifiers.getNextSibling();
        AST methodName = type.getNextSibling();
        DetailAST parameters = aAST.findFirstToken(20);
        if (type.getFirstChild().getType() == 50 && "equals".equals(methodName.getText()) && modifiers.branchContains(62) && parameters.getChildCount() == 1 && this.isObjectParam(parameters.getFirstChild())) {
            this.mObjBlockEquals.put(aAST.getParent(), aAST);
        } else if (type.getFirstChild().getType() == 54 && "hashCode".equals(methodName.getText()) && modifiers.branchContains(62) && parameters.getFirstChild() == null) {
            this.mObjBlockWithHashCode.add(aAST.getParent());
        }
    }

    private boolean isObjectParam(AST aFirstChild) {
        AST modifiers = aFirstChild.getFirstChild();
        AST type = modifiers.getNextSibling();
        switch (type.getFirstChild().getType()) {
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return false;
            }
        }
        return true;
    }

    public void finishTree(DetailAST aRootAST) {
        Set equalsDefs = this.mObjBlockEquals.keySet();
        Iterator it = equalsDefs.iterator();
        while (it.hasNext()) {
            Object objBlock = it.next();
            if (this.mObjBlockWithHashCode.contains(objBlock)) continue;
            DetailAST equalsAST = (DetailAST)((Object)this.mObjBlockEquals.get(objBlock));
            this.log(equalsAST.getLineNo(), equalsAST.getColumnNo(), "equals.noHashCode");
        }
        this.mObjBlockEquals.clear();
        this.mObjBlockWithHashCode.clear();
    }
}

