/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessage;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.AbstractOption;
import com.puppycrawl.tools.checkstyle.checks.LineSeparatorOption;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.commons.beanutils.ConversionException;

public class NewlineAtEndOfFileCheck
extends AbstractFileSetCheck {
    private LineSeparatorOption mLineSeparator = LineSeparatorOption.SYSTEM;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void process(File[] aFiles) {
        files = this.filter(aFiles);
        dispatcher = this.getMessageDispatcher();
        for (i = 0; i < files.length; ++i) {
            block13: {
                file = files[i];
                path = file.getPath();
                dispatcher.fireFileStarted(path);
                randomAccessFile = null;
                try {
                    block12: {
                        randomAccessFile = new RandomAccessFile(file, "r");
                        if (this.endsWithNewline(randomAccessFile)) break block12;
                        this.log(0, "noNewlineAtEOF", (Object)path);
                    }
                    var10_9 = null;
                    ** if (randomAccessFile == null) goto lbl-1000
                }
                catch (Throwable var9_11) {
                    var10_9 = null;
                    if (randomAccessFile != null) {
                        try {
                            randomAccessFile.close();
                        }
                        catch (IOException e) {
                            this.logIOException(e);
                        }
                    }
                    throw var9_11;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        randomAccessFile.close();
                    }
                    catch (IOException e) {
                        this.logIOException(e);
                    }
                }
lbl-1000:
                // 2 sources

                {
                    break block13;
                    catch (IOException e) {
                        this.logIOException(e);
                        var10_9 = null;
                        if (randomAccessFile != null) {
                            try {
                                randomAccessFile.close();
                            }
                            catch (IOException e) {
                                this.logIOException(e);
                            }
                        }
                    }
                }
            }
            this.fireErrors(path);
            dispatcher.fireFileFinished(path);
        }
    }

    public void setLineSeparator(String aLineSeparator) {
        AbstractOption option = LineSeparatorOption.SYSTEM.decode(aLineSeparator);
        if (option == null) {
            throw new ConversionException("unable to parse " + aLineSeparator);
        }
        this.mLineSeparator = (LineSeparatorOption)option;
    }

    private boolean endsWithNewline(RandomAccessFile aRandomAccessFile) throws IOException {
        int len = this.mLineSeparator.length();
        if (aRandomAccessFile.length() < (long)len) {
            return false;
        }
        aRandomAccessFile.seek(aRandomAccessFile.length() - (long)len);
        byte[] lastBytes = new byte[len];
        aRandomAccessFile.read(lastBytes);
        return this.mLineSeparator.matches(lastBytes);
    }

    private void logIOException(IOException aEx) {
        Object[] args = null;
        String key = "general.fileNotFound";
        if (!(aEx instanceof FileNotFoundException)) {
            args = new String[]{aEx.getMessage()};
            key = "general.exception";
        }
        LocalizedMessage message = new LocalizedMessage(0, "com.puppycrawl.tools.checkstyle.messages", key, args, this.getClass());
        this.getMessageCollector().add(message);
        Utils.getExceptionLogger().debug((Object)"IOException occured.", (Throwable)aEx);
    }
}

