/*
 * Decompiled with CFR 0.152.
 */
package rj.tools.util.ui;

import gnu.regexp.RE;
import gnu.regexp.REException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import rj.tools.util.ui.RegexpDialogTextComponent;
import rj.tools.util.ui.WidgetSizer;

public class RegexpDialog
extends JDialog {
    private static final String WINDOW_TITLE = "Regular Expression Compiler";
    private static final String REGEXP = "Regexp:";
    private static final String TEST_STRING = "Test String:";
    private static final String TEST = "Test";
    private static final String PASSED = "PASSED";
    private static final String FAILED = "FAILED";
    private static final String OK = "Ok";
    private static final String CANCEL = "Cancel";
    private JLabel mRegexpLabel = new JLabel("Regexp:");
    private JTextComponent mRegexpTC;
    private JLabel mTestStringLabel = new JLabel("Test String:");
    private JTextComponent mTestStringTC;
    private JLabel mResultLabel = new JLabel("");
    private JButton mTestButton = new JButton("Test");
    private JButton mOkButton = new JButton("Ok");
    private JButton mCancelButton = new JButton("Cancel");
    private String mRegexpBackup;

    public static String escapeNewLine(String text) {
        StringBuffer sb = new StringBuffer("");
        int i = 0;
        int count = text.length();
        while (i < count) {
            char c = text.charAt(i);
            if (c == '\n') {
                sb.append("\\n");
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String unescapeNewLine(String text) {
        StringBuffer sb = new StringBuffer("");
        int i = 0;
        int count = text.length();
        while (i < count) {
            char c = text.charAt(i);
            if (c == '\\' && text.charAt(i + 1) == 'n') {
                sb.append('\n');
                ++i;
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String removeCR(String text) {
        StringBuffer sb = new StringBuffer("");
        int i = 0;
        int count = text.length();
        while (i < count) {
            char c = text.charAt(i);
            if (c == '\r') {
                ++i;
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public RegexpDialog() {
        this.mRegexpTC = new RegTextField();
        this.mTestStringTC = new RegTextField();
        this.init();
    }

    private RegexpDialog(RegexpDialogTextComponent regexp, RegexpDialogTextComponent test) {
        if (!(regexp instanceof JTextComponent) || !(test instanceof JTextComponent)) {
            throw new IllegalArgumentException("arguments have to be JTextComponents");
        }
        this.mRegexpTC = (JTextComponent)((Object)regexp);
        this.mTestStringTC = (JTextComponent)((Object)test);
        this.init();
    }

    public RegexpDialog(Component parent) {
        this();
        this.setLocationRelativeTo(parent);
    }

    public RegexpDialog(Component parent, RegexpDialogTextComponent regexp, RegexpDialogTextComponent test) {
        this(regexp, test);
        this.setLocationRelativeTo(parent);
    }

    private void init() {
        this.setTitle(WINDOW_TITLE);
        this.setModal(true);
        this.initUI();
        this.pack();
    }

    private void initUI() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JComponent textComponent = null;
        mainPanel.setLayout(gb);
        mainPanel.setBorder(BorderFactory.createEtchedBorder());
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(10, 10, 0, 10);
        gb.setConstraints(this.mRegexpLabel, c);
        mainPanel.add(this.mRegexpLabel);
        if (((RegexpDialogTextComponent)((Object)this.mRegexpTC)).isMultiLine()) {
            textComponent = new JScrollPane(this.mRegexpTC);
            c.weighty = 1.0;
            c.fill = 1;
        } else {
            textComponent = this.mRegexpTC;
            c.weighty = 0.0;
            c.fill = 2;
        }
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        c.insets = new Insets(10, 0, 0, 10);
        gb.setConstraints(textComponent, c);
        mainPanel.add(textComponent);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.anchor = 17;
        c.fill = 0;
        c.insets = new Insets(0, 10, 0, 10);
        gb.setConstraints(this.mTestStringLabel, c);
        mainPanel.add(this.mTestStringLabel);
        if (((RegexpDialogTextComponent)((Object)this.mRegexpTC)).isMultiLine()) {
            textComponent = new JScrollPane(this.mTestStringTC);
            c.weighty = 1.0;
            c.fill = 1;
        } else {
            textComponent = this.mTestStringTC;
            c.weighty = 0.0;
            c.fill = 2;
        }
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 10);
        c.fill = 1;
        gb.setConstraints(textComponent, c);
        mainPanel.add(textComponent);
        c.gridx = 0;
        c.gridy = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 10;
        c.fill = 0;
        c.insets = new Insets(10, 10, 10, 10);
        gb.setConstraints(this.mResultLabel, c);
        mainPanel.add(this.mResultLabel);
        c.gridx = 1;
        c.gridy = 2;
        c.weightx = 1.0;
        c.insets = new Insets(10, 0, 10, 10);
        c.fill = 2;
        gb.setConstraints(this.mTestButton, c);
        mainPanel.add(this.mTestButton);
        JPanel buttonPanel = new JPanel();
        JPanel space1 = new JPanel();
        JPanel space2 = new JPanel();
        gb = new GridBagLayout();
        buttonPanel.setLayout(gb);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.insets = new Insets(10, 0, 10, 10);
        c.fill = 2;
        gb.setConstraints(space1, c);
        buttonPanel.add(space1);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 0.0;
        c.insets = new Insets(10, 0, 10, 10);
        c.fill = 2;
        gb.setConstraints(space2, c);
        buttonPanel.add(space2);
        c.gridx = 2;
        c.gridy = 0;
        c.weightx = 0.0;
        c.insets = new Insets(10, 0, 10, 10);
        c.fill = 2;
        gb.setConstraints(this.mCancelButton, c);
        buttonPanel.add(this.mCancelButton);
        c.gridx = 3;
        c.gridy = 0;
        c.weightx = 0.0;
        c.insets = new Insets(10, 0, 10, 10);
        c.fill = 2;
        gb.setConstraints(this.mOkButton, c);
        buttonPanel.add(this.mOkButton);
        WidgetSizer.alignToMaxWidth(new JComponent[]{this.mCancelButton, this.mOkButton});
        this.getContentPane().add((Component)mainPanel, "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
        this.createListener();
    }

    private void createListener() {
        this.mTestButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (RegexpDialog.this.isMatch(RegexpDialog.this.mRegexpTC.getText(), RegexpDialog.this.mTestStringTC.getText())) {
                    RegexpDialog.this.mResultLabel.setForeground(Color.green.darker());
                    RegexpDialog.this.mResultLabel.setText("<HTML><B><CENTER>PASSED</CENTER></B></HTML>");
                } else {
                    RegexpDialog.this.mResultLabel.setForeground(Color.red.darker());
                    RegexpDialog.this.mResultLabel.setText("<HTML><B><CENTER>FAILED</CENTER></B></HTML>");
                }
            }
        });
        this.mCancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RegexpDialog.this.cancel();
            }
        });
        this.mOkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RegexpDialog.this.ok();
            }
        });
        DocumentListener docListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                RegexpDialog.this.clearLabel();
            }

            public void insertUpdate(DocumentEvent e) {
                RegexpDialog.this.clearLabel();
            }

            public void removeUpdate(DocumentEvent e) {
                RegexpDialog.this.clearLabel();
            }
        };
        this.mRegexpTC.getDocument().addDocumentListener(docListener);
        this.mTestStringTC.getDocument().addDocumentListener(docListener);
    }

    private void clearLabel() {
        this.mResultLabel.setText("");
    }

    public void setRegexp(String regexp) {
        ((RegexpDialogTextComponent)((Object)this.mRegexpTC)).setExpressionText(regexp);
        this.mRegexpBackup = regexp;
    }

    public String getRegexp() {
        return ((RegexpDialogTextComponent)((Object)this.mRegexpTC)).getExpressionText();
    }

    public void setTestString(String testString) {
        ((RegexpDialogTextComponent)((Object)this.mTestStringTC)).setExpressionText(testString);
    }

    public String getTestString() {
        return ((RegexpDialogTextComponent)((Object)this.mTestStringTC)).getExpressionText();
    }

    private boolean isMatch(String regexp, String text) {
        try {
            RE reg = new RE(regexp);
            return reg.isMatch(text);
        }
        catch (REException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void cancel() {
        ((RegexpDialogTextComponent)((Object)this.mRegexpTC)).setExpressionText(this.mRegexpBackup);
        this.dispose();
    }

    private void ok() {
        this.dispose();
    }

    public void processWindowEvent(WindowEvent e) {
        if (e.paramString().equals("WINDOW_CLOSING")) {
            this.cancel();
        } else {
            super.processWindowEvent(e);
        }
    }

    public static class RegTextArea
    extends JTextArea
    implements RegexpDialogTextComponent {
        public RegTextArea() {
            super(6, 80);
        }

        public void setExpressionText(String text) {
            super.setText(text);
        }

        public String getExpressionText() {
            return super.getText();
        }

        public boolean isMultiLine() {
            return true;
        }
    }

    public static class RegTextField
    extends JTextField
    implements RegexpDialogTextComponent {
        public RegTextField() {
            super(15);
        }

        public void setExpressionText(String text) {
            super.setText(text);
        }

        public String getExpressionText() {
            return super.getText();
        }

        public boolean isMultiLine() {
            return false;
        }
    }
}

