/*
 * Decompiled with CFR 0.152.
 */
package rj.tools.util.ui;

import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rj.tools.util.Checker;

public class AnimatedLabel
extends JPanel {
    private JLabel mIconLabel;
    private Icon[] mIcons;
    private int mDelayMS;
    private int mCurrentIndex = 0;
    private Thread mUpdateThread;
    private boolean mGo = false;
    private boolean mExit = false;

    public AnimatedLabel(Icon[] icons, int delayMS) {
        Checker.isNotNull(icons);
        Checker.assertTrue(delayMS >= 0);
        this.mDelayMS = delayMS;
        this.mIcons = icons;
        this.mIconLabel = new JLabel();
        this.mIconLabel.setIcon(this.mIcons[this.mCurrentIndex]);
        this.add(this.mIconLabel);
        this.mUpdateThread = new Thread(){

            public void run() {
                AnimatedLabel.this.go();
            }
        };
        this.mUpdateThread.start();
    }

    public void start() {
        AnimatedLabel animatedLabel = this;
        synchronized (animatedLabel) {
            this.mGo = true;
            this.notifyAll();
        }
    }

    public void stop() {
        new Thread(){

            public void run() {
                AnimatedLabel.this.stop2();
            }
        }.start();
    }

    public void init(Icon icon) {
        Checker.isNotNull(icon);
        if (this.mGo) {
            return;
        }
        this.mIconLabel.setIcon(icon);
    }

    public void done(Icon icon) {
        Checker.isNotNull(icon);
        this.mExit = true;
        try {
            Thread.sleep((int)((double)this.mDelayMS * 1.75));
        }
        catch (InterruptedException e) {
            e.printStackTrace(System.err);
        }
        this.mIconLabel.setIcon(icon);
    }

    private void go() {
        do {
            if (this.mExit) {
                return;
            }
            try {
                Thread.sleep(this.mDelayMS);
            }
            catch (InterruptedException e) {
                e.printStackTrace(System.err);
            }
            if (!this.mGo) continue;
            this.incCurrentIndex();
            this.mIconLabel.setIcon(this.mIcons[this.mCurrentIndex]);
        } while (!this.mExit);
    }

    private void stop2() {
        AnimatedLabel animatedLabel = this;
        synchronized (animatedLabel) {
            try {
                this.mGo = false;
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace(System.err);
            }
        }
    }

    private void incCurrentIndex() {
        this.mCurrentIndex = this.mCurrentIndex < this.mIcons.length - 1 ? ++this.mCurrentIndex : 0;
    }
}

