/*
 * Decompiled with CFR 0.152.
 */
package rj.tools.util.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.swing.JDialog;
import rj.tools.util.ui.AboutPanel;

public class AboutDialog
extends JDialog {
    public AboutDialog(Frame parent, String title, String image, Object[][] keyValue, String copyright) {
        super(parent, title);
        this.initialize(image, keyValue, copyright);
    }

    public AboutDialog(JDialog parent, String title, String image, Object[][] keyValue, String copyright) {
        super((Dialog)parent, title);
        this.initialize(image, keyValue, copyright);
    }

    private void initialize(String image, Object[][] keyValue, String copyright) {
        AboutPanel panel = new AboutPanel(image, keyValue, copyright);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)panel, "Center");
        this.pack();
        this.setResizable(true);
    }

    public static String getOSVersion() {
        return System.getProperty("os.name") + " " + System.getProperty("os.version");
    }

    public static String getJavaVersion() {
        return System.getProperty("java.version") + " " + System.getProperty("java.vm.info");
    }

    public static Object[][] getJarsLabel() {
        String classpath = System.getProperty("java.class.path");
        HashMap<String, String> map = new HashMap<String, String>();
        StringTokenizer st = new StringTokenizer(classpath, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String element = st.nextToken();
            File f = new File(element);
            if (!f.getAbsolutePath().endsWith(".jar")) continue;
            try {
                JarFile jf = new JarFile(f);
                Manifest manifest = jf.getManifest();
                String value = null;
                if (manifest == null) {
                    value = "no MANIFEST file";
                } else {
                    Attributes attrs = jf.getManifest().getMainAttributes();
                    value = attrs.getValue("Label");
                    if (value == null) {
                        value = "N/A";
                    }
                }
                map.put(f.getAbsolutePath(), value);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return AboutDialog.map2Matrix(map);
    }

    public static Object[][] concatMatrizes(Object[][] o1, Object[][] o2) {
        Object[][] objs = new Object[o1.length + o2.length][2];
        int i = 0;
        int count = o1.length;
        while (i < count) {
            objs[i][0] = o1[i][0];
            objs[i][1] = o1[i][1];
            ++i;
        }
        int i2 = o1.length;
        int count2 = o1.length + o2.length;
        while (i2 < count2) {
            objs[i2][0] = o2[i2 - o1.length][0];
            objs[i2][1] = o2[i2 - o1.length][1];
            ++i2;
        }
        return objs;
    }

    private static Object[][] map2Matrix(Map map) {
        ArrayList list = new ArrayList(map.keySet());
        Collections.sort(list);
        Object[][] objs = new Object[map.size()][2];
        int i = 0;
        ListIterator iter = ((AbstractList)list).listIterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            objs[i][0] = key;
            objs[i][1] = map.get(key);
            ++i;
        }
        return objs;
    }
}

