/*
 * Decompiled with CFR 0.152.
 */
package rj.tools.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import rj.tools.util.Checker;

public class SubstitutionInputStream
extends FilterInputStream {
    private char mTargetChar;
    private String mReplacementString;
    private char[] mReplacementArray;
    private int mReplacementLength;
    private int mReplacementCharCount;
    private int mValue;

    public SubstitutionInputStream(InputStream inputStream, char target, String replacement) {
        super(inputStream);
        Checker.isNotNull(inputStream);
        Checker.isNotNull(replacement);
        this.mTargetChar = target;
        this.mReplacementString = replacement;
        this.mReplacementArray = this.mReplacementString.toCharArray();
        this.mReplacementCharCount = this.mReplacementLength = this.mReplacementString.length();
    }

    public int read() throws IOException {
        return this.getValue();
    }

    private void resetCount() {
        this.mReplacementCharCount = 0;
    }

    private int getValue() throws IOException {
        if (this.mReplacementCharCount < this.mReplacementLength) {
            this.mValue = this.mReplacementArray[this.mReplacementCharCount++];
        } else {
            this.mValue = super.read();
            if (this.mValue == this.mTargetChar) {
                this.resetCount();
                this.mValue = this.getValue();
            }
        }
        return this.mValue;
    }
}

