/*
 * Decompiled with CFR 0.152.
 */
package rj.tools.util;

import gnu.regexp.RE;
import gnu.regexp.REException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;

public class JavaDocParser {
    private static final String AUTHOR = "@author";
    private static final String VERSION = "@version";
    private static final String PARAM = "@param";
    private static final String RETURN = "@return";
    private static final String THROWS = "@(throws|exception)";
    private static final String SEE = "@see";
    private static final String SINCE = "@since";
    private static final String SERIAL = "@serial";
    private static final String DEPRECATED = "@deprecated";
    private static RE sAUTHORRegexp;
    private static RE sVERSIONRegexp;
    private static RE sPARAMRegexp;
    private static RE sRETURNRegexp;
    private static RE sTHROWSRegexp;
    private static RE sSEERegexp;
    private static RE sSINCERegexp;
    private static RE sSERIALRegexp;
    private static RE sDEPRECATEDRegexp;
    private ArrayList mAuthorTags = new ArrayList();
    private ArrayList mVersionTags = new ArrayList();
    private ArrayList mParamTags = new ArrayList();
    private ArrayList mReturnTags = new ArrayList();
    private ArrayList mThrowsTags = new ArrayList();
    private ArrayList mSeeTags = new ArrayList();
    private ArrayList mSinceTags = new ArrayList();
    private ArrayList mSerialTags = new ArrayList();
    private ArrayList mDeprecatedTags = new ArrayList();
    private ArrayList mTagOrder = new ArrayList();
    private boolean mIsJavaDoc = false;

    public static List getOrderConvention() {
        return Arrays.asList(AUTHOR, VERSION, PARAM, RETURN, THROWS, SEE, SINCE, SERIAL, DEPRECATED);
    }

    public JavaDocParser(String docs) {
        this.parse(docs);
    }

    private void addTag(String tag, String line, Collection col) {
        col.add(this.getTagValue(tag, line.trim()));
    }

    private void addParamTag(String line, Collection col) {
        String name = this.getTagValue(PARAM, line);
        if (name.indexOf(" ") != -1) {
            name = name.substring(0, name.indexOf(" "));
        }
        col.add(name);
    }

    private String getTagValue(String tag, String line) {
        int index;
        if (this.mTagOrder.size() == 0 || !this.mTagOrder.get(this.mTagOrder.size() - 1).equals(tag)) {
            this.mTagOrder.add(tag);
        }
        if ((index = line.indexOf(tag) + tag.length() + 1) >= line.length()) {
            return "";
        }
        return line.substring(line.indexOf(tag) + tag.length() + 1);
    }

    private void parse(String docs) {
        if (!(docs = docs.trim()).startsWith("/**") || !docs.endsWith("*/")) {
            return;
        }
        this.mIsJavaDoc = true;
        StringTokenizer st = new StringTokenizer(docs, "\n");
        while (st.hasMoreTokens()) {
            String line = (String)st.nextElement();
            if (sAUTHORRegexp.isMatch(line)) {
                this.addTag(AUTHOR, line, this.mAuthorTags);
                continue;
            }
            if (sVERSIONRegexp.isMatch(line)) {
                this.addTag(VERSION, line, this.mVersionTags);
                continue;
            }
            if (sRETURNRegexp.isMatch(line)) {
                this.addTag(RETURN, line, this.mReturnTags);
                continue;
            }
            if (sDEPRECATEDRegexp.isMatch(line)) {
                this.addTag(DEPRECATED, line, this.mDeprecatedTags);
                continue;
            }
            if (sSINCERegexp.isMatch(line)) {
                this.addTag(SINCE, line, this.mSinceTags);
                continue;
            }
            if (sSEERegexp.isMatch(line)) {
                this.addTag(SEE, line, this.mSeeTags);
                continue;
            }
            if (sPARAMRegexp.isMatch(line)) {
                this.addParamTag(line, this.mParamTags);
                continue;
            }
            if (!sTHROWSRegexp.isMatch(line)) continue;
            this.addTag(THROWS, line, this.mThrowsTags);
        }
    }

    public boolean isJavaDoc() {
        return this.mIsJavaDoc;
    }

    public boolean hasAuthorTags() {
        return this.mAuthorTags.size() > 0;
    }

    public Collection getAuthorTags() {
        return this.mAuthorTags;
    }

    public boolean hasVersionTags() {
        return this.mVersionTags.size() > 0;
    }

    public Collection getVersionTags() {
        return this.mVersionTags;
    }

    public boolean hasParamTags() {
        return this.mVersionTags.size() > 0;
    }

    public Collection getParamTags() {
        return this.mParamTags;
    }

    public boolean hasReturnTags() {
        return this.mReturnTags.size() > 0;
    }

    public Collection getReturnTags() {
        return this.mReturnTags;
    }

    public boolean hasThrowsTags() {
        return this.mThrowsTags.size() > 0;
    }

    public Collection getThrowsTags() {
        return this.mThrowsTags;
    }

    public boolean hasSeeTags() {
        return this.mSeeTags.size() > 0;
    }

    public Collection getSeeTags() {
        return this.mSeeTags;
    }

    public boolean hasSinceTags() {
        return this.mSinceTags.size() > 0;
    }

    public Collection getSinceTags() {
        return this.mSinceTags;
    }

    public boolean hasSerialTags() {
        return this.mSerialTags.size() > 0;
    }

    public Collection getSerialTags() {
        return this.mSerialTags;
    }

    public boolean hasDeprecatedTags() {
        return this.mDeprecatedTags.size() > 0;
    }

    public Collection getDeprecatedTags() {
        return this.mDeprecatedTags;
    }

    public List getOrder() {
        return this.mTagOrder;
    }

    public boolean isOrderCorrect() {
        List order = this.getOrder();
        ArrayList conv = new ArrayList(JavaDocParser.getOrderConvention());
        int lastHit = 0;
        int i = 0;
        int count = order.size();
        while (i < count) {
            Object is = order.get(i);
            int j = 0;
            int count2 = conv.size();
            while (j < count2) {
                Object should = conv.get(j);
                if (is.equals(should)) {
                    if (i <= j && j >= lastHit) {
                        lastHit = j;
                    } else {
                        return false;
                    }
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    static {
        try {
            sAUTHORRegexp = new RE(".*@author.*");
            sVERSIONRegexp = new RE(".*@version.*");
            sPARAMRegexp = new RE(".*@param.*");
            sRETURNRegexp = new RE(".*@return.*");
            sTHROWSRegexp = new RE(".*@(throws|exception).*");
            sSEERegexp = new RE(".*@see.*");
            sSINCERegexp = new RE(".*@since.*");
            sSERIALRegexp = new RE(".*@serial.*");
            sDEPRECATEDRegexp = new RE(".*@deprecated.*");
        }
        catch (REException e) {
            e.printStackTrace(System.err);
        }
    }
}

