/*
 * Decompiled with CFR 0.152.
 */
package rj.tools.util;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class FileFinder {
    private boolean mRecursive;
    private FileFilter mFileFilter;
    private File mFolder;
    private ArrayList mFiles = new ArrayList();
    private ArrayList mFolders = new ArrayList();
    private boolean mHasRun = false;

    public FileFinder(String folder, boolean recursive) {
        this.mFolder = new File(folder);
        this.mRecursive = recursive;
        this.mFileFilter = new FileFilter(){

            public final boolean accept(File pathName) {
                return true;
            }
        };
        if (!this.mFolder.isDirectory()) {
            throw new IllegalArgumentException("Folder is not a directory");
        }
    }

    public FileFinder(String folder, FileFilter filter, boolean recursive) {
        this(folder, recursive);
        this.mFileFilter = filter;
    }

    private void doSearch() {
        File[] fileList = this.mFolder.listFiles(this.mFileFilter);
        int i = 0;
        int count = fileList.length;
        while (i < count) {
            if (!fileList[i].isDirectory()) {
                this.mFiles.add(fileList[i]);
            } else if (this.mRecursive) {
                this.mFolders.add(fileList[i]);
                FileFinder ff = new FileFinder(fileList[i].getAbsolutePath(), this.mFileFilter, true);
                Collection col = ff.getFiles();
                Iterator iter = col.iterator();
                while (iter.hasNext()) {
                    File file = (File)iter.next();
                    this.mFiles.add(file);
                }
            }
            ++i;
        }
    }

    public Collection getFiles() {
        if (!this.mHasRun) {
            this.doSearch();
            this.mHasRun = true;
        }
        return this.mFiles;
    }

    public Collection getDirectories() {
        if (!this.mHasRun) {
            this.doSearch();
            this.mHasRun = true;
        }
        return this.mFolders;
    }
}

