/*
 * Decompiled with CFR 0.152.
 */
package rj.tools.jcsc.ui;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import rj.tools.jcsc.ui.UIString;

public class XMLI18nMap
extends AbstractMap {
    private String mLanguage;
    private Document mDocument;
    private HashMap mTextCache = new HashMap();

    public XMLI18nMap(Document document) {
        this(document, "english");
    }

    public XMLI18nMap(Document document, String language) {
        this.mDocument = document;
        this.mLanguage = language;
    }

    public Object get(Object key) {
        if (this.mTextCache.containsKey(key)) {
            return (UIString)this.mTextCache.get(key);
        }
        UIString string = this.findText(this.mDocument, key.toString());
        this.mTextCache.put(key, string);
        return string;
    }

    public Set entrySet() {
        return this.mTextCache.entrySet();
    }

    private UIString findText(Document document, String name) {
        NodeList list = document.getElementsByTagName("text");
        int i = 0;
        int count = list.getLength();
        while (i < count) {
            Node node = list.item(i);
            NamedNodeMap attributes = node.getAttributes();
            String stringName = null;
            String category = null;
            boolean isFound = false;
            int j = 0;
            int count2 = attributes.getLength();
            while (j < count2) {
                Node current = attributes.item(j);
                if (current.getNodeName().equals("category")) {
                    category = current.getNodeValue();
                } else if (current.getNodeName().equals("name") && current.getNodeValue().equals(name)) {
                    isFound = true;
                    stringName = current.getNodeValue();
                }
                ++j;
            }
            if (isFound) {
                return this.buildString(node, stringName, category);
            }
            ++i;
        }
        return null;
    }

    private String getValue(Node node, String name) {
        NodeList children = node.getChildNodes();
        if (children != null) {
            int i = 0;
            int count = children.getLength();
            while (i < count) {
                Node child = children.item(i);
                if (child.getNodeName().equals(name)) {
                    if (child.getChildNodes().item(0) != null) {
                        return child.getChildNodes().item(0).getNodeValue();
                    }
                    return "";
                }
                ++i;
            }
        }
        return null;
    }

    private UIString buildString(Node node, String name, String category) {
        String english = this.getValue(node, this.mLanguage);
        return new UIString(english, name, category);
    }
}

