/*
 * Decompiled with CFR 0.152.
 */
package rj.tools.jcsc.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import rj.tools.jcsc.ui.ExamplePanel;
import rj.tools.jcsc.ui.FieldTab;
import rj.tools.jcsc.ui.GeneralTab;
import rj.tools.jcsc.ui.JavaDocTab;
import rj.tools.jcsc.ui.JcscTab;
import rj.tools.jcsc.ui.MethodTab;
import rj.tools.jcsc.ui.MetricsTab;
import rj.tools.jcsc.ui.UnitTestTab;

public class RulesPanel
extends JPanel {
    static final int REGEXP_TF_LENGTH = 5;
    private JTabbedPane mTabbedPane = new JTabbedPane();
    private JcscTab mGeneralTab = new GeneralTab(this);
    private JcscTab mFieldTab = new FieldTab(this);
    private JcscTab mMethodTab = new MethodTab(this);
    private JcscTab mJavaDocTab = new JavaDocTab(this);
    private JcscTab mMetricsTab = new MetricsTab(this);
    private JcscTab mUnitTestTab = new UnitTestTab(this);
    private ExamplePanel mExamplePanel;

    public RulesPanel() {
        this.initUI();
    }

    private void initUI() {
        this.initializeTabbedPane();
        URL url = this.getClass().getResource("examplehtml/EmptyPage.html");
        JSplitPane splitPane = new JSplitPane(1, true);
        this.mExamplePanel = new ExamplePanel(url);
        splitPane.setLeftComponent(this.mTabbedPane);
        splitPane.setRightComponent(this.mExamplePanel);
        splitPane.setDividerLocation(0.5);
        splitPane.setResizeWeight(0.5);
        this.setLayout(new BorderLayout());
        this.add((Component)splitPane, "Center");
    }

    private void initializeTabbedPane() {
        List tabs = this.getTabs();
        Iterator iter = tabs.iterator();
        while (iter.hasNext()) {
            JcscTab tab = (JcscTab)iter.next();
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)((JPanel)((Object)tab)), "North");
            this.mTabbedPane.addTab(tab.getName(), new JScrollPane(panel));
        }
    }

    public ExamplePanel getExamplePanel() {
        return this.mExamplePanel;
    }

    public List getTabs() {
        ArrayList<JcscTab> list = new ArrayList<JcscTab>();
        list.add(this.mGeneralTab);
        list.add(this.mFieldTab);
        list.add(this.mMethodTab);
        list.add(this.mJavaDocTab);
        list.add(this.mMetricsTab);
        list.add(this.mUnitTestTab);
        return list;
    }

    public void setRules(Map map) {
        this.mGeneralTab.setRules(map);
        this.mMethodTab.setRules(map);
        this.mFieldTab.setRules(map);
        this.mJavaDocTab.setRules(map);
        this.mMetricsTab.setRules(map);
        this.mUnitTestTab.setRules(map);
    }

    public Map getRules() {
        HashMap map = new HashMap();
        map.putAll(this.mGeneralTab.getRules());
        map.putAll(this.mMethodTab.getRules());
        map.putAll(this.mFieldTab.getRules());
        map.putAll(this.mJavaDocTab.getRules());
        map.putAll(this.mMetricsTab.getRules());
        map.putAll(this.mUnitTestTab.getRules());
        return map;
    }

    public void setI18nStrings(Map map) {
        this.mGeneralTab.setI18nStrings(map);
        this.mMethodTab.setI18nStrings(map);
        this.mFieldTab.setI18nStrings(map);
        this.mJavaDocTab.setI18nStrings(map);
        this.mMetricsTab.setI18nStrings(map);
        this.mUnitTestTab.setI18nStrings(map);
    }
}

