/*
 * Decompiled with CFR 0.152.
 */
package rj.tools.jcsc.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.filechooser.FileFilter;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import rj.tools.argumentprocessor.ArgProcessor;
import rj.tools.jcsc.rules.RulesHandler;
import rj.tools.jcsc.ui.RulesPanel;
import rj.tools.jcsc.ui.XMLI18nMap;
import rj.tools.util.ui.TextFieldButton;
import rj.tools.util.ui.WidgetSizer;

public class RulesDialog
extends JDialog {
    private static final String WINDOW_TITLE = "JCSC Rules Editor";
    private static final String DEFAULT = "Default";
    private static final String OTHER = "Other";
    private static final String SAVE = "Save";
    private static final String SAVEAS = "Save As";
    private static final String CLOSE = "Close";
    private static JFrame sFrame = new JFrame();
    private boolean mIsStartedStandAlone = false;
    private ButtonGroup mSourceButtonGroup = new ButtonGroup();
    private JRadioButton mDefaultRB = new JRadioButton("Default");
    private JRadioButton mOtherRB = new JRadioButton("Other");
    private TextFieldButton mOtherSourceTF = new TextFieldButton();
    private JButton mSaveButton = new JButton("Save");
    private JButton mSaveAsButton = new JButton("Save As");
    private JButton mCloseButton = new JButton("Close");
    private RulesPanel mRulesPanel = new RulesPanel();
    private JFileChooser mFileChooser = new JFileChooser();
    private File mOtherRuleFile;

    public static void main(String[] args) {
        RulesDialog dialog = new RulesDialog();
        ArgProcessor ap = new ArgProcessor();
        ap.defineOptions("h");
        ap.putArguments(args);
        args = ap.getArguments();
        if (ap.hasFlagOption("h")) {
            System.out.println("\nJCSC Ruleseditor Version __0.96__:  Usage is one of:");
            System.out.println("Usage:");
            System.out.println("  ruleseditor [-h] [<rule-file>]");
            System.out.println("    -h      : show this output");
            System.out.println("\nWritten by Ralph Jocham in 1999-2004");
            System.out.println("This Software is Free under the GPL (GNU Public Licence)\n");
            System.exit(0);
        }
        if (args.length > 0) {
            if (args.length > 1) {
                JOptionPane.showMessageDialog(dialog, "Several arguments were provided, only the first  one is used!", "Startup Warning", 2);
            }
            dialog.setRules(args[0]);
        }
        dialog.mIsStartedStandAlone = true;
        ((Component)dialog).setVisible(true);
        dialog.pack();
    }

    public RulesDialog() {
        super(sFrame);
        ((Frame)sFrame).setIconImage(new ImageIcon(this.getClass().getResource("icons/JCSCTitleBar.gif")).getImage());
        this.initInstance();
    }

    public RulesDialog(Component parent) {
        ((Frame)sFrame).setIconImage(new ImageIcon(this.getClass().getResource("icons/JCSCTitleBar.gif")).getImage());
        this.initInstance();
        this.setLocationRelativeTo(parent);
    }

    public RulesDialog(Frame frame) {
        super(frame);
        ((Frame)sFrame).setIconImage(new ImageIcon(this.getClass().getResource("icons/JCSCTitleBar.gif")).getImage());
        this.initInstance();
        this.setLocationRelativeTo(frame);
    }

    private void initInstance() {
        this.setTitle(WINDOW_TITLE);
        this.setModal(true);
        this.initUI();
        this.setDefaultRules();
        this.pack();
    }

    private void initUI() {
        this.mDefaultRB.setSelected(true);
        this.mOtherSourceTF.setEnabled(false);
        this.mSaveButton.setEnabled(false);
        this.mSourceButtonGroup.add(this.mDefaultRB);
        this.mSourceButtonGroup.add(this.mOtherRB);
        this.getContentPane().setLayout(new BorderLayout());
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel sourcePanel = new JPanel();
        JPanel space0 = new JPanel();
        sourcePanel.setLayout(gb);
        sourcePanel.setBorder(BorderFactory.createTitledBorder("Rules Source"));
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 10, 0, 10);
        c.anchor = 17;
        c.fill = 2;
        gb.setConstraints(this.mDefaultRB, c);
        sourcePanel.add(this.mDefaultRB);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 10, 10, 0);
        c.anchor = 17;
        c.fill = 2;
        gb.setConstraints(this.mOtherRB, c);
        sourcePanel.add(this.mOtherRB);
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 0.2;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 10, 0);
        c.anchor = 17;
        c.fill = 2;
        gb.setConstraints(this.mOtherSourceTF, c);
        sourcePanel.add(this.mOtherSourceTF);
        c.gridx = 2;
        c.gridy = 1;
        c.weightx = 0.8;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 0, 0);
        c.anchor = 17;
        c.fill = 2;
        gb.setConstraints(space0, c);
        sourcePanel.add(space0);
        this.mRulesPanel.setBorder(BorderFactory.createTitledBorder("Rules"));
        JPanel buttonPanel = new JPanel();
        JPanel space1 = new JPanel();
        JPanel space2 = new JPanel();
        WidgetSizer.alignToMaxWidth(new JComponent[]{this.mSaveButton, this.mSaveAsButton, this.mCloseButton});
        gb = new GridBagLayout();
        buttonPanel.setLayout(gb);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.insets = new Insets(10, 0, 10, 10);
        c.fill = 2;
        gb.setConstraints(space1, c);
        buttonPanel.add(space1);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 0.0;
        c.insets = new Insets(10, 0, 10, 10);
        c.fill = 2;
        gb.setConstraints(space2, c);
        buttonPanel.add(space2);
        c.gridx = 2;
        c.gridy = 0;
        c.weightx = 0.0;
        c.insets = new Insets(10, 0, 10, 10);
        c.fill = 2;
        gb.setConstraints(this.mSaveButton, c);
        buttonPanel.add(this.mSaveButton);
        c.gridx = 3;
        c.gridy = 0;
        c.weightx = 0.0;
        c.insets = new Insets(10, 0, 10, 10);
        c.fill = 2;
        gb.setConstraints(this.mSaveAsButton, c);
        buttonPanel.add(this.mSaveAsButton);
        c.gridx = 4;
        c.gridy = 0;
        c.weightx = 0.0;
        c.insets = new Insets(10, 0, 10, 10);
        c.fill = 2;
        gb.setConstraints(this.mCloseButton, c);
        buttonPanel.add(this.mCloseButton);
        this.getContentPane().add((Component)sourcePanel, "North");
        this.getContentPane().add((Component)this.mRulesPanel, "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
        this.mDefaultRB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RulesDialog.this.handleSourceRadioButton(e);
            }
        });
        this.mOtherRB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RulesDialog.this.handleSourceRadioButton(e);
            }
        });
        this.mOtherSourceTF.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RulesDialog.this.openRulesFile();
            }
        });
        this.mSaveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RulesDialog.this.save();
            }
        });
        this.mSaveAsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RulesDialog.this.saveAs();
            }
        });
        this.mCloseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RulesDialog.this.ok();
            }
        });
        this.setI18nStrings(this.getZipI18nStrings());
    }

    private void save() {
        this.persistRules();
    }

    private void saveAs() {
        this.mFileChooser.setDialogTitle("Save JCSC Rules File");
        this.mFileChooser.setFileFilter(new JCSCFileFilter());
        this.mFileChooser.setApproveButtonText(SAVE);
        this.mFileChooser.setCurrentDirectory(this.deserializeOpenPath(".filechooser.save.ser"));
        if (this.mFileChooser.showSaveDialog(this) == 0) {
            File file;
            this.mOtherRuleFile = file = this.appendExtension(this.mFileChooser.getSelectedFile());
            this.mOtherSourceTF.setText(this.mOtherRuleFile.getAbsolutePath());
            this.persistRules();
            this.serializeOpenPath(new File(this.mOtherRuleFile.getParent()), ".filechooser.save.ser");
        }
    }

    private File appendExtension(File file) {
        File tmpFile = file;
        if (!file.getName().endsWith(".jcsc.xml")) {
            tmpFile = new File(file.getAbsolutePath() + ".jcsc.xml");
        }
        return tmpFile;
    }

    private void persistRules() {
        try {
            Map map = this.mRulesPanel.getRules();
            RulesHandler rh = new RulesHandler();
            rh.setPrintStream(new PrintStream(new FileOutputStream(this.mOtherRuleFile)));
            rh.persistRules(map);
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(this, "Cannot access file '" + this.mOtherRuleFile + "'", "Save Error", 0);
        }
    }

    private void cancel() {
        this.dispose();
        this.exitIfStandAlone();
    }

    private void ok() {
        this.dispose();
        this.exitIfStandAlone();
    }

    private void exitIfStandAlone() {
        if (this.mIsStartedStandAlone) {
            System.exit(0);
        }
    }

    private void handleSourceRadioButton(ActionEvent e) {
        this.setCursor(new Cursor(3));
        if (e.getSource() == this.mOtherRB) {
            this.mOtherSourceTF.setEnabled(true);
            this.mSaveButton.setEnabled(true);
            if (!this.mOtherSourceTF.getText().equals("")) {
                this.setRules(this.mOtherSourceTF.getText());
            }
        } else {
            this.mOtherSourceTF.setEnabled(false);
            this.mSaveButton.setEnabled(false);
            this.setDefaultRules();
        }
        this.setCursor(new Cursor(0));
    }

    public void openRulesFile() {
        this.mFileChooser.setDialogTitle("Load JCSC Rules File");
        this.mFileChooser.setFileFilter(new JCSCFileFilter());
        this.mFileChooser.setCurrentDirectory(this.deserializeOpenPath(".filechooser.open.ser"));
        if (this.mFileChooser.showOpenDialog(this) == 0) {
            this.mOtherRuleFile = this.mFileChooser.getSelectedFile();
            this.mOtherSourceTF.setText(this.mOtherRuleFile.getAbsolutePath());
            try {
                this.setRules(new RulesHandler().readRulesFile(this.mOtherRuleFile.getAbsolutePath()));
                this.serializeOpenPath(new File(this.mOtherRuleFile.getParent()), ".filechooser.open.ser");
            }
            catch (FileNotFoundException fne) {
                fne.printStackTrace(System.err);
            }
            catch (IOException ioe) {
                ioe.printStackTrace(System.err);
            }
        }
    }

    private void serializeOpenPath(File file, String name) {
        try {
            ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(System.getProperty("jcsc.home") + File.separator + name));
            os.writeObject(file);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }

    private File deserializeOpenPath(String name) {
        File file = null;
        boolean isError = false;
        try {
            ObjectInputStream is = new ObjectInputStream(new FileInputStream(System.getProperty("jcsc.home") + File.separator + name));
            file = (File)is.readObject();
        }
        catch (IOException e) {
            isError = true;
        }
        catch (ClassNotFoundException e) {
            isError = true;
        }
        if (isError) {
            file = new File(System.getProperty("jcsc.home") + File.separator + "rules");
        }
        return file;
    }

    public void processWindowEvent(WindowEvent e) {
        if (e.paramString().equals("WINDOW_CLOSING")) {
            this.cancel();
        } else {
            super.processWindowEvent(e);
        }
    }

    private Map getZipI18nStrings() {
        XMLI18nMap map = null;
        boolean isError = false;
        try {
            URL url = this.getClass().getResource("/rj/tools/jcsc/ui/JcscI18n.xml");
            DOMParser parser = new DOMParser();
            parser.parse(new InputSource(url.openStream()));
            Document document = parser.getDocument();
            map = new XMLI18nMap(document, "english");
        }
        catch (SAXException e) {
            isError = true;
        }
        catch (IOException e) {
            isError = true;
        }
        if (isError) {
            throw new RuntimeException("'JcscI18n.xml' could not be found in the JCSC.jar file");
        }
        return map;
    }

    private void setRules(Map map) {
        this.mRulesPanel.setRules(map);
    }

    public void setRules(String rulesFile) {
        try {
            Map cache = new RulesHandler().readRulesFile(rulesFile);
            this.setRules(cache);
            this.mOtherRB.setSelected(true);
            this.mSaveButton.setEnabled(true);
            this.mOtherSourceTF.setEnabled(true);
            this.mOtherRuleFile = new File(rulesFile);
            this.mOtherSourceTF.setText(this.mOtherRuleFile.getAbsolutePath());
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Cannot read the '" + rulesFile + "' rules file. Using 'default.jcsc'", "Startup Error", 0);
            this.setDefaultRules();
        }
    }

    private void setDefaultRules() {
        try {
            this.setRules(new RulesHandler().readZipRulesFile("default.jcsc.xml"));
            this.mDefaultRB.setSelected(false);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Cannot read the 'default.jcsc.xml' rules file from the jcsc.jar", "Startup Error", 0);
            System.exit(1);
        }
    }

    private void setI18nStrings(Map map) {
        this.mRulesPanel.setI18nStrings(map);
    }

    private class JCSCFileFilter
    extends FileFilter {
        private JCSCFileFilter() {
        }

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().endsWith(".jcsc.xml");
        }

        public String getDescription() {
            return "The Rules File for JCSC (*.jcsc.xml)";
        }
    }
}

