/*
 * Decompiled with CFR 0.152.
 */
package rj.tools.jcsc.ui;

import gnu.regexp.RE;
import gnu.regexp.REException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rj.tools.jcsc.rules.Rule;
import rj.tools.jcsc.ui.AbstractJcscTab;
import rj.tools.jcsc.ui.ExamplePanel;
import rj.tools.jcsc.ui.JcscTab;
import rj.tools.jcsc.ui.RegexpActionListener;
import rj.tools.util.Checker;
import rj.tools.util.DecimalNumberDocument;
import rj.tools.util.ui.RegexpDialog;
import rj.tools.util.ui.TextFieldButton;

public abstract class AbstractJcscTab
extends JPanel
implements JcscTab {
    private static final String GAP = " ";
    protected int mRuleCount = 0;
    protected Rule[] mRules;
    protected Map mI18nStringsMap;
    private GridBagLayout mLayout;

    protected static String boolean2String(boolean flag) {
        return flag ? "true" : "false";
    }

    protected static boolean booleanFromString(String flag) {
        Checker.isArgValid(flag.equalsIgnoreCase("true") || flag.equalsIgnoreCase("false"));
        return flag.equalsIgnoreCase("true");
    }

    public AbstractJcscTab() {
        this.initUI();
    }

    private void initUI() {
        this.mLayout = new GridBagLayout();
        this.setLayout(this.mLayout);
        this.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
    }

    protected void addRules(Rule[] rules) {
        this.removeAll();
        this.mRuleCount = 0;
        this.mRules = rules;
        int i = 0;
        int count = this.mRules.length;
        while (i < count) {
            this.addRule(this.mRules[i]);
            ++this.mRuleCount;
            ++i;
        }
        this.revalidate();
    }

    public Map getRules() {
        HashMap<String, Rule> map = new HashMap<String, Rule>();
        int i = 0;
        int count = this.mRules.length;
        while (i < count) {
            map.put(this.mRules[i].getName(), this.mRules[i]);
            ++i;
        }
        return map;
    }

    private JCheckBox createIsEnabled(Rule rule) {
        ImageIcon iconOn = new ImageIcon(this.getClass().getResource("icons/loupe_green.gif"));
        ImageIcon iconOff = new ImageIcon(this.getClass().getResource("icons/loupe_grey.gif"));
        JCheckBox isEnabled = new JCheckBox();
        isEnabled.setBorder(null);
        isEnabled.setSelectedIcon(iconOn);
        isEnabled.setDisabledSelectedIcon(iconOff);
        isEnabled.setMaximumSize(new Dimension(16, 16));
        isEnabled.setMinimumSize(new Dimension(16, 16));
        isEnabled.setPreferredSize(new Dimension(16, 16));
        isEnabled.setSelected(false);
        isEnabled.setIcon(iconOff);
        isEnabled.setOpaque(true);
        isEnabled.setSelected(rule.isEnabled());
        isEnabled.setToolTipText("En-/Disable rule checking");
        return isEnabled;
    }

    private JLabel createLabel(Rule rule) {
        JLabel label = new JLabel(this.mI18nStringsMap.get(rule.getName()).toString() + GAP);
        label.setForeground(rule.isEnabled() ? Color.black : Color.gray);
        return label;
    }

    private JButton createSeverity(Rule rule) {
        if (rule.getSeverity() == 0) {
            return new JButton("don't show");
        }
        ImageIcon[] icons = new ImageIcon[]{new ImageIcon(this.getClass().getResource("icons/dia_green.gif")), new ImageIcon(this.getClass().getResource("icons/dia_white.gif")), new ImageIcon(this.getClass().getResource("icons/dia_yellow.gif")), new ImageIcon(this.getClass().getResource("icons/dia_orange.gif")), new ImageIcon(this.getClass().getResource("icons/dia_red.gif"))};
        final JButton button = new JButton(icons[rule.getSeverity() - 1]);
        final JPopupMenu popup = new JPopupMenu();
        class SeverityAction
        extends AbstractAction {
            int mLevel;
            private final /* synthetic */ JButton val$button;
            private final /* synthetic */ Rule val$rule;
            private final /* synthetic */ AbstractJcscTab this$0;

            SeverityAction(AbstractJcscTab this$0, JButton val$button, Rule val$rule, String name, Icon icon, int level) {
                super(name, icon);
                this.this$0 = this$0;
                this.val$button = val$button;
                this.val$rule = val$rule;
                this.mLevel = level;
            }

            public void actionPerformed(ActionEvent e) {
                this.val$button.setIcon((Icon)this.getValue("SmallIcon"));
                this.val$rule.setSeverity(this.mLevel);
            }
        }
        popup.add(new SeverityAction(this, button, rule, "Level 5 - Severe", icons[4], 5));
        popup.add(new SeverityAction(this, button, rule, "Level 4", icons[3], 4));
        popup.add(new SeverityAction(this, button, rule, "Level 3 - Warning", icons[2], 3));
        popup.add(new SeverityAction(this, button, rule, "Level 2", icons[1], 2));
        popup.add(new SeverityAction(this, button, rule, "Level 1 - Notice", icons[0], 1));
        button.setMaximumSize(new Dimension(22, 21));
        button.setMinimumSize(new Dimension(22, 21));
        button.setPreferredSize(new Dimension(22, 21));
        button.setEnabled(rule.isEnabled());
        button.setBorder(null);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                popup.setSelected(popup.getComponent(3));
                popup.show(AbstractJcscTab.this, button.getX() + 20, button.getY());
            }
        });
        button.setToolTipText("Set severity of rule");
        return button;
    }

    private JComponent createRule(Rule rule) {
        JComponent component = null;
        if (rule.getType().equals("boolean")) {
            component = this.createBooleanComponent(rule);
        } else if (rule.getType().equals("regexp")) {
            component = this.createRegexpComponent(rule);
        } else if (rule.getType().equals("regexp-multiline")) {
            component = this.createRegexpMultiLineComponent(rule);
        } else if (rule.getType().equals("integer")) {
            component = this.createIntegerComponent(rule);
        } else if (rule.getType().equals("multichoice")) {
            component = this.createMultiChoiceComponent(rule);
        }
        return component;
    }

    private JComponent createBooleanComponent(Rule rule) {
        JCheckBox cb = new JCheckBox();
        cb.setSelected(AbstractJcscTab.booleanFromString(rule.getValue()));
        cb.setToolTipText("Enforce rule");
        return cb;
    }

    private JComponent createRegexpComponent(final Rule rule) {
        RegexpDialog.RegTextField upperWidget = new RegexpDialog.RegTextField();
        RegexpDialog.RegTextField lowerWidget = new RegexpDialog.RegTextField();
        final TextFieldButton tfb = new TextFieldButton();
        tfb.setText(rule.getValue());
        tfb.addActionListener(new RegexpActionListener(tfb, upperWidget, lowerWidget));
        tfb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equalsIgnoreCase("AC_TEXTFIELD")) {
                    rule.setValue(tfb.getText());
                }
            }
        });
        tfb.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                rule.setValue(tfb.getText());
            }
        });
        tfb.setToolTipText("Regexp rule value");
        return tfb;
    }

    private JComponent createRegexpMultiLineComponent(final Rule rule) {
        final RegexpDialog.RegTextArea upperWidget = new RegexpDialog.RegTextArea();
        final RegexpDialog.RegTextArea lowerWidget = new RegexpDialog.RegTextArea();
        final JButton button = new JButton("...");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RegexpDialog rd = new RegexpDialog(button, upperWidget, lowerWidget);
                rd.setRegexp(rule.getValue());
                ((Component)rd).setVisible(true);
                rule.setValue(upperWidget.getExpressionText());
                button.setToolTipText(AbstractJcscTab.this.createHTMLToolTip(rule.getValue()));
            }
        });
        button.setToolTipText(this.createHTMLToolTip(rule.getValue()));
        return button;
    }

    private String createHTMLToolTip(String tooltip) {
        try {
            RE re = new RE(new char[]{'\n'});
            tooltip = re.substituteAll(tooltip, "<br>");
        }
        catch (REException e) {
            e.printStackTrace();
        }
        return "<html><code>" + tooltip + "<code><html>";
    }

    private JComponent createIntegerComponent(final Rule rule) {
        final JTextField tf = new JTextField(new DecimalNumberDocument(), "0", 3);
        tf.setText(rule.getValue());
        tf.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                rule.setValue(tf.getText());
            }
        });
        tf.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                rule.setValue(tf.getText());
            }

            public void focusGained(FocusEvent e) {
            }
        });
        tf.setToolTipText("integer value");
        return tf;
    }

    private JComponent createMultiChoiceComponent(final Rule rule) {
        final JComboBox<String> cb = new JComboBox<String>(rule.getChoices());
        cb.setSelectedItem(rule.getValue());
        cb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                rule.setValue(cb.getSelectedItem().toString());
            }
        });
        cb.setToolTipText("multichoice value");
        return cb;
    }

    private void createEnabledListener(JToggleButton isEnabled, final Rule rule, final JLabel ruleLabel, final JComponent component, final JButton severity) {
        isEnabled.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                boolean flag = ((JToggleButton)e.getSource()).isSelected();
                rule.setEnabled(flag);
                ruleLabel.setForeground(flag ? Color.black : Color.gray);
                component.setEnabled(flag);
                severity.setEnabled(flag);
            }
        });
    }

    private void addRule(Rule rule) {
        GridBagConstraints c = new GridBagConstraints();
        JCheckBox isEnabled = this.createIsEnabled(rule);
        JLabel ruleLabel = this.createLabel(rule);
        JButton severity = this.createSeverity(rule);
        JComponent component = this.createRule(rule);
        this.createEnabledListener(isEnabled, rule, ruleLabel, component, severity);
        this.addExampleCodeListener(new Component[]{isEnabled, ruleLabel, component, severity}, rule);
        isEnabled.setSelected(rule.isEnabled());
        c.gridx = 0;
        c.gridy = this.mRuleCount;
        c.weightx = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.mLayout.setConstraints(isEnabled, c);
        this.add(isEnabled);
        c.gridx = 1;
        c.gridy = this.mRuleCount;
        c.weightx = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.mLayout.setConstraints(ruleLabel, c);
        this.add(ruleLabel);
        c.gridx = 2;
        c.gridy = this.mRuleCount;
        c.weightx = 1.0;
        c.gridwidth = severity.getText().equals("don't show") ? 2 : 1;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.mLayout.setConstraints(component, c);
        this.add(component);
        if (!severity.getText().equals("don't show")) {
            c.gridx = 3;
            c.gridy = this.mRuleCount;
            c.weightx = 0.0;
            c.fill = 2;
            c.insets = new Insets(0, 0, 0, 0);
            this.mLayout.setConstraints(severity, c);
            this.add(severity);
        }
    }

    public abstract ExamplePanel getExamplePane();

    public void setI18nStrings(Map map) {
        this.mI18nStringsMap = map;
    }

    void addExampleCodeListener(Component[] components, Rule rule) {
        new ExampleCodeMouseListener(components, rule, this.getExamplePane());
    }

    public abstract void setRules(Map var1);

    public class ExampleCodeMouseListener
    implements MouseListener {
        private Rule mRule;
        private ExamplePanel mExamplePanel;

        private ExampleCodeMouseListener(Component[] components, Rule rule, ExamplePanel examplePanel) {
            this.mRule = rule;
            this.mExamplePanel = examplePanel;
            int i = 0;
            int count = components.length;
            while (i < count) {
                if (components[i] instanceof JComboBox) {
                    JComboBox c = (JComboBox)components[i];
                    int j = 0;
                    int cc = c.getComponentCount();
                    while (j < cc) {
                        c.getComponent(j).addMouseListener(this);
                        ++j;
                    }
                } else {
                    components[i].addMouseListener(this);
                }
                ++i;
            }
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
            this.showExampleCode();
        }

        public void mouseExited(MouseEvent e) {
            this.showExampleCode();
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        private void showExampleCode() {
            URL url = this.getClass().getResource("examplehtml/" + this.mRule.getExamplePath());
            String name = AbstractJcscTab.this.mI18nStringsMap.get(this.mRule.getName()).toString();
            String title = "<html>Name:&nbsp;<i><font color=\"#0000ff\">" + name + "</font></i>" + "&nbsp;&nbsp;-&nbsp;&nbsp;" + "Key:&nbsp;<i><font color=\"#0000ff\">" + this.mRule.getName() + "</font></i></html>";
            this.mExamplePanel.setPage(url);
            this.mExamplePanel.setTitle(title);
        }
    }
}

