/*
 * Decompiled with CFR 0.152.
 */
package rj.tools.jcsc.rules;

import java.io.IOException;
import java.util.Date;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import rj.tools.jcsc.rules.Rule;
import rj.tools.jcsc.rules.RulesHandler;

public class XMLRulesMapTest
extends TestCase {
    static /* synthetic */ Class class$rj$tools$jcsc$rules$XMLRulesMapTest;

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(class$rj$tools$jcsc$rules$XMLRulesMapTest == null ? (class$rj$tools$jcsc$rules$XMLRulesMapTest = XMLRulesMapTest.class$("rj.tools.jcsc.rules.XMLRulesMapTest")) : class$rj$tools$jcsc$rules$XMLRulesMapTest);
        return suite;
    }

    public XMLRulesMapTest(String name) {
        super(name);
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testFindElement() {
        try {
            Map cache = new RulesHandler().readRulesFile("junit-src/rj/tools/jcsc/rules/test.jcsc.xml");
            Rule rule = (Rule)cache.get("Rule1");
            Assert.assertNotNull((String)"element not found", (Object)rule);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public void testCaching() {
        Map cache = null;
        try {
            cache = new RulesHandler().readRulesFile("junit-src/rj/tools/jcsc/rules/test.jcsc.xml");
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        Rule rule = (Rule)cache.get("Rule1");
        long first = 0L;
        long second = 0L;
        long millis = new Date().getTime();
        rule = (Rule)cache.get("Rule1");
        Assert.assertEquals((String)"name is wrong", (String)"Rule1", (String)rule.getName());
        Assert.assertEquals((String)"type is wrong", (String)"regexp", (String)rule.getType());
        Assert.assertEquals((String)"value is wrong", (String)"[a-z]*", (String)rule.getValue());
        Assert.assertEquals((String)"priority is wrong", (int)5, (int)rule.getSeverity());
        rule = (Rule)cache.get("Rule2");
        Assert.assertEquals((String)"name is wrong", (String)"Rule2", (String)rule.getName());
        Assert.assertEquals((String)"type is wrong", (String)"boolean", (String)rule.getType());
        Assert.assertEquals((String)"value is wrong", (String)"true", (String)rule.getValue());
        Assert.assertEquals((String)"priority is wrong", (int)3, (int)rule.getSeverity());
        rule = (Rule)cache.get("Rule3");
        Assert.assertEquals((String)"name is wrong", (String)"Rule3", (String)rule.getName());
        Assert.assertEquals((String)"type is wrong", (String)"integer", (String)rule.getType());
        Assert.assertEquals((String)"value is wrong", (String)"80", (String)rule.getValue());
        Assert.assertEquals((String)"priority is wrong", (int)4, (int)rule.getSeverity());
        first = new Date().getTime() - millis;
        millis = new Date().getTime();
        rule = (Rule)cache.get("Rule1");
        Assert.assertEquals((String)"name is wrong", (String)"Rule1", (String)rule.getName());
        Assert.assertEquals((String)"type is wrong", (String)"regexp", (String)rule.getType());
        Assert.assertEquals((String)"value is wrong", (String)"[a-z]*", (String)rule.getValue());
        Assert.assertEquals((String)"priority is wrong", (int)5, (int)rule.getSeverity());
        rule = (Rule)cache.get("Rule2");
        Assert.assertEquals((String)"name is wrong", (String)"Rule2", (String)rule.getName());
        Assert.assertEquals((String)"type is wrong", (String)"boolean", (String)rule.getType());
        Assert.assertEquals((String)"value is wrong", (String)"true", (String)rule.getValue());
        Assert.assertEquals((String)"priority is wrong", (int)3, (int)rule.getSeverity());
        rule = (Rule)cache.get("Rule3");
        Assert.assertEquals((String)"name is wrong", (String)"Rule3", (String)rule.getName());
        Assert.assertEquals((String)"type is wrong", (String)"integer", (String)rule.getType());
        Assert.assertEquals((String)"value is wrong", (String)"80", (String)rule.getValue());
        Assert.assertEquals((String)"priority is wrong", (int)4, (int)rule.getSeverity());
        second = new Date().getTime() - millis;
        Assert.assertTrue((String)("Cache not working: " + (second - first)), (second <= first ? 1 : 0) != 0);
    }

    public void testChoices() {
        Map cache = null;
        try {
            cache = new RulesHandler().readRulesFile("junit-src/rj/tools/jcsc/rules/test.jcsc.xml");
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        Rule rule = (Rule)cache.get("Rule4");
        String[] choices = rule.getChoices();
        Assert.assertEquals((String)"choice 1 is wrong", (String)"choice one", (String)choices[0]);
        Assert.assertEquals((String)"choice 2 is wrong", (String)"choice two", (String)choices[1]);
        Assert.assertEquals((String)"choice 3 is wrong", (String)"choice three", (String)choices[2]);
        Assert.assertEquals((String)"choice 4 is wrong", (String)"choice four", (String)choices[3]);
        rule = (Rule)cache.get("Rule1");
        choices = rule.getChoices();
        Assert.assertEquals((String)"choices are not an empty String", (int)0, (int)choices.length);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

