/*
 * Decompiled with CFR 0.152.
 */
package rj.tools.jcsc.rules;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import rj.tools.jcsc.rules.Rule;

public class XMLRulesMap
extends AbstractMap {
    private Document mDocument;
    private HashMap mRulesCache = new HashMap();

    public XMLRulesMap(Document document) {
        this.mDocument = document;
    }

    public Object get(Object key) {
        if (this.mRulesCache.containsKey(key)) {
            return (Rule)this.mRulesCache.get(key);
        }
        Rule rule = this.findRule(this.mDocument, key.toString());
        this.mRulesCache.put(key, rule);
        return rule;
    }

    public Set entrySet() {
        return this.mRulesCache.entrySet();
    }

    private Rule findRule(Document document, String name) {
        NodeList list = document.getElementsByTagName("rule");
        int i = 0;
        int count = list.getLength();
        while (i < count) {
            Node node = list.item(i);
            NamedNodeMap attributes = node.getAttributes();
            String ruleName = null;
            String category = null;
            String enabled = null;
            boolean isFound = false;
            int j = 0;
            int count2 = attributes.getLength();
            while (j < count2) {
                Node current = attributes.item(j);
                if (current.getNodeName().equals("category")) {
                    category = current.getNodeValue();
                } else if (current.getNodeName().equals("enabled")) {
                    enabled = current.getNodeValue();
                } else if (current.getNodeName().equals("name") && current.getNodeValue().equals(name)) {
                    isFound = true;
                    ruleName = current.getNodeValue();
                }
                ++j;
            }
            if (isFound) {
                return this.buildRule(node, ruleName, category, enabled);
            }
            ++i;
        }
        return null;
    }

    private String getValue(Node node, String name) {
        NodeList children = node.getChildNodes();
        if (children != null) {
            int i = 0;
            int count = children.getLength();
            while (i < count) {
                Node child = children.item(i);
                if (child.getNodeName().equals(name)) {
                    if (child.getChildNodes().item(0) != null) {
                        return child.getChildNodes().item(0).getNodeValue();
                    }
                    return "";
                }
                ++i;
            }
        }
        return null;
    }

    private String[] getValues(Node node, String name, String multi) {
        NodeList children = node.getChildNodes();
        if (children != null) {
            int i = 0;
            int count = children.getLength();
            while (i < count) {
                Node child = children.item(i);
                if (child.getNodeName().equals(name)) {
                    NodeList list = child.getChildNodes();
                    ArrayList<String> choices = new ArrayList<String>();
                    if (list != null) {
                        int k = 0;
                        int count3 = list.getLength();
                        while (k < count3) {
                            Node choice = list.item(k);
                            if (choice.getNodeName().equals(multi)) {
                                choices.add(choice.getFirstChild().getNodeValue());
                            }
                            ++k;
                        }
                    }
                    return choices.toArray(new String[choices.size()]);
                }
                ++i;
            }
        }
        return new String[0];
    }

    private Rule buildRule(Node node, String name, String category, String enabled) {
        String type = this.getValue(node, "type");
        String value = this.getValue(node, "value");
        String severity = this.getValue(node, "severity");
        String[] choices = this.getValues(node, "choices", "choice");
        if (null == severity) {
            System.err.println("\n\nThe XML of the rules file has been changed:");
            System.err.println(" <priority> to <severity>");
            System.err.println(" </priority> to </severity>\n\n");
            System.exit(1);
        }
        return new Rule(name, category, enabled, type, value, severity, choices);
    }
}

