/*
 * Decompiled with CFR 0.152.
 */
package rj.tools.jcsc.rules;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import rj.tools.jcsc.rules.Rule;
import rj.tools.jcsc.rules.XMLRulesMap;

public class RulesHandler {
    public static final String JCSC = "jcsc";
    public static final String RULES = "rules";
    public static final String RULE = "rule";
    public static final String TYPE = "type";
    public static final String VALUE = "value";
    public static final String SEVERITY = "severity";
    public static final String CHOICES = "choices";
    public static final String CHOICE = "choice";
    private PrintStream mPrintStream;
    private int mIndent;

    public void setPrintStream(PrintStream ps) {
        this.mPrintStream = ps;
    }

    public void persistRules(Map map) {
        this.mPrintStream.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>");
        this.mPrintStream.println("<?xml-stylesheet href=\"xsl/rules.xsl\" type=\"text/xsl\"?>");
        this.openTag(JCSC, new String[]{"version=\"__0.96__\"", "date=\"" + this.getDate() + "\""});
        this.openTag(RULES);
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            Rule rule = (Rule)map.get(iter.next());
            this.openTag(RULE, new String[]{"name=\"" + rule.getName() + "\"", "category=\"" + rule.getCategory() + "\"", "enabled=\"" + rule.isEnabled() + "\""});
            this.tag(TYPE, rule.getType());
            if (rule.getType().equals("multichoice")) {
                this.openTag(CHOICES);
                String[] choices = rule.getChoices();
                int i = 0;
                int count = choices.length;
                while (i < count) {
                    this.tag(CHOICE, choices[i]);
                    ++i;
                }
                this.closeTag(CHOICES);
            }
            this.tag(VALUE, rule.getValue());
            this.tag(SEVERITY, Integer.toString(rule.getSeverity()));
            this.closeTag(RULE);
        }
        this.closeTag(RULES);
        this.closeTag(JCSC);
    }

    public void printIndent() {
        int i = 0;
        while (i < this.mIndent) {
            this.mPrintStream.print("   ");
            ++i;
        }
    }

    public void openTag(String tag) {
        this.printIndent();
        this.mPrintStream.println("<" + tag + ">");
        ++this.mIndent;
    }

    public void openTag(String tag, String[] attributes) {
        this.printIndent();
        this.mPrintStream.print("<" + tag + " ");
        int i = 0;
        int count = attributes.length;
        while (i < count) {
            this.mPrintStream.print(attributes[i]);
            if (i + 1 < count) {
                this.mPrintStream.print(" ");
            }
            ++i;
        }
        this.mPrintStream.println(">");
        ++this.mIndent;
    }

    public void tag(String tagName, String value) {
        this.printIndent();
        this.mPrintStream.print("<" + tagName + ">");
        this.mPrintStream.print(value);
        this.mPrintStream.println("</" + tagName + ">");
    }

    public void closeTag(String tag) {
        --this.mIndent;
        this.printIndent();
        this.mPrintStream.println("</" + tag + ">");
    }

    private String getDate() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return df.format(new Date());
    }

    public Map readZipRulesFile(String fileName) throws IOException {
        InputStream is = null;
        XMLRulesMap map = null;
        boolean isError = false;
        try {
            URL url = Class.forName("rj.tools.jcsc.rules.RuleConstants").getResource(fileName);
            is = url.openStream();
            map = this.createRulesMap(is);
        }
        catch (ClassNotFoundException e) {
            isError = true;
        }
        catch (IOException e) {
            isError = true;
        }
        catch (SAXException e) {
            isError = true;
        }
        catch (RuntimeException e) {
            isError = true;
        }
        if (isError) {
            throw new IOException("'" + fileName + "' could not be found in the .jar file");
        }
        return map;
    }

    public Map readRulesFile(String fileName) throws IOException {
        XMLRulesMap map = null;
        boolean isError = false;
        try {
            map = this.createRulesMap(new FileInputStream(fileName));
        }
        catch (SAXException e) {
            isError = true;
        }
        catch (IOException e) {
            isError = true;
        }
        if (isError) {
            try {
                return this.readZipRulesFile(fileName);
            }
            catch (IOException e2) {
                throw new IOException("'" + fileName + "' could not be found");
            }
        }
        return map;
    }

    private XMLRulesMap createRulesMap(InputStream stream) throws SAXException, IOException {
        ClassLoader savedClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        DOMParser parser = new DOMParser();
        parser.parse(new InputSource(stream));
        Document document = parser.getDocument();
        Thread.currentThread().setContextClassLoader(savedClassLoader);
        XMLRulesMap rm = new XMLRulesMap(document);
        return rm;
    }

    public Properties readPropertiesRulesFile(String fileName) throws IOException {
        try {
            Properties p = new Properties();
            p.load(new FileInputStream(new File(fileName)));
            return p;
        }
        catch (IOException e) {
            throw new IOException("'" + fileName + "' could not be found");
        }
    }
}

