/*
 * Decompiled with CFR 0.152.
 */
package rj.tools.jcsc.rules;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import rj.tools.jcsc.rules.RulesHandler;
import rj.tools.util.ui.RegexpDialog;

public class Properties2Xml {
    private String mResultFileName;
    private RulesHandler mRH;
    private Properties mProperties;
    private PrintStream mPrintStream;

    public static void main(String[] args) {
        if (args.length != 1) {
            System.exit(1);
        }
        new Properties2Xml(args[0]).transform();
    }

    public Properties2Xml(String propertiesFile) {
        try {
            this.mResultFileName = propertiesFile;
            this.mProperties = new RulesHandler().readPropertiesRulesFile(this.mResultFileName);
        }
        catch (IOException e) {
            throw new RuntimeException("The output .xml cannot be written");
        }
    }

    public void transform() {
        try {
            try {
                this.mPrintStream = new PrintStream(new FileOutputStream(this.mResultFileName + ".xml"));
                this.mRH = new RulesHandler();
                this.mRH.setPrintStream(this.mPrintStream);
                this.mRH.openTag("jcsc", new String[]{"version=\"__0.96__\"", "date=\"n/a\""});
                this.mRH.openTag("rules");
                this.printRules(this.mProperties);
                this.printConfigRules();
                this.mRH.closeTag("rules");
                this.mRH.closeTag("jcsc");
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("The output .xml cannot be created");
            }
            Object var3_1 = null;
            this.mPrintStream.close();
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.mPrintStream.close();
            throw throwable;
        }
    }

    private void printRules(Properties properties) {
        Iterator iter = ((Hashtable)properties).keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String value = (String)((Hashtable)properties).get(key);
            this.rule(this.getName(key), this.getCategory(key), "true", value);
        }
    }

    private void printConfigRules() {
        this.printRule("SortViolationsBy", "Configuration", "true", "Occurence", "0");
    }

    private void rule(String name, String category, String enabled, String value) {
        if (!this.shallMove2XML(name, category, value)) {
            return;
        }
        if (value.equals("-1")) {
            enabled = "false";
            value = "0";
        } else if (value.equalsIgnoreCase("either")) {
            enabled = "false";
            value = "true";
        }
        this.printRule(name, category, enabled, value, "3");
    }

    private void printRule(String name, String category, String enabled, String value, String priority) {
        enabled = this.updateEnabled(name, enabled);
        this.mRH.openTag("rule", new String[]{"name=\"" + name + "\"", "category=\"" + category + "\"", "enabled=\"" + enabled + "\""});
        String type = this.getType(value, name);
        value = this.updateValue(name, value);
        this.mRH.tag("type", type);
        if (type.equals("multichoice")) {
            this.makeMultiChoice(name);
        }
        this.mRH.tag("value", value);
        this.mRH.tag("severity", priority);
        this.mRH.closeTag("rule");
    }

    private String updateEnabled(String key, String value) {
        if (key.equals("TypeHeaderExpression")) {
            value = (String)((Hashtable)this.mProperties).get("General.TypeHeader");
        } else if (key.equals("UnitTestClassRegExp")) {
            value = (String)((Hashtable)this.mProperties).get("Unit.CountUnitTestClasses");
        } else if (key.equals("UnitTestsRegExp")) {
            value = (String)((Hashtable)this.mProperties).get("Unit.CountUnitTests");
        } else if (key.equals("AllowedComplexLoopExpression")) {
            value = (String)((Hashtable)this.mProperties).get("General.ComplexLoopExpression");
        }
        return value;
    }

    private String updateValue(String key, String value) {
        if (key.equals("TypeHeaderExpression")) {
            value = "<![CDATA[" + RegexpDialog.unescapeNewLine(value) + "]]>";
        } else if (value.equals("NTPR_BEGINNING_OF_CLASS")) {
            value = "Beginning of Class";
        } else if (value.equals("NTPR_END_OF_CLASS")) {
            value = "End of Class";
        } else if (value.equals("FPR_BEFORE_METHOD")) {
            value = "Field Block Before Method Block";
        } else if (value.equals("FPR_AFTER_METHOD")) {
            value = "Field Block After Method Block";
        } else if (value.equals("FOR_NO_ORDER")) {
            value = "No Order";
        } else if (value.equals("FOR_PUBPROPACPRI")) {
            value = "Pub->Pro->Pac->Pri";
        } else if (value.equals("FOR_PRIPACPROPUB")) {
            value = "Pri->Pac->Pro->Pub";
        } else if (value.equals("FOR_STATFIN_STAT_INS")) {
            value = "Static Final->Static->Inst";
        } else if (value.equals("MPR_BEFORE_FIELD")) {
            value = "Method Block Before Field Block";
        } else if (value.equals("MPR_AFTER_FIELD")) {
            value = "Method Block After Field Block";
        } else if (value.equals("MOR_NO_ORDER")) {
            value = "No Order";
        } else if (value.equals("MOR_PUBPROPACPRI")) {
            value = "Pub->Pro->Pac->Pri";
        } else if (value.equals("MOR_PRIPACPROPUB")) {
            value = "Pri->Pac->Pro->Pub";
        } else if (value.equals("MOR_CTOR_INS_STAT")) {
            value = "Ctor->Inst->Static";
        } else if (value.equals("MOR_CTOR_STAT_INS")) {
            value = "Ctor->Static->Inst";
        } else if (value.equals("MOR_STAT_CTOR_INS")) {
            value = "Static Final->Static->Inst";
        }
        return value;
    }

    private void makeMultiChoice(String name) {
        this.mRH.openTag("choices");
        if (name.equals("NestedTypeBlockPlaceRule")) {
            this.mRH.tag("choice", "Beginning of Class");
            this.mRH.tag("choice", "End of Class");
        } else if (name.equals("FieldBlockPlaceRule")) {
            this.mRH.tag("choice", "Field Block Before Method Block");
            this.mRH.tag("choice", "Field Block After Method Block");
        } else if (name.equals("FieldOrderRule")) {
            this.mRH.tag("choice", "No Order");
            this.mRH.tag("choice", "Pub->Pro->Pac->Pri");
            this.mRH.tag("choice", "Pri->Pac->Pro->Pub");
            this.mRH.tag("choice", "Static Final->Static->Inst");
        } else if (name.equals("MethodBlockPlaceRule")) {
            this.mRH.tag("choice", "Method Block Before Field Block");
            this.mRH.tag("choice", "Method Block After Field Block");
        } else if (name.equals("MethodOrderRule")) {
            this.mRH.tag("choice", "No Order");
            this.mRH.tag("choice", "Pub->Pro->Pac->Pri");
            this.mRH.tag("choice", "Pri->Pac->Pro->Pub");
            this.mRH.tag("choice", "Ctor->Inst->Static");
            this.mRH.tag("choice", "Ctor->Static->Inst");
            this.mRH.tag("choice", "Static Final->Static->Inst");
        } else if (name.equals("SortViolationsBy")) {
            this.mRH.tag("choice", "Occurence");
            this.mRH.tag("choice", "Priority");
            this.mRH.tag("choice", "Rulekey");
        }
        this.mRH.closeTag("choices");
    }

    private boolean shallMove2XML(String name, String category, String value) {
        if (category.equalsIgnoreCase("unittest")) {
            if (name.equalsIgnoreCase("CountUnitTestClasses")) {
                return false;
            }
            if (name.equalsIgnoreCase("CountUnitTests")) {
                return false;
            }
        } else if (category.equalsIgnoreCase("general")) {
            if (name.equalsIgnoreCase("TypeHeader")) {
                return false;
            }
            if (name.equalsIgnoreCase("ComplexLoopExpression")) {
                return false;
            }
        }
        return true;
    }

    private String getCategory(String fullName) {
        String category = fullName.substring(0, fullName.indexOf("."));
        return category.equals("Unit") ? "Unittest" : category;
    }

    private String getName(String fullName) {
        return fullName.substring(fullName.indexOf(".") + 1);
    }

    private String getType(String value, String name) {
        try {
            Integer.parseInt(value);
            return "integer";
        }
        catch (NumberFormatException numberFormatException) {
            if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
                return "boolean";
            }
            if (value.equalsIgnoreCase("either")) {
                return "boolean";
            }
            if (value.startsWith("NTPR_") || value.startsWith("FPR_") || value.startsWith("FOR_") || value.startsWith("MPR_") || value.startsWith("MOR_") || value.startsWith("FOR_") || value.startsWith("Occurence")) {
                return "multichoice";
            }
            if (name.equals("TypeHeaderExpression")) {
                return "regexp-multiline";
            }
            return "regexp";
        }
    }
}

