/*
 * Decompiled with CFR 0.152.
 */
package rj.tools.jcsc.formatter;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import rj.tools.jcsc.MethodMetric;
import rj.tools.jcsc.Violation;
import rj.tools.jcsc.ant.PackageStatistics;
import rj.tools.jcsc.ant.WorstElement;
import rj.tools.jcsc.formatter.AbstractResultsFormatter;
import rj.tools.jcsc.rules.Rule;

public class XMLResultsFormatter
extends AbstractResultsFormatter {
    private static final String INDENT = "  ";
    private ArrayList mAllClasses = new ArrayList();

    public void format() {
        this.mAllClasses.add(this.mPackage + "." + this.mClass);
        PrintStream ps = new PrintStream(this.mOutputStream);
        ps.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>");
        ps.println("<?xml-stylesheet href=\"xsl/class.xsl\" type=\"text/xsl\"?>");
        ps.println("<jcsc>");
        ps.println("  <package>" + this.mPackage + "</package>");
        ps.println("  <class>" + this.mClass + "</class>");
        ps.println("  <methods>" + this.mMethodsCount + "</methods>");
        ps.println("  <author><![CDATA[" + this.mAuthors + "]]></author>");
        ps.println("  <count>" + this.mViolationsCount + "</count>");
        ps.println("  <ncss>" + this.mNCSSCount + "</ncss>");
        ps.println("  <lines>" + this.mLineCount + "</lines>");
        ps.println("  <unittestclasses>" + this.mUnitTestClassCount + "</unittestclasses>");
        ps.println("  <unittests>" + this.mUnitTestsCount + "</unittests>");
        ListIterator iter = this.mViolations.listIterator();
        while (iter.hasNext()) {
            Violation v = (Violation)iter.next();
            XMLResultsFormatter.printViolation(v, ps, 1);
        }
        Iterator iter2 = this.mMethodMetrics.iterator();
        while (iter2.hasNext()) {
            MethodMetric mm = (MethodMetric)iter2.next();
            ps.println("  <metric>");
            ps.println("    <method>>");
            ps.println("      <name>" + mm.getMethodName() + "</name>");
            ps.println("      <line>" + mm.getLine() + "</line>");
            ps.println("      <column>" + mm.getColumn() + "</column>");
            ps.println("      <ncss>" + mm.getNCSSCount() + "</ncss>");
            ps.println("      <ccn>" + mm.getCCNCount() + "</ccn>");
            ps.println("    </method>");
            ps.println("  </metric>");
        }
        ps.println("</jcsc>");
        ps.close();
    }

    public void formatBatch() {
        if (this.isBatchMode()) {
            this.handleBatchMode();
        }
    }

    private void handleBatchMode() {
        this.writeOverviewXML();
        this.writePackageOverviewXML();
        this.writeAllPackagesXML();
        this.writeAllClassesXML();
        this.writeViolationsByCategoryXML();
        this.writeViolationsByRuleXML();
        this.writeViolatedCategoriesXML();
        this.writeViolationsBySeverityXML();
        this.writeViolatedSeveritiesXML();
    }

    private void writeAllPackagesXML() {
        try {
            PrintStream pps = new PrintStream(new FileOutputStream(this.mBatchSummary.getDestDir() + File.separatorChar + "packagelist.xml"));
            List packNames = this.mBatchSummary.getOverviewStatistics().getPackageNames();
            Collections.sort(packNames);
            pps.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
            pps.println("<?xml-stylesheet href=\"xsl/packagelist.xsl\" type=\"text/xsl\"?>");
            pps.println("<jcsc>");
            pps.println("  <packagelist>");
            Iterator iter = packNames.iterator();
            while (iter.hasNext()) {
                String packName = (String)iter.next();
                List classNames = this.mBatchSummary.getOverviewStatistics().getClassNamesOfPackage(packName);
                Collections.sort(classNames);
                pps.println("    <package>" + packName + "</package>");
                this.writeQualifiedPackageXml(packName, classNames);
            }
            pps.println("  </packagelist>");
            pps.println("  <categories>");
            Iterator iter2 = this.mBatchSummary.getOverviewStatistics().getViolatedCategories().iterator();
            while (iter2.hasNext()) {
                pps.println("    <category>" + iter2.next() + "</category>");
            }
            pps.println("  </categories>");
            pps.println("  <severities>");
            Iterator iter3 = this.mBatchSummary.getOverviewStatistics().getViolatedSeverities().iterator();
            while (iter3.hasNext()) {
                pps.println("    <severity>" + iter3.next() + "</severity>");
            }
            pps.println("  </severities>");
            pps.println("</jcsc>");
            pps.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace(System.err);
        }
    }

    private void writeQualifiedPackageXml(String packName, List classNames) {
        try {
            PrintStream cps = new PrintStream(new FileOutputStream(this.mBatchSummary.getDestDir() + File.separatorChar + packName + ".xml"));
            cps.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>");
            cps.println("<?xml-stylesheet href=\"xsl/package.xsl\" type=\"text/xsl\"?>");
            cps.println("<jcsc>");
            cps.println("  <classlist>");
            cps.println("    <package>" + packName + "</package>");
            cps.println("    <classes>");
            Iterator iter2 = classNames.iterator();
            while (iter2.hasNext()) {
                String className = (String)iter2.next();
                cps.println("      <class>" + packName + "." + className + "</class>");
            }
            cps.println("    </classes>");
            cps.println("  </classlist>");
            cps.println("</jcsc>");
            cps.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace(System.err);
        }
    }

    private void writeAllClassesXML() {
        try {
            PrintStream aps = new PrintStream(new FileOutputStream(this.mBatchSummary.getDestDir() + File.separatorChar + "allclasses.xml"));
            aps.println("<?xml version=\"1.0\"?>");
            aps.println("<?xml-stylesheet href=\"xsl/package.xsl\" type=\"text/xsl\"?>");
            aps.println("<jcsc>");
            aps.println("  <classlist>");
            aps.println("    <package>All Classes</package>");
            aps.println("    <classes>");
            Collections.sort(this.mAllClasses, new Comparator(){

                public int compare(Object o1, Object o2) {
                    String s1 = ((String)o1).substring(((String)o1).lastIndexOf(".") + 1);
                    String s2 = ((String)o2).substring(((String)o2).lastIndexOf(".") + 1);
                    return s1.compareToIgnoreCase(s2);
                }
            });
            Iterator iter = ((AbstractList)this.mAllClasses).iterator();
            while (iter.hasNext()) {
                String className = (String)iter.next();
                aps.println("      <class>" + className + "</class>");
            }
            aps.println("    </classes>");
            aps.println("  </classlist>");
            aps.println("</jcsc>");
            aps.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace(System.err);
        }
    }

    private void writeViolatedCategoriesXML() {
        try {
            PrintStream ps = new PrintStream(new FileOutputStream(this.mBatchSummary.getDestDir() + File.separatorChar + "allcategories.xml"));
            ps.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
            ps.println("<?xml-stylesheet href=\"xsl/category.xsl\" type=\"text/xsl\"?>");
            ps.println("<jcsc>");
            ps.println("  <rulelist>");
            ps.println("    <category>All Categories</category>");
            ps.println("    <rules>");
            List rules = this.mBatchSummary.getOverviewStatistics().getViolatedRules();
            Collections.sort(rules, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((Rule)o1).getName().compareToIgnoreCase(((Rule)o2).getName());
                }
            });
            Iterator iter = rules.iterator();
            while (iter.hasNext()) {
                Rule rule = (Rule)iter.next();
                XMLResultsFormatter.printRule(rule, ps, 3);
            }
            ps.println("    </rules>");
            ps.println("  </rulelist>");
            ps.println("</jcsc>");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void writeViolatedSeveritiesXML() {
        try {
            PrintStream ps = new PrintStream(new FileOutputStream(this.mBatchSummary.getDestDir() + File.separatorChar + "allseverities.xml"));
            ps.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
            ps.println("<?xml-stylesheet href=\"xsl/severity.xsl\" type=\"text/xsl\"?>");
            ps.println("<jcsc>");
            ps.println("  <rulelist>");
            ps.println("    <severity>All Severities</severity>");
            ps.println("    <rules>");
            List rules = this.mBatchSummary.getOverviewStatistics().getViolatedRules();
            Collections.sort(rules, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((Rule)o1).getName().compareToIgnoreCase(((Rule)o2).getName());
                }
            });
            ListIterator iter = rules.listIterator();
            while (iter.hasNext()) {
                Rule rule = (Rule)iter.next();
                XMLResultsFormatter.printRule(rule, ps, 3);
            }
            ps.println("    </rules>");
            ps.println("  </rulelist>");
            ps.println("</jcsc>");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void writeViolationsByRuleXML() {
        try {
            List rules = this.mBatchSummary.getOverviewStatistics().getViolatedRules();
            Iterator iter = rules.iterator();
            while (iter.hasNext()) {
                Rule rule = (Rule)iter.next();
                List violations = this.mBatchSummary.getOverviewStatistics().getViolationByRuleName(rule.getName());
                PrintStream ps = new PrintStream(new FileOutputStream(this.mBatchSummary.getDestDir() + File.separatorChar + rule.getName() + ".xml"));
                ps.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
                ps.println("<?xml-stylesheet href=\"xsl/rule.xsl\" type=\"text/xsl\"?>");
                ps.println("<jcsc>");
                ps.println("  <category>" + rule.getCategory() + "</category>");
                ps.println("  <rule>" + rule.getName() + "</rule>");
                ps.println("  <violations>");
                Iterator iter2 = violations.iterator();
                while (iter2.hasNext()) {
                    Violation violation = (Violation)iter2.next();
                    XMLResultsFormatter.printViolation(violation, ps, 2);
                }
                ps.println("  </violations>");
                ps.println("</jcsc>");
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void writeViolationsByCategoryXML() {
        try {
            List categories = this.mBatchSummary.getOverviewStatistics().getViolatedCategories();
            Iterator iter = categories.iterator();
            while (iter.hasNext()) {
                String category = (String)iter.next();
                List violations = this.mBatchSummary.getOverviewStatistics().getViolationsByCategory(category);
                PrintStream ps = new PrintStream(new FileOutputStream(this.mBatchSummary.getDestDir() + File.separatorChar + category + ".xml"));
                ps.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
                ps.println("<?xml-stylesheet href=\"xsl/category.xsl\" type=\"text/xsl\"?>");
                ps.println("<jcsc>");
                ps.println("  <rulelist>");
                ps.println("    <category>" + category + "</category>");
                ps.println("    <rules>");
                Collections.sort(violations, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        return ((Violation)o1).getRule().getName().compareToIgnoreCase(((Violation)o2).getRule().getName());
                    }
                });
                Iterator iter2 = violations.iterator();
                while (iter2.hasNext()) {
                    Rule rule = ((Violation)iter2.next()).getRule();
                    XMLResultsFormatter.printRule(rule, ps, 3);
                }
                ps.println("    </rules>");
                ps.println("  </rulelist>");
                ps.println("</jcsc>");
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void writeViolationsBySeverityXML() {
        try {
            List categories = this.mBatchSummary.getOverviewStatistics().getViolatedSeverities();
            Iterator iter = categories.iterator();
            while (iter.hasNext()) {
                Integer severity = (Integer)iter.next();
                List violations = this.mBatchSummary.getOverviewStatistics().getViolationsBySeverity(severity);
                PrintStream ps = new PrintStream(new FileOutputStream(this.mBatchSummary.getDestDir() + File.separatorChar + severity + ".xml"));
                ps.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
                ps.println("<?xml-stylesheet href=\"xsl/severity.xsl\" type=\"text/xsl\"?>");
                ps.println("<jcsc>");
                ps.println("  <rulelist>");
                ps.println("    <severity>" + severity + "</severity>");
                ps.println("    <rules>");
                Collections.sort(violations, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        return ((Violation)o1).getRule().getName().compareToIgnoreCase(((Violation)o2).getRule().getName());
                    }
                });
                ListIterator iter2 = violations.listIterator();
                while (iter2.hasNext()) {
                    Rule rule = ((Violation)iter2.next()).getRule();
                    XMLResultsFormatter.printRule(rule, ps, 3);
                }
                ps.println("    </rules>");
                ps.println("  </rulelist>");
                ps.println("</jcsc>");
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void writeOverviewXML() {
        try {
            PrintStream ps = new PrintStream(new FileOutputStream(this.mBatchSummary.getDestDir() + File.separatorChar + "overview.xml"));
            ps.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>");
            ps.println("<?xml-stylesheet href=\"xsl/overview.xsl\" type=\"text/xsl\"?>");
            ps.println("<jcsc>");
            ps.println("  <overview>");
            ps.println("    <rules>" + this.mBatchSummary.getRulesName() + "</rules>");
            ps.println("    <timestamp>" + new Date().toString() + "</timestamp>");
            ps.println("    <packagename>Overview</packagename>");
            ps.println("    <packagecount>" + this.mBatchSummary.getOverviewStatistics().getPackageCount() + "</packagecount>");
            ps.println("    <classcount>" + this.mBatchSummary.getOverviewStatistics().getClassCount() + "</classcount>");
            ps.println("    <methodscount>" + this.mBatchSummary.getOverviewStatistics().getMethodCount() + "</methodscount>");
            ps.println("    <violationscount>" + this.mBatchSummary.getOverviewStatistics().getViolationCount() + "</violationscount>");
            ps.println("    <linecount>" + this.mBatchSummary.getOverviewStatistics().getLineCount() + "</linecount>");
            ps.println("    <ncsscount>" + this.mBatchSummary.getOverviewStatistics().getNCSSCount() + "</ncsscount>");
            ps.println("    <functionpointscount>" + this.mBatchSummary.getOverviewStatistics().getFunctionPointCount() + "</functionpointscount>");
            ps.println("    <unittestclasscount>" + this.mBatchSummary.getOverviewStatistics().getUnitTestClassCount() + "</unittestclasscount>");
            ps.println("    <unittestscount>" + this.mBatchSummary.getOverviewStatistics().getUnitTestCount() + "</unittestscount>");
            ps.println("    <severitylevel>" + this.mBatchSummary.getOverviewStatistics().getHighestSeverityLevel() + "</severitylevel>");
            this.writeWorstClassesXml(ps, this.mBatchSummary.getOverviewStatistics().getWorstCount(this.mBatchSummary.getWorstCount()));
            ps.println("  </overview>");
            ps.println("</jcsc>");
            ps.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace(System.err);
        }
    }

    private void writePackageOverviewXML() {
        try {
            HashMap allPackages = this.getPackageMap();
            Iterator iter = allPackages.keySet().iterator();
            while (iter.hasNext()) {
                PackageStatistics ps = (PackageStatistics)allPackages.get(iter.next());
                PrintStream pps = new PrintStream(new FileOutputStream(this.mBatchSummary.getDestDir() + File.separatorChar + ps.getPackageName() + ".overview.xml"));
                pps.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>");
                pps.println("<?xml-stylesheet href=\"xsl/overview.xsl\" type=\"text/xsl\"?>");
                pps.println("<jcsc>");
                pps.println("  <overview>");
                pps.println("    <packagename>" + ps.getPackageName() + "</packagename>");
                pps.println("    <packagecount>0</packagecount>");
                pps.println("    <name>" + ps.getPackageName() + "</name>");
                pps.println("    <classcount>" + ps.getClassCount() + "</classcount>");
                pps.println("    <methodscount>" + ps.getMethodCount() + "</methodscount>");
                pps.println("    <violationscount>" + ps.getViolationCount() + "</violationscount>");
                pps.println("    <linecount>" + ps.getLineCount() + "</linecount>");
                pps.println("    <ncsscount>" + ps.getNCSSCount() + "</ncsscount>");
                pps.println("    <functionpointscount>" + ps.getFunctionPointsCount() + "</functionpointscount>");
                pps.println("    <unittestclasscount>" + ps.getUnitTestClassCount() + "</unittestclasscount>");
                pps.println("    <unittestscount>" + ps.getUnitTestCount() + "</unittestscount>");
                pps.println("    <severitylevel>" + ps.getHighestSeverityLevel() + "</severitylevel>");
                this.writeWorstClassesXml(pps, this.mBatchSummary.getOverviewStatistics().getWorstCountFromPackage(ps.getPackageName(), this.mBatchSummary.getWorstCount()));
                pps.println("  </overview>");
                pps.println("</jcsc>");
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace(System.err);
        }
    }

    private void writeWorstClassesXml(PrintStream stream, List worst) {
        stream.println("    <worstclasses>");
        int j = 0;
        int count = worst.size();
        while (j < count) {
            WorstElement we = (WorstElement)worst.get(j);
            stream.println("      <worst>");
            stream.println("        <class>" + we.getClassName() + "</class>");
            stream.println("        <count>" + we.getViolationsCount() + "</count>");
            stream.println("        <author><![CDATA[" + we.getAuthors() + "]]></author>");
            stream.println("      </worst>");
            ++j;
        }
        stream.println("    </worstclasses>");
    }

    HashMap getPackageMap() {
        return this.mBatchSummary.getOverviewStatistics().getPackageMap();
    }

    private static String indent(int idn) {
        StringBuffer indent = new StringBuffer(100);
        int i = 0;
        while (i < idn) {
            indent.append(INDENT);
            ++i;
        }
        return indent.toString();
    }

    private static void printRule(Rule rule, PrintStream ps, int i) {
        ps.println(XMLResultsFormatter.indent(i) + "<rule>");
        ps.println(XMLResultsFormatter.indent(i + 1) + "<name>" + rule.getName() + "</name>");
        ps.println(XMLResultsFormatter.indent(i + 1) + "<severity>" + rule.getSeverity() + "</severity>");
        ps.println(XMLResultsFormatter.indent(i + 1) + "<category>" + rule.getCategory() + "</category>");
        ps.println(XMLResultsFormatter.indent(i) + "</rule>");
    }

    private static void printViolation(Violation violation, PrintStream ps, int i) {
        ps.println(XMLResultsFormatter.indent(i) + "<violation>");
        XMLResultsFormatter.printRule(violation.getRule(), ps, i + 1);
        ps.println(XMLResultsFormatter.indent(i + 1) + "<classname>" + violation.getClassName() + "</classname>");
        ps.println(XMLResultsFormatter.indent(i + 1) + "<package>" + violation.getPackageName() + "</package>");
        ps.println(XMLResultsFormatter.indent(i + 1) + "<line>" + violation.getLine() + "</line>");
        ps.println(XMLResultsFormatter.indent(i + 1) + "<column>" + violation.getColumn() + "</column>");
        ps.println(XMLResultsFormatter.indent(i + 1) + "<message><![CDATA[" + violation.getMessage() + "]]></message>");
        ps.println(XMLResultsFormatter.indent(i + 1) + "<source>" + violation.getSource() + "</source>");
        ps.println(XMLResultsFormatter.indent(i) + "</violation>");
    }
}

