/*
 * Decompiled with CFR 0.152.
 */
package rj.tools.jcsc.formatter;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.ListIterator;
import rj.tools.jcsc.MethodMetric;
import rj.tools.jcsc.Violation;
import rj.tools.jcsc.formatter.AbstractResultsFormatter;

public class ConsoleResultsFormatter
extends AbstractResultsFormatter {
    private static final String NL = "\n";
    private static final String OK = "Ok";
    private static final String COLON = ":";
    private static final String VIOLATIONS = "\nViolations:\n";
    private static final String METRICS = "\nMetrics:\n";
    private static final String VIOLATIONS_FOUND = " violation(s) found";
    private static final String METHOD = "Method";
    private static final String NCSS = "NCSS";
    private static final String CCN = "CCN";
    private static final String TOTALNCSS = "NCSS count      ";
    private static final String TOTALLINES = "Lines count     ";
    private static final String TOTALMETHODS = "Methods count   ";
    private static final String UNITTESTCLASS = "Unit Test Class count ";
    private static final String UNITTESTS = "Unit Tests count      ";

    public void format() {
        PrintStream ps = new PrintStream(this.mOutputStream);
        ps.println(VIOLATIONS);
        ListIterator iter = this.mViolations.listIterator();
        while (iter.hasNext()) {
            Violation v = (Violation)iter.next();
            ps.print(v.getSource() + COLON);
            ps.print(v.getLine() + COLON);
            ps.print(v.getColumn() + COLON);
            ps.print(v.getMessage() + COLON);
            ps.print(v.getRule().getName() + COLON);
            ps.print(v.getRule().getSeverity() + NL);
        }
        if (this.mViolations.size() > 0) {
            ps.println(NL + this.mViolations.size() + VIOLATIONS_FOUND);
        } else {
            ps.println("\nOk");
        }
        ps.println(METRICS);
        Iterator iter2 = this.mMethodMetrics.iterator();
        while (iter2.hasNext()) {
            MethodMetric mm = (MethodMetric)iter2.next();
            ps.print(mm.getLine() + COLON + mm.getColumn() + COLON + mm.getMethodName() + COLON + NCSS + "-" + mm.getNCSSCount() + COLON + CCN + "-" + mm.getCCNCount() + NL);
        }
        ps.println();
        ps.println("NCSS count      : " + this.mNCSSCount);
        ps.println("Lines count     : " + this.mLineCount);
        ps.println("Methods count   : " + this.mMethodsCount);
        ps.println("Unit Test Class count : " + this.mUnitTestClassCount);
        ps.println("Unit Tests count      : " + this.mUnitTestsCount);
    }
}

