/*
 * Decompiled with CFR 0.152.
 */
package rj.tools.jcsc.formatter;

import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import rj.tools.jcsc.BatchSummary;
import rj.tools.jcsc.ResultsFormatter;
import rj.tools.jcsc.ViolationsSorter;

public abstract class AbstractResultsFormatter
implements ResultsFormatter {
    protected OutputStream mOutputStream;
    protected String mAuthors = "";
    protected List mViolations;
    protected List mMethodMetrics;
    protected String mPackage;
    protected String mClass;
    protected int mViolationsCount;
    protected int mUnitTestClassCount;
    protected int mUnitTestsCount;
    protected int mNCSSCount;
    protected int mLineCount;
    protected int mMethodsCount;
    protected BatchSummary mBatchSummary;
    protected ViolationsSorter mViolationsSorter;

    public void setOutputStream(OutputStream os) {
        this.mOutputStream = os;
    }

    public void setAuthors(List authors) {
        this.mAuthors = "";
        Iterator iter = authors.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            this.mAuthors = this.mAuthors + name + ", ";
        }
        if (this.mAuthors.length() >= 2) {
            this.mAuthors = this.mAuthors.substring(0, this.mAuthors.length() - 2);
        }
    }

    public void setViolations(List violations) {
        this.mViolations = violations;
        this.mViolationsSorter.setViolations(this.mViolations);
        this.mViolationsSorter.sort();
    }

    public void setMethodMetrics(List metrics) {
        this.mMethodMetrics = metrics;
    }

    public void setPackage(String name) {
        this.mPackage = name;
    }

    public void setClassName(String name) {
        this.mClass = name;
    }

    public void setViolationsCount(int count) {
        this.mViolationsCount = count;
    }

    public void setUnitTestClassCount(int count) {
        this.mUnitTestClassCount = count;
    }

    public void setUnitTestsCount(int count) {
        this.mUnitTestsCount = count;
    }

    public void setNCSSCount(int count) {
        this.mNCSSCount = count;
    }

    public void setLineCount(int count) {
        this.mLineCount = count;
    }

    public void setMethodsCount(int count) {
        this.mMethodsCount = count;
    }

    public void setViolationSorter(ViolationsSorter sorter) {
        this.mViolationsSorter = sorter;
    }

    public void setBatchMode(BatchSummary batchSummary) {
        this.mBatchSummary = batchSummary;
    }

    protected boolean isBatchMode() {
        return this.mBatchSummary != null;
    }

    public void formatBatch() {
    }

    public abstract void format();
}

