/*
 * Decompiled with CFR 0.152.
 */
package rj.tools.jcsc.ant;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import rj.tools.jcsc.ant.WorstElement;

class WorstStatistics {
    private HashMap mCandidates = new HashMap();

    WorstStatistics() {
    }

    public void addCandidate(int violationsCount, String className, String authors) {
        Integer violations = new Integer(violationsCount);
        if (!this.mCandidates.keySet().contains(violations)) {
            ArrayList<WorstElement> al = new ArrayList<WorstElement>();
            al.add(new WorstElement(className, authors, violationsCount));
            this.mCandidates.put(violations, al);
        } else {
            ArrayList al = (ArrayList)this.mCandidates.get(violations);
            al.add(new WorstElement(className, authors, violationsCount));
            this.mCandidates.put(violations, al);
        }
    }

    public List getFirstCount(int count) {
        ArrayList list = new ArrayList();
        Iterator iter = ((AbstractList)this.getCandidatesSorted()).iterator();
        while (iter.hasNext()) {
            ArrayList al = (ArrayList)this.mCandidates.get(iter.next());
            int i = 0;
            int c = al.size();
            while (i < c) {
                list.add(al.get(i));
                ++i;
            }
        }
        return this.getFirstCountFromList(list, count);
    }

    public List getFirstCountFromPackage(String fullPackagePath, int count) {
        ArrayList<WorstElement> packageList = new ArrayList<WorstElement>();
        Iterator iter = ((AbstractList)this.getCandidatesSorted()).iterator();
        while (iter.hasNext()) {
            ArrayList al = (ArrayList)this.mCandidates.get(iter.next());
            int i = 0;
            int c = al.size();
            while (i < c) {
                WorstElement we = (WorstElement)al.get(i);
                String name = we.getClassName().substring(0, we.getClassName().lastIndexOf("."));
                if (name.equals(fullPackagePath)) {
                    packageList.add(we);
                }
                ++i;
            }
        }
        return this.getFirstCountFromList(packageList, count);
    }

    private List getFirstCountFromList(List list, int count) {
        int worstCount = 0;
        ArrayList worstList = new ArrayList();
        Iterator iter = list.iterator();
        while (worstCount < count && iter.hasNext()) {
            Object obj = iter.next();
            worstList.add(obj);
            ++worstCount;
        }
        return worstList;
    }

    private ArrayList getCandidatesSorted() {
        ArrayList candidates = new ArrayList(this.mCandidates.keySet());
        Collections.sort(candidates, new Comparator(){

            public int compare(Object o1, Object o2) {
                return (Integer)o2 - (Integer)o1;
            }
        });
        return candidates;
    }
}

