/*
 * Decompiled with CFR 0.152.
 */
package rj.tools.jcsc.ant;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import rj.tools.jcsc.Violation;
import rj.tools.jcsc.ant.BatchResult;
import rj.tools.jcsc.ant.PackageStatistics;
import rj.tools.jcsc.ant.WorstStatistics;
import rj.tools.jcsc.rules.Rule;

public class OverviewStatistics {
    private HashMap mFileKeyMap = new HashMap();
    private HashMap mRuleNameKeyMap = new HashMap();
    private HashMap mIndexMap = new HashMap();
    private HashMap mPackageMap = new HashMap();
    private WorstStatistics mWorstCandidates = new WorstStatistics();

    public void addResult(BatchResult result) {
        this.addViolations(result.getViolations());
        this.add2IndexMap(result.getPackageName(), result.getClassName());
        this.add2PackageMap(result.getPackageName(), result.getMethodCount(), result.getViolations().length, result.getNcssCount(), result.getLineCount(), result.getUnitTestClassCount(), result.getUnitTestsCount(), result.getHighestSeverityLevel());
        this.mWorstCandidates.addCandidate(result.getViolations().length, result.getPackageName() + "." + result.getClassName(), result.getAuthors());
    }

    private void addViolation(Violation violation) {
        this.mFileKeyMap.put(violation.getSource(), violation);
        this.add2RuleKeyMap(violation);
    }

    private void addViolations(Violation[] violations) {
        int i = 0;
        int count = violations.length;
        while (i < count) {
            this.addViolation(violations[i]);
            ++i;
        }
    }

    private void add2RuleKeyMap(Violation violation) {
        Rule rule = violation.getRule();
        ArrayList al = null;
        al = !this.mRuleNameKeyMap.keySet().contains(rule.getName()) ? new ArrayList() : (ArrayList)this.mRuleNameKeyMap.get(rule.getName());
        al.add(violation);
        this.mRuleNameKeyMap.put(rule.getName(), al);
    }

    public Rule getRule(String ruleName) {
        List vios = (List)this.mRuleNameKeyMap.get(ruleName);
        Rule rule = ((Violation)vios.get(0)).getRule();
        return rule;
    }

    public List getViolatedRules() {
        HashSet<Rule> rules = new HashSet<Rule>();
        Iterator iter = this.mRuleNameKeyMap.keySet().iterator();
        while (iter.hasNext()) {
            rules.add(this.getRule((String)iter.next()));
        }
        return new ArrayList(rules);
    }

    public List getViolatedCategories() {
        HashSet<String> categories = new HashSet<String>();
        Iterator iter = this.mRuleNameKeyMap.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            List vios = (List)this.mRuleNameKeyMap.get(key);
            Rule rule = ((Violation)vios.get(0)).getRule();
            categories.add(rule.getCategory());
        }
        return new ArrayList(categories);
    }

    public List getViolatedSeverities() {
        HashSet<Integer> categories = new HashSet<Integer>();
        Iterator iter = this.mRuleNameKeyMap.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            List vios = (List)this.mRuleNameKeyMap.get(key);
            Rule rule = ((Violation)vios.get(0)).getRule();
            categories.add(new Integer(rule.getSeverity()));
        }
        return new ArrayList(categories);
    }

    public List getViolationsBySeverity(int severity) {
        HashSet<String> contains = new HashSet<String>();
        HashSet<Violation> hs = new HashSet<Violation>();
        Iterator iter = this.mRuleNameKeyMap.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            List vios = (List)this.mRuleNameKeyMap.get(key);
            Rule rule = ((Violation)vios.get(0)).getRule();
            if (rule.getSeverity() != severity) continue;
            Iterator iter2 = vios.iterator();
            while (iter2.hasNext()) {
                Violation violation = (Violation)iter2.next();
                if (contains.contains(violation.getRule().getName())) continue;
                hs.add(violation);
                contains.add(violation.getRule().getName());
            }
        }
        return new ArrayList(hs);
    }

    public List getViolationByRuleName(String rule) {
        ArrayList vr = new ArrayList();
        Iterator iter = this.mRuleNameKeyMap.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!key.equals(rule)) continue;
            return (List)this.mRuleNameKeyMap.get(key);
        }
        return vr;
    }

    public List getViolationsByCategory(String category) {
        HashSet<String> contains = new HashSet<String>();
        HashSet<Violation> hs = new HashSet<Violation>();
        Iterator iter = this.mRuleNameKeyMap.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            List vios = (List)this.mRuleNameKeyMap.get(key);
            Rule rule = ((Violation)vios.get(0)).getRule();
            if (!rule.getCategory().equals(category)) continue;
            Iterator iter2 = vios.iterator();
            while (iter2.hasNext()) {
                Violation violation = (Violation)iter2.next();
                if (contains.contains(violation.getRule().getName())) continue;
                hs.add(violation);
                contains.add(violation.getRule().getName());
            }
        }
        return new ArrayList(hs);
    }

    private void add2PackageMap(String packageName, int methodsCount, int violationsCount, int ncssCount, int lineCount, int unitTestClassCount, int unitTestsCount, int severity) {
        PackageStatistics ps = null;
        ps = !this.mPackageMap.keySet().contains(packageName) ? new PackageStatistics(packageName) : (PackageStatistics)this.mPackageMap.get(packageName);
        ps.incrementClassCount(1);
        ps.incrementMethodCount(methodsCount);
        ps.incrementViolationCount(violationsCount);
        ps.incrementNCSSCount(ncssCount);
        ps.incrementLineCount(lineCount);
        ps.incrementUnitTestClassCount(unitTestClassCount);
        ps.incrementUnitTestCount(unitTestsCount);
        ps.setHighestSeverityLevel(severity);
        this.mPackageMap.put(packageName, ps);
    }

    public HashMap getRulesMap() {
        return this.mRuleNameKeyMap;
    }

    public HashMap getPackageMap() {
        return this.mPackageMap;
    }

    private void add2IndexMap(String packageName, String className) {
        HashSet hs = null;
        hs = !this.mIndexMap.keySet().contains(packageName) ? new HashSet() : (HashSet)this.mIndexMap.get(packageName);
        hs.add(className);
        this.mIndexMap.put(packageName, hs);
    }

    public List getPackageNames() {
        return new ArrayList(this.mIndexMap.keySet());
    }

    public List getClassNamesOfPackage(String pack) {
        return new ArrayList((Collection)this.mIndexMap.get(pack));
    }

    public List getWorstCount(int count) {
        return this.mWorstCandidates.getFirstCount(count);
    }

    public List getWorstCountFromPackage(String pack, int count) {
        return this.mWorstCandidates.getFirstCountFromPackage(pack, count);
    }

    public int getPackageCount() {
        return this.getPackageMap().size();
    }

    public int getClassCount() {
        HashMap pm = this.getPackageMap();
        int classCount = 0;
        Iterator iter = pm.keySet().iterator();
        while (iter.hasNext()) {
            PackageStatistics ps = (PackageStatistics)pm.get(iter.next());
            classCount += ps.getClassCount();
        }
        return classCount;
    }

    public int getMethodCount() {
        HashMap pm = this.getPackageMap();
        int methodCount = 0;
        Iterator iter = pm.keySet().iterator();
        while (iter.hasNext()) {
            PackageStatistics ps = (PackageStatistics)pm.get(iter.next());
            methodCount += ps.getMethodCount();
        }
        return methodCount;
    }

    public int getViolationCount() {
        HashMap pm = this.getPackageMap();
        int violationCount = 0;
        Iterator iter = pm.keySet().iterator();
        while (iter.hasNext()) {
            PackageStatistics ps = (PackageStatistics)pm.get(iter.next());
            violationCount += ps.getViolationCount();
        }
        return violationCount;
    }

    public int getNCSSCount() {
        HashMap pm = this.getPackageMap();
        int ncssCount = 0;
        Iterator iter = pm.keySet().iterator();
        while (iter.hasNext()) {
            PackageStatistics ps = (PackageStatistics)pm.get(iter.next());
            ncssCount += ps.getNCSSCount();
        }
        return ncssCount;
    }

    public double getFunctionPointCount() {
        HashMap pm = this.getPackageMap();
        double fpCount = 0.0;
        Iterator iter = pm.keySet().iterator();
        while (iter.hasNext()) {
            PackageStatistics ps = (PackageStatistics)pm.get(iter.next());
            fpCount += ps.getFunctionPointsCount();
        }
        return fpCount;
    }

    public int getLineCount() {
        HashMap pm = this.getPackageMap();
        int lineCount = 0;
        Iterator iter = pm.keySet().iterator();
        while (iter.hasNext()) {
            PackageStatistics ps = (PackageStatistics)pm.get(iter.next());
            lineCount += ps.getLineCount();
        }
        return lineCount;
    }

    public int getUnitTestClassCount() {
        HashMap pm = this.getPackageMap();
        int unittestclassCount = 0;
        Iterator iter = pm.keySet().iterator();
        while (iter.hasNext()) {
            PackageStatistics ps = (PackageStatistics)pm.get(iter.next());
            unittestclassCount += ps.getUnitTestClassCount();
        }
        return unittestclassCount;
    }

    public int getUnitTestCount() {
        HashMap pm = this.getPackageMap();
        int unittestsCount = 0;
        Iterator iter = pm.keySet().iterator();
        while (iter.hasNext()) {
            PackageStatistics ps = (PackageStatistics)pm.get(iter.next());
            unittestsCount += ps.getUnitTestCount();
        }
        return unittestsCount;
    }

    public double calculateAvgViolationsPerNcss() {
        return this.getNCSSCount() != 0 ? (double)((float)this.getViolationCount() / (float)this.getNCSSCount()) : 0.0;
    }

    public double calculateAvgViolationsPerClass() {
        return this.getClassCount() != 0 ? (double)((float)this.getViolationCount() / (float)this.getClassCount()) : 0.0;
    }

    public int getHighestSeverityLevel() {
        List levels = this.getViolatedSeverities();
        int max = 0;
        int i = 0;
        int count = levels.size();
        while (i < count) {
            max = Math.max(max, (Integer)levels.get(i));
            ++i;
        }
        return max;
    }
}

