/*
 * Decompiled with CFR 0.152.
 */
package rj.tools.jcsc.ant;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import rj.tools.jcsc.ant.JCSCTask;
import rj.tools.jcsc.ant.PackageStatistics;
import rj.tools.util.FileFinder;

public class JCSCTaskTest
extends TestCase {
    private JCSCTask mTask;
    private Project mProject;
    static /* synthetic */ Class class$rj$tools$jcsc$ant$JCSCTaskTest;

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(class$rj$tools$jcsc$ant$JCSCTaskTest == null ? (class$rj$tools$jcsc$ant$JCSCTaskTest = JCSCTaskTest.class$("rj.tools.jcsc.ant.JCSCTaskTest")) : class$rj$tools$jcsc$ant$JCSCTaskTest);
        return suite;
    }

    public JCSCTaskTest(String name) {
        super(name);
    }

    protected void setUp() {
        this.mTask = new JCSCTask();
        this.mProject = new Project();
        this.mTask.setProject(this.mProject);
    }

    protected void tearDown() {
    }

    public void testSingleModeFileNotFound() {
        try {
            this.mTask.setFile("DontExist");
            this.mTask.execute();
        }
        catch (BuildException e) {
            return;
        }
        Assert.fail((String)"an exception should have been thrown");
    }

    public void testResultFormatterNotFound() {
        try {
            this.mTask.setFile("src/rj/tools/util/FileFinder.java");
            this.mTask.setResultsformatter("DontExist");
            this.mTask.execute();
        }
        catch (BuildException e) {
            return;
        }
        Assert.fail((String)"an exception should have been thrown");
    }

    public void testViolationsSorterNotFound() {
        try {
            this.mTask.setFile("src/rj/tools/util/FileFinder.java");
            this.mTask.setViolationsSorter("DontExist");
            this.mTask.execute();
        }
        catch (BuildException e) {
            return;
        }
        Assert.fail((String)"an exception should have been thrown");
    }

    public void testDefaultResultsFormatter() {
        try {
            this.mTask.setFile("src/rj/tools/util/FileFinder.java");
            this.mTask.execute();
        }
        catch (BuildException e) {
            Assert.fail((String)"an exception should NOT have been thrown");
            e.printStackTrace(System.err);
        }
    }

    public void testXMLResultsFormatter() {
        Assert.assertTrue((boolean)true);
    }

    public void testConsoleResultsFormatter() {
        try {
            this.mTask.setFile("src/rj/tools/util/FileFinder.java");
            this.mTask.setResultsformatter("rj.tools.jcsc.formatter.ConsoleResultsFormatter");
            this.mTask.execute();
        }
        catch (BuildException e) {
            Assert.fail((String)"an exception should NOT have been thrown");
            e.printStackTrace(System.err);
        }
    }

    public void testBatchModePackageStatistics() {
        try {
            FileSet fileset = new FileSet();
            this.mProject.setBasedir(".");
            fileset.setDir(this.mProject.resolveFile("src/"));
            fileset.setIncludes("**/*.java");
            fileset.setExcludes("**/JavaCodingStandardChecker.java,**/JavaCodingStandardCheckerTokenManager.java,**/JavaCodingStandardCheckerConstants.java,**/JavaCharStream.java,**/Token.java,**/TokenMgrError.java,**/ParseException.java");
            this.mTask.addFileSet(fileset);
            fileset = new FileSet();
            fileset.setDir(this.mProject.resolveFile("junit-src/"));
            fileset.setIncludes("**/*Test.java");
            this.mTask.setProject(this.mProject);
            this.mTask.addFileSet(fileset);
            this.mTask.setResultsformatter("rj.tools.jcsc.formatter.XMLResultsFormatter");
            this.mTask.setRules("rules/jcsc.jcsc.xml");
            this.mTask.setDestdir("tmp");
            this.mTask.execute();
            HashMap pm = this.mTask.getPackageMap();
            Assert.assertEquals((int)10, (int)pm.size());
            int classCount = 0;
            int methodCount = 0;
            int violationCount = 0;
            int ncssCount = 0;
            int unittestclassCount = 0;
            int unittestsCount = 0;
            Iterator iter = pm.keySet().iterator();
            while (iter.hasNext()) {
                PackageStatistics ps = (PackageStatistics)pm.get(iter.next());
                classCount += ps.getClassCount();
                methodCount += ps.getMethodCount();
                violationCount += ps.getViolationCount();
                ncssCount += ps.getNCSSCount();
                unittestclassCount += ps.getUnitTestClassCount();
                unittestsCount += ps.getUnitTestCount();
            }
            Assert.assertEquals((int)80, (int)classCount);
            Assert.assertEquals((int)864, (int)methodCount);
            Assert.assertEquals((int)204, (int)violationCount);
            Assert.assertEquals((int)5833, (int)ncssCount);
            Assert.assertEquals((int)19, (int)unittestclassCount);
            Assert.assertEquals((int)120, (int)unittestsCount);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            Assert.fail((String)"An exception should NOT have been thrown");
        }
    }

    public void testCopyIndex() {
        this.mTask.setDestdir("junit-src/rj/tools/jcsc/ant");
        this.mTask.setJcscHome(".");
        this.mTask.copyIndex();
        String name = "junit-src/rj/tools/jcsc/ant/index.html";
        name = name.replace('/', File.separatorChar);
        File targetFile = new File(name);
        Assert.assertTrue((String)"index.html has not been copied", (boolean)targetFile.exists());
        if (targetFile.exists()) {
            targetFile.delete();
        }
    }

    public void testCopyXSL() {
        String[] xslFiles = new String[]{"overview.xsl", "packagelist.xsl", "package.xsl", "category.xsl", "class.xsl", "rule.xsl"};
        this.mTask.setDestdir("junit-src/rj/tools/jcsc/ant");
        this.mTask.setJcscHome(".");
        this.mTask.copyXSL();
        int i = 0;
        int count = xslFiles.length;
        while (i < count) {
            String name = "junit-src/rj/tools/jcsc/ant/xsl/" + xslFiles[i];
            name = name.replace('/', File.separatorChar);
            File targetFile = new File(name);
            Assert.assertTrue((String)("xsl/" + xslFiles[i] + " has not been copied"), (boolean)targetFile.exists());
            if (targetFile.exists()) {
                targetFile.delete();
            }
            ++i;
        }
    }

    public void testCopyExampleHTML() {
        String s = File.separator;
        String[] htmlFiles = new String[]{"field" + s + "CFPacRegExp.html", "general" + s + "AllowDotStarImport.html", "javadoc" + s + "AnonymousClassMethodJavaDoc.html", "method" + s + "CMetPacRegExp.html", "metrics" + s + "MaxNumberOfCCNPerConstructor.html", "unittest" + s + "UnitTestClassRegExp.html"};
        this.mTask.setDestdir("junit-src/rj/tools/jcsc/ant");
        this.mTask.setJcscHome(".");
        this.mTask.copyExampleHtml();
        int i = 0;
        int count = htmlFiles.length;
        while (i < count) {
            String name = "junit-src/rj/tools/jcsc/ant/examplehtml/" + htmlFiles[i];
            name = name.replace('/', File.separatorChar);
            File targetFile = new File(name);
            Assert.assertTrue((String)("examplehtml" + s + htmlFiles[i] + " has not been copied"), (boolean)targetFile.exists());
            if (targetFile.exists()) {
                targetFile.delete();
            }
            ++i;
        }
        String dest = "junit-src/rj/tools/jcsc/ant/examplehtml";
        dest.replace('/', File.separatorChar);
        FileFinder ff = new FileFinder(dest, new FileFilter(){

            public boolean accept(File pathname) {
                if (pathname.isDirectory()) {
                    return true;
                }
                return pathname.getName().endsWith(".html");
            }
        }, true);
        ArrayList files = new ArrayList(ff.getFiles());
        ArrayList folders = new ArrayList(ff.getDirectories());
        int i2 = 0;
        int count2 = files.size();
        while (i2 < count2) {
            File file = (File)files.get(i2);
            if (file.exists()) {
                file.delete();
            }
            ++i2;
        }
        int i3 = 0;
        int count3 = folders.size();
        while (i3 < count3) {
            File folder = (File)folders.get(i3);
            if (folder.exists()) {
                folder.delete();
            }
            ++i3;
        }
    }

    public void testCopyRules() {
        this.mTask.setDestdir("junit-src/rj/tools/jcsc/ant");
        this.mTask.setRules("src/rj/tools/jcsc/rules/default.jcsc.xml");
        this.mTask.copyRules();
        String name = "junit-src/rj/tools/jcsc/ant/rules.jcsc.xml";
        name = name.replace('/', File.separatorChar);
        File targetFile = new File(name);
        Assert.assertTrue((String)"default.jcsc.xml (-> rules.jcsc.xml) has not been copied", (boolean)targetFile.exists());
        if (targetFile.exists()) {
            targetFile.delete();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

