/*
 * Decompiled with CFR 0.152.
 */
package rj.tools.jcsc.ant;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import rj.tools.jcsc.BatchSummary;
import rj.tools.jcsc.JavaCodingStandardChecker;
import rj.tools.jcsc.ResultsFormatter;
import rj.tools.jcsc.Violation;
import rj.tools.jcsc.ViolationsSorter;
import rj.tools.jcsc.ant.BatchResult;
import rj.tools.jcsc.ant.OverviewStatistics;
import rj.tools.jcsc.ant.ParseFile;
import rj.tools.jcsc.rules.RulesHandler;
import rj.tools.jcsc.sorter.OccurenceSorter;
import rj.tools.util.FileFinder;
import rj.tools.util.FileIO;

public class JCSCTask
extends Task {
    private static final String CONSOLE_FORMATTER = "rj.tools.jcsc.formatter.ConsoleResultsFormatter";
    private static final String XML_FORMATTER = "rj.tools.jcsc.formatter.XMLResultsFormatter";
    private static final String OCCURENCE_SORTER = "rj.tools.jcsc.osrter.OccurenceSorter";
    private String mRules;
    private String mFile;
    private String mResultsFormatter;
    private ResultsFormatter mResultsFormatterInstance;
    private Vector mFileSets = new Vector();
    private String mDestDir;
    private int mWorstCount = 15;
    private String mStartDate;
    private long mStartDateInMillis;
    private String mFailValue;
    private double mFailValueNumber;
    private String mFailSeverity;
    private int mFailSeverityNumber;
    private String mFailProperty;
    private boolean mCopyAssociatedFiles = false;
    private String mViolationsSorter;
    private ViolationsSorter mViolationsSorterInstance;
    private String mJcscHome;
    private String mIgnoreTestSeverity;
    private int mIgnoreTestSeverityNumber;
    private OverviewStatistics mOverviewStatistics = new OverviewStatistics();
    private boolean mIsBatchMode = false;
    private JavaCodingStandardChecker mJCSC;

    public void setRules(String rules) {
        this.mRules = rules;
    }

    public void setFile(String file) {
        this.mFile = file;
        this.mFile = this.mFile.replace('/', File.separatorChar);
        this.mIsBatchMode = false;
    }

    public void setStartpackage(String startpackage) {
        String message = "<startpackage> is no longer supported. The top level package is the name of the folder(s) in FileSet(s) specified.";
        this.log(message);
        throw new BuildException(message);
    }

    public void setResultsformatter(String resultsFormatter) {
        this.mResultsFormatter = resultsFormatter;
    }

    public void setDestdir(String dir) {
        this.mDestDir = dir;
        this.mDestDir = this.mDestDir.replace('/', File.separatorChar);
    }

    public void setWorstCount(int count) {
        this.mWorstCount = count == -1 ? this.mWorstCount : count;
    }

    public void setStartDate(String date) {
        this.mStartDate = date.equals("") ? (String)null : date;
    }

    public void setFailValue(String value) {
        this.mFailValue = value.equals("") ? (String)null : value;
    }

    public void setViolationsSorter(String name) {
        this.mViolationsSorter = name;
    }

    public void setFailSeverity(String level) {
        this.mFailSeverity = level;
    }

    public void setFailProperty(String name) {
        this.mFailProperty = name;
    }

    public void setIgnoreTestSeverity(String level) {
        this.mIgnoreTestSeverity = level;
    }

    public void setCopyAssociatedFiles(String value) {
        this.mCopyAssociatedFiles = value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("true");
    }

    public void setJcscHome(String home) {
        this.mJcscHome = home;
    }

    public void addFileSet(FileSet fs) {
        this.mIsBatchMode = true;
        this.mFileSets.addElement(fs);
    }

    protected ParseFile[] getFiles() {
        Vector<ParseFile> v = new Vector<ParseFile>();
        int i = 0;
        int count = this.mFileSets.size();
        while (i < count) {
            FileSet fs = (FileSet)this.mFileSets.elementAt(i);
            DirectoryScanner ds = fs.getDirectoryScanner(((ProjectComponent)this).project);
            ds.scan();
            String[] f = ds.getIncludedFiles();
            int j = 0;
            while (j < f.length) {
                String pathname = f[j];
                ParseFile file = new ParseFile(new File(ds.getBasedir(), pathname), ds.getBasedir());
                if (!this.isStartDateSet() || file.getParseFile().lastModified() > this.mStartDateInMillis) {
                    file = new ParseFile(((ProjectComponent)this).project.resolveFile(file.getParseFile().getAbsolutePath()), ds.getBasedir());
                    v.addElement(file);
                }
                ++j;
            }
            ++i;
        }
        Object[] files = new ParseFile[v.size()];
        v.copyInto(files);
        return files;
    }

    public void execute() throws BuildException {
        this.parameterCheck();
        if (this.mIsBatchMode) {
            this.executeFiles(this.getFiles());
            this.mResultsFormatterInstance.formatBatch();
            if (this.mCopyAssociatedFiles) {
                this.copyIndex();
                this.copyXSL();
                this.copyExampleHtml();
                this.copyRules();
            }
        } else {
            this.executeFile(this.getFile(this.mFile));
        }
        this.checkForSeverityViolation();
        this.checkForTooManyViolations();
    }

    private ParseFile getFile(String fileName) throws BuildException {
        File file = new File(fileName);
        if (file.exists()) {
            return new ParseFile(file, file.getParentFile());
        }
        throw new BuildException("<file> could not be found");
    }

    private void checkForSeverityViolation() {
        if (this.isFailSeveritySet() && this.mOverviewStatistics.getHighestSeverityLevel() >= this.mFailSeverityNumber) {
            this.failBuild("The severity of violations is to high - <failseverity>: " + this.mFailSeverityNumber);
        }
    }

    private void checkForTooManyViolations() {
        if (this.isFailValueSet() && this.mOverviewStatistics.calculateAvgViolationsPerNcss() >= this.mFailValueNumber) {
            this.failBuild("The avg of violations per ncss is to high - <failvalue>: " + this.mFailValueNumber);
        }
    }

    private void failBuild(String failMsg) {
        if (!this.isFailPropertySet()) {
            throw new BuildException(failMsg);
        }
        this.getProject().setNewProperty(this.mFailProperty, "true");
    }

    private void parameterCheck() throws BuildException {
        boolean isError = false;
        String errorMsg = "";
        this.log("Attribute <rules> '" + (this.isRulesFileSet() ? this.mRules : "default.jcsc (from JCSC.jar)'"), 3);
        if (this.mIsBatchMode) {
            this.batchParameterCheck();
        }
        if (this.isStartDateSet()) {
            this.log("Attribute <startdate> : " + this.mStartDate, 3);
            try {
                if (this.mStartDate.length() != 19) {
                    throw new NumberFormatException();
                }
                this.mStartDateInMillis = this.convertDate2Long();
            }
            catch (NumberFormatException e) {
                errorMsg = errorMsg + "\n<stardate> has the wrong format (YYYY-MM-DD HH:MM:SS)";
                isError = true;
            }
        }
        if (this.isFailValueSet()) {
            this.log("Attribute <failvalue> '" + this.mFailValue + "'", 3);
            try {
                this.mFailValueNumber = Double.parseDouble(this.mFailValue);
            }
            catch (NumberFormatException e) {
                errorMsg = errorMsg + "\n<failvalue> has to be of type double";
                isError = true;
            }
        }
        if (this.isFailSeveritySet()) {
            this.log("Attribute <failseverity> '" + this.mFailSeverity + "'", 3);
            try {
                this.mFailSeverityNumber = Integer.parseInt(this.mFailSeverity);
            }
            catch (NumberFormatException e) {
                errorMsg = errorMsg + "\n<failseverity> has to be of type integer";
                isError = true;
            }
        }
        if (this.isViolationsSorterSet()) {
            this.log("Attribute <violationssorter> '" + this.mViolationsSorter + "'", 3);
            try {
                this.createViolationsSorterInstance(this.mViolationsSorter);
            }
            catch (BuildException e) {
                errorMsg = errorMsg + e.getMessage();
                isError = true;
            }
        } else {
            this.log("<violationssorter> '" + this.mViolationsSorter + "' could not be loaded -- using OccurenceSorter", 3);
            this.mViolationsSorterInstance = new OccurenceSorter();
        }
        if (this.isResultsFormatterSet()) {
            this.log("Attribute <resultsformatter> '" + this.mResultsFormatter + "'", 3);
            try {
                this.createResultsFormatterInstance(this.mResultsFormatter, this.mIsBatchMode);
            }
            catch (BuildException e) {
                errorMsg = errorMsg + e.getMessage();
                isError = true;
            }
        }
        this.throwExceptionIfError(isError, errorMsg);
    }

    private void batchParameterCheck() throws BuildException {
        boolean isError = false;
        String errorMsg = "";
        this.log("Attribute <destdir> '" + this.mDestDir + "'", 3);
        this.log("Attribute <worstcount> '" + this.mWorstCount + "''", 3);
        if (this.isCopyAssociatedFilesSet()) {
            this.log("Attribute <copyassociatedfiles> '" + this.mCopyAssociatedFiles + "'", 3);
            this.log("Attribute <jcschome> '" + this.mJcscHome + "'", 3);
            if (!this.isJcscHomeSet()) {
                errorMsg = errorMsg + "\nNo <jcschome> is specified; This is mandatory if <copyassociatedfiles> is set";
                isError = true;
            }
        }
        if (!this.isFileSetSet()) {
            errorMsg = errorMsg + "\nNo <fileset> is specified; This is mandatory if used in batch mode";
            isError = true;
        }
        if (!this.isDestDirSet()) {
            errorMsg = errorMsg + "\nNo <destdir> is specified; This is mandatory if used in batch mode";
            isError = true;
        }
        if (this.isIgnoreTestSeveritySet()) {
            this.log("Attribute <ignoretestseverity> '" + this.mIgnoreTestSeverity + "'", 3);
            try {
                this.mIgnoreTestSeverityNumber = Integer.parseInt(this.mIgnoreTestSeverity);
            }
            catch (NumberFormatException e) {
                errorMsg = errorMsg + "\n<ignoretestseverity> has to be of type integer";
                isError = true;
            }
        }
        this.throwExceptionIfError(isError, errorMsg);
    }

    private void throwExceptionIfError(boolean error, String message) throws BuildException {
        if (error) {
            throw new BuildException(message);
        }
    }

    protected void executeFile(ParseFile file) throws BuildException {
        if (this.mResultsFormatterInstance == null) {
            this.createResultsFormatterInstance(CONSOLE_FORMATTER, false);
        }
        try {
            this.parseSingleFile(file, System.out, this.mResultsFormatterInstance, this.getRules());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace(System.err);
            throw new BuildException((Throwable)e);
        }
    }

    protected void executeFiles(ParseFile[] files) throws BuildException {
        Map rules = this.getRules();
        if (this.mResultsFormatterInstance == null) {
            this.createResultsFormatterInstance(XML_FORMATTER, true);
        }
        int i = 0;
        int count = files.length;
        while (i < count) {
            this.parseSingleFileFromBatch(files[i], this.mResultsFormatterInstance, rules);
            ++i;
        }
        this.writeOverview(System.out);
    }

    private void parseSingleFileFromBatch(ParseFile file, ResultsFormatter rf, Map rules) throws BuildException {
        try {
            FileOutputStream fos = new FileOutputStream(this.getOutputFileName(file));
            this.parseSingleFile(file, fos, rf, rules);
            String packageName = this.getPackageName(file);
            String className = this.getClassName(file);
            Violation[] violations = this.mJCSC.getViolations().toArray(new Violation[this.mJCSC.getViolationsCount()]);
            this.mOverviewStatistics.addResult(new BatchResult(violations, packageName, className, this.convertAuthors2String(this.mJCSC.getAuthors()), this.mJCSC.getMethodsCount(), this.mJCSC.getNCSSCount(), this.mJCSC.getLineCount(), this.mJCSC.getUnitTestClassCount(), this.mJCSC.getUnitTestsCount()));
        }
        catch (FileNotFoundException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private String convertAuthors2String(List authors) {
        String authorsString = "";
        Iterator iter = authors.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            authorsString = authorsString + name + ", ";
        }
        if (authorsString.length() >= 2) {
            authorsString = authorsString.substring(0, authorsString.length() - 2);
        }
        return authorsString;
    }

    private void parseSingleFile(ParseFile file, OutputStream os, ResultsFormatter rf, Map map) throws FileNotFoundException {
        FileInputStream fin = new FileInputStream(file.getParseFile());
        if (this.mJCSC == null) {
            this.mJCSC = new JavaCodingStandardChecker(fin);
        }
        this.mJCSC.ReInit(fin);
        rf.setOutputStream(os);
        rf.setViolationSorter(this.mViolationsSorterInstance);
        super.log("Parsing " + file.getParseFile().getAbsolutePath(), 3);
        this.mJCSC.setFileName(file.getParseFile().getAbsolutePath());
        this.mJCSC.setIgnoreTestSeverity(this.mIgnoreTestSeverityNumber);
        this.mJCSC.setRules(map);
        this.mJCSC.setResultsFormatter(rf);
        this.mJCSC.parse();
    }

    private boolean isFileSetSet() {
        return this.mFileSets.size() > 0;
    }

    private boolean isResultsFormatterSet() {
        return this.mResultsFormatter != null;
    }

    private boolean isDestDirSet() {
        return this.mDestDir != null;
    }

    private boolean isIgnoreTestSeveritySet() {
        return !this.isNullOrEmpty(this.mIgnoreTestSeverity);
    }

    private boolean isStartDateSet() {
        return !this.isNullOrEmpty(this.mStartDate);
    }

    private boolean isFailValueSet() {
        return !this.isNullOrEmpty(this.mFailValue);
    }

    private boolean isFailSeveritySet() {
        return !this.isNullOrEmpty(this.mFailSeverity);
    }

    private boolean isFailPropertySet() {
        return !this.isNullOrEmpty(this.mFailProperty);
    }

    private boolean isViolationsSorterSet() {
        return this.mViolationsSorter != null;
    }

    private boolean isCopyAssociatedFilesSet() {
        return this.mCopyAssociatedFiles;
    }

    private boolean isJcscHomeSet() {
        return this.mJcscHome != null;
    }

    private boolean isNullOrEmpty(String str) {
        boolean isNullOrEmpty = false;
        if (null == str) {
            isNullOrEmpty = true;
        } else if (str.equals("")) {
            isNullOrEmpty = true;
        }
        return isNullOrEmpty;
    }

    private void createResultsFormatterInstance(String name, boolean isBatchMode) throws BuildException {
        boolean isError = false;
        String errorMsg = "";
        try {
            this.mResultsFormatterInstance = (ResultsFormatter)Class.forName(name).newInstance();
            if (isBatchMode) {
                this.mResultsFormatterInstance.setBatchMode(new BatchSummary(this.mOverviewStatistics, this.mDestDir, this.mRules, this.mWorstCount));
            }
        }
        catch (Exception e) {
            errorMsg = errorMsg + "\n<violationssorter> " + name + " cannot be found";
            isError = true;
        }
        this.throwExceptionIfError(isError, errorMsg);
    }

    private void createViolationsSorterInstance(String name) throws BuildException {
        boolean isError = false;
        String errorMsg = "";
        try {
            this.mViolationsSorterInstance = (ViolationsSorter)Class.forName(name).newInstance();
        }
        catch (Exception e) {
            errorMsg = errorMsg + "\n<resultsformatter> " + name + " cannot be found";
            isError = true;
        }
        this.throwExceptionIfError(isError, errorMsg);
    }

    private Map getRules() {
        Map map = null;
        try {
            map = !this.isRulesFileSet() ? new RulesHandler().readZipRulesFile("default.jcsc.xml") : new RulesHandler().readRulesFile(this.mRules);
        }
        catch (IOException e) {
            System.err.println("Rules file '" + this.mRules + "' could not be found");
            System.exit(1);
        }
        return map;
    }

    private boolean isRulesFileSet() {
        return this.mRules != null;
    }

    private String getRelativeFilePath(ParseFile file) {
        String parseFilePath = file.getParseFile().getAbsolutePath();
        String baseDirPath = file.getBaseDir().getAbsolutePath();
        String fileName = parseFilePath.substring(baseDirPath.length() + 1);
        return fileName;
    }

    private String getOutputFileName(ParseFile file) {
        String fileName = this.getRelativeFilePath(file);
        fileName = fileName.replace(File.separatorChar, '.');
        fileName = fileName.substring(0, fileName.indexOf(".java"));
        fileName = fileName + ".xml";
        String output = this.mDestDir + File.separator + fileName;
        return output;
    }

    private String getPackageName(ParseFile file) {
        String fileName = this.getRelativeFilePath(file);
        fileName = fileName.replace(File.separatorChar, '.');
        fileName = fileName.substring(0, fileName.indexOf(".java"));
        String packageName = fileName.substring(0, fileName.lastIndexOf("."));
        return packageName;
    }

    private String getClassName(ParseFile file) {
        String fileName = this.getRelativeFilePath(file);
        fileName = fileName.replace(File.separatorChar, '.');
        fileName = fileName.substring(0, fileName.indexOf(".java"));
        String className = fileName.substring(fileName.lastIndexOf(".") + 1);
        return className;
    }

    private long convertDate2Long() {
        Date calendar = null;
        long millis = 0L;
        try {
            int year = Integer.parseInt(this.mStartDate.substring(0, 4));
            int month = Integer.parseInt(this.mStartDate.substring(5, 7));
            int day = Integer.parseInt(this.mStartDate.substring(8, 10));
            int hours = Integer.parseInt(this.mStartDate.substring(11, 13));
            int minutes = Integer.parseInt(this.mStartDate.substring(14, 16));
            int seconds = Integer.parseInt(this.mStartDate.substring(17, 19));
            calendar = new Date(year - 1900, month - 1, day, hours, minutes, seconds);
            millis = calendar.getTime();
            Object var11_9 = null;
            return millis;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            return millis;
        }
    }

    private void writeOverview(PrintStream ps) {
        ps.println("Package Count:            " + this.mOverviewStatistics.getPackageCount());
        ps.println("Class Count:              " + this.mOverviewStatistics.getClassCount());
        ps.println("Methods Count:            " + this.mOverviewStatistics.getMethodCount());
        ps.println("Violations Count :        " + this.mOverviewStatistics.getViolationCount());
        ps.println("Avg Violations per Class: " + this.mOverviewStatistics.calculateAvgViolationsPerClass());
        ps.println("NCSS Count:               " + this.mOverviewStatistics.getNCSSCount());
        ps.println("Avg Violations per NCSS:  " + this.mOverviewStatistics.calculateAvgViolationsPerNcss());
        ps.println("Function Points Count:    " + this.mOverviewStatistics.getFunctionPointCount());
        ps.println("Lines Count:              " + this.mOverviewStatistics.getLineCount());
        ps.println("Unit Test Class Count:    " + this.mOverviewStatistics.getUnitTestClassCount());
        ps.println("Unit Tests Count:         " + this.mOverviewStatistics.getUnitTestCount());
        ps.println("Highest Severity:         " + this.mOverviewStatistics.getHighestSeverityLevel());
    }

    HashMap getPackageMap() {
        return this.mOverviewStatistics.getPackageMap();
    }

    void copyExampleHtml() {
        String[] folders = new String[]{"javadoc", "method", "metrics", "unittest", "field", "general"};
        int i = 0;
        int count = folders.length;
        while (i < count) {
            String folder = folders[i];
            try {
                FileFinder ff = new FileFinder(this.mJcscHome + File.separator + "html" + File.separator + "examplehtml" + File.separator + folder, new FileFilter(){

                    public boolean accept(File pathname) {
                        return pathname.getName().endsWith(".html");
                    }
                }, false);
                ArrayList files = new ArrayList(ff.getFiles());
                File destDir = new File(this.mDestDir + File.separator + "examplehtml" + File.separator + folder);
                destDir.mkdirs();
                int j = 0;
                int count2 = files.size();
                while (j < count2) {
                    File file = (File)files.get(j);
                    FileIO.copyFile(file.getAbsolutePath(), this.mDestDir + File.separator + "examplehtml" + File.separator + folder + File.separator + file.getName());
                    ++j;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    void copyXSL() {
        try {
            FileFinder ff = new FileFinder(this.mJcscHome + File.separator + "html" + File.separator + "xml" + File.separator + "xsl", new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getName().endsWith(".xsl");
                }
            }, false);
            ArrayList files = new ArrayList(ff.getFiles());
            File destDir = new File(this.mDestDir + File.separator + "xsl");
            destDir.mkdir();
            int i = 0;
            int count = files.size();
            while (i < count) {
                File file = (File)files.get(i);
                FileIO.copyFile(file.getAbsolutePath(), this.mDestDir + File.separator + "xsl" + File.separator + file.getName());
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void copyIndex() {
        try {
            FileIO.copyFile(this.mJcscHome + File.separator + "html" + File.separator + "xml" + File.separator + "index.html", this.mDestDir + File.separator + "index.html");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void copyRules() {
        try {
            FileIO.copyFile(this.mRules, this.mDestDir + File.separator + "rules.jcsc.xml");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

