/*
 * Decompiled with CFR 0.152.
 */
package rj.tools.jcsc.ant;

import rj.tools.jcsc.Violation;

public class BatchResult {
    private Violation[] mViolations;
    private String mPackageName;
    private String mClassName;
    private String mAuthors;
    private int mMethodCount;
    private int mNcssCount;
    private int mLineCount;
    private int mUnitTestClassCount;
    private int mUnitTestsCount;

    public BatchResult(Violation[] violations, String packageName, String className, String authors, int methodCount, int ncssCount, int lineCount, int unitTestClassCount, int unitTestsCount) {
        this.mPackageName = packageName;
        this.mClassName = className;
        this.mAuthors = authors;
        this.mViolations = violations;
        this.mMethodCount = methodCount;
        this.mNcssCount = ncssCount;
        this.mLineCount = lineCount;
        this.mUnitTestClassCount = unitTestClassCount;
        this.mUnitTestsCount = unitTestsCount;
    }

    public String getClassName() {
        return this.mClassName;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public String getAuthors() {
        return this.mAuthors;
    }

    public int getMethodCount() {
        return this.mMethodCount;
    }

    public int getNcssCount() {
        return this.mNcssCount;
    }

    public int getLineCount() {
        return this.mLineCount;
    }

    public int getUnitTestClassCount() {
        return this.mUnitTestClassCount;
    }

    public int getUnitTestsCount() {
        return this.mUnitTestsCount;
    }

    public int getHighestSeverityLevel() {
        return this.findHighestSeverityLevel();
    }

    private int findHighestSeverityLevel() {
        Violation[] violations = this.mViolations;
        int max = 0;
        int i = 0;
        int count = violations.length;
        while (i < count) {
            max = Math.max(max, violations[i].getRule().getSeverity());
            ++i;
        }
        return max;
    }

    public Violation[] getViolations() {
        return this.mViolations;
    }
}

