/*
 * Decompiled with CFR 0.152.
 */
package rj.tools.jcsc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import rj.tools.jcsc.JUnitResultsFormatter;
import rj.tools.jcsc.JavaCodingStandardChecker;
import rj.tools.jcsc.rules.RulesHandler;
import rj.tools.jcsc.sorter.OccurenceSorter;

public class JcscTestUtil {
    public static Map getDefaultRules() {
        try {
            Map map = new RulesHandler().readZipRulesFile("default.jcsc.xml");
            System.out.println("JCSCUtil.rm: " + map);
            System.out.println("2RM.linelenght: " + map.get("LineLength"));
            return map;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("default.jcsc.xml rules file not found in jcsc.jar");
        }
    }

    public static Map getJCSCRules() {
        try {
            return new RulesHandler().readRulesFile("rules/jcsc.jcsc.xml");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("jcsc.jcsc rules file not found JCSC_HOME/rules");
        }
    }

    public static Map getStrictRules() {
        try {
            return new RulesHandler().readRulesFile("rules/strict.jcsc.xml");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("strict.jcsc rules file not found JCSC_HOME/rules");
        }
    }

    public static JUnitResultsFormatter runTest(String fileName, Map cache) {
        JUnitResultsFormatter rf = new JUnitResultsFormatter();
        try {
            File file = new File(fileName);
            JavaCodingStandardChecker jcsc = null;
            FileInputStream fin = new FileInputStream(file);
            jcsc = new JavaCodingStandardChecker(fin);
            rf.setOutputStream(System.out);
            rf.setViolationSorter(new OccurenceSorter());
            jcsc.setFileName(file.getAbsolutePath());
            jcsc.setRules(cache);
            jcsc.setResultsFormatter(rf);
            jcsc.parse();
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("File not found");
        }
        return rf;
    }
}

