/*
 * Decompiled with CFR 0.152.
 */
package rj.tools.jcsc;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import rj.tools.jcsc.JUnitResultsFormatter;
import rj.tools.jcsc.JavaCodingStandardChecker;
import rj.tools.jcsc.JcscTestUtil;
import rj.tools.jcsc.sorter.OccurenceSorter;

public class JcscAdditionalTest
extends TestCase {
    static /* synthetic */ Class class$rj$tools$jcsc$JcscAdditionalTest;

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(class$rj$tools$jcsc$JcscAdditionalTest == null ? (class$rj$tools$jcsc$JcscAdditionalTest = JcscAdditionalTest.class$("rj.tools.jcsc.JcscAdditionalTest")) : class$rj$tools$jcsc$JcscAdditionalTest);
        return suite;
    }

    public JcscAdditionalTest(String name) {
        super(name);
    }

    public void testXdotSuperdotA() {
        JUnitResultsFormatter rf = new JUnitResultsFormatter();
        try {
            File file = new File("junit-src/rj/tools/jcsc/XdotSuperdotA.xava");
            JavaCodingStandardChecker jcsc = null;
            FileInputStream fin = new FileInputStream(file);
            ByteArrayOutputStream out = new ByteArrayOutputStream(1000);
            PrintStream ps = new PrintStream(out);
            PrintStream sout = System.out;
            PrintStream serr = System.err;
            System.setErr(ps);
            System.setOut(ps);
            jcsc = new JavaCodingStandardChecker(fin);
            rf.setOutputStream(System.out);
            rf.setViolationSorter(new OccurenceSorter());
            jcsc.setFileName(file.getAbsolutePath());
            jcsc.setRules(JcscTestUtil.getDefaultRules());
            jcsc.setResultsFormatter(rf);
            jcsc.parse();
            ps.close();
            String output = out.toString();
            int index = output.indexOf("Was expecting one of:");
            System.setErr(sout);
            System.setOut(serr);
            Assert.assertEquals((String)"X.super.A has caused an error", (int)-1, (int)index);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("File not found");
        }
    }

    public void testRecursion() {
        Map map = JcscTestUtil.getDefaultRules();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println("map: " + map);
        JUnitResultsFormatter rf = JcscTestUtil.runTest("junit-src/rj/tools/jcsc/Recursion.xava", JcscTestUtil.getDefaultRules());
        Assert.assertEquals((int)0, (int)rf.getViolationsCount());
    }

    public void testNumberOfNewLinesInDoc() {
        String doc = "// Line 1\n// Line 2\n/**\n * Line 4\n * Line 5\n */\n// Line 7\n// Line 8\n/*\n * Line 10\n * Line 11\n */\n// Line 13\n/**\n * Line 15\n * Line 16\n */\n/** Line 18 */\n";
        Assert.assertEquals((String)"The Number of NL is wrong", (int)18, (int)JavaCodingStandardChecker.getNumberOfNewLines(doc));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

