/*
 * Decompiled with CFR 0.152.
 */
package rj.tools.jcsc;

import gnu.regexp.RE;
import gnu.regexp.REException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import rj.tools.argumentprocessor.ArgProcessor;
import rj.tools.jcsc.JavaCharStream;
import rj.tools.jcsc.JavaCodingStandardCheckerConstants;
import rj.tools.jcsc.JavaCodingStandardCheckerTokenManager;
import rj.tools.jcsc.MethodMetric;
import rj.tools.jcsc.ParseException;
import rj.tools.jcsc.ResultsFormatter;
import rj.tools.jcsc.Return;
import rj.tools.jcsc.Token;
import rj.tools.jcsc.Violation;
import rj.tools.jcsc.formatter.ConsoleResultsFormatter;
import rj.tools.jcsc.rules.Rule;
import rj.tools.jcsc.rules.RulesHandler;
import rj.tools.jcsc.sorter.OccurenceSorter;
import rj.tools.util.JavaDocParser;
import rj.tools.util.ui.RegexpDialog;

public class JavaCodingStandardChecker
implements JavaCodingStandardCheckerConstants {
    private static final String FIELDDECLARATION = "FIELDDECLARATION";
    private static final String METHODDECLARATION = "METHODDECLARATION";
    private static final String NESTEDCLASSDECLARATION = "NESTEDCLASSDECLARATION";
    private static final String NESTEDINTERFACEDECLARATION = "NESTEDINTERFACEDECLARATION";
    private static final String FOR_STATEMENT = "for";
    private static final String WHILE_STATEMENT = "while";
    private static final String IF_STATEMENT = "if";
    private static final String SWITCH_STATEMENT = "switch";
    private static final String ASSIGNMENT_BINARY = "=";
    private static final String CONDITIONAL_OR_BINARY = "||";
    private static final String CONDITIONAL_AND_BINARY = "&&";
    private static final String INCLUSIVE_OR_BINARY = "|";
    private static final String EXCLUSIVE_OR_BINARY = "^";
    private static final String AND_BINARY = "&";
    private static final String OR_BINARY = "|";
    private static final String EQUALITY_BINARY = "== | !=";
    private static final String RELATIONAL_BINARY = "< | > | <= | >=";
    private static final String SHIFT_BINARY = "<< | >> | >>>";
    private static final String ADDITIVE_BINARY = "+ | -";
    private static final String MULTIPLICATIVE_BINARY = "* | / | %";
    private static final String BEFORE_BINARY = "before";
    private static final String AFTER_BINARY = "after";
    private static final int FPR_BEFORE_METHOD = 1;
    private static final int FPR_AFTER_METHOD = 2;
    private static final int MPR_BEFORE_FIELD = 1;
    private static final int MPR_AFTER_FIELD = 2;
    private static final int MOR_CTOR_INS_STAT = 8;
    private static final int MOR_CTOR_STAT_INS = 16;
    private static final int MOR_STAT_CTOR_INS = 32;
    private static final int NTPR_BEGINNING_OF_CLASS = 1;
    private static final int NTPR_END_OF_CLASS = 2;
    private static final int NTPR_MIDDLE_OF_CLASS = 4;
    private static Map sRulesMap;
    private static OutputStream sOutputStream;
    private static ResultsFormatter sResultsFormatter;
    private static String sFileName;
    private static String sPackage;
    private static String sClassName;
    public static ArrayList sAuthors;
    public static ArrayList sViolations;
    public static ArrayList sMethodMetrics;
    public static String sJVMVersion;
    public static String sLastJavaDoc;
    public static StringBuffer sLastComment;
    public static int sSpaceCount;
    public static int sUnitTestClassCount;
    public static int sUnitTestsCount;
    public static int sMethodsCount;
    public static int sNCSSCount;
    public static int sCCNCount;
    public static boolean sReturn;
    public static boolean sNewLine;
    public static int sLineCount;
    public static int sIgnoreTestSeverity;
    private static Stack sSavedStates;
    public static CurrentState sCurrentState;
    public JavaCodingStandardCheckerTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[115];
    private final int[] jj_la1_0 = new int[]{0, 0, 0x40204000, 0, 16384, 0x40004000, 0x40004000, 0x10000000, 0, 1144176640, 0x40004000, 0x40004000, 1142063104, 0x40004000, 0x40004000, 16384, 16384, 0x40004000, 0x40004000, 0x10000000, 1144176640, 1142063104, 0x40000000, 0x40000000, 0, 0, 0, 605192192, 605192192, 0, 0x40004000, 0x40004000, 0, 0, 0, 0, 1142063104, 0x40000000, 0, 0, 0, 1723039744, 605192192, 0, 68321280, 0, 68321280, 68321280, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 605192192, 0, 0, 605192192, 0x20000000, 0, 0, 0, 0, 0x20000000, 0, 0, 0x20000000, 0x20000000, 605192192, 0, 0, 0, 0, 0, 0, 647200768, 1723039744, 649297920, 0x40000000, 0, 0, 0, 605192192, 0x1040000, 1723039744, 0x1040000, 647200768, 647200768, 1678934016, 605192192, 605192192, 605192192, 0, 0, 0, 605192192, Integer.MIN_VALUE, 0, 0, 0};
    private final int[] jj_la1_1 = new int[]{8192, 32, 65792, 0, 65792, 65536, 65536, 0, 16, 1682818945, 638976, 638976, 1141752449, 4834304, 4834304, 65536, 65536, 638976, 638976, 0, 1682818945, 1141752449, 1141489664, 1141489664, 0, 0, 0, 680794753, 680794753, 0, 4834304, 4834304, 0x2000000, 0, 0, 0, 262785, 0, 114688, 114688, 0x2000000, -1175053429, 680794753, 524288, 262785, 0, 262785, 537133697, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 680794753, 0, 0, 680794753, 143661056, 0, 0, 0, 0, 143661056, 0, 0, 0x8001000, 0x8000000, 680794753, 0, 0, 0, 2048, 0, 0, -1175053685, -1175053429, -1175053429, 0, 0, 0, 0, 680794753, 0, -1175053429, 0, -1175053685, -1175053685, 680794753, 680794753, 680794753, 680794753, 0, 0, 0, 680794753, 0, 0, 0, 0};
    private final int[] jj_la1_2 = new int[]{0, 0, 524289, 0x200000, 524289, 1, 1, 0, 0, 558081, 1, 1, 525312, 1, 1, 1, 1, 1, 1, 0, 525313, 525312, 0, 0, 0x100000, 0x400000, 131072, 100706116, 100706116, 0x100000, 1, 1, 0, 557056, 131072, 0x100000, 1024, 0, 0, 0, 0, 567110, 10052, 0, 1024, 131072, 0, 1024, 0x100000, 0x400000, 0x400000, 0x8000000, 0, 0, 0, 0, 0, 0x20000000, 0x20000000, 0, -1048576000, -1048576000, 0, 0, 0, 0, 0, 0, 0, 100673348, 0x6000000, 0x6000000, 10052, 100673348, 8192, 0, 0, 8192, 9028, 1024, 0x222000, 836, 0, 100673348, 0x100000, 32768, 139264, 0, 131072, 131072, 567110, 567110, 567110, 0, 0x100000, 0x400000, 0x400000, 10052, 0, 567110, 0, 567110, 567110, 10052, 100673348, 10052, 10052, 0x100000, 1024, 1024, 100673348, 0, 32768, 32768, 0x10000000};
    private final int[] jj_la1_3 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 120, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 24, 0, 0, 0, 0, 0, 0, 0, 0x7FF0000, 0x7FF0000, 0, 2, 4, 1024, 2048, 512, 1, 1, 0, 0, 0, 57344, 57344, 96, 96, 4480, 4480, 96, 120, 0, 0, 0, 0, 0, 24, 24, 0, 0, 0, 0, 0, 0, 120, 0, 0, 0, 0, 0, 0, 24, 24, 24, 0, 0, 134152216, 134152216, 24, 0, 24, 0, 24, 24, 24, 120, 24, 24, 0, 0, 0, 120, 0, 0, 0, 0};
    private final JJCalls[] jj_2_rtns = new JJCalls[36];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public static void main(String[] args) {
        if (!JavaCodingStandardChecker.hasJVMRightVersion(System.getProperty("java.specification.version"))) {
            System.out.println("JVM is not supported JDK1.3+ is required");
        }
        JavaCodingStandardChecker parser = null;
        ArgProcessor ap = new ArgProcessor();
        ap.defineOptions("r:j:h");
        ap.putArguments(args);
        args = ap.getArguments();
        try {
            parser = JavaCodingStandardChecker.createFileParser(args);
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + sFileName);
            return;
        }
        try {
            JavaCodingStandardChecker.setRulesOnParser(ap, parser);
        }
        catch (IOException e) {
            System.err.println("Rules file could not be found");
            System.exit(1);
        }
        ConsoleResultsFormatter rf = new ConsoleResultsFormatter();
        rf.setViolationSorter(new OccurenceSorter());
        rf.setOutputStream(System.out);
        parser.setResultsFormatter(rf);
        parser.parse();
    }

    private static boolean hasJVMRightVersion(String version) {
        if (sJVMVersion == null) {
            int[] versions = new int[5];
            int count = 0;
            StringTokenizer st = new StringTokenizer(version, ".");
            while (st.hasMoreTokens()) {
                versions[count++] = Integer.parseInt(st.nextToken());
            }
            return versions[0] >= 1 && versions[1] > 2;
        }
        return true;
    }

    private static JavaCodingStandardChecker createFileParser(String[] args) throws FileNotFoundException {
        JavaCodingStandardChecker parser = null;
        if (args.length == 0) {
            parser = new JavaCodingStandardChecker(System.in);
            parser.setFileName("System.in");
        } else {
            parser = new JavaCodingStandardChecker(new FileInputStream(args[0]));
            parser.setFileName(args[0]);
        }
        return parser;
    }

    private static void setRulesOnParser(ArgProcessor ap, JavaCodingStandardChecker parser) throws IOException {
        if (ap.hasFlagOption("h")) {
            System.out.println("\nJava Coding Standard Checker Parser Version __0.96__:  Usage is one of:");
            System.out.println("Usage:");
            System.out.println("  jcsc [-j <rule> | -r <rule>] <file>|stream");
            System.out.println("    -r <rule> : the rule file is read from the file system");
            System.out.println("    -j <rule> : the rule file is read from rule folder in the jcsc.jar file");
            System.out.println("\nWritten by Ralph Jocham in 1999-2004");
            System.out.println("This Software is Free under the GPL (GNU Public Licence)\n");
            System.exit(0);
        }
        if (ap.hasOption("r")) {
            parser.setRules(new RulesHandler().readRulesFile(ap.getArgumentOption("r")));
        } else if (ap.hasOption("j")) {
            parser.setRules(new RulesHandler().readZipRulesFile(ap.getArgumentOption("j")));
        } else {
            parser.setRules(new RulesHandler().readZipRulesFile("default.jcsc.xml"));
        }
    }

    public void parse() {
        try {
            this.CompilationUnit();
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            System.err.println("File: " + sFileName);
        }
        sResultsFormatter.setViolations(this.getViolations());
        sResultsFormatter.setViolationsCount(this.getViolationsCount());
        sResultsFormatter.setMethodMetrics(sMethodMetrics);
        sResultsFormatter.setUnitTestClassCount(this.getUnitTestClassCount());
        sResultsFormatter.setUnitTestsCount(this.getUnitTestsCount());
        sResultsFormatter.setMethodsCount(this.getMethodsCount());
        sResultsFormatter.setPackage(sPackage);
        sResultsFormatter.setClassName(sClassName);
        sResultsFormatter.setAuthors(sAuthors);
        sResultsFormatter.setNCSSCount(this.getNCSSCount());
        sResultsFormatter.setLineCount(this.getLineCount());
        sResultsFormatter.format();
    }

    private List filterTestViolations(List violations) {
        if (this.getUnitTestClassCount() > 0) {
            return this.filterViolationsSeverityHigher(violations, 4);
        }
        return violations;
    }

    private List filterViolationsSeverityHigher(List violations, int severity) {
        ArrayList<Violation> list = new ArrayList<Violation>();
        Iterator iter = violations.iterator();
        while (iter.hasNext()) {
            Violation violation = (Violation)iter.next();
            if (violation.getRule().getSeverity() <= sIgnoreTestSeverity) continue;
            list.add(violation);
        }
        return list;
    }

    public List getViolations() {
        return this.filterTestViolations(sViolations);
    }

    public int getViolationsCount() {
        return this.getViolations().size();
    }

    public int getUnitTestClassCount() {
        return sUnitTestClassCount;
    }

    public int getUnitTestsCount() {
        return sUnitTestsCount;
    }

    public int getMethodsCount() {
        return sMethodsCount;
    }

    public List getAuthors() {
        return sAuthors;
    }

    public int getNCSSCount() {
        return sNCSSCount;
    }

    public int getLineCount() {
        return sLineCount;
    }

    public void setResultsFormatter(ResultsFormatter resultsFormatter) {
        sResultsFormatter = resultsFormatter;
    }

    public void setIgnoreTestSeverity(int severity) {
        sIgnoreTestSeverity = severity;
    }

    public void setFileName(String fileName) {
        sFileName = fileName;
        sClassName = this.getClassNameFromFileName(fileName);
        sPackage = "";
        sSpaceCount = 0;
        sNCSSCount = 0;
        sLineCount = 0;
        sUnitTestClassCount = 0;
        sUnitTestsCount = 0;
        sMethodsCount = 0;
        sLastJavaDoc = "";
        sIgnoreTestSeverity = 0;
        sLastComment = new StringBuffer();
        sSavedStates = new Stack();
        sCurrentState = null;
        sViolations = new ArrayList();
        sMethodMetrics = new ArrayList();
        sAuthors = new ArrayList();
    }

    private String getClassNameFromFileName(String fileName) {
        String name = fileName.substring(0, fileName.lastIndexOf("."));
        name = name.replace(File.separatorChar, '.');
        name = name.replace('/', '.');
        name = name.substring(name.lastIndexOf(46) + 1);
        return name;
    }

    public void setRules(Map cache) {
        sRulesMap = cache;
    }

    static void addViolation(Rule rule, int pLine, int pColumn, String message) {
        sViolations.add(new Violation(rule, sFileName, JavaCodingStandardChecker.sCurrentState.mName, sPackage, message, pLine, pColumn));
    }

    static void addMethodMetrics(int pLine, int pColumn, String pMethod, int pNCSSCount, int pCCNCount) {
        String classes = "";
        int i = 1;
        int count = sSavedStates.size();
        while (i < count) {
            classes = classes + ((CurrentState)JavaCodingStandardChecker.sSavedStates.get((int)i)).mName + ".";
            ++i;
        }
        sMethodMetrics.add(new MethodMetric(pLine, pColumn, classes + JavaCodingStandardChecker.sCurrentState.mName + "." + pMethod + "()", pNCSSCount, pCCNCount));
    }

    public static boolean isRegexpMatch(Object regexp, Object value) {
        try {
            RE reg = new RE(regexp.toString());
            if (reg.isMatch(value.toString())) {
                return true;
            }
        }
        catch (REException e) {
            e.printStackTrace();
        }
        return false;
    }

    static int getNumberOfNewLines(String text) {
        int nl = 0;
        int i = 0;
        int count = text.length();
        while (i < count) {
            char c = text.charAt(i);
            if (c == '\n') {
                ++nl;
            }
            ++i;
        }
        return nl;
    }

    public static void handleTypeHeaderExpression(StringBuffer pHeader, int pLine, int pColumn) {
        Rule rule = (Rule)sRulesMap.get("TypeHeaderExpression");
        if (rule.isEnabled()) {
            ArrayList<String> hl = new ArrayList<String>();
            ArrayList<String> rl = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(pHeader.toString().trim(), String.valueOf(new char[]{'\n'}));
            boolean isNotEqual = false;
            while (st.hasMoreTokens()) {
                hl.add(st.nextToken());
            }
            st = new StringTokenizer(rule.getValue().trim(), String.valueOf(new char[]{'\n'}));
            while (st.hasMoreTokens()) {
                rl.add(st.nextToken());
            }
            if (hl.size() != rl.size()) {
                JavaCodingStandardChecker.addViolation(rule, 0, 0, "type does not have the correct header");
                return;
            }
            int i = 0;
            int count = hl.size();
            while (i < count) {
                String h = RegexpDialog.removeCR((String)hl.get(i));
                String r = RegexpDialog.removeCR((String)rl.get(i));
                if (!JavaCodingStandardChecker.isRegexpMatch(r, h)) {
                    isNotEqual = true;
                    break;
                }
                ++i;
            }
            if (isNotEqual) {
                JavaCodingStandardChecker.addViolation(rule, 0, 0, "type does not have the correct header");
            }
        }
    }

    static void handleTab(int pLine, int pColumn) {
        Rule rule = (Rule)sRulesMap.get("TabsAllowed");
        if (rule.isEnabled() && !rule.getValue().equals("true")) {
            JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "is a tab '\\t' character which is not allowed");
        }
    }

    static void handleLineLength(int pLine, int pColumn) {
        int lineLength;
        Rule rule = (Rule)sRulesMap.get("LineLength");
        if (rule.isEnabled() && pColumn > (lineLength = Integer.parseInt(rule.getValue()))) {
            JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "line is too long 0.." + lineLength + " characters are allowed");
        }
    }

    static void handleLongValues(String pLongIdentifier, int pLine, int pColumn) {
        Rule rule = (Rule)sRulesMap.get("OnlyCapitalLForLong");
        if (rule.isEnabled() && rule.getValue().equals("true") && pLongIdentifier.charAt(pLongIdentifier.length() - 1) == 'l') {
            JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "Don't use 'l' for long values, it can be misstaken for '1' use 'L'");
        }
    }

    static void handleOpenBracePosition(int pLine, int pColumn) {
        Rule rule = (Rule)sRulesMap.get("OpenBraceNewLine");
        if (rule.isEnabled() && rule.getValue().equals("true") && !sNewLine) {
            JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "is a '{' which must be on the next line");
        }
    }

    static void handleUnitTestClass(StringBuffer pName, int pLine, int pColumn) {
        Rule rule = (Rule)sRulesMap.get("UnitTestClassRegExp");
        if (rule.isEnabled() && JavaCodingStandardChecker.isRegexpMatch(rule.getValue(), pName)) {
            ++sUnitTestClassCount;
        }
    }

    static void handleUnitTests(StringBuffer pName, int pLine, int pColumn) {
        Rule rule = (Rule)sRulesMap.get("UnitTestsRegExp");
        if (rule.isEnabled() && JavaCodingStandardChecker.isRegexpMatch(rule.getValue(), pName)) {
            ++sUnitTestsCount;
        }
    }

    static void handleMethodThrowException(ArrayList pExceps, int pLine, int pColumn) {
        Rule rule = (Rule)sRulesMap.get("OnlyThrowSubclassedException");
        if (rule.isEnabled() && rule.getValue().equals("true")) {
            Iterator iter = ((AbstractList)pExceps).iterator();
            while (iter.hasNext()) {
                String tkn = (String)iter.next();
                if (!JavaCodingStandardChecker.isRegexpMatch("(java\\.lang\\.)?(Exception|Throwable)$", tkn)) continue;
                JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "throwing '" + tkn + "' is to generic and a" + " missuse of exceptions. throw a subclass of" + " 'Exception'");
            }
        }
    }

    static void handleSwitchNeedsDefault(boolean pHasDefault, int pLine, int pColumn) {
        Rule rule = (Rule)sRulesMap.get("SwitchRequiresDefault");
        if (rule.isEnabled() && rule.getValue().equals("true") && !pHasDefault) {
            JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "switch statement doesn't have a 'default' block which is required");
        }
    }

    static void handleSubclassedCatchBlock(StringBuffer pType, StringBuffer pName, int pLine, int pColumn) {
        String type;
        Rule rule = (Rule)sRulesMap.get("OnlySubclassedCatchBlock");
        if (rule.isEnabled() && rule.getValue().equals("true") && JavaCodingStandardChecker.isRegexpMatch("(java\\.lang\\.)?(Throwable|Exception)", type = pType.toString())) {
            JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "catching of java.lang.(Throwable|Exception) is to generic - catch a subclass");
        }
    }

    static void handleEmptyCatchBlock(int pLine, int pColumn) {
        Rule rule = (Rule)sRulesMap.get("EmptyCatchBlockAllowed");
        if (rule.isEnabled() && !rule.getValue().equals("true")) {
            JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "empty catch block, this is normally an error");
        }
    }

    static void handleEmptyFinallyBlock(int pLine, int pColumn) {
        Rule rule = (Rule)sRulesMap.get("EmptyFinallyBlockAllowed");
        if (rule.isEnabled() && !rule.getValue().equals("true")) {
            JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "empty finally block, this is normally an error");
        }
    }

    static void handleArrayDeclaration(int pLine, int pColumn) {
        Rule rule = (Rule)sRulesMap.get("CheckArrayAtType");
        if (rule.isEnabled() && Boolean.valueOf(rule.getValue()).booleanValue()) {
            JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "'[]' on array declarations should be grouped  with the type rather than the variable name,  e.g. 'int[] x' rather than 'int x[]'");
        }
    }

    static void handleSemicolonAfterTypeDeclaration(int pLine, int pColumn) {
        Rule rule = (Rule)sRulesMap.get("SemicolonAfterTypeDeclaration");
        if (rule.isEnabled() && !rule.getValue().equals("true")) {
            JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "typedeclaration is terminated with a ';'. This is not correct Java, though many compilers accept it");
        }
    }

    static void handleNoBraceStatement(String pKind, int pLine, int pColumn) {
        Rule rule = (Rule)sRulesMap.get("BracesAroundSingleLineStatement");
        if (rule.isEnabled() && !rule.getValue().equals("true")) {
            JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "statement following '" + pKind + "' is not in '{' ... '}'" + "  which is a source of many errors.");
        }
    }

    static void handleConditionalExpressAssignment(int pLine, int pColumn) {
        Rule rule = (Rule)sRulesMap.get("AssignmentInConditionalExpression");
        if (rule.isEnabled() && !rule.getValue().equals("true")) {
            JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "assignment in conditional expression is often a mistyped '=='");
        }
    }

    static void handleLabelNaming(StringBuffer pLabel, int pLine, int pColumn) {
        Rule rule = (Rule)sRulesMap.get("LabelNameRegExp");
        if (rule.isEnabled() && !JavaCodingStandardChecker.isRegexpMatch(rule.getValue(), pLabel)) {
            JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "label '" + pLabel + "'" + " must match the following regexp '" + rule.getValue() + "'");
        }
    }

    static void handlePackageNameRegExp(StringBuffer pPackage, int pLine, int pColumn) {
        Rule rule = (Rule)sRulesMap.get("PackageNameRegExp");
        if (rule.isEnabled() && !JavaCodingStandardChecker.isRegexpMatch(rule.getValue(), pPackage.toString())) {
            JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "package name must match the following regexp '" + rule.getValue() + "'");
        }
    }

    static void handleImportDeclaration(StringBuffer pImport, int pLine, int pColumn) {
        int lastDot;
        Rule rule = (Rule)sRulesMap.get("AllowDotStarImport");
        if (pImport.toString().startsWith("java.lang") && (lastDot = pImport.toString().lastIndexOf(46)) == "java.lang".length()) {
            JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "java.lang packages must not be imported (import " + pImport + ")" + " - implicit import");
        }
        if (rule.isEnabled() && pImport.toString().endsWith(".*")) {
            JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "Not allowed general import statement (import " + pImport + ")");
        }
    }

    static void handleTypeModifierOrder(StringBuffer pModifier, String pType, int pLine, int pColumn) {
        Rule rule = (Rule)sRulesMap.get("TypeDeclarationModifierOrder");
        if (rule.isEnabled()) {
            StringBuffer mod = new StringBuffer("");
            boolean pub = false;
            boolean abs = false;
            boolean fin = false;
            boolean sfp = false;
            StringTokenizer st = new StringTokenizer(pModifier.toString());
            while (st.hasMoreElements()) {
                String tkn = st.nextToken();
                if (tkn.equals("public")) {
                    pub = true;
                }
                if (tkn.equals("abstract")) {
                    abs = true;
                }
                if (tkn.equals("final")) {
                    fin = true;
                }
                if (!tkn.equals("strictfp")) continue;
                sfp = true;
            }
            if (pub) {
                mod.append("public ");
            }
            if (abs) {
                mod.append("abstract ");
            }
            if (fin) {
                mod.append("final ");
            }
            if (sfp) {
                mod.append("strictfp ");
            }
            if (!pModifier.toString().trim().equals(mod.toString().trim())) {
                String fnl = "->[final]";
                if (pType.equals("interface")) {
                    fnl = "";
                }
                JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, pType + " modifiers should have the following order" + " [public]->[abstract]" + fnl + "->[strictfp]");
            }
        }
    }

    static void handleFieldDeclarationPlaceRule(int pLine, int pColumn) {
        if (!JavaCodingStandardChecker.sCurrentState.mHasHandledMethodDeclaration) {
            JavaCodingStandardChecker.sCurrentState.mFieldBlockPlace |= 1;
        }
        if (JavaCodingStandardChecker.sCurrentState.mHasHandledMethodDeclaration) {
            JavaCodingStandardChecker.sCurrentState.mFieldBlockPlace |= 2;
        }
    }

    static void handleMethodDeclarationPlaceRule(int pLine, int pColumn) {
        if (!JavaCodingStandardChecker.sCurrentState.mHasHandledFieldDeclaration) {
            JavaCodingStandardChecker.sCurrentState.mMethodBlockPlace |= 1;
        }
        if (JavaCodingStandardChecker.sCurrentState.mHasHandledFieldDeclaration) {
            JavaCodingStandardChecker.sCurrentState.mMethodBlockPlace |= 2;
        }
    }

    static void handleNestedTypePlaceRule(String pFrom, int pLine, int pColumn) {
        Rule rule = (Rule)sRulesMap.get("NestedTypeBlockPlaceRule");
        if (pFrom.equals(NESTEDCLASSDECLARATION) || pFrom.equals(NESTEDINTERFACEDECLARATION)) {
            if (!(JavaCodingStandardChecker.sCurrentState.mHasHandledFieldDeclaration || JavaCodingStandardChecker.sCurrentState.mHasHandledMethodDeclaration || JavaCodingStandardChecker.sCurrentState.mHasHandledStaticInitializer)) {
                JavaCodingStandardChecker.sCurrentState.mNestedTypeBlockPlace |= 1;
            }
        } else if (pFrom.equals(FIELDDECLARATION)) {
            if (JavaCodingStandardChecker.sCurrentState.mHasHandledNestedTypeDeclaration && JavaCodingStandardChecker.sCurrentState.mHasHandledMethodDeclaration && !JavaCodingStandardChecker.sCurrentState.mHasHandledFieldDeclaration && rule.getValue().equals("End of Class")) {
                JavaCodingStandardChecker.sCurrentState.mNestedTypeBlockPlace |= 4;
            }
        } else if (pFrom.equals(METHODDECLARATION) && JavaCodingStandardChecker.sCurrentState.mHasHandledNestedTypeDeclaration && !JavaCodingStandardChecker.sCurrentState.mHasHandledMethodDeclaration && JavaCodingStandardChecker.sCurrentState.mHasHandledFieldDeclaration && rule.getValue().equals("End of Class")) {
            JavaCodingStandardChecker.sCurrentState.mNestedTypeBlockPlace |= 4;
        }
    }

    static void handleNestedTypeModifierOrder(StringBuffer pModifier, int pLine, int pColumn) {
        Rule rule = (Rule)sRulesMap.get("NestedTypeDeclarationModifierOrder");
        if (rule.isEnabled() && Boolean.valueOf(rule.getValue()).booleanValue()) {
            boolean pub = false;
            boolean pro = false;
            boolean pri = false;
            boolean abs = false;
            boolean fin = false;
            boolean sta = false;
            boolean sfp = false;
            StringBuffer mod = new StringBuffer("");
            StringTokenizer st = new StringTokenizer(pModifier.toString());
            while (st.hasMoreElements()) {
                String tkn = st.nextToken();
                if (tkn.equals("public")) {
                    pub = true;
                }
                if (tkn.equals("protected")) {
                    pro = true;
                }
                if (tkn.equals("private")) {
                    pri = true;
                }
                if (tkn.equals("abstract")) {
                    abs = true;
                }
                if (tkn.equals("final")) {
                    fin = true;
                }
                if (tkn.equals("static")) {
                    sta = true;
                }
                if (!tkn.equals("strictfp")) continue;
                sfp = true;
            }
            if (pub || pro || pri) {
                if (pub) {
                    mod.append("public ");
                }
                if (pro) {
                    mod.append("protected ");
                }
                if (pri) {
                    mod.append("private ");
                }
            }
            if (abs) {
                mod.append("abstract ");
            }
            if (sta) {
                mod.append("static ");
            }
            if (fin) {
                mod.append("final ");
            }
            if (sfp) {
                mod.append("strictfp ");
            }
            if (!pModifier.toString().trim().equals(mod.toString().trim())) {
                JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "nested class modifiers should have the following order[pub|prot|pri]->[abstract]->[static]->[final]->[strictfp]");
            }
        }
    }

    static void handleAllowedFieldVisibility(StringBuffer pVisibility, int pLine, int pColumn) {
        Rule rulePub = (Rule)sRulesMap.get("AllowPublicField");
        Rule rulePro = (Rule)sRulesMap.get("AllowProtectedField");
        Rule rulePac = (Rule)sRulesMap.get("AllowPackageField");
        Rule rule = null;
        if (!JavaCodingStandardChecker.sCurrentState.isInterface) {
            boolean pub = false;
            boolean pro = false;
            boolean pri = false;
            boolean sta = false;
            boolean fin = false;
            StringTokenizer st = new StringTokenizer(pVisibility.toString());
            while (st.hasMoreElements()) {
                String tkn = st.nextToken();
                if (tkn.equals("public")) {
                    pub = true;
                }
                if (tkn.equals("protected")) {
                    pro = true;
                }
                if (tkn.equals("private")) {
                    pri = true;
                }
                if (tkn.equals("static")) {
                    sta = true;
                }
                if (!tkn.equals("final")) continue;
                fin = true;
            }
            if (sta && fin) {
                return;
            }
            String visibility = "";
            if (pub) {
                if (rulePub.isEnabled() && !Boolean.valueOf(rulePub.getValue()).booleanValue()) {
                    visibility = "public";
                    rule = rulePub;
                }
            } else if (pro) {
                if (rulePro.isEnabled() && !Boolean.valueOf(rulePro.getValue()).booleanValue()) {
                    visibility = "protected";
                    rule = rulePro;
                }
            } else if (!(pub || pro || pri || !rulePac.isEnabled() || Boolean.valueOf(rulePro.getValue()).booleanValue())) {
                visibility = "package";
                rule = rulePac;
            }
            if (!visibility.equals("")) {
                JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "field declaration having '" + visibility + "' visibility are not allowed.");
            }
        }
    }

    static void handleFieldDeclarationModifierOrder(StringBuffer pModifier, int pLine, int pColumn) {
        Rule rule = (Rule)sRulesMap.get("FieldDeclarationModifierOrder");
        if (rule.isEnabled() && Boolean.valueOf(rule.getValue()).booleanValue()) {
            boolean pub = false;
            boolean pro = false;
            boolean pri = false;
            boolean sta = false;
            boolean fin = false;
            boolean tra = false;
            boolean vol = false;
            StringBuffer mod = new StringBuffer("");
            StringTokenizer st = new StringTokenizer(pModifier.toString());
            while (st.hasMoreElements()) {
                String tkn = st.nextToken();
                if (tkn.equals("public")) {
                    pub = true;
                }
                if (tkn.equals("protected")) {
                    pro = true;
                }
                if (tkn.equals("private")) {
                    pri = true;
                }
                if (tkn.equals("static")) {
                    sta = true;
                }
                if (tkn.equals("final")) {
                    fin = true;
                }
                if (tkn.equals("transient")) {
                    tra = true;
                }
                if (!tkn.equals("volatile")) continue;
                vol = true;
            }
            if (pub || pro || pri) {
                if (pub) {
                    mod.append("public ");
                }
                if (pro) {
                    mod.append("protected ");
                }
                if (pri) {
                    mod.append("private ");
                }
            }
            if (sta) {
                mod.append("static ");
            }
            if (fin) {
                mod.append("final ");
            }
            if (tra) {
                mod.append("transient ");
            }
            if (vol) {
                mod.append("volatile ");
            }
            if (!pModifier.toString().trim().equals(mod.toString().trim())) {
                JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "field declaration modifiers should have the following order[pub|pro|pri]->[abstract]->[static]->[final]->[transient]->[volatile]");
            }
        }
    }

    void handleMethodDeclarationModifierOrder(StringBuffer pModifier, int pLine, int pColumn) {
        Rule rule = (Rule)sRulesMap.get("MethodDeclarationModifierOrder");
        if (rule.isEnabled() && Boolean.valueOf(rule.getValue()).booleanValue()) {
            boolean pub = false;
            boolean pro = false;
            boolean pri = false;
            boolean abs = false;
            boolean sta = false;
            boolean fin = false;
            boolean syn = false;
            boolean nat = false;
            boolean sfp = false;
            StringBuffer mod = new StringBuffer("");
            StringTokenizer st = new StringTokenizer(pModifier.toString());
            while (st.hasMoreElements()) {
                String tkn = st.nextToken();
                if (tkn.equals("public")) {
                    pub = true;
                }
                if (tkn.equals("protected")) {
                    pro = true;
                }
                if (tkn.equals("private")) {
                    pri = true;
                }
                if (tkn.equals("abstract")) {
                    abs = true;
                }
                if (tkn.equals("static")) {
                    sta = true;
                }
                if (tkn.equals("final")) {
                    fin = true;
                }
                if (tkn.equals("synchronized")) {
                    syn = true;
                }
                if (tkn.equals("native")) {
                    nat = true;
                }
                if (!tkn.equals("strictfp")) continue;
                sfp = true;
            }
            if (pub || pro || pri) {
                if (pub) {
                    mod.append("public ");
                }
                if (pro) {
                    mod.append("protected ");
                }
                if (pri) {
                    mod.append("private ");
                }
            }
            if (abs) {
                mod.append("abstract ");
            }
            if (sta) {
                mod.append("static ");
            }
            if (fin) {
                mod.append("final ");
            }
            if (syn) {
                mod.append("synchronized ");
            }
            if (nat) {
                mod.append("native ");
            }
            if (sfp) {
                mod.append("strictfp ");
            }
            if (!pModifier.toString().trim().equals(mod.toString().trim())) {
                JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "method declaration modifiers should have the following order[pub|pro|pri]->[abstract]->[static]->[final]->[synchronized]->[native]->[strictfp]");
            }
        }
    }

    static void handleTypeDeclaration(StringBuffer pClass, int pLine, int pColumn) {
        Rule rule = null;
        if (sCurrentState.type().equals("class")) {
            rule = (Rule)sRulesMap.get("ClassNameRegExp");
        } else if (sCurrentState.type().equals("interface")) {
            rule = (Rule)sRulesMap.get("InterfaceNameRegExp");
        }
        if (rule.isEnabled() && !JavaCodingStandardChecker.isRegexpMatch(rule.getValue(), pClass)) {
            JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, sCurrentState.type() + " '" + pClass + "'" + " name must match the following regexp '" + rule.getValue() + "'");
        }
    }

    static void handleAbstractClassDeclaration(StringBuffer pAClass, int pLine, int pColumn) {
        Rule rule = (Rule)sRulesMap.get("AbstractClassNameRegExp");
        if (rule.isEnabled() && !JavaCodingStandardChecker.isRegexpMatch(rule.getValue(), pAClass)) {
            JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, sCurrentState.type() + " '" + pAClass + "'" + " name must match the following regexp '" + rule.getValue() + "'");
        }
    }

    static void handleInterfaceCheckAbstract(StringBuffer pInterface, StringBuffer pAccess, int pLine, int pColumn) {
        Rule rule = (Rule)sRulesMap.get("InterfaceCheckAbstract");
        if (rule.isEnabled() && pAccess.toString().indexOf("abstract") != -1) {
            JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "'abstract' is implicit for interface, it may be used but Java language spec says it is obsolete");
        }
    }

    static void handleAbstractClassNameRegExp(StringBuffer pInterface, StringBuffer pAccess, int pLine, int pColumn) {
        Rule rule = (Rule)sRulesMap.get("AbstractClassNameRegExp");
        if (rule.isEnabled() && !JavaCodingStandardChecker.isRegexpMatch(rule.getValue(), pInterface)) {
            JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, sCurrentState.type() + " '" + pInterface + "'" + " name must match the following regexp '" + rule.getValue() + "'");
        }
    }

    static void handleLocalVariableDeclaration(StringBuffer pType, StringBuffer pName, int pLine, int pColumn) {
        Rule rule = (Rule)sRulesMap.get("LVRegExp");
        if (rule.isEnabled() && !JavaCodingStandardChecker.isRegexpMatch(rule.getValue(), pName)) {
            JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, " local variable '" + pName + "'" + " name must match the following regexp '" + rule.getValue() + "'");
        }
    }

    static void handleOnlyOneVariableDeclarationPerLine(int pLine, int pColumn) {
        Rule rule = (Rule)sRulesMap.get("OnlyOneFieldDeclarationPerLine");
        if (rule.isEnabled() && Boolean.valueOf(rule.getValue()).booleanValue()) {
            JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "only 1 field declaration per line is allowed");
        }
    }

    static void handleFieldDeclaration(StringBuffer pAccess, StringBuffer pName, int pLine, int pColumn) {
        String access = pAccess.toString();
        String name = pName.toString();
        Object pre = null;
        boolean index = false;
        boolean pub = false;
        boolean pro = false;
        boolean pac = false;
        boolean pri = false;
        boolean sta = false;
        boolean fin = false;
        StringTokenizer st = new StringTokenizer(access);
        while (st.hasMoreElements()) {
            String tkn = st.nextToken();
            if (tkn.equals("public")) {
                pub = true;
            }
            if (tkn.equals("protected")) {
                pro = true;
            }
            if (tkn.equals("private")) {
                pri = true;
            }
            if (tkn.equals("static")) {
                sta = true;
            }
            if (!tkn.equals("final")) continue;
            fin = true;
        }
        if (JavaCodingStandardChecker.sCurrentState.isInterface) {
            pub = true;
            sta = true;
            fin = true;
        }
        if (!(pub || pro || pri)) {
            access = "package " + access;
            pac = true;
        }
        Rule rule = null;
        rule = (Rule)sRulesMap.get("FieldOrderRule");
        if (rule.isEnabled()) {
            if (rule.getValue().equals("Static Final->Static->Inst")) {
                if (sta && fin) {
                    if (JavaCodingStandardChecker.sCurrentState.mHasHandledStatFieldDeclaration || JavaCodingStandardChecker.sCurrentState.mHasHandledInsFieldDeclaration) {
                        JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "static final field decalration is in the wrong order. Order: Static Final->Static->Instance");
                    }
                } else if (sta && JavaCodingStandardChecker.sCurrentState.mHasHandledInsFieldDeclaration) {
                    JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "static field decalration is in the wrong order. Order: Static Final->Static->Instance");
                }
            } else if (rule.getValue().equals("Pub->Pro->Pac->Pri")) {
                if (pub) {
                    if (JavaCodingStandardChecker.sCurrentState.mHasHandledProFieldDeclararion || JavaCodingStandardChecker.sCurrentState.mHasHandledPacFieldDeclararion || JavaCodingStandardChecker.sCurrentState.mHasHandledPriFieldDeclararion) {
                        JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "public field decalration is in the wrong order. Order: Pub->Pro->Pac->Pri");
                    }
                } else if (pro) {
                    if (JavaCodingStandardChecker.sCurrentState.mHasHandledPacFieldDeclararion || JavaCodingStandardChecker.sCurrentState.mHasHandledPriFieldDeclararion) {
                        JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "public field decalration is in the wrong order. Order: Pub->Pro->Pac->Pri");
                    }
                } else if (pac && JavaCodingStandardChecker.sCurrentState.mHasHandledPriFieldDeclararion) {
                    JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "public field decalration is in the wrong order. Order: Pub->Pro->Pac->Pri");
                }
            } else if (rule.getValue().equals("Pri->Pac->Pro->Pub")) {
                if (pri) {
                    if (JavaCodingStandardChecker.sCurrentState.mHasHandledPubFieldDeclararion || JavaCodingStandardChecker.sCurrentState.mHasHandledProFieldDeclararion || JavaCodingStandardChecker.sCurrentState.mHasHandledPacFieldDeclararion) {
                        JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "private field decalration is in the wrong order. Order: Pri->Pac->Pro->Pub");
                    }
                } else if (pac) {
                    if (JavaCodingStandardChecker.sCurrentState.mHasHandledPubFieldDeclararion || JavaCodingStandardChecker.sCurrentState.mHasHandledProFieldDeclararion) {
                        JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "package field decalration is in the wrong order. Order: Pri->Pac->Pro->Pub");
                    }
                } else if (pro && JavaCodingStandardChecker.sCurrentState.mHasHandledPubFieldDeclararion) {
                    JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "protected field decalration is in the wrong order. Order: Pri->Pac->Pro->Pub");
                }
            } else if (rule.getValue().equals("No Order")) {
                // empty if block
            }
        }
        if (sta && fin) {
            if (pub) {
                rule = (Rule)sRulesMap.get("FCFPubRegExp");
            } else if (pro) {
                rule = (Rule)sRulesMap.get("FCFProRegExp");
            } else if (pac) {
                rule = (Rule)sRulesMap.get("FCFPacRegExp");
            } else if (pri) {
                rule = (Rule)sRulesMap.get("FCFPriRegExp");
            }
        } else if (sta) {
            if (pub) {
                rule = (Rule)sRulesMap.get("CFPubRegExp");
            } else if (pro) {
                rule = (Rule)sRulesMap.get("CFProRegExp");
            } else if (pac) {
                rule = (Rule)sRulesMap.get("CFPacRegExp");
            } else if (pri) {
                rule = (Rule)sRulesMap.get("CFPriRegExp");
            }
        } else if (pub) {
            rule = (Rule)sRulesMap.get("IFPubRegExp");
        } else if (pro) {
            rule = (Rule)sRulesMap.get("IFProRegExp");
        } else if (pac) {
            rule = (Rule)sRulesMap.get("IFPacRegExp");
        } else if (pri) {
            rule = (Rule)sRulesMap.get("IFPriRegExp");
        }
        if (rule.isEnabled() && !JavaCodingStandardChecker.isRegexpMatch(rule.getValue(), name)) {
            JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "field declaration '" + name + "' must match" + " the following regexp '" + rule.getValue());
        }
        if (pub) {
            JavaCodingStandardChecker.sCurrentState.mHasHandledPubFieldDeclararion = true;
        } else if (pro) {
            JavaCodingStandardChecker.sCurrentState.mHasHandledProFieldDeclararion = true;
        } else if (pac) {
            JavaCodingStandardChecker.sCurrentState.mHasHandledPacFieldDeclararion = true;
        } else if (pri) {
            JavaCodingStandardChecker.sCurrentState.mHasHandledPriFieldDeclararion = true;
        } else if (sta && fin) {
            JavaCodingStandardChecker.sCurrentState.mHasHandledStatFinFieldDeclaration = true;
        } else if (sta) {
            JavaCodingStandardChecker.sCurrentState.mHasHandledStatFieldDeclaration = true;
        }
        if (!sta && !fin) {
            JavaCodingStandardChecker.sCurrentState.mHasHandledInsFieldDeclaration = true;
        }
    }

    static void handleMethodMetrics(int pNCSSCount, int pCCNCount, StringBuffer pName, int pLine, int pColumn) {
        Rule ruleNCSS = (Rule)sRulesMap.get("MaxNumberOfNCSSPerMethod");
        Rule ruleCCN = (Rule)sRulesMap.get("MaxNumberOfCCNPerMethod");
        if (ruleNCSS.isEnabled() && pNCSSCount > Integer.parseInt(ruleNCSS.getValue())) {
            JavaCodingStandardChecker.addViolation(ruleNCSS, pLine, pColumn, "method declaration '" + pName + "' has too many" + " NCSS (" + pNCSSCount + ") - " + ruleNCSS.getValue() + " are allowed");
        }
        if (ruleCCN.isEnabled() && pCCNCount > Integer.parseInt(ruleCCN.getValue())) {
            JavaCodingStandardChecker.addViolation(ruleCCN, pLine, pColumn, "method declaration '" + pName + "' has a too high" + " CCN (" + pCCNCount + ") - " + ruleCCN.getValue() + " are allowed");
        }
        JavaCodingStandardChecker.addMethodMetrics(pLine, pColumn, pName.toString(), pNCSSCount, pCCNCount);
    }

    static void handleMethodDeclarationArgumentsCount(int pNumArgs, StringBuffer pName, int pLine, int pColumn) {
        Rule rule = (Rule)sRulesMap.get("MaxNumberOfArgumentsPerMethod");
        if (rule.isEnabled() && pNumArgs > Integer.parseInt(rule.getValue())) {
            JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "method declaration '" + pName + "' has too many" + " arguments - " + rule.getValue() + " are allowed");
        }
    }

    static void handleConstructorMetrics(int pNCSSCount, int pCCNCount, StringBuffer pName, int pLine, int pColumn) {
        Rule ruleNCSS = (Rule)sRulesMap.get("MaxNumberOfNCSSPerConstructor");
        Rule ruleCCN = (Rule)sRulesMap.get("MaxNumberOfCCNPerConstructor");
        if (ruleNCSS.isEnabled() && pNCSSCount > Integer.parseInt(ruleNCSS.getValue())) {
            JavaCodingStandardChecker.addViolation(ruleNCSS, pLine, pColumn, "constructor has too many NCSS (" + pNCSSCount + ") - " + ruleNCSS.getValue() + " are allowed");
        }
        if (ruleCCN.isEnabled() && pCCNCount > Integer.parseInt(ruleCCN.getValue())) {
            JavaCodingStandardChecker.addViolation(ruleCCN, pLine, pColumn, "constructor declaration has a too high CCN (" + pCCNCount + ") - " + ruleCCN.getValue() + " are allowed");
        }
        JavaCodingStandardChecker.addMethodMetrics(pLine, pColumn, pName.toString(), pNCSSCount, pCCNCount);
    }

    static void handleConstructorDeclarationArgumentsCount(int pNumArgs, StringBuffer pName, int pLine, int pColumn) {
        Rule rule = (Rule)sRulesMap.get("MaxNumberOfArgumentsPerConstructor");
        if (rule.isEnabled() && pNumArgs > Integer.parseInt(rule.getValue())) {
            JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "constructor declaration has too many arguments - " + rule.getValue() + " are allowed");
        }
    }

    static void handleMethodDeclaration(StringBuffer pAccess, StringBuffer pRetType, StringBuffer pName, int pLine, int pColumn) {
        String access = pAccess.toString();
        String name = pName.toString();
        Object pre = null;
        boolean index = false;
        boolean pub = false;
        boolean pro = false;
        boolean pac = false;
        boolean pri = false;
        boolean sta = false;
        boolean fin = false;
        boolean sfp = false;
        boolean ctr = false;
        StringTokenizer st = new StringTokenizer(access);
        while (st.hasMoreElements()) {
            String tkn = st.nextToken();
            if (tkn.equals("public")) {
                pub = true;
            }
            if (tkn.equals("protected")) {
                pro = true;
            }
            if (tkn.equals("private")) {
                pri = true;
            }
            if (tkn.equals("static")) {
                sta = true;
            }
            if (tkn.equals("final")) {
                fin = true;
            }
            if (!tkn.equals("strictfp")) continue;
            sfp = true;
        }
        if (JavaCodingStandardChecker.sCurrentState.isInterface) {
            pub = true;
        }
        if (name.equals("constructor")) {
            ctr = true;
        }
        if (!(pub || pro || pri)) {
            access = "package " + access;
            pac = true;
        }
        Rule rule = null;
        if (pRetType.toString().equals("boolean") && (rule = (Rule)sRulesMap.get("RegExpPrefixForMethodReturingBoolean")).isEnabled() && !JavaCodingStandardChecker.isRegexpMatch(rule.getValue(), name)) {
            JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "method '" + pName + "' returns 'boolean' and " + "it should start with '" + rule.getValue() + "'");
        }
        if ((rule = (Rule)sRulesMap.get("DontReturnTypeVector")).isEnabled() && rule.getValue().equals("true") && JavaCodingStandardChecker.isRegexpMatch("(java.util.)?Vector", pRetType)) {
            JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "method return type 'Vector' is being replaced by the JDK1.2+ Collection API - return interface 'Collection' instead.");
        }
        if ((rule = (Rule)sRulesMap.get("DontReturnTypeHashtable")).isEnabled() && rule.getValue().equals("true") && JavaCodingStandardChecker.isRegexpMatch("(java.util.)?Hashtable", pRetType)) {
            JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "method return type 'Hashtable' is being replaced by the JDK1.2+ Collection API - return interface 'Map' instead.");
        }
        if ((rule = (Rule)sRulesMap.get("MethodOrderRule")).isEnabled()) {
            if (rule.getValue().equals("Ctor->Static->Inst")) {
                if (ctr) {
                    if (JavaCodingStandardChecker.sCurrentState.mHasHandledInsMethodDeclaration || JavaCodingStandardChecker.sCurrentState.mHasHandledStatMethodDeclaration) {
                        JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "construtor  declaration is in the wrong order. Order: constructor->static->instance");
                    }
                } else if (sta && JavaCodingStandardChecker.sCurrentState.mHasHandledInsMethodDeclaration) {
                    JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "static method declaration is in the wrong order. Order: constructor->static->instance");
                }
            } else if (rule.getValue().equals("Static->Ctor->Inst")) {
                if (sta) {
                    if (JavaCodingStandardChecker.sCurrentState.mHasHandledInsMethodDeclaration || JavaCodingStandardChecker.sCurrentState.mHasHandledCtorMethodDeclaration) {
                        JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "static method declaration is in the wrong order. Order: static->constructor->instance");
                    }
                } else if (ctr && JavaCodingStandardChecker.sCurrentState.mHasHandledInsMethodDeclaration) {
                    JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "instance method declaration is in the wrong order. Order: static->constructor->instance");
                }
            } else if (rule.getValue().equals("Ctor->Inst->Static")) {
                if (ctr) {
                    if (JavaCodingStandardChecker.sCurrentState.mHasHandledInsMethodDeclaration || JavaCodingStandardChecker.sCurrentState.mHasHandledStatMethodDeclaration) {
                        JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "construtor  declaration is in the wrong order. Order: constructor->instance->static");
                    }
                } else if (!sta && JavaCodingStandardChecker.sCurrentState.mHasHandledStatMethodDeclaration) {
                    JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "instance method declaration is in the wrong order. Order: constructor->instance->static");
                }
            } else if (rule.getValue().equals("Pub->Pro->Pac->Pri")) {
                if (pub) {
                    if (JavaCodingStandardChecker.sCurrentState.mHasHandledProMethodDeclararion || JavaCodingStandardChecker.sCurrentState.mHasHandledPacMethodDeclararion || JavaCodingStandardChecker.sCurrentState.mHasHandledPriMethodDeclararion) {
                        JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "public method declaration is in the wrong order. Order: Pub->Pro->Pac->Pri");
                    }
                } else if (pro) {
                    if (JavaCodingStandardChecker.sCurrentState.mHasHandledPacMethodDeclararion || JavaCodingStandardChecker.sCurrentState.mHasHandledPriMethodDeclararion) {
                        JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "protected method declaration is in the wrong order. Order: Pub->Pro->Pac->Pri");
                    }
                } else if (pac && JavaCodingStandardChecker.sCurrentState.mHasHandledPriMethodDeclararion) {
                    JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "package method declaration is in the wrong order. Order: Pub->Pro->Pac->Pri");
                }
            } else if (rule.getValue().equals("Pri->Pac->Pro->Pub")) {
                if (pri) {
                    if (JavaCodingStandardChecker.sCurrentState.mHasHandledPubMethodDeclararion || JavaCodingStandardChecker.sCurrentState.mHasHandledProMethodDeclararion || JavaCodingStandardChecker.sCurrentState.mHasHandledPacMethodDeclararion) {
                        JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "private method declaration is in the wrong order. Order: Pri->Pac->Pro->Pub");
                    }
                } else if (pac) {
                    if (JavaCodingStandardChecker.sCurrentState.mHasHandledPubMethodDeclararion || JavaCodingStandardChecker.sCurrentState.mHasHandledProMethodDeclararion) {
                        JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "package method declaration is in the wrong order. Order: Pri->Pac->Pro->Pub");
                    }
                } else if (pro && JavaCodingStandardChecker.sCurrentState.mHasHandledPubMethodDeclararion) {
                    JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "protected method declaration is in the wrong order. Order: Pri->Pac->Pro->Pub");
                }
            } else if (rule.getValue().equals("No Order")) {
                // empty if block
            }
        }
        if (fin && sta) {
            if (pub) {
                rule = (Rule)sRulesMap.get("FCMetPubRegExp");
            } else if (pro) {
                rule = (Rule)sRulesMap.get("FCMetProRegExp");
            } else if (pac) {
                rule = (Rule)sRulesMap.get("FCMetPacRegExp");
            } else if (pri) {
                rule = (Rule)sRulesMap.get("FCMetPriRegExp");
            }
        } else if (fin) {
            if (pub) {
                rule = (Rule)sRulesMap.get("FMetPubRegExp");
            } else if (pro) {
                rule = (Rule)sRulesMap.get("FMetProRegExp");
            } else if (pac) {
                rule = (Rule)sRulesMap.get("FMetPacRegExp");
            } else if (pri) {
                rule = (Rule)sRulesMap.get("FMetPriRegExp");
            }
        } else if (sta) {
            if (pub) {
                rule = (Rule)sRulesMap.get("CMetPubRegExp");
            } else if (pro) {
                rule = (Rule)sRulesMap.get("CMetProRegExp");
            } else if (pac) {
                rule = (Rule)sRulesMap.get("CMetPacRegExp");
            } else if (pri) {
                rule = (Rule)sRulesMap.get("CMetPriRegExp");
            }
        } else if (pub) {
            rule = (Rule)sRulesMap.get("IMetPubRegExp");
        } else if (pro) {
            rule = (Rule)sRulesMap.get("FMetProRegExp");
        } else if (pac) {
            rule = (Rule)sRulesMap.get("FMetProRegExp");
        } else if (pri) {
            rule = (Rule)sRulesMap.get("FMetProRegExp");
        }
        if (rule.isEnabled() && !ctr && !JavaCodingStandardChecker.isRegexpMatch(rule.getValue(), name)) {
            JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "method declaration '" + name + "' must match" + " the following regexp '" + rule.getValue() + "'");
        }
        if (pub) {
            JavaCodingStandardChecker.sCurrentState.mHasHandledPubMethodDeclararion = true;
        } else if (pro) {
            JavaCodingStandardChecker.sCurrentState.mHasHandledProMethodDeclararion = true;
        } else if (pac) {
            JavaCodingStandardChecker.sCurrentState.mHasHandledPacMethodDeclararion = true;
        } else if (pri) {
            JavaCodingStandardChecker.sCurrentState.mHasHandledPriMethodDeclararion = true;
        } else if (sta) {
            JavaCodingStandardChecker.sCurrentState.mHasHandledStatMethodDeclaration = true;
        }
        if (!sta && !ctr) {
            JavaCodingStandardChecker.sCurrentState.mHasHandledInsMethodDeclaration = true;
        }
    }

    public static void handleParaRegExp(StringBuffer pAccess, StringBuffer pName, int pLine, int pColumn) {
        Rule rule;
        String access = pAccess.toString();
        String name = pName.toString();
        Object pre = null;
        boolean index = false;
        boolean fin = false;
        StringTokenizer st = new StringTokenizer(access);
        while (st.hasMoreElements()) {
            String tkn = st.nextToken();
            if (!tkn.equals("final")) continue;
            fin = true;
        }
        if (fin) {
            rule = (Rule)sRulesMap.get("FinParaRegExp");
            if (rule.isEnabled() && !JavaCodingStandardChecker.isRegexpMatch(rule.getValue(), name)) {
                JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "parameter declaration '" + name + "' must match" + " the following regexp '" + rule.getValue());
            }
        } else {
            rule = (Rule)sRulesMap.get("ParaRegExp");
            if (rule.isEnabled() && !JavaCodingStandardChecker.isRegexpMatch(rule.getValue(), name)) {
                JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "parameter declaration '" + name + "' must match" + " the following regexp '" + rule.getValue());
            }
        }
    }

    public static void overviewClassResults() {
        Rule rule = (Rule)sRulesMap.get("FieldBlockPlaceRule");
        if (rule.isEnabled()) {
            if ((JavaCodingStandardChecker.sCurrentState.mFieldBlockPlace & 1) == 1 && (JavaCodingStandardChecker.sCurrentState.mFieldBlockPlace & 2) == 2) {
                if (rule.getValue().equals("Field Block Before Method Block")) {
                    JavaCodingStandardChecker.addViolation(rule, -1, -1, "fields in class '" + JavaCodingStandardChecker.sCurrentState.mName + "' must not be declared before and" + " after the method definitions, you have" + " to place them before the method" + " definitions");
                }
                if (rule.getValue().equals("Field Block After Method Block")) {
                    JavaCodingStandardChecker.addViolation(rule, -1, -1, "fields in class '" + JavaCodingStandardChecker.sCurrentState.mName + "' must not be declared before and" + " after the method definitions, you have" + " to place them after the method" + " definitions");
                }
            } else if ((JavaCodingStandardChecker.sCurrentState.mFieldBlockPlace & 1) == 1) {
                if (rule.getValue().equals("Field Block After Method Block")) {
                    JavaCodingStandardChecker.addViolation(rule, -1, -1, "fields in class '" + JavaCodingStandardChecker.sCurrentState.mName + "' must not be declared before" + " the method definitions, you have" + " to place them after the method" + " definitions");
                }
            } else if ((JavaCodingStandardChecker.sCurrentState.mFieldBlockPlace & 2) == 2 && rule.getValue().equals("Field Block Before Method Block")) {
                JavaCodingStandardChecker.addViolation(rule, -1, -1, "fields in class '" + JavaCodingStandardChecker.sCurrentState.mName + "' must not be declared after" + " the method definitions, you have" + " to place them before the method" + " definitions");
            }
        }
        if ((rule = (Rule)sRulesMap.get("NestedTypeBlockPlaceRule")).isEnabled()) {
            if (rule.getValue().equals("Beginning of Class")) {
                if ((JavaCodingStandardChecker.sCurrentState.mNestedTypeBlockPlace & 4) == 4) {
                    JavaCodingStandardChecker.addViolation(rule, -1, -1, "nested type in class '" + JavaCodingStandardChecker.sCurrentState.mName + "' must not be declared between fields and methods" + " , you have to place them at the beginning of the class");
                }
            } else if (rule.getValue().equals("End of Class")) {
                if ((JavaCodingStandardChecker.sCurrentState.mNestedTypeBlockPlace & 1) == 1) {
                    JavaCodingStandardChecker.addViolation(rule, -1, -1, "nested type in class '" + JavaCodingStandardChecker.sCurrentState.mName + "' must not be declared at the beginning of the class" + " , you have to place them at the end of the class");
                } else if ((JavaCodingStandardChecker.sCurrentState.mNestedTypeBlockPlace & 4) == 4) {
                    JavaCodingStandardChecker.addViolation(rule, -1, -1, "nested type in class '" + JavaCodingStandardChecker.sCurrentState.mName + "' must not be declared between fields and methods" + " , you have to place them at the end of the class");
                }
            }
        }
    }

    public static void incrementSpace() {
        ++sSpaceCount;
    }

    public static void resetSpaceCount() {
        sSpaceCount = 0;
    }

    public static void resetNewLine() {
        sNewLine = false;
    }

    public static void setNewLine() {
        sNewLine = true;
    }

    public static void incrementLineCount(int pCount) {
        sLineCount += pCount;
    }

    public static void resetLineCount() {
        sLineCount = 0;
    }

    public static void setLastJavaDoc(String doc) {
        sLastJavaDoc = doc;
    }

    public static void appendComment(String comment) {
        sLastComment.append(comment);
    }

    public static void handleSpaceAfterStatementKeyword(String pKind, int pLine, int pColumn) {
        Rule rule = (Rule)sRulesMap.get("SpaceAfterStatementKeyword");
        if (rule.isEnabled()) {
            if (rule.getValue().equals("true")) {
                if (sSpaceCount == 0) {
                    JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "A space after statement keyword '" + pKind + "' is mandatory");
                }
            } else if (rule.getValue().equals("false") && sSpaceCount != 0) {
                JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "A space after statement keyword '" + pKind + "' is not allowed");
            }
        }
    }

    public static void handleSpaceAfterMethodName(String pName, int pLine, int pColumn) {
        Rule rule = (Rule)sRulesMap.get("SpaceAfterMethodName");
        if (rule.isEnabled()) {
            if (sSpaceCount == 0) {
                JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "A space after method '" + pName + "' is mandatory");
            }
        } else if (sSpaceCount != 0) {
            JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "A space after method '" + pName + "' is not allowed");
        }
    }

    public static void handleSpaceAroundBinaryExpression(String pPlace, String pKind, int pLine, int pColumn) {
    }

    public static void handleStringLiteral(String pLiteral, int pLine, int pColumn) {
        Rule ruleString = (Rule)sRulesMap.get("StringLiteralAllowed");
        Rule ruleEmpty = (Rule)sRulesMap.get("EmptyStringLiteralAllowed");
        if (ruleString.isEnabled() && !Boolean.valueOf(ruleString.getValue()).booleanValue()) {
            if (ruleEmpty.isEnabled() && Boolean.valueOf(ruleEmpty.getValue()).booleanValue()) {
                if (!pLiteral.equals("\"\"")) {
                    JavaCodingStandardChecker.addViolation(ruleEmpty, pLine, pColumn, "String literal " + pLiteral + " is not allowed" + " \"\" is the only allowed string literal");
                }
            } else {
                JavaCodingStandardChecker.addViolation(ruleString, pLine, pColumn, "String literal " + pLiteral + " is not allowed");
            }
        }
    }

    public static void handleComplexLoopExpression(StringBuffer pExpression, int pLine, int pColumn) {
        Rule rule = (Rule)sRulesMap.get("AllowedComplexLoopExpression");
        String expression = pExpression.toString();
        if (rule.isEnabled() && expression.indexOf("(") >= 0) {
            int index = expression.lastIndexOf(".");
            String expr = expression.substring(index + 1, expression.length() - 2);
            if (!JavaCodingStandardChecker.isRegexpMatch(rule.getValue(), expr)) {
                JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "'" + expr + "' - this complex loop" + " expression is not allowed");
            }
        }
    }

    public static void handleConditionalExpression(int pLine, int pColumn) {
        Rule rule = (Rule)sRulesMap.get("ConditionalExpression");
        if (rule.isEnabled() && !Boolean.valueOf(rule.getValue()).booleanValue()) {
            JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "conditional expression (?:) are not allowed");
        }
    }

    public static void handleTypeDeclarationJavaDoc(String pDoc, StringBuffer pAccess, String pType, int pLine, int pColumn) {
        Rule ruleAuthor = (Rule)sRulesMap.get("TypeDeclarationAuthor");
        Rule ruleVersion = (Rule)sRulesMap.get("TypeDeclarationVersion");
        JavaDocParser jdp = null;
        if (ruleAuthor.isEnabled() || ruleVersion.isEnabled()) {
            jdp = new JavaDocParser(pDoc);
            if (ruleAuthor.isEnabled()) {
                if (!jdp.hasAuthorTags()) {
                    JavaCodingStandardChecker.addViolation(ruleAuthor, pLine, pColumn, pType + " Declaration JavaDoc does not provide the" + " required '@author' tag");
                } else {
                    sAuthors.addAll(jdp.getAuthorTags());
                }
            }
            if (ruleVersion.isEnabled() && !jdp.hasAuthorTags()) {
                JavaCodingStandardChecker.addViolation(ruleVersion, pLine, pColumn, pType + " Declaration JavaDoc does not provide the" + " required '@version' tag");
            }
        }
        if (jdp != null) {
            JavaCodingStandardChecker.handleJavaDocTagOrder(jdp, pLine, pColumn);
        }
    }

    private static boolean isJavaDocRequired(boolean pType, StringBuffer pAccess, boolean pPub, boolean pPro, boolean pPac, boolean pPri) {
        if (pType) {
            boolean pub = false;
            boolean pro = false;
            boolean pac = false;
            boolean pri = false;
            String vis = JavaCodingStandardChecker.getVisibility(pAccess.toString());
            if (vis.equals("public")) {
                pub = true;
            }
            if (vis.equals("protected")) {
                pro = true;
            }
            if (vis.equals("package")) {
                pac = true;
            }
            if (vis.equals("private")) {
                pri = true;
            }
            if (pPub & pub) {
                return true;
            }
            if (pPro & pro) {
                return true;
            }
            if (pPac & pac) {
                return true;
            }
            if (pPri & pri) {
                return true;
            }
        }
        return false;
    }

    private static String getVisibility(String access) {
        StringTokenizer st = new StringTokenizer(access);
        while (st.hasMoreElements()) {
            String tkn = st.nextToken();
            if (tkn.equals("public")) {
                return "public";
            }
            if (tkn.equals("protected")) {
                return "protected";
            }
            if (!tkn.equals("private")) continue;
            return "private";
        }
        return "package";
    }

    public static void handleConstructorDeclarationJavaDoc(String pDoc, StringBuffer pAccess, int pParaCount, ArrayList pExcpts, int pLine, int pColumn) {
        Rule ruleParam = (Rule)sRulesMap.get("CtorDeclarationParam");
        Rule ruleThrows = (Rule)sRulesMap.get("CtorDeclarationThrows");
        Rule rulePub = (Rule)sRulesMap.get("CtorJavaDocPublic");
        Rule rulePro = (Rule)sRulesMap.get("CtorJavaDocProtected");
        Rule rulePac = (Rule)sRulesMap.get("CtorJavaDocPackage");
        Rule rulePri = (Rule)sRulesMap.get("CtorJavaDocPrivate");
        JavaDocParser jdp = null;
        if (ruleParam.isEnabled() || ruleThrows.isEnabled()) {
            jdp = new JavaDocParser(pDoc);
            if (JavaCodingStandardChecker.isJavaDocRequired(ruleParam.isEnabled(), pAccess, rulePub.isEnabled() && Boolean.valueOf(rulePub.getValue()) != false, rulePro.isEnabled() && Boolean.valueOf(rulePro.getValue()) != false, rulePac.isEnabled() && Boolean.valueOf(rulePac.getValue()) != false, rulePri.isEnabled() && Boolean.valueOf(rulePri.getValue()) != false)) {
                if (!jdp.isJavaDoc()) {
                    Rule tmpRule = rulePac;
                    String access = pAccess.toString().trim();
                    if (access.equals("public")) {
                        tmpRule = rulePub;
                    } else if (access.equals("protected")) {
                        tmpRule = rulePro;
                    } else if (access.equals("private")) {
                        tmpRule = rulePri;
                    }
                    JavaCodingStandardChecker.addViolation(tmpRule, pLine, pColumn, access + " constructor declaration does not provide any" + " JavaDoc");
                }
                if (pParaCount > jdp.getParamTags().size()) {
                    JavaCodingStandardChecker.addViolation(ruleParam, pLine, pColumn, pAccess + "constructor declaration JavaDoc does not provide the" + " required '@param' tag for all parameters");
                } else if (pParaCount < jdp.getParamTags().size()) {
                    JavaCodingStandardChecker.addViolation(ruleParam, pLine, pColumn, pAccess + "constructor declaration JavaDoc has more" + " '@param' tags as parameters existing");
                }
            }
            if (JavaCodingStandardChecker.isJavaDocRequired(ruleThrows.isEnabled(), pAccess, rulePub.isEnabled() && Boolean.valueOf(rulePub.getValue()) != false, rulePro.isEnabled() && Boolean.valueOf(rulePro.getValue()) != false, rulePac.isEnabled() && Boolean.valueOf(rulePac.getValue()) != false, rulePri.isEnabled() && Boolean.valueOf(rulePri.getValue()) != false) && pExcpts.size() > jdp.getThrowsTags().size()) {
                JavaCodingStandardChecker.addViolation(ruleThrows, pLine, pColumn, pAccess + "constructor declaration JavaDoc does not provide the" + " required '@throws' tag");
            }
        }
        if (jdp != null) {
            JavaCodingStandardChecker.handleJavaDocTagOrder(jdp, pLine, pColumn);
        }
    }

    public static void handleMethodDeclarationJavaDoc(String pDoc, StringBuffer pAccess, StringBuffer pReturn, int pParaCount, ArrayList pExcpts, int pLine, int pColumn) {
        Rule ruleParam = (Rule)sRulesMap.get("MethodDeclarationParam");
        Rule ruleThrows = (Rule)sRulesMap.get("MethodDeclarationThrows");
        Rule ruleReturn = (Rule)sRulesMap.get("MethodDeclarationReturn");
        Rule ruleVoid = (Rule)sRulesMap.get("MethodVoidNoReturn");
        Rule ruleAnonym = (Rule)sRulesMap.get("AnonymousClassMethodJavaDoc");
        Rule rulePub = (Rule)sRulesMap.get("MethodJavaDocPublic");
        Rule rulePro = (Rule)sRulesMap.get("MethodJavaDocProtected");
        Rule rulePac = (Rule)sRulesMap.get("MethodJavaDocPackage");
        Rule rulePri = (Rule)sRulesMap.get("MethodJavaDocPrivate");
        JavaDocParser jdp = null;
        boolean isRequired = false;
        if (JavaCodingStandardChecker.sCurrentState.isAnonymousClass && !ruleAnonym.getValue().equals("true")) {
            return;
        }
        if (ruleParam.isEnabled() || ruleThrows.isEnabled() || ruleReturn.isEnabled()) {
            jdp = new JavaDocParser(pDoc);
            if (JavaCodingStandardChecker.isJavaDocRequired(ruleParam.isEnabled(), pAccess, rulePub.isEnabled() && Boolean.valueOf(rulePub.getValue()) != false, rulePro.isEnabled() && Boolean.valueOf(rulePro.getValue()) != false, rulePac.isEnabled() && Boolean.valueOf(rulePac.getValue()) != false, rulePri.isEnabled() && Boolean.valueOf(rulePri.getValue()) != false)) {
                isRequired = true;
                if (pParaCount > jdp.getParamTags().size()) {
                    JavaCodingStandardChecker.addViolation(ruleParam, pLine, pColumn, pAccess + "method declaration JavaDoc does not provide the" + " required '@param' tag for all parameters");
                } else if (pParaCount < jdp.getParamTags().size()) {
                    JavaCodingStandardChecker.addViolation(ruleParam, pLine, pColumn, pAccess + "method declaration JavaDoc has more" + " '@param' tags as parameters existing");
                }
            }
            if (JavaCodingStandardChecker.isJavaDocRequired(ruleThrows.isEnabled(), pAccess, rulePub.isEnabled() && Boolean.valueOf(rulePub.getValue()) != false, rulePro.isEnabled() && Boolean.valueOf(rulePro.getValue()) != false, rulePac.isEnabled() && Boolean.valueOf(rulePac.getValue()) != false, rulePri.isEnabled() && Boolean.valueOf(rulePri.getValue()) != false)) {
                isRequired = true;
                if (pExcpts.size() > jdp.getThrowsTags().size()) {
                    JavaCodingStandardChecker.addViolation(ruleThrows, pLine, pColumn, pAccess + "method declaration JavaDoc does not provide the" + " required '@throws' tag");
                }
            }
            if (JavaCodingStandardChecker.isJavaDocRequired(ruleReturn.isEnabled(), pAccess, rulePub.isEnabled() && Boolean.valueOf(rulePub.getValue()) != false, rulePro.isEnabled() && Boolean.valueOf(rulePro.getValue()) != false, rulePac.isEnabled() && Boolean.valueOf(rulePac.getValue()) != false, rulePri.isEnabled() && Boolean.valueOf(rulePri.getValue()) != false)) {
                isRequired = true;
                if ("void".equals(pReturn.toString())) {
                    if (jdp.hasReturnTags() && ruleVoid.isEnabled() && Boolean.valueOf(ruleVoid.getValue()).booleanValue()) {
                        JavaCodingStandardChecker.addViolation(ruleVoid, pLine, pColumn, "'void' return must not have a '@return' JavaDoc tag");
                    }
                } else if (!jdp.hasReturnTags()) {
                    JavaCodingStandardChecker.addViolation(ruleReturn, pLine, pColumn, pAccess + "method declaration JavaDoc does not provide the" + " required '@return' tag");
                }
            }
            if (isRequired && !jdp.isJavaDoc()) {
                Rule rule = null;
                String vis = JavaCodingStandardChecker.getVisibility(pAccess.toString());
                rule = vis.equals("public") ? rulePub : (vis.equals("protected") ? rulePro : (vis.equals("private") ? rulePri : rulePac));
                JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, pAccess + "method doesn't provide any JavaDoc");
                return;
            }
        }
        if (jdp != null) {
            JavaCodingStandardChecker.handleJavaDocTagOrder(jdp, pLine, pColumn);
        }
    }

    public static void handleFieldDeclarationJavaDoc(String pDoc, StringBuffer pAccess, int pLine, int pColumn) {
        Rule rulePub = (Rule)sRulesMap.get("FieldJavaDocPublic");
        Rule rulePro = (Rule)sRulesMap.get("FieldJavaDocProtected");
        Rule rulePac = (Rule)sRulesMap.get("FieldJavaDocPackage");
        Rule rulePri = (Rule)sRulesMap.get("FieldJavaDocPrivate");
        JavaDocParser jdp = null;
        if (JavaCodingStandardChecker.isJavaDocRequired(true, pAccess, rulePub.isEnabled() && Boolean.valueOf(rulePub.getValue()) != false, rulePro.isEnabled() && Boolean.valueOf(rulePro.getValue()) != false, rulePac.isEnabled() && Boolean.valueOf(rulePac.getValue()) != false, rulePri.isEnabled() && Boolean.valueOf(rulePri.getValue()) != false)) {
            jdp = new JavaDocParser(pDoc);
            Rule rule = null;
            String vis = JavaCodingStandardChecker.getVisibility(pAccess.toString());
            if (vis.equals("public")) {
                rule = rulePub;
            }
            if (vis.equals("protected")) {
                rule = rulePro;
            }
            if (vis.equals("package")) {
                rule = rulePac;
            }
            if (vis.equals("private")) {
                rule = rulePri;
            }
            if (!jdp.isJavaDoc()) {
                JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, pAccess + "field declaration does not have a JavaDoc");
            }
        }
    }

    public static void handleJavaDocTagOrder(JavaDocParser pJdp, int pLine, int pColumn) {
        Rule rule = (Rule)sRulesMap.get("JavaDocTagOrder");
        if (rule.isEnabled() && !pJdp.isOrderCorrect()) {
            JavaCodingStandardChecker.addViolation(rule, pLine, pColumn, "JavaDocs Tags are in wrong order. Order: [@author]->[@version]->[@param]->[@return]->[@throws]->[@see]->[@since]->[@serial]->[@deprecated]");
        }
    }

    public final void CompilationUnit() throws ParseException {
        sCurrentState = new CurrentState();
        JavaCodingStandardChecker.sCurrentState.mName = sClassName;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 45: {
                this.PackageDeclaration();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                break;
            }
        }
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 37: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block9;
                }
            }
            this.ImportDeclaration();
        }
        JavaCodingStandardChecker.handleTypeHeaderExpression(sLastComment, this.token.beginLine, this.token.beginColumn);
        sLastComment = new StringBuffer();
        block10: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 14: 
                case 21: 
                case 30: 
                case 40: 
                case 48: 
                case 64: 
                case 83: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block10;
                }
            }
            this.TypeDeclaration();
        }
        this.jj_consume_token(0);
    }

    public final void PackageDeclaration() throws ParseException {
        StringBuffer name = null;
        this.jj_consume_token(45);
        name = this.Name();
        this.jj_consume_token(83);
        JavaCodingStandardChecker.handlePackageNameRegExp(name, this.token.beginLine, this.token.beginColumn);
        sPackage = name.toString();
        ++sNCSSCount;
    }

    public final void ImportDeclaration() throws ParseException {
        StringBuffer name = null;
        this.jj_consume_token(37);
        name = this.Name();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 85: {
                this.jj_consume_token(85);
                this.jj_consume_token(103);
                name.append(".*");
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        this.jj_consume_token(83);
        JavaCodingStandardChecker.handleImportDeclaration(name, this.token.beginLine, this.token.beginColumn);
        ++sNCSSCount;
    }

    public final String TypeDeclaration() throws ParseException {
        String name = "";
        if (this.jj_2_1(Integer.MAX_VALUE)) {
            name = this.ClassDeclaration();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 14: 
                case 40: 
                case 48: 
                case 64: {
                    name = this.InterfaceDeclaration();
                    break;
                }
                case 83: {
                    this.jj_consume_token(83);
                    JavaCodingStandardChecker.handleSemicolonAfterTypeDeclaration(this.token.beginLine, this.token.beginColumn);
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return name;
    }

    public final String ClassDeclaration() throws ParseException {
        String name;
        StringBuffer access;
        block10: {
            access = new StringBuffer("");
            name = "";
            block9: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 14: 
                    case 30: 
                    case 48: 
                    case 64: {
                        break;
                    }
                    default: {
                        this.jj_la1[5] = this.jj_gen;
                        break block10;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 14: {
                        this.jj_consume_token(14);
                        access.append("abstract ");
                        continue block9;
                    }
                    case 30: {
                        this.jj_consume_token(30);
                        access.append("final ");
                        continue block9;
                    }
                    case 48: {
                        this.jj_consume_token(48);
                        access.append("public ");
                        continue block9;
                    }
                    case 64: {
                        this.jj_consume_token(64);
                        access.append("strictfp ");
                        continue block9;
                    }
                }
                break;
            }
            this.jj_la1[6] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        JavaCodingStandardChecker.handleTypeDeclarationJavaDoc(sLastJavaDoc, access, "class", this.token.beginLine, this.token.beginColumn);
        sLastJavaDoc = "";
        JavaCodingStandardChecker.handleTypeModifierOrder(access, "class", this.token.beginLine, this.token.beginColumn);
        name = this.UnmodifiedClassDeclaration(access);
        return name;
    }

    public final String UnmodifiedClassDeclaration(StringBuffer pAccess) throws ParseException {
        StringBuffer superClassName = new StringBuffer();
        sSavedStates.push(sCurrentState);
        sCurrentState = new CurrentState();
        this.jj_consume_token(21);
        this.jj_consume_token(74);
        StringBuffer name = new StringBuffer(this.token.image);
        JavaCodingStandardChecker.sCurrentState.mName = name.toString();
        if (pAccess.toString().lastIndexOf("abstract") != -1) {
            JavaCodingStandardChecker.sCurrentState.isAbstractClass = true;
            JavaCodingStandardChecker.handleAbstractClassDeclaration(name, this.token.beginLine, this.token.beginColumn);
        } else {
            JavaCodingStandardChecker.sCurrentState.isClass = true;
            JavaCodingStandardChecker.handleTypeDeclaration(name, this.token.beginLine, this.token.beginColumn);
        }
        JavaCodingStandardChecker.resetNewLine();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 28: {
                JavaCodingStandardChecker.resetNewLine();
                this.jj_consume_token(28);
                superClassName = this.Name();
                JavaCodingStandardChecker.handleUnitTestClass(superClassName, this.token.beginLine, this.token.beginColumn);
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 36: {
                JavaCodingStandardChecker.resetNewLine();
                this.jj_consume_token(36);
                this.NameList();
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
            }
        }
        this.ClassBody();
        JavaCodingStandardChecker.overviewClassResults();
        sCurrentState = (CurrentState)sSavedStates.pop();
        ++sNCSSCount;
        return name.toString();
    }

    public final void ClassBody() throws ParseException {
        this.jj_consume_token(79);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 14: 
                case 15: 
                case 17: 
                case 20: 
                case 21: 
                case 26: 
                case 30: 
                case 32: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 46: 
                case 47: 
                case 48: 
                case 50: 
                case 51: 
                case 54: 
                case 58: 
                case 61: 
                case 62: 
                case 64: 
                case 74: 
                case 79: 
                case 83: {
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                    break block3;
                }
            }
            this.ClassBodyDeclaration();
        }
        this.jj_consume_token(80);
    }

    public final void NestedClassDeclaration() throws ParseException {
        StringBuffer access;
        block13: {
            access = new StringBuffer("");
            JavaCodingStandardChecker.handleNestedTypePlaceRule(NESTEDCLASSDECLARATION, this.token.beginLine, this.token.beginColumn);
            block12: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 14: 
                    case 30: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 51: 
                    case 64: {
                        break;
                    }
                    default: {
                        this.jj_la1[10] = this.jj_gen;
                        break block13;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 51: {
                        this.jj_consume_token(51);
                        access.append("static ");
                        continue block12;
                    }
                    case 14: {
                        this.jj_consume_token(14);
                        access.append("abstract ");
                        continue block12;
                    }
                    case 30: {
                        this.jj_consume_token(30);
                        access.append("final ");
                        continue block12;
                    }
                    case 48: {
                        this.jj_consume_token(48);
                        access.append("public ");
                        continue block12;
                    }
                    case 47: {
                        this.jj_consume_token(47);
                        access.append("protected ");
                        continue block12;
                    }
                    case 46: {
                        this.jj_consume_token(46);
                        access.append("private ");
                        continue block12;
                    }
                    case 64: {
                        this.jj_consume_token(64);
                        access.append("strictfp ");
                        continue block12;
                    }
                }
                break;
            }
            this.jj_la1[11] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        JavaCodingStandardChecker.handleNestedTypeModifierOrder(access, this.token.beginLine, this.token.beginColumn);
        this.UnmodifiedClassDeclaration(access);
        JavaCodingStandardChecker.sCurrentState.mHasHandledNestedTypeDeclaration = true;
    }

    public final void ClassBodyDeclaration() throws ParseException {
        if (this.jj_2_2(2)) {
            this.Initializer();
        } else if (this.jj_2_3(Integer.MAX_VALUE)) {
            this.NestedClassDeclaration();
        } else if (this.jj_2_4(Integer.MAX_VALUE)) {
            this.NestedInterfaceDeclaration();
        } else if (this.jj_2_5(Integer.MAX_VALUE)) {
            this.ConstructorDeclaration();
        } else if (this.jj_2_6(Integer.MAX_VALUE)) {
            this.MethodDeclaration();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 15: 
                case 17: 
                case 20: 
                case 26: 
                case 30: 
                case 32: 
                case 39: 
                case 41: 
                case 46: 
                case 47: 
                case 48: 
                case 50: 
                case 51: 
                case 58: 
                case 62: 
                case 74: {
                    this.FieldDeclaration();
                    break;
                }
                case 83: {
                    this.jj_consume_token(83);
                    break;
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final void MethodDeclarationLookahead() throws ParseException {
        block15: {
            block14: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 14: 
                    case 30: 
                    case 42: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 51: 
                    case 54: 
                    case 64: {
                        break;
                    }
                    default: {
                        this.jj_la1[13] = this.jj_gen;
                        break block15;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 48: {
                        this.jj_consume_token(48);
                        continue block14;
                    }
                    case 47: {
                        this.jj_consume_token(47);
                        continue block14;
                    }
                    case 46: {
                        this.jj_consume_token(46);
                        continue block14;
                    }
                    case 51: {
                        this.jj_consume_token(51);
                        continue block14;
                    }
                    case 14: {
                        this.jj_consume_token(14);
                        continue block14;
                    }
                    case 30: {
                        this.jj_consume_token(30);
                        continue block14;
                    }
                    case 42: {
                        this.jj_consume_token(42);
                        continue block14;
                    }
                    case 54: {
                        this.jj_consume_token(54);
                        continue block14;
                    }
                    case 64: {
                        this.jj_consume_token(64);
                        continue block14;
                    }
                }
                break;
            }
            this.jj_la1[14] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.ResultType();
        this.jj_consume_token(74);
        this.jj_consume_token(77);
    }

    public final String InterfaceDeclaration() throws ParseException {
        String name;
        StringBuffer access;
        block9: {
            access = new StringBuffer("");
            name = "";
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 14: 
                    case 48: 
                    case 64: {
                        break;
                    }
                    default: {
                        this.jj_la1[15] = this.jj_gen;
                        break block9;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 14: {
                        this.jj_consume_token(14);
                        access.append("abstract ");
                        continue block8;
                    }
                    case 48: {
                        this.jj_consume_token(48);
                        access.append("public ");
                        continue block8;
                    }
                    case 64: {
                        this.jj_consume_token(64);
                        access.append("strictfp ");
                        continue block8;
                    }
                }
                break;
            }
            this.jj_la1[16] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        JavaCodingStandardChecker.handleTypeDeclarationJavaDoc(sLastJavaDoc, access, "interface", this.token.beginLine, this.token.beginColumn);
        sLastJavaDoc = "";
        JavaCodingStandardChecker.handleTypeModifierOrder(access, "interface", this.token.beginLine, this.token.beginColumn);
        name = this.UnmodifiedInterfaceDeclaration(access);
        return name;
    }

    public final void NestedInterfaceDeclaration() throws ParseException {
        StringBuffer access;
        block13: {
            access = new StringBuffer("");
            JavaCodingStandardChecker.handleNestedTypePlaceRule(NESTEDINTERFACEDECLARATION, this.token.beginLine, this.token.beginColumn);
            block12: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 14: 
                    case 30: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 51: 
                    case 64: {
                        break;
                    }
                    default: {
                        this.jj_la1[17] = this.jj_gen;
                        break block13;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 51: {
                        this.jj_consume_token(51);
                        access.append("static ");
                        continue block12;
                    }
                    case 14: {
                        this.jj_consume_token(14);
                        access.append("abstract ");
                        continue block12;
                    }
                    case 30: {
                        this.jj_consume_token(30);
                        access.append("final ");
                        continue block12;
                    }
                    case 48: {
                        this.jj_consume_token(48);
                        access.append("public ");
                        continue block12;
                    }
                    case 47: {
                        this.jj_consume_token(47);
                        access.append("protected ");
                        continue block12;
                    }
                    case 46: {
                        this.jj_consume_token(46);
                        access.append("private ");
                        continue block12;
                    }
                    case 64: {
                        this.jj_consume_token(64);
                        access.append("strictfp ");
                        continue block12;
                    }
                }
                break;
            }
            this.jj_la1[18] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        JavaCodingStandardChecker.handleNestedTypeModifierOrder(access, this.token.beginLine, this.token.beginColumn);
        this.UnmodifiedInterfaceDeclaration(access);
        JavaCodingStandardChecker.sCurrentState.mHasHandledNestedTypeDeclaration = true;
    }

    public final String UnmodifiedInterfaceDeclaration(StringBuffer pAccess) throws ParseException {
        sSavedStates.push(sCurrentState);
        sCurrentState = new CurrentState();
        this.jj_consume_token(40);
        this.jj_consume_token(74);
        StringBuffer name = new StringBuffer(this.token.image);
        JavaCodingStandardChecker.sCurrentState.mName = name.toString();
        JavaCodingStandardChecker.sCurrentState.isInterface = true;
        JavaCodingStandardChecker.handleInterfaceCheckAbstract(name, pAccess, this.token.beginLine, this.token.beginColumn);
        JavaCodingStandardChecker.handleAbstractClassNameRegExp(name, pAccess, this.token.beginLine, this.token.beginColumn);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 28: {
                this.jj_consume_token(28);
                this.NameList();
                break;
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
            }
        }
        this.jj_consume_token(79);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 14: 
                case 15: 
                case 17: 
                case 20: 
                case 21: 
                case 26: 
                case 30: 
                case 32: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 46: 
                case 47: 
                case 48: 
                case 50: 
                case 51: 
                case 54: 
                case 58: 
                case 61: 
                case 62: 
                case 64: 
                case 74: 
                case 83: {
                    break;
                }
                default: {
                    this.jj_la1[20] = this.jj_gen;
                    break block6;
                }
            }
            this.InterfaceMemberDeclaration();
        }
        this.jj_consume_token(80);
        JavaCodingStandardChecker.overviewClassResults();
        sCurrentState = (CurrentState)sSavedStates.pop();
        ++sNCSSCount;
        return name.toString();
    }

    public final void InterfaceMemberDeclaration() throws ParseException {
        Object access = null;
        if (this.jj_2_7(Integer.MAX_VALUE)) {
            this.NestedClassDeclaration();
        } else if (this.jj_2_8(Integer.MAX_VALUE)) {
            this.NestedInterfaceDeclaration();
        } else if (this.jj_2_9(Integer.MAX_VALUE)) {
            this.MethodDeclaration();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 15: 
                case 17: 
                case 20: 
                case 26: 
                case 30: 
                case 32: 
                case 39: 
                case 41: 
                case 46: 
                case 47: 
                case 48: 
                case 50: 
                case 51: 
                case 58: 
                case 62: 
                case 74: {
                    this.FieldDeclaration();
                    break;
                }
                case 83: {
                    this.jj_consume_token(83);
                    break;
                }
                default: {
                    this.jj_la1[21] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final void FieldDeclaration() throws ParseException {
        StringBuffer name;
        StringBuffer access;
        block17: {
            access = new StringBuffer("");
            name = null;
            JavaCodingStandardChecker.handleFieldDeclarationPlaceRule(this.token.beginLine, this.token.beginColumn);
            JavaCodingStandardChecker.handleNestedTypePlaceRule(FIELDDECLARATION, this.token.beginLine, this.token.beginColumn);
            block15: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 30: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 51: 
                    case 58: 
                    case 62: {
                        break;
                    }
                    default: {
                        this.jj_la1[22] = this.jj_gen;
                        break block17;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 48: {
                        this.jj_consume_token(48);
                        access.append("public ");
                        continue block15;
                    }
                    case 47: {
                        this.jj_consume_token(47);
                        access.append("protected ");
                        continue block15;
                    }
                    case 46: {
                        this.jj_consume_token(46);
                        access.append("private ");
                        continue block15;
                    }
                    case 51: {
                        this.jj_consume_token(51);
                        access.append("static ");
                        continue block15;
                    }
                    case 30: {
                        this.jj_consume_token(30);
                        access.append("final ");
                        continue block15;
                    }
                    case 58: {
                        this.jj_consume_token(58);
                        access.append("transient ");
                        continue block15;
                    }
                    case 62: {
                        this.jj_consume_token(62);
                        access.append("volatile ");
                        continue block15;
                    }
                }
                break;
            }
            this.jj_la1[23] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        JavaCodingStandardChecker.handleFieldDeclarationJavaDoc(sLastJavaDoc, access, this.token.beginLine, this.token.beginColumn);
        sLastJavaDoc = "";
        JavaCodingStandardChecker.handleAllowedFieldVisibility(access, this.token.beginLine, this.token.beginColumn);
        JavaCodingStandardChecker.handleFieldDeclarationModifierOrder(access, this.token.beginLine, this.token.beginColumn);
        this.Type();
        JavaCodingStandardChecker.sCurrentState.mInFieldDeclaration = true;
        name = this.VariableDeclarator();
        JavaCodingStandardChecker.handleFieldDeclaration(access, name, this.token.beginLine, this.token.beginColumn);
        block16: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 84: {
                    break;
                }
                default: {
                    this.jj_la1[24] = this.jj_gen;
                    break block16;
                }
            }
            this.jj_consume_token(84);
            name = this.VariableDeclarator();
            JavaCodingStandardChecker.handleFieldDeclaration(access, name, this.token.beginLine, this.token.beginColumn);
            JavaCodingStandardChecker.handleOnlyOneVariableDeclarationPerLine(this.token.beginLine, this.token.beginColumn);
        }
        this.jj_consume_token(83);
        JavaCodingStandardChecker.sCurrentState.mHasHandledFieldDeclaration = true;
        JavaCodingStandardChecker.sCurrentState.mInFieldDeclaration = false;
        ++sNCSSCount;
    }

    public final StringBuffer VariableDeclarator() throws ParseException {
        StringBuffer name = this.VariableDeclaratorId();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 86: {
                this.jj_consume_token(86);
                this.VariableInitializer();
                break;
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
            }
        }
        return name;
    }

    public final StringBuffer VariableDeclaratorId() throws ParseException {
        this.jj_consume_token(74);
        StringBuffer name = new StringBuffer(this.token.image);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 81: {
                    break;
                }
                default: {
                    this.jj_la1[26] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(81);
            this.jj_consume_token(82);
            JavaCodingStandardChecker.handleArrayDeclaration(this.token.beginLine, this.token.beginColumn);
        }
        return name;
    }

    public final void VariableInitializer() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 79: {
                this.ArrayInitializer();
                break;
            }
            case 15: 
            case 17: 
            case 20: 
            case 26: 
            case 29: 
            case 32: 
            case 39: 
            case 41: 
            case 43: 
            case 44: 
            case 50: 
            case 52: 
            case 55: 
            case 59: 
            case 61: 
            case 66: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 77: 
            case 89: 
            case 90: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                this.Expression();
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void ArrayInitializer() throws ParseException {
        this.jj_consume_token(79);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: 
            case 17: 
            case 20: 
            case 26: 
            case 29: 
            case 32: 
            case 39: 
            case 41: 
            case 43: 
            case 44: 
            case 50: 
            case 52: 
            case 55: 
            case 59: 
            case 61: 
            case 66: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 77: 
            case 79: 
            case 89: 
            case 90: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                this.VariableInitializer();
                while (this.jj_2_10(2)) {
                    this.jj_consume_token(84);
                    this.VariableInitializer();
                }
                break;
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 84: {
                this.jj_consume_token(84);
                break;
            }
            default: {
                this.jj_la1[29] = this.jj_gen;
            }
        }
        this.jj_consume_token(80);
    }

    public final void MethodDeclaration() throws ParseException {
        boolean oldReturn;
        int oldCCNCount;
        int ncssCount;
        int column;
        int line;
        ArrayList excpts;
        StringBuffer retType;
        StringBuffer access;
        block23: {
            access = new StringBuffer("");
            retType = null;
            excpts = new ArrayList();
            line = 0;
            column = 0;
            ncssCount = sNCSSCount;
            oldCCNCount = sCCNCount;
            oldReturn = sReturn;
            ++sMethodsCount;
            sCCNCount = 1;
            JavaCodingStandardChecker.resetNewLine();
            JavaCodingStandardChecker.handleMethodDeclarationPlaceRule(this.token.beginLine, this.token.beginColumn);
            JavaCodingStandardChecker.handleNestedTypePlaceRule(METHODDECLARATION, this.token.beginLine, this.token.beginColumn);
            block21: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 14: 
                    case 30: 
                    case 42: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 51: 
                    case 54: 
                    case 64: {
                        break;
                    }
                    default: {
                        this.jj_la1[30] = this.jj_gen;
                        break block23;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 48: {
                        this.jj_consume_token(48);
                        access.append("public ");
                        continue block21;
                    }
                    case 47: {
                        this.jj_consume_token(47);
                        access.append("protected ");
                        continue block21;
                    }
                    case 46: {
                        this.jj_consume_token(46);
                        access.append("private ");
                        continue block21;
                    }
                    case 51: {
                        this.jj_consume_token(51);
                        access.append("static ");
                        continue block21;
                    }
                    case 14: {
                        this.jj_consume_token(14);
                        access.append("abstract ");
                        continue block21;
                    }
                    case 30: {
                        this.jj_consume_token(30);
                        access.append("final ");
                        continue block21;
                    }
                    case 42: {
                        this.jj_consume_token(42);
                        access.append("native ");
                        continue block21;
                    }
                    case 54: {
                        this.jj_consume_token(54);
                        access.append("synchronized ");
                        continue block21;
                    }
                    case 64: {
                        this.jj_consume_token(64);
                        access.append("strictfp ");
                        continue block21;
                    }
                }
                break;
            }
            this.jj_la1[31] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.handleMethodDeclarationModifierOrder(access, this.token.beginLine, this.token.beginColumn);
        retType = this.ResultType();
        Return.MethodDeclaratorReturn mdReturn = this.MethodDeclarator();
        sReturn = false;
        line = this.token.beginLine;
        column = this.token.beginColumn;
        JavaCodingStandardChecker.handleMethodDeclaration(access, retType, mdReturn.getMethodName(), this.token.beginLine, this.token.beginColumn);
        JavaCodingStandardChecker.handleUnitTests(mdReturn.getMethodName(), this.token.beginLine, this.token.beginColumn);
        JavaCodingStandardChecker.resetNewLine();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 57: {
                JavaCodingStandardChecker.resetNewLine();
                this.jj_consume_token(57);
                excpts = this.NameList();
                break;
            }
            default: {
                this.jj_la1[32] = this.jj_gen;
            }
        }
        JavaCodingStandardChecker.handleMethodDeclarationJavaDoc(sLastJavaDoc, access, retType, mdReturn.getParaCount(), excpts, line, this.token.beginColumn);
        sLastJavaDoc = "";
        JavaCodingStandardChecker.handleMethodThrowException(excpts, this.token.beginLine, this.token.beginColumn);
        JavaCodingStandardChecker.resetNewLine();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 79: {
                this.Block();
                break;
            }
            case 83: {
                this.jj_consume_token(83);
                break;
            }
            default: {
                this.jj_la1[33] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (sReturn) {
            --sCCNCount;
        }
        JavaCodingStandardChecker.sCurrentState.mHasHandledMethodDeclaration = true;
        JavaCodingStandardChecker.handleMethodMetrics(++sNCSSCount - ncssCount, sCCNCount, mdReturn.getMethodName(), line, column);
        sReturn = oldReturn;
        sCCNCount = oldCCNCount;
    }

    public final Return.MethodDeclaratorReturn MethodDeclarator() throws ParseException {
        int numParameters = 0;
        this.jj_consume_token(74);
        StringBuffer name = new StringBuffer(this.token.image);
        numParameters = this.FormalParameters();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 81: {
                    break;
                }
                default: {
                    this.jj_la1[34] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(81);
            this.jj_consume_token(82);
        }
        JavaCodingStandardChecker.handleMethodDeclarationArgumentsCount(numParameters, name, this.token.beginLine, this.token.beginColumn);
        return new Return.MethodDeclaratorReturn(name, numParameters);
    }

    public final int FormalParameters() throws ParseException {
        int numFormParameters = 0;
        this.jj_consume_token(77);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: 
            case 17: 
            case 20: 
            case 26: 
            case 30: 
            case 32: 
            case 39: 
            case 41: 
            case 50: 
            case 74: {
                this.FormalParameter();
                ++numFormParameters;
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 84: {
                            break;
                        }
                        default: {
                            this.jj_la1[35] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(84);
                    this.FormalParameter();
                    ++numFormParameters;
                }
            }
            default: {
                this.jj_la1[36] = this.jj_gen;
            }
        }
        this.jj_consume_token(78);
        return numFormParameters;
    }

    public final Return.FormalParameterReturn FormalParameter() throws ParseException {
        StringBuffer name = null;
        StringBuffer type = null;
        StringBuffer access = new StringBuffer("");
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                this.jj_consume_token(30);
                access.append("final ");
                break;
            }
            default: {
                this.jj_la1[37] = this.jj_gen;
            }
        }
        type = this.Type();
        name = this.VariableDeclaratorId();
        JavaCodingStandardChecker.handleParaRegExp(access, name, this.token.beginLine, this.token.beginColumn);
        return new Return.FormalParameterReturn(type, name);
    }

    public final void ConstructorDeclaration() throws ParseException {
        StringBuffer access = new StringBuffer("");
        ArrayList excpts = new ArrayList();
        int paraCount = 0;
        int line = 0;
        int column = 0;
        int ncssCount = sNCSSCount;
        int oldCCNCount = sCCNCount;
        boolean oldReturn = sReturn;
        ++sMethodsCount;
        sCCNCount = 1;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 46: 
            case 47: 
            case 48: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 48: {
                        this.jj_consume_token(48);
                        access.append("public ");
                        break block0;
                    }
                    case 47: {
                        this.jj_consume_token(47);
                        access.append("protected ");
                        break block0;
                    }
                    case 46: {
                        this.jj_consume_token(46);
                        access.append("private ");
                        break block0;
                    }
                }
                this.jj_la1[38] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[39] = this.jj_gen;
            }
        }
        this.jj_consume_token(74);
        line = this.token.beginLine;
        column = this.token.beginColumn;
        paraCount = this.FormalParameters();
        sReturn = false;
        JavaCodingStandardChecker.handleMethodDeclaration(access, new StringBuffer(""), new StringBuffer("constructor"), line, column);
        JavaCodingStandardChecker.handleConstructorDeclarationArgumentsCount(paraCount, new StringBuffer("constructor"), line, column);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 57: {
                this.jj_consume_token(57);
                excpts = this.NameList();
                break;
            }
            default: {
                this.jj_la1[40] = this.jj_gen;
            }
        }
        JavaCodingStandardChecker.handleConstructorDeclarationJavaDoc(sLastJavaDoc, access, paraCount, excpts, line, column);
        sLastJavaDoc = "";
        this.jj_consume_token(79);
        if (this.jj_2_11(Integer.MAX_VALUE)) {
            this.ExplicitConstructorInvocation();
        }
        block14: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 15: 
                case 16: 
                case 17: 
                case 20: 
                case 21: 
                case 23: 
                case 25: 
                case 26: 
                case 29: 
                case 30: 
                case 32: 
                case 33: 
                case 35: 
                case 39: 
                case 40: 
                case 41: 
                case 43: 
                case 44: 
                case 49: 
                case 50: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 59: 
                case 60: 
                case 61: 
                case 63: 
                case 65: 
                case 66: 
                case 70: 
                case 72: 
                case 73: 
                case 74: 
                case 77: 
                case 79: 
                case 83: 
                case 99: 
                case 100: {
                    break;
                }
                default: {
                    this.jj_la1[41] = this.jj_gen;
                    break block14;
                }
            }
            this.BlockStatement();
        }
        this.jj_consume_token(80);
        if (sReturn) {
            --sCCNCount;
        }
        JavaCodingStandardChecker.sCurrentState.mHasHandledCtorMethodDeclaration = true;
        JavaCodingStandardChecker.handleConstructorMetrics(++sNCSSCount - ncssCount, sCCNCount, new StringBuffer("constructor"), line, column);
        sCCNCount = oldCCNCount;
        sReturn = oldReturn;
    }

    public final void ExplicitConstructorInvocation() throws ParseException {
        if (this.jj_2_13(Integer.MAX_VALUE)) {
            this.jj_consume_token(55);
            this.Arguments();
            this.jj_consume_token(83);
            ++sNCSSCount;
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 15: 
                case 17: 
                case 20: 
                case 26: 
                case 29: 
                case 32: 
                case 39: 
                case 41: 
                case 43: 
                case 44: 
                case 50: 
                case 52: 
                case 55: 
                case 59: 
                case 61: 
                case 66: 
                case 70: 
                case 72: 
                case 73: 
                case 74: 
                case 77: {
                    if (this.jj_2_12(2)) {
                        this.PrimaryExpression();
                        this.jj_consume_token(85);
                    }
                    this.jj_consume_token(52);
                    this.Arguments();
                    this.jj_consume_token(83);
                    ++sNCSSCount;
                    break;
                }
                default: {
                    this.jj_la1[42] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final void Initializer() throws ParseException {
        JavaCodingStandardChecker.resetNewLine();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 51: {
                this.jj_consume_token(51);
                JavaCodingStandardChecker.resetNewLine();
                break;
            }
            default: {
                this.jj_la1[43] = this.jj_gen;
            }
        }
        this.Block();
        JavaCodingStandardChecker.sCurrentState.mHasHandledStaticInitializer = true;
        ++sNCSSCount;
    }

    public final StringBuffer Type() throws ParseException {
        StringBuffer type = new StringBuffer("");
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: 
            case 17: 
            case 20: 
            case 26: 
            case 32: 
            case 39: 
            case 41: 
            case 50: {
                type = this.PrimitiveType();
                break;
            }
            case 74: {
                type = this.Name();
                break;
            }
            default: {
                this.jj_la1[44] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 81: {
                    break;
                }
                default: {
                    this.jj_la1[45] = this.jj_gen;
                    break block7;
                }
            }
            this.jj_consume_token(81);
            this.jj_consume_token(82);
        }
        return type;
    }

    public final StringBuffer PrimitiveType() throws ParseException {
        StringBuffer type = new StringBuffer("");
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                this.jj_consume_token(15);
                type.append("boolean");
                break;
            }
            case 20: {
                this.jj_consume_token(20);
                type.append("char");
                break;
            }
            case 17: {
                this.jj_consume_token(17);
                type.append("byte");
                break;
            }
            case 50: {
                this.jj_consume_token(50);
                type.append("short");
                break;
            }
            case 39: {
                this.jj_consume_token(39);
                type.append("int");
                break;
            }
            case 41: {
                this.jj_consume_token(41);
                type.append("long");
                break;
            }
            case 32: {
                this.jj_consume_token(32);
                type.append("float");
                break;
            }
            case 26: {
                this.jj_consume_token(26);
                type.append("double");
                break;
            }
            default: {
                this.jj_la1[46] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return type;
    }

    public final StringBuffer ResultType() throws ParseException {
        StringBuffer type = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 61: {
                this.jj_consume_token(61);
                type = new StringBuffer("void");
                break;
            }
            case 15: 
            case 17: 
            case 20: 
            case 26: 
            case 32: 
            case 39: 
            case 41: 
            case 50: 
            case 74: {
                type = this.Type();
                break;
            }
            default: {
                this.jj_la1[47] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return type;
    }

    public final StringBuffer Name() throws ParseException {
        this.jj_consume_token(74);
        StringBuffer name = new StringBuffer(this.token.image);
        while (this.jj_2_14(2)) {
            this.jj_consume_token(85);
            this.jj_consume_token(74);
            name.append(".");
            name.append(new String(this.token.image));
        }
        return name;
    }

    public final ArrayList NameList() throws ParseException {
        StringBuffer temp = null;
        ArrayList<String> excpts = new ArrayList<String>();
        temp = this.Name();
        excpts.add(temp.toString());
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 84: {
                    break;
                }
                default: {
                    this.jj_la1[48] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(84);
            temp = this.Name();
            excpts.add(temp.toString());
        }
        return excpts;
    }

    public final void Expression() throws ParseException {
        this.ConditionalExpression();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 86: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: {
                this.AssignmentOperator();
                this.Expression();
                JavaCodingStandardChecker.handleSpaceAroundBinaryExpression(AFTER_BINARY, "Assignment", this.token.beginLine, this.token.beginColumn);
                break;
            }
            default: {
                this.jj_la1[49] = this.jj_gen;
            }
        }
    }

    public final void AssignmentOperator() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 86: {
                this.jj_consume_token(86);
                if (!JavaCodingStandardChecker.sCurrentState.mInNoAssignmentExpression) break;
                JavaCodingStandardChecker.handleConditionalExpressAssignment(this.token.beginLine, this.token.beginColumn);
                break;
            }
            case 114: {
                this.jj_consume_token(114);
                break;
            }
            case 115: {
                this.jj_consume_token(115);
                break;
            }
            case 119: {
                this.jj_consume_token(119);
                break;
            }
            case 112: {
                this.jj_consume_token(112);
                break;
            }
            case 113: {
                this.jj_consume_token(113);
                break;
            }
            case 120: {
                this.jj_consume_token(120);
                break;
            }
            case 121: {
                this.jj_consume_token(121);
                break;
            }
            case 122: {
                this.jj_consume_token(122);
                break;
            }
            case 116: {
                this.jj_consume_token(116);
                break;
            }
            case 118: {
                this.jj_consume_token(118);
                break;
            }
            case 117: {
                this.jj_consume_token(117);
                break;
            }
            default: {
                this.jj_la1[50] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void ConditionalExpression() throws ParseException {
        this.ConditionalOrExpression();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 91: {
                this.jj_consume_token(91);
                this.Expression();
                this.jj_consume_token(92);
                this.ConditionalExpression();
                JavaCodingStandardChecker.handleConditionalExpression(this.token.beginLine, this.token.beginColumn);
                break;
            }
            default: {
                this.jj_la1[51] = this.jj_gen;
            }
        }
    }

    public final void ConditionalOrExpression() throws ParseException {
        this.ConditionalAndExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 97: {
                    break;
                }
                default: {
                    this.jj_la1[52] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(97);
            this.ConditionalAndExpression();
            JavaCodingStandardChecker.handleSpaceAroundBinaryExpression(AFTER_BINARY, CONDITIONAL_OR_BINARY, this.token.beginLine, this.token.beginColumn);
        }
    }

    public final void ConditionalAndExpression() throws ParseException {
        this.InclusiveOrExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 98: {
                    break;
                }
                default: {
                    this.jj_la1[53] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(98);
            this.InclusiveOrExpression();
            JavaCodingStandardChecker.handleSpaceAroundBinaryExpression(AFTER_BINARY, CONDITIONAL_AND_BINARY, this.token.beginLine, this.token.beginColumn);
        }
    }

    public final void InclusiveOrExpression() throws ParseException {
        this.ExclusiveOrExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 106: {
                    break;
                }
                default: {
                    this.jj_la1[54] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(106);
            this.ExclusiveOrExpression();
            JavaCodingStandardChecker.handleSpaceAroundBinaryExpression(AFTER_BINARY, "|", this.token.beginLine, this.token.beginColumn);
        }
    }

    public final void ExclusiveOrExpression() throws ParseException {
        this.AndExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 107: {
                    break;
                }
                default: {
                    this.jj_la1[55] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(107);
            this.AndExpression();
            JavaCodingStandardChecker.handleSpaceAroundBinaryExpression(AFTER_BINARY, EXCLUSIVE_OR_BINARY, this.token.beginLine, this.token.beginColumn);
        }
    }

    public final void AndExpression() throws ParseException {
        this.EqualityExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 105: {
                    break;
                }
                default: {
                    this.jj_la1[56] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(105);
            this.EqualityExpression();
            JavaCodingStandardChecker.handleSpaceAroundBinaryExpression(AFTER_BINARY, AND_BINARY, this.token.beginLine, this.token.beginColumn);
        }
    }

    public final void EqualityExpression() throws ParseException {
        this.InstanceOfExpression();
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 93: 
                case 96: {
                    break;
                }
                default: {
                    this.jj_la1[57] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 93: {
                    this.jj_consume_token(93);
                    break;
                }
                case 96: {
                    this.jj_consume_token(96);
                    break;
                }
                default: {
                    this.jj_la1[58] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.InstanceOfExpression();
            JavaCodingStandardChecker.handleSpaceAroundBinaryExpression(AFTER_BINARY, EQUALITY_BINARY, this.token.beginLine, this.token.beginColumn);
        }
    }

    public final void InstanceOfExpression() throws ParseException {
        this.RelationalExpression();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 38: {
                this.jj_consume_token(38);
                this.Type();
                break;
            }
            default: {
                this.jj_la1[59] = this.jj_gen;
            }
        }
    }

    public final void RelationalExpression() throws ParseException {
        this.ShiftExpression();
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 87: 
                case 88: 
                case 94: 
                case 95: {
                    break;
                }
                default: {
                    this.jj_la1[60] = this.jj_gen;
                    break block9;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 88: {
                    this.jj_consume_token(88);
                    break;
                }
                case 87: {
                    this.jj_consume_token(87);
                    break;
                }
                case 94: {
                    this.jj_consume_token(94);
                    break;
                }
                case 95: {
                    this.jj_consume_token(95);
                    break;
                }
                default: {
                    this.jj_la1[61] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.ShiftExpression();
            JavaCodingStandardChecker.handleSpaceAroundBinaryExpression(AFTER_BINARY, RELATIONAL_BINARY, this.token.beginLine, this.token.beginColumn);
        }
    }

    public final void ShiftExpression() throws ParseException {
        this.AdditiveExpression();
        block8: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 109: 
                case 110: 
                case 111: {
                    break;
                }
                default: {
                    this.jj_la1[62] = this.jj_gen;
                    break block8;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 109: {
                    this.jj_consume_token(109);
                    break;
                }
                case 110: {
                    this.jj_consume_token(110);
                    break;
                }
                case 111: {
                    this.jj_consume_token(111);
                    break;
                }
                default: {
                    this.jj_la1[63] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.AdditiveExpression();
            JavaCodingStandardChecker.handleSpaceAroundBinaryExpression(AFTER_BINARY, SHIFT_BINARY, this.token.beginLine, this.token.beginColumn);
        }
    }

    public final void AdditiveExpression() throws ParseException {
        this.MultiplicativeExpression();
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 101: 
                case 102: {
                    break;
                }
                default: {
                    this.jj_la1[64] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 101: {
                    this.jj_consume_token(101);
                    break;
                }
                case 102: {
                    this.jj_consume_token(102);
                    break;
                }
                default: {
                    this.jj_la1[65] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.MultiplicativeExpression();
            JavaCodingStandardChecker.handleSpaceAroundBinaryExpression(AFTER_BINARY, ADDITIVE_BINARY, this.token.beginLine, this.token.beginColumn);
        }
    }

    public final void MultiplicativeExpression() throws ParseException {
        this.UnaryExpression();
        block8: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 103: 
                case 104: 
                case 108: {
                    break;
                }
                default: {
                    this.jj_la1[66] = this.jj_gen;
                    break block8;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 103: {
                    this.jj_consume_token(103);
                    break;
                }
                case 104: {
                    this.jj_consume_token(104);
                    break;
                }
                case 108: {
                    this.jj_consume_token(108);
                    break;
                }
                default: {
                    this.jj_la1[67] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.UnaryExpression();
            JavaCodingStandardChecker.handleSpaceAroundBinaryExpression(AFTER_BINARY, MULTIPLICATIVE_BINARY, this.token.beginLine, this.token.beginColumn);
        }
    }

    public final void UnaryExpression() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 101: 
            case 102: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 101: {
                        this.jj_consume_token(101);
                        break;
                    }
                    case 102: {
                        this.jj_consume_token(102);
                        break;
                    }
                    default: {
                        this.jj_la1[68] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.UnaryExpression();
                break;
            }
            case 99: {
                this.PreIncrementExpression();
                break;
            }
            case 100: {
                this.PreDecrementExpression();
                break;
            }
            case 15: 
            case 17: 
            case 20: 
            case 26: 
            case 29: 
            case 32: 
            case 39: 
            case 41: 
            case 43: 
            case 44: 
            case 50: 
            case 52: 
            case 55: 
            case 59: 
            case 61: 
            case 66: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 77: 
            case 89: 
            case 90: {
                this.UnaryExpressionNotPlusMinus();
                break;
            }
            default: {
                this.jj_la1[69] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void PreIncrementExpression() throws ParseException {
        this.jj_consume_token(99);
        this.PrimaryExpression();
    }

    public final void PreDecrementExpression() throws ParseException {
        this.jj_consume_token(100);
        this.PrimaryExpression();
    }

    public final void UnaryExpressionNotPlusMinus() throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 89: 
            case 90: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 90: {
                        this.jj_consume_token(90);
                        break;
                    }
                    case 89: {
                        this.jj_consume_token(89);
                        break;
                    }
                    default: {
                        this.jj_la1[70] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.UnaryExpression();
                break;
            }
            default: {
                this.jj_la1[71] = this.jj_gen;
                if (this.jj_2_15(Integer.MAX_VALUE)) {
                    this.CastExpression();
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 15: 
                    case 17: 
                    case 20: 
                    case 26: 
                    case 29: 
                    case 32: 
                    case 39: 
                    case 41: 
                    case 43: 
                    case 44: 
                    case 50: 
                    case 52: 
                    case 55: 
                    case 59: 
                    case 61: 
                    case 66: 
                    case 70: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 77: {
                        this.PostfixExpression();
                        break block0;
                    }
                }
                this.jj_la1[72] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void CastLookahead() throws ParseException {
        if (this.jj_2_16(2)) {
            this.jj_consume_token(77);
            this.PrimitiveType();
        } else if (this.jj_2_17(Integer.MAX_VALUE)) {
            this.jj_consume_token(77);
            this.Name();
            this.jj_consume_token(81);
            this.jj_consume_token(82);
        } else {
            block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 77: {
                    this.jj_consume_token(77);
                    this.Name();
                    this.jj_consume_token(78);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 90: {
                            this.jj_consume_token(90);
                            break block0;
                        }
                        case 89: {
                            this.jj_consume_token(89);
                            break block0;
                        }
                        case 77: {
                            this.jj_consume_token(77);
                            break block0;
                        }
                        case 74: {
                            this.jj_consume_token(74);
                            break block0;
                        }
                        case 55: {
                            this.jj_consume_token(55);
                            break block0;
                        }
                        case 52: {
                            this.jj_consume_token(52);
                            break block0;
                        }
                        case 43: {
                            this.jj_consume_token(43);
                            break block0;
                        }
                        case 29: 
                        case 44: 
                        case 59: 
                        case 66: 
                        case 70: 
                        case 72: 
                        case 73: {
                            this.Literal();
                            break block0;
                        }
                    }
                    this.jj_la1[73] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[74] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final void PostfixExpression() throws ParseException {
        this.PrimaryExpression();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 99: 
            case 100: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 99: {
                        this.jj_consume_token(99);
                        break block0;
                    }
                    case 100: {
                        this.jj_consume_token(100);
                        break block0;
                    }
                }
                this.jj_la1[75] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[76] = this.jj_gen;
            }
        }
    }

    public final void CastExpression() throws ParseException {
        if (this.jj_2_18(Integer.MAX_VALUE)) {
            this.jj_consume_token(77);
            this.Type();
            this.jj_consume_token(78);
            this.UnaryExpression();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 77: {
                    this.jj_consume_token(77);
                    this.Type();
                    this.jj_consume_token(78);
                    this.UnaryExpressionNotPlusMinus();
                    break;
                }
                default: {
                    this.jj_la1[77] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final void PrimaryExpression() throws ParseException {
        StringBuffer prefix = new StringBuffer();
        StringBuffer suffix = new StringBuffer();
        StringBuffer tmp = new StringBuffer();
        prefix = this.PrimaryPrefix();
        while (this.jj_2_19(2)) {
            tmp = this.PrimarySuffix();
            suffix.append((Object)tmp);
        }
        if (JavaCodingStandardChecker.sCurrentState.mInLoopExpressionBlock) {
            JavaCodingStandardChecker.handleComplexLoopExpression(prefix.append((Object)suffix), this.token.beginLine, this.token.beginColumn);
        }
    }

    public final StringBuffer PrimaryPrefix() throws ParseException {
        StringBuffer name = new StringBuffer();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 29: 
            case 44: 
            case 59: 
            case 66: 
            case 70: 
            case 72: 
            case 73: {
                this.Literal();
                break;
            }
            case 55: {
                this.jj_consume_token(55);
                break;
            }
            case 52: {
                this.jj_consume_token(52);
                this.jj_consume_token(85);
                this.jj_consume_token(74);
                break;
            }
            case 77: {
                this.jj_consume_token(77);
                this.Expression();
                this.jj_consume_token(78);
                break;
            }
            case 43: {
                this.AllocationExpression();
                break;
            }
            default: {
                this.jj_la1[78] = this.jj_gen;
                if (this.jj_2_20(Integer.MAX_VALUE)) {
                    this.ResultType();
                    this.jj_consume_token(85);
                    this.jj_consume_token(21);
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 74: {
                        name = this.Name();
                        break block0;
                    }
                }
                this.jj_la1[79] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return name;
    }

    public final StringBuffer PrimarySuffix() throws ParseException {
        StringBuffer suffix = new StringBuffer();
        if (this.jj_2_21(2)) {
            this.jj_consume_token(85);
            this.jj_consume_token(55);
        } else if (this.jj_2_22(2)) {
            this.jj_consume_token(85);
            this.jj_consume_token(52);
        } else if (this.jj_2_23(2)) {
            this.jj_consume_token(85);
            this.AllocationExpression();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 81: {
                    this.jj_consume_token(81);
                    this.Expression();
                    this.jj_consume_token(82);
                    suffix.append("[]");
                    break;
                }
                case 85: {
                    this.jj_consume_token(85);
                    this.jj_consume_token(74);
                    suffix.append("." + this.token.image);
                    break;
                }
                case 77: {
                    this.Arguments();
                    suffix.append("()");
                    break;
                }
                default: {
                    this.jj_la1[80] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return suffix;
    }

    public final void Literal() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 66: {
                this.jj_consume_token(66);
                break;
            }
            case 70: {
                this.jj_consume_token(70);
                break;
            }
            case 72: {
                this.jj_consume_token(72);
                break;
            }
            case 73: {
                this.jj_consume_token(73);
                if (JavaCodingStandardChecker.sCurrentState.mInFieldDeclaration) break;
                JavaCodingStandardChecker.handleStringLiteral(this.token.image, this.token.beginLine, this.token.beginColumn);
                break;
            }
            case 29: 
            case 59: {
                this.BooleanLiteral();
                break;
            }
            case 44: {
                this.NullLiteral();
                break;
            }
            default: {
                this.jj_la1[81] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void BooleanLiteral() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 59: {
                this.jj_consume_token(59);
                break;
            }
            case 29: {
                this.jj_consume_token(29);
                break;
            }
            default: {
                this.jj_la1[82] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void NullLiteral() throws ParseException {
        this.jj_consume_token(44);
    }

    public final void Arguments() throws ParseException {
        this.jj_consume_token(77);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: 
            case 17: 
            case 20: 
            case 26: 
            case 29: 
            case 32: 
            case 39: 
            case 41: 
            case 43: 
            case 44: 
            case 50: 
            case 52: 
            case 55: 
            case 59: 
            case 61: 
            case 66: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 77: 
            case 89: 
            case 90: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                this.ArgumentList();
                break;
            }
            default: {
                this.jj_la1[83] = this.jj_gen;
            }
        }
        this.jj_consume_token(78);
    }

    public final void ArgumentList() throws ParseException {
        this.Expression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 84: {
                    break;
                }
                default: {
                    this.jj_la1[84] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(84);
            this.Expression();
        }
    }

    public final void AllocationExpression() throws ParseException {
        StringBuffer name = null;
        if (this.jj_2_24(2)) {
            this.jj_consume_token(43);
            this.PrimitiveType();
            this.ArrayDimsAndInits();
        } else {
            block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 43: {
                    this.jj_consume_token(43);
                    name = this.Name();
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 81: {
                            this.ArrayDimsAndInits();
                            break block0;
                        }
                        case 77: {
                            this.Arguments();
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 79: {
                                    sSavedStates.push(sCurrentState);
                                    sCurrentState = new CurrentState();
                                    JavaCodingStandardChecker.sCurrentState.mName = name.toString();
                                    JavaCodingStandardChecker.sCurrentState.isClass = true;
                                    JavaCodingStandardChecker.sCurrentState.isAnonymousClass = true;
                                    this.ClassBody();
                                    JavaCodingStandardChecker.overviewClassResults();
                                    sCurrentState = (CurrentState)sSavedStates.pop();
                                    break block0;
                                }
                            }
                            this.jj_la1[85] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_la1[86] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[87] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final void ArrayDimsAndInits() throws ParseException {
        if (this.jj_2_27(2)) {
            do {
                this.jj_consume_token(81);
                this.Expression();
                this.jj_consume_token(82);
            } while (this.jj_2_25(2));
            while (this.jj_2_26(2)) {
                this.jj_consume_token(81);
                this.jj_consume_token(82);
            }
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 81: {
                    block8: while (true) {
                        this.jj_consume_token(81);
                        this.jj_consume_token(82);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 81: {
                                continue block8;
                            }
                        }
                        break;
                    }
                    this.jj_la1[88] = this.jj_gen;
                    this.ArrayInitializer();
                    break;
                }
                default: {
                    this.jj_la1[89] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final void Statement() throws ParseException {
        if (this.jj_2_28(2)) {
            this.LabeledStatement();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 79: {
                    this.Block();
                    break;
                }
                case 83: {
                    this.EmptyStatement();
                    break;
                }
                case 15: 
                case 17: 
                case 20: 
                case 26: 
                case 29: 
                case 32: 
                case 39: 
                case 41: 
                case 43: 
                case 44: 
                case 50: 
                case 52: 
                case 55: 
                case 59: 
                case 61: 
                case 66: 
                case 70: 
                case 72: 
                case 73: 
                case 74: 
                case 77: 
                case 99: 
                case 100: {
                    this.StatementExpression();
                    this.jj_consume_token(83);
                    ++sNCSSCount;
                    break;
                }
                case 53: {
                    this.SwitchStatement();
                    break;
                }
                case 35: {
                    this.IfStatement();
                    ++sCCNCount;
                    break;
                }
                case 63: {
                    this.WhileStatement();
                    ++sCCNCount;
                    break;
                }
                case 25: {
                    this.DoStatement();
                    ++sCCNCount;
                    break;
                }
                case 33: {
                    this.ForStatement();
                    ++sCCNCount;
                    break;
                }
                case 16: {
                    this.BreakStatement();
                    break;
                }
                case 23: {
                    this.ContinueStatement();
                    break;
                }
                case 49: {
                    this.ReturnStatement();
                    break;
                }
                case 56: {
                    this.ThrowStatement();
                    break;
                }
                case 54: {
                    this.SynchronizedStatement();
                    break;
                }
                case 60: {
                    this.TryStatement();
                    break;
                }
                case 65: {
                    this.AssertStatement();
                    break;
                }
                default: {
                    this.jj_la1[90] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final void LabeledStatement() throws ParseException {
        this.jj_consume_token(74);
        StringBuffer name = new StringBuffer(this.token.image);
        JavaCodingStandardChecker.handleLabelNaming(name, this.token.beginLine, this.token.beginColumn);
        this.jj_consume_token(92);
        this.Statement();
        ++sNCSSCount;
    }

    public final void Block() throws ParseException {
        this.jj_consume_token(79);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 15: 
                case 16: 
                case 17: 
                case 20: 
                case 21: 
                case 23: 
                case 25: 
                case 26: 
                case 29: 
                case 30: 
                case 32: 
                case 33: 
                case 35: 
                case 39: 
                case 40: 
                case 41: 
                case 43: 
                case 44: 
                case 49: 
                case 50: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 59: 
                case 60: 
                case 61: 
                case 63: 
                case 65: 
                case 66: 
                case 70: 
                case 72: 
                case 73: 
                case 74: 
                case 77: 
                case 79: 
                case 83: 
                case 99: 
                case 100: {
                    break;
                }
                default: {
                    this.jj_la1[91] = this.jj_gen;
                    break block3;
                }
            }
            this.BlockStatement();
        }
        this.jj_consume_token(80);
    }

    public final void BlockStatement() throws ParseException {
        if (this.jj_2_29(Integer.MAX_VALUE)) {
            this.LocalVariableDeclaration();
            this.jj_consume_token(83);
            ++sNCSSCount;
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 15: 
                case 16: 
                case 17: 
                case 20: 
                case 23: 
                case 25: 
                case 26: 
                case 29: 
                case 32: 
                case 33: 
                case 35: 
                case 39: 
                case 41: 
                case 43: 
                case 44: 
                case 49: 
                case 50: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 59: 
                case 60: 
                case 61: 
                case 63: 
                case 65: 
                case 66: 
                case 70: 
                case 72: 
                case 73: 
                case 74: 
                case 77: 
                case 79: 
                case 83: 
                case 99: 
                case 100: {
                    this.Statement();
                    break;
                }
                case 21: {
                    this.UnmodifiedClassDeclaration(new StringBuffer(""));
                    break;
                }
                case 40: {
                    this.UnmodifiedInterfaceDeclaration(new StringBuffer(""));
                    break;
                }
                default: {
                    this.jj_la1[92] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final void LocalVariableDeclaration() throws ParseException {
        StringBuffer type = new StringBuffer();
        StringBuffer name = new StringBuffer();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                this.jj_consume_token(30);
                break;
            }
            default: {
                this.jj_la1[93] = this.jj_gen;
            }
        }
        type = this.Type();
        name = this.VariableDeclarator();
        JavaCodingStandardChecker.handleLocalVariableDeclaration(type, name, this.token.beginLine, this.token.beginColumn);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 84: {
                    break;
                }
                default: {
                    this.jj_la1[94] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(84);
            this.VariableDeclarator();
            if (!JavaCodingStandardChecker.sCurrentState.mInForInitBlock) {
                JavaCodingStandardChecker.handleOnlyOneVariableDeclarationPerLine(this.token.beginLine, this.token.beginColumn);
            }
            JavaCodingStandardChecker.handleLocalVariableDeclaration(type, name, this.token.beginLine, this.token.beginColumn);
        }
    }

    public final void EmptyStatement() throws ParseException {
        this.jj_consume_token(83);
    }

    public final void StatementExpression() throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 99: {
                this.PreIncrementExpression();
                break;
            }
            case 100: {
                this.PreDecrementExpression();
                break;
            }
            case 15: 
            case 17: 
            case 20: 
            case 26: 
            case 29: 
            case 32: 
            case 39: 
            case 41: 
            case 43: 
            case 44: 
            case 50: 
            case 52: 
            case 55: 
            case 59: 
            case 61: 
            case 66: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 77: {
                this.PrimaryExpression();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 86: 
                    case 99: 
                    case 100: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 121: 
                    case 122: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 99: {
                                this.jj_consume_token(99);
                                break block0;
                            }
                            case 100: {
                                this.jj_consume_token(100);
                                break block0;
                            }
                            case 86: 
                            case 112: 
                            case 113: 
                            case 114: 
                            case 115: 
                            case 116: 
                            case 117: 
                            case 118: 
                            case 119: 
                            case 120: 
                            case 121: 
                            case 122: {
                                this.AssignmentOperator();
                                this.Expression();
                                JavaCodingStandardChecker.handleSpaceAroundBinaryExpression(AFTER_BINARY, "Assignment", this.token.beginLine, this.token.beginColumn);
                                break block0;
                            }
                        }
                        this.jj_la1[95] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_la1[96] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[97] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void SwitchStatement() throws ParseException {
        boolean hasDefault = false;
        this.jj_consume_token(53);
        JavaCodingStandardChecker.resetSpaceCount();
        JavaCodingStandardChecker.resetNewLine();
        int line = this.token.beginLine;
        int column = this.token.beginColumn;
        this.jj_consume_token(77);
        JavaCodingStandardChecker.handleSpaceAfterStatementKeyword(SWITCH_STATEMENT, this.token.beginLine, this.token.beginColumn);
        this.Expression();
        this.jj_consume_token(78);
        this.jj_consume_token(79);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 18: 
                case 24: {
                    break;
                }
                default: {
                    this.jj_la1[98] = this.jj_gen;
                    break block6;
                }
            }
            hasDefault = this.SwitchLabel();
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 15: 
                    case 16: 
                    case 17: 
                    case 20: 
                    case 21: 
                    case 23: 
                    case 25: 
                    case 26: 
                    case 29: 
                    case 30: 
                    case 32: 
                    case 33: 
                    case 35: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 43: 
                    case 44: 
                    case 49: 
                    case 50: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 63: 
                    case 65: 
                    case 66: 
                    case 70: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 77: 
                    case 79: 
                    case 83: 
                    case 99: 
                    case 100: {
                        break;
                    }
                    default: {
                        this.jj_la1[99] = this.jj_gen;
                        continue block6;
                    }
                }
                this.BlockStatement();
            }
            break;
        }
        this.jj_consume_token(80);
        JavaCodingStandardChecker.handleSwitchNeedsDefault(hasDefault, line, column);
        ++sNCSSCount;
    }

    public final boolean SwitchLabel() throws ParseException {
        boolean isDefault = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: {
                this.jj_consume_token(18);
                this.Expression();
                this.jj_consume_token(92);
                ++sCCNCount;
                ++sNCSSCount;
                break;
            }
            case 24: {
                this.jj_consume_token(24);
                this.jj_consume_token(92);
                isDefault = true;
                ++sNCSSCount;
                break;
            }
            default: {
                this.jj_la1[100] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return isDefault;
    }

    public final void SpecialStatementBlock(String pKind) throws ParseException {
        int line = 0;
        int column = 0;
        if (this.jj_2_30(2)) {
            JavaCodingStandardChecker.resetNewLine();
            this.Block();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 15: 
                case 16: 
                case 17: 
                case 20: 
                case 23: 
                case 25: 
                case 26: 
                case 29: 
                case 32: 
                case 33: 
                case 35: 
                case 39: 
                case 41: 
                case 43: 
                case 44: 
                case 49: 
                case 50: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 59: 
                case 60: 
                case 61: 
                case 63: 
                case 65: 
                case 66: 
                case 70: 
                case 72: 
                case 73: 
                case 74: 
                case 77: 
                case 79: 
                case 83: 
                case 99: 
                case 100: {
                    line = this.token.beginLine;
                    column = this.token.beginColumn;
                    this.Statement();
                    JavaCodingStandardChecker.handleNoBraceStatement(pKind, line, column);
                    break;
                }
                default: {
                    this.jj_la1[101] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final void IfStatement() throws ParseException {
        JavaCodingStandardChecker.sCurrentState.mInNoAssignmentExpression = true;
        this.jj_consume_token(35);
        JavaCodingStandardChecker.resetSpaceCount();
        JavaCodingStandardChecker.resetNewLine();
        this.jj_consume_token(77);
        JavaCodingStandardChecker.handleSpaceAfterStatementKeyword(IF_STATEMENT, this.token.beginLine, this.token.beginColumn);
        this.Expression();
        this.jj_consume_token(78);
        JavaCodingStandardChecker.sCurrentState.mInNoAssignmentExpression = false;
        ++sNCSSCount;
        this.SpecialStatementBlock(IF_STATEMENT);
        if (this.jj_2_32(Integer.MAX_VALUE)) {
            this.jj_consume_token(27);
            JavaCodingStandardChecker.resetNewLine();
            if (this.jj_2_31(Integer.MAX_VALUE)) {
                this.IfStatement();
            } else {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 15: 
                    case 16: 
                    case 17: 
                    case 20: 
                    case 23: 
                    case 25: 
                    case 26: 
                    case 29: 
                    case 32: 
                    case 33: 
                    case 35: 
                    case 39: 
                    case 41: 
                    case 43: 
                    case 44: 
                    case 49: 
                    case 50: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 63: 
                    case 65: 
                    case 66: 
                    case 70: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 77: 
                    case 79: 
                    case 83: 
                    case 99: 
                    case 100: {
                        this.SpecialStatementBlock("else");
                        break;
                    }
                    default: {
                        this.jj_la1[102] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            ++sNCSSCount;
        }
    }

    public final void WhileStatement() throws ParseException {
        JavaCodingStandardChecker.sCurrentState.mInNoAssignmentExpression = true;
        this.jj_consume_token(63);
        JavaCodingStandardChecker.resetSpaceCount();
        JavaCodingStandardChecker.resetNewLine();
        this.jj_consume_token(77);
        JavaCodingStandardChecker.handleSpaceAfterStatementKeyword(WHILE_STATEMENT, this.token.beginLine, this.token.beginColumn);
        this.LoopExpression();
        this.jj_consume_token(78);
        JavaCodingStandardChecker.sCurrentState.mInNoAssignmentExpression = false;
        this.SpecialStatementBlock(WHILE_STATEMENT);
        ++sNCSSCount;
    }

    public final void DoStatement() throws ParseException {
        this.jj_consume_token(25);
        this.Statement();
        this.jj_consume_token(63);
        this.jj_consume_token(77);
        this.LoopExpression();
        this.jj_consume_token(78);
        this.jj_consume_token(83);
        ++sNCSSCount;
    }

    public final void ForStatement() throws ParseException {
        this.jj_consume_token(33);
        JavaCodingStandardChecker.resetSpaceCount();
        JavaCodingStandardChecker.resetNewLine();
        this.jj_consume_token(77);
        JavaCodingStandardChecker.handleSpaceAfterStatementKeyword(FOR_STATEMENT, this.token.beginLine, this.token.beginColumn);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: 
            case 17: 
            case 20: 
            case 26: 
            case 29: 
            case 30: 
            case 32: 
            case 39: 
            case 41: 
            case 43: 
            case 44: 
            case 50: 
            case 52: 
            case 55: 
            case 59: 
            case 61: 
            case 66: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 77: 
            case 99: 
            case 100: {
                this.ForInit();
                break;
            }
            default: {
                this.jj_la1[103] = this.jj_gen;
            }
        }
        this.jj_consume_token(83);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: 
            case 17: 
            case 20: 
            case 26: 
            case 29: 
            case 32: 
            case 39: 
            case 41: 
            case 43: 
            case 44: 
            case 50: 
            case 52: 
            case 55: 
            case 59: 
            case 61: 
            case 66: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 77: 
            case 89: 
            case 90: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                this.LoopExpression();
                break;
            }
            default: {
                this.jj_la1[104] = this.jj_gen;
            }
        }
        this.jj_consume_token(83);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: 
            case 17: 
            case 20: 
            case 26: 
            case 29: 
            case 32: 
            case 39: 
            case 41: 
            case 43: 
            case 44: 
            case 50: 
            case 52: 
            case 55: 
            case 59: 
            case 61: 
            case 66: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 77: 
            case 99: 
            case 100: {
                this.ForUpdate();
                break;
            }
            default: {
                this.jj_la1[105] = this.jj_gen;
            }
        }
        this.jj_consume_token(78);
        this.SpecialStatementBlock(FOR_STATEMENT);
        ++sNCSSCount;
    }

    public final void ForInit() throws ParseException {
        JavaCodingStandardChecker.sCurrentState.mInForInitBlock = true;
        if (this.jj_2_33(Integer.MAX_VALUE)) {
            this.LocalVariableDeclaration();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 15: 
                case 17: 
                case 20: 
                case 26: 
                case 29: 
                case 32: 
                case 39: 
                case 41: 
                case 43: 
                case 44: 
                case 50: 
                case 52: 
                case 55: 
                case 59: 
                case 61: 
                case 66: 
                case 70: 
                case 72: 
                case 73: 
                case 74: 
                case 77: 
                case 99: 
                case 100: {
                    this.StatementExpressionList();
                    break;
                }
                default: {
                    this.jj_la1[106] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        JavaCodingStandardChecker.sCurrentState.mInForInitBlock = false;
    }

    public final void LoopExpression() throws ParseException {
        JavaCodingStandardChecker.sCurrentState.mInLoopExpressionBlock = true;
        this.Expression();
        JavaCodingStandardChecker.sCurrentState.mInLoopExpressionBlock = false;
    }

    public final void StatementExpressionList() throws ParseException {
        this.StatementExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 84: {
                    break;
                }
                default: {
                    this.jj_la1[107] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(84);
            this.StatementExpression();
        }
    }

    public final void ForUpdate() throws ParseException {
        this.StatementExpressionList();
    }

    public final void BreakStatement() throws ParseException {
        this.jj_consume_token(16);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 74: {
                this.jj_consume_token(74);
                break;
            }
            default: {
                this.jj_la1[108] = this.jj_gen;
            }
        }
        this.jj_consume_token(83);
        ++sNCSSCount;
    }

    public final void ContinueStatement() throws ParseException {
        this.jj_consume_token(23);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 74: {
                this.jj_consume_token(74);
                break;
            }
            default: {
                this.jj_la1[109] = this.jj_gen;
            }
        }
        this.jj_consume_token(83);
        ++sNCSSCount;
    }

    public final void ReturnStatement() throws ParseException {
        this.jj_consume_token(49);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: 
            case 17: 
            case 20: 
            case 26: 
            case 29: 
            case 32: 
            case 39: 
            case 41: 
            case 43: 
            case 44: 
            case 50: 
            case 52: 
            case 55: 
            case 59: 
            case 61: 
            case 66: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 77: 
            case 89: 
            case 90: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                this.Expression();
                break;
            }
            default: {
                this.jj_la1[110] = this.jj_gen;
            }
        }
        this.jj_consume_token(83);
        ++sNCSSCount;
        ++sCCNCount;
        sReturn = true;
    }

    public final void ThrowStatement() throws ParseException {
        this.jj_consume_token(56);
        this.Expression();
        this.jj_consume_token(83);
        ++sNCSSCount;
        ++sCCNCount;
    }

    public final void SynchronizedStatement() throws ParseException {
        this.jj_consume_token(54);
        this.jj_consume_token(77);
        this.Expression();
        JavaCodingStandardChecker.resetNewLine();
        this.jj_consume_token(78);
        this.Block();
        ++sNCSSCount;
    }

    public final void TryStatement() throws ParseException {
        Return.FormalParameterReturn fp = null;
        JavaCodingStandardChecker.resetNewLine();
        this.jj_consume_token(60);
        this.Block();
        while (this.jj_2_34(2)) {
            this.jj_consume_token(19);
            this.jj_consume_token(77);
            fp = this.FormalParameter();
            JavaCodingStandardChecker.handleSubclassedCatchBlock(fp.getParameterType(), fp.getParameterName(), this.token.beginLine, this.token.beginColumn);
            this.jj_consume_token(78);
            JavaCodingStandardChecker.resetNewLine();
            this.CatchBlock();
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 31: {
                this.jj_consume_token(31);
                JavaCodingStandardChecker.resetNewLine();
                this.FinallyBlock();
                break;
            }
            default: {
                this.jj_la1[111] = this.jj_gen;
            }
        }
    }

    public final void CatchBlock() throws ParseException {
        int line = 0;
        if (this.jj_2_35(3)) {
            line = this.token.beginLine;
            this.jj_consume_token(79);
            this.jj_consume_token(80);
            JavaCodingStandardChecker.handleEmptyCatchBlock(line, this.token.beginColumn);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 79: {
                    this.Block();
                    break;
                }
                default: {
                    this.jj_la1[112] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        ++sNCSSCount;
        ++sCCNCount;
    }

    public final void FinallyBlock() throws ParseException {
        int line = 0;
        if (this.jj_2_36(3)) {
            line = this.token.beginLine;
            this.jj_consume_token(79);
            this.jj_consume_token(80);
            JavaCodingStandardChecker.handleEmptyFinallyBlock(line, this.token.beginColumn);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 79: {
                    this.Block();
                    break;
                }
                default: {
                    this.jj_la1[113] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        ++sNCSSCount;
    }

    public final void AssertStatement() throws ParseException {
        this.jj_consume_token(65);
        this.Expression();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 92: {
                this.jj_consume_token(92);
                this.Expression();
                break;
            }
            default: {
                this.jj_la1[114] = this.jj_gen;
            }
        }
        this.jj_consume_token(83);
        ++sNCSSCount;
    }

    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_1();
        this.jj_save(0, xla);
        return retval;
    }

    private final boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_2();
        this.jj_save(1, xla);
        return retval;
    }

    private final boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_3();
        this.jj_save(2, xla);
        return retval;
    }

    private final boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_4();
        this.jj_save(3, xla);
        return retval;
    }

    private final boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_5();
        this.jj_save(4, xla);
        return retval;
    }

    private final boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_6();
        this.jj_save(5, xla);
        return retval;
    }

    private final boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_7();
        this.jj_save(6, xla);
        return retval;
    }

    private final boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_8();
        this.jj_save(7, xla);
        return retval;
    }

    private final boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_9();
        this.jj_save(8, xla);
        return retval;
    }

    private final boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_10();
        this.jj_save(9, xla);
        return retval;
    }

    private final boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_11();
        this.jj_save(10, xla);
        return retval;
    }

    private final boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_12();
        this.jj_save(11, xla);
        return retval;
    }

    private final boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_13();
        this.jj_save(12, xla);
        return retval;
    }

    private final boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_14();
        this.jj_save(13, xla);
        return retval;
    }

    private final boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_15();
        this.jj_save(14, xla);
        return retval;
    }

    private final boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_16();
        this.jj_save(15, xla);
        return retval;
    }

    private final boolean jj_2_17(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_17();
        this.jj_save(16, xla);
        return retval;
    }

    private final boolean jj_2_18(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_18();
        this.jj_save(17, xla);
        return retval;
    }

    private final boolean jj_2_19(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_19();
        this.jj_save(18, xla);
        return retval;
    }

    private final boolean jj_2_20(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_20();
        this.jj_save(19, xla);
        return retval;
    }

    private final boolean jj_2_21(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_21();
        this.jj_save(20, xla);
        return retval;
    }

    private final boolean jj_2_22(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_22();
        this.jj_save(21, xla);
        return retval;
    }

    private final boolean jj_2_23(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_23();
        this.jj_save(22, xla);
        return retval;
    }

    private final boolean jj_2_24(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_24();
        this.jj_save(23, xla);
        return retval;
    }

    private final boolean jj_2_25(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_25();
        this.jj_save(24, xla);
        return retval;
    }

    private final boolean jj_2_26(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_26();
        this.jj_save(25, xla);
        return retval;
    }

    private final boolean jj_2_27(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_27();
        this.jj_save(26, xla);
        return retval;
    }

    private final boolean jj_2_28(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_28();
        this.jj_save(27, xla);
        return retval;
    }

    private final boolean jj_2_29(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_29();
        this.jj_save(28, xla);
        return retval;
    }

    private final boolean jj_2_30(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_30();
        this.jj_save(29, xla);
        return retval;
    }

    private final boolean jj_2_31(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_31();
        this.jj_save(30, xla);
        return retval;
    }

    private final boolean jj_2_32(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_32();
        this.jj_save(31, xla);
        return retval;
    }

    private final boolean jj_2_33(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_33();
        this.jj_save(32, xla);
        return retval;
    }

    private final boolean jj_2_34(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_34();
        this.jj_save(33, xla);
        return retval;
    }

    private final boolean jj_2_35(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_35();
        this.jj_save(34, xla);
        return retval;
    }

    private final boolean jj_2_36(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_36();
        this.jj_save(35, xla);
        return retval;
    }

    private final boolean jj_3R_166() {
        if (this.jj_scan_token(70)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_86() {
        if (this.jj_scan_token(47)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_158() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_165()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_166()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_167()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_168()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_169()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_170()) {
                                return true;
                            }
                            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_165() {
        if (this.jj_scan_token(66)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_79() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_72() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_130() {
        if (this.jj_scan_token(48)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_88() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_130()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_131()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_132()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_133()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_134()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_135()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_136()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_137()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_138()) {
                                            return true;
                                        }
                                        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                            return false;
                                        }
                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                        return false;
                                    }
                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                    return false;
                                }
                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_155() {
        if (this.jj_3R_158()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_48() {
        Token xsp;
        block7: {
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_88()) break block7;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        if (this.jj_3R_58()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(74)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(77)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_121() {
        if (this.jj_3R_54()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_6() {
        if (this.jj_3R_48()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_85() {
        if (this.jj_scan_token(48)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_46() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_85()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_86()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_87()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_120() {
        if (this.jj_scan_token(85)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(74)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_5() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_46()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_47()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(77)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_119() {
        if (this.jj_scan_token(81)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_60()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(82)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_78() {
        if (this.jj_scan_token(51)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_45() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_78()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_79()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_80()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_81()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_82()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_83()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_84()) {
                                    return true;
                                }
                                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                    return false;
                                }
                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_154() {
        if (this.jj_scan_token(43)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_4() {
        Token xsp;
        block3: {
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_45()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        if (this.jj_scan_token(40)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_263() {
        if (this.jj_scan_token(83)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_23() {
        if (this.jj_scan_token(85)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_59()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_44() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_71()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_72()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_73()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_74()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_75()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_76()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_77()) {
                                    return true;
                                }
                                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                    return false;
                                }
                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_71() {
        if (this.jj_scan_token(51)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_262() {
        if (this.jj_3R_270()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_3() {
        Token xsp;
        block3: {
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_44()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        if (this.jj_scan_token(21)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_22() {
        if (this.jj_scan_token(85)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(52)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_261() {
        if (this.jj_3R_269()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_21() {
        if (this.jj_scan_token(85)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(55)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_260() {
        if (this.jj_3R_268()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_57() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_21()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_22()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_23()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_119()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_120()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_121()) {
                                return true;
                            }
                            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_153() {
        if (this.jj_scan_token(52)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_20() {
        if (this.jj_3R_58()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(85)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(21)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_259() {
        if (this.jj_3R_267()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_258() {
        if (this.jj_3R_266()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_19() {
        if (this.jj_3R_57()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_2() {
        if (this.jj_3R_43()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_253() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_2()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_258()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_259()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_260()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_261()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_262()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_263()) {
                                    return true;
                                }
                                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                    return false;
                                }
                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_146() {
        if (this.jj_3R_47()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_152() {
        if (this.jj_scan_token(55)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_145() {
        if (this.jj_3R_58()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(85)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(21)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_144() {
        if (this.jj_3R_59()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_143() {
        if (this.jj_scan_token(77)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_60()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(78)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_142() {
        if (this.jj_scan_token(52)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(85)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(74)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_308() {
        if (this.jj_scan_token(64)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_307() {
        if (this.jj_scan_token(46)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_141() {
        if (this.jj_scan_token(55)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_306() {
        if (this.jj_scan_token(47)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_305() {
        if (this.jj_scan_token(48)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_140() {
        if (this.jj_3R_158()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_304() {
        if (this.jj_scan_token(30)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_395() {
        if (this.jj_scan_token(100)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_303() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_151() {
        if (this.jj_scan_token(74)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_302() {
        if (this.jj_scan_token(51)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_280() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_302()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_303()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_304()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_305()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_306()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_307()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_308()) {
                                    return true;
                                }
                                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                    return false;
                                }
                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_107() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_140()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_141()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_142()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_143()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_144()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_145()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_146()) {
                                    return true;
                                }
                                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                    return false;
                                }
                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_266() {
        Token xsp;
        block3: {
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_280()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        if (this.jj_3R_175()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_150() {
        if (this.jj_scan_token(77)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_394() {
        if (this.jj_scan_token(99)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_383() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_394()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_395()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_53() {
        Token xsp;
        block3: {
            if (this.jj_3R_107()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3_19()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_250() {
        if (this.jj_3R_253()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_149() {
        if (this.jj_scan_token(89)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_18() {
        if (this.jj_scan_token(77)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_56()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_245() {
        Token xsp;
        block5: {
            if (this.jj_scan_token(79)) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_250()) break block5;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        if (this.jj_scan_token(80)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_148() {
        if (this.jj_scan_token(90)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_369() {
        if (this.jj_scan_token(77)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_63()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(78)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_301()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_368() {
        if (this.jj_scan_token(77)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_63()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(78)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_265()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_360() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_368()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_369()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_310() {
        if (this.jj_scan_token(36)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_324()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_17() {
        if (this.jj_scan_token(77)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_47()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(81)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_361() {
        if (this.jj_3R_53()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_383()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_309() {
        if (this.jj_scan_token(28)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_47()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_110() {
        if (this.jj_scan_token(77)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_47()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(78)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_148()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_149()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_150()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_151()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_152()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_153()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_154()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_155()) {
                                        return true;
                                    }
                                    if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                        return false;
                                    }
                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                    return false;
                                }
                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_109() {
        if (this.jj_scan_token(77)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_47()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(81)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(82)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_16() {
        if (this.jj_scan_token(77)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_56()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_55() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_16()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_109()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_110()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_15() {
        if (this.jj_3R_55()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_359() {
        if (this.jj_scan_token(89)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_69() {
        if (this.jj_scan_token(64)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_349() {
        if (this.jj_3R_361()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_358() {
        if (this.jj_scan_token(90)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_348() {
        if (this.jj_3R_360()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_175() {
        if (this.jj_scan_token(21)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(74)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_309()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_310()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_245()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_347() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_358()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_359()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_265()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_301() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_347()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_348()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_349()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_68() {
        if (this.jj_scan_token(48)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_239() {
        if (this.jj_scan_token(100)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_53()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_238() {
        if (this.jj_scan_token(99)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_53()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_67() {
        if (this.jj_scan_token(30)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_300() {
        if (this.jj_scan_token(102)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_357() {
        if (this.jj_scan_token(108)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_279() {
        if (this.jj_3R_301()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_278() {
        if (this.jj_3R_239()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_299() {
        if (this.jj_scan_token(101)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_277() {
        if (this.jj_3R_238()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_356() {
        if (this.jj_scan_token(104)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_265() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_276()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_277()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_278()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_279()) {
                        return true;
                    }
                    if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_276() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_299()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_300()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_265()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_42() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_66()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_67()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_68()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_69()) {
                        return true;
                    }
                    if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_66() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_355() {
        if (this.jj_scan_token(103)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_1() {
        Token xsp;
        block3: {
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_42()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        if (this.jj_scan_token(21)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_344() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_355()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_356()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_357()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_265()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_346() {
        if (this.jj_scan_token(102)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_257() {
        Token xsp;
        block3: {
            if (this.jj_3R_265()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_344()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_298() {
        if (this.jj_scan_token(111)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_345() {
        if (this.jj_scan_token(101)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_295() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_345()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_346()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_257()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_297() {
        if (this.jj_scan_token(110)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_275() {
        if (this.jj_scan_token(95)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_252() {
        Token xsp;
        block3: {
            if (this.jj_3R_257()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_295()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_296() {
        if (this.jj_scan_token(109)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_274() {
        if (this.jj_scan_token(94)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_271() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_296()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_297()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_298()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_252()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_247() {
        Token xsp;
        block3: {
            if (this.jj_3R_252()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_271()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_273() {
        if (this.jj_scan_token(87)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_272() {
        if (this.jj_scan_token(88)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_264() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_272()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_273()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_274()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_275()) {
                        return true;
                    }
                    if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_247()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_243() {
        Token xsp;
        block3: {
            if (this.jj_3R_247()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_264()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_254() {
        if (this.jj_scan_token(38)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_63()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_256() {
        if (this.jj_scan_token(96)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_237() {
        if (this.jj_3R_243()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_254()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_255() {
        if (this.jj_scan_token(93)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_251() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_255()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_256()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_237()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_229() {
        Token xsp;
        block3: {
            if (this.jj_3R_237()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_251()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_246() {
        if (this.jj_scan_token(105)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_229()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_213() {
        Token xsp;
        block3: {
            if (this.jj_3R_229()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_246()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_242() {
        if (this.jj_scan_token(107)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_213()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_181() {
        Token xsp;
        block3: {
            if (this.jj_3R_213()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_242()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_236() {
        if (this.jj_scan_token(106)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_181()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_172() {
        Token xsp;
        block3: {
            if (this.jj_3R_181()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_236()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_228() {
        if (this.jj_scan_token(98)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_172()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_160() {
        Token xsp;
        block3: {
            if (this.jj_3R_172()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_228()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_200() {
        if (this.jj_scan_token(97)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_160()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_156() {
        Token xsp;
        block3: {
            if (this.jj_3R_160()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_200()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_179() {
        if (this.jj_scan_token(91)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_60()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(92)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_125()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_125() {
        if (this.jj_3R_156()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_179()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_212() {
        if (this.jj_scan_token(117)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_211() {
        if (this.jj_scan_token(118)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_210() {
        if (this.jj_scan_token(116)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_209() {
        if (this.jj_scan_token(122)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_208() {
        if (this.jj_scan_token(121)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_207() {
        if (this.jj_scan_token(120)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_206() {
        if (this.jj_scan_token(113)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_205() {
        if (this.jj_scan_token(112)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_204() {
        if (this.jj_scan_token(119)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_203() {
        if (this.jj_scan_token(115)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_202() {
        if (this.jj_scan_token(114)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_180() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_201()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_202()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_203()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_204()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_205()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_206()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_207()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_208()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_209()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_210()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3R_211()) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_3R_212()) {
                                                        return true;
                                                    }
                                                    if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                        return false;
                                                    }
                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                    return false;
                                                }
                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                return false;
                                            }
                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                            return false;
                                        }
                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                        return false;
                                    }
                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                    return false;
                                }
                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_201() {
        if (this.jj_scan_token(86)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_171() {
        if (this.jj_3R_180()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_60()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_60() {
        if (this.jj_3R_125()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_171()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_382() {
        if (this.jj_scan_token(92)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_60()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_353() {
        if (this.jj_scan_token(84)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_47()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_324() {
        Token xsp;
        block3: {
            if (this.jj_3R_47()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_353()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_227() {
        if (this.jj_scan_token(65)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_60()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_382()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(83)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_405() {
        if (this.jj_3R_64()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_14() {
        if (this.jj_scan_token(85)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(74)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_36() {
        if (this.jj_scan_token(79)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(80)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_393() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_36()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_405()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_47() {
        Token xsp;
        block3: {
            if (this.jj_scan_token(74)) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3_14()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_404() {
        if (this.jj_3R_64()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_35() {
        if (this.jj_scan_token(79)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(80)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_123() {
        if (this.jj_3R_63()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_392() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_35()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_404()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_122() {
        if (this.jj_scan_token(61)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_58() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_122()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_123()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_381() {
        if (this.jj_scan_token(31)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_393()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_34() {
        if (this.jj_scan_token(19)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(77)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_351()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(78)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_392()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_118() {
        if (this.jj_scan_token(26)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_117() {
        if (this.jj_scan_token(32)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_226() {
        Token xsp;
        block8: {
            if (this.jj_scan_token(60)) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            if (this.jj_3R_64()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3_34()) break block8;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        xsp = this.jj_scanpos;
        if (this.jj_3R_381()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_116() {
        if (this.jj_scan_token(41)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_115() {
        if (this.jj_scan_token(39)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_114() {
        if (this.jj_scan_token(50)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_113() {
        if (this.jj_scan_token(17)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_112() {
        if (this.jj_scan_token(20)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_111() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_225() {
        if (this.jj_scan_token(54)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(77)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_60()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(78)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_64()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_56() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_111()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_112()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_113()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_114()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_115()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_116()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_117()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_118()) {
                                        return true;
                                    }
                                    if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                        return false;
                                    }
                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                    return false;
                                }
                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_380() {
        if (this.jj_3R_60()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_128() {
        if (this.jj_scan_token(81)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(82)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_224() {
        if (this.jj_scan_token(56)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_60()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(83)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_379() {
        if (this.jj_scan_token(74)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_127() {
        if (this.jj_3R_47()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_126() {
        if (this.jj_3R_56()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_63() {
        Token xsp;
        block6: {
            xsp = this.jj_scanpos;
            if (this.jj_3R_126()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_127()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_128()) break block6;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_223() {
        if (this.jj_scan_token(49)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_380()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(83)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_406() {
        if (this.jj_scan_token(84)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_215()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_378() {
        if (this.jj_scan_token(74)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_222() {
        if (this.jj_scan_token(23)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_379()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(83)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_377() {
        if (this.jj_3R_391()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_70() {
        if (this.jj_scan_token(51)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_221() {
        if (this.jj_scan_token(16)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_378()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(83)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_13() {
        if (this.jj_scan_token(55)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_54()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(83)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_43() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_70()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_64()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_391() {
        if (this.jj_3R_403()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_12() {
        if (this.jj_3R_53()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(85)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_106() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_12()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(52)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_54()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(83)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_403() {
        Token xsp;
        block3: {
            if (this.jj_3R_215()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_406()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_105() {
        if (this.jj_scan_token(55)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_54()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(83)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_52() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_105()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_106()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_11() {
        if (this.jj_3R_52()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_65() {
        if (this.jj_scan_token(30)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_374() {
        if (this.jj_3R_60()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_33() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_65()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_63()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(74)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_376() {
        if (this.jj_3R_374()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_286() {
        if (this.jj_3R_157()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_285() {
        if (this.jj_3R_52()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_402() {
        if (this.jj_3R_403()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_401() {
        if (this.jj_3R_173()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_284() {
        if (this.jj_scan_token(57)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_324()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_390() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_401()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_402()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_375() {
        if (this.jj_3R_390()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_220() {
        if (this.jj_scan_token(33)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(77)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_375()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(83)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_376()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(83)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_377()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(78)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_372()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_322() {
        if (this.jj_scan_token(46)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_321() {
        if (this.jj_scan_token(47)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_219() {
        if (this.jj_scan_token(25)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_174()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(63)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(77)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_374()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(78)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(83)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_320() {
        if (this.jj_scan_token(48)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_282() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_320()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_321()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_322()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_268() {
        Token xsp;
        block18: {
            xsp = this.jj_scanpos;
            if (this.jj_3R_282()) {
                this.jj_scanpos = xsp;
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            if (this.jj_scan_token(74)) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            if (this.jj_3R_283()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            xsp = this.jj_scanpos;
            if (this.jj_3R_284()) {
                this.jj_scanpos = xsp;
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            if (this.jj_scan_token(79)) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            xsp = this.jj_scanpos;
            if (this.jj_3R_285()) {
                this.jj_scanpos = xsp;
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_286()) break block18;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        if (this.jj_scan_token(80)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_31() {
        if (this.jj_scan_token(35)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_218() {
        if (this.jj_scan_token(63)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(77)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_374()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(78)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_372()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_32() {
        if (this.jj_scan_token(27)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_334() {
        if (this.jj_scan_token(81)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(82)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_389() {
        if (this.jj_3R_372()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_388() {
        if (this.jj_3R_217()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_367() {
        if (this.jj_scan_token(30)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_373() {
        if (this.jj_scan_token(27)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_388()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_389()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_351() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_367()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_63()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_342()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_217() {
        if (this.jj_scan_token(35)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(77)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_60()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(78)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_372()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_373()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_352() {
        if (this.jj_scan_token(84)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_351()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_323() {
        Token xsp;
        block3: {
            if (this.jj_3R_351()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_352()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_283() {
        if (this.jj_scan_token(77)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_323()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(78)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_386() {
        if (this.jj_3R_157()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_387() {
        if (this.jj_3R_174()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_372() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_30()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_387()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_30() {
        if (this.jj_3R_64()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_249() {
        if (this.jj_scan_token(84)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_288() {
        Token xsp;
        block5: {
            if (this.jj_scan_token(74)) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            if (this.jj_3R_283()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_334()) break block5;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_400() {
        if (this.jj_scan_token(24)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(92)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_399() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_60()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(92)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_291() {
        if (this.jj_scan_token(83)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_385() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_399()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_400()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_371() {
        Token xsp;
        block3: {
            if (this.jj_3R_385()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_386()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_290() {
        if (this.jj_3R_64()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_289() {
        if (this.jj_scan_token(57)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_324()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_216() {
        Token xsp;
        block13: {
            if (this.jj_scan_token(53)) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            if (this.jj_scan_token(77)) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            if (this.jj_3R_60()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            if (this.jj_scan_token(78)) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            if (this.jj_scan_token(79)) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_371()) break block13;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        if (this.jj_scan_token(80)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_398() {
        if (this.jj_3R_180()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_60()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_397() {
        if (this.jj_scan_token(100)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_333() {
        if (this.jj_scan_token(64)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_332() {
        if (this.jj_scan_token(54)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_396() {
        if (this.jj_scan_token(99)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_384() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_396()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_397()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_398()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_331() {
        if (this.jj_scan_token(42)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_10() {
        if (this.jj_scan_token(84)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_51()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_330() {
        if (this.jj_scan_token(30)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_329() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_328() {
        if (this.jj_scan_token(51)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_327() {
        if (this.jj_scan_token(46)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_232() {
        if (this.jj_3R_53()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_384()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_326() {
        if (this.jj_scan_token(47)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_325() {
        if (this.jj_scan_token(48)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_287() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_325()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_326()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_327()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_328()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_329()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_330()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_331()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_332()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_333()) {
                                            return true;
                                        }
                                        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                            return false;
                                        }
                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                        return false;
                                    }
                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                    return false;
                                }
                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_231() {
        if (this.jj_3R_239()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_215() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_230()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_231()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_232()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_230() {
        if (this.jj_3R_238()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_269() {
        Token xsp;
        block13: {
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_287()) break block13;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        if (this.jj_3R_58()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_288()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_289()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_290()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_291()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_214() {
        if (this.jj_scan_token(83)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_248() {
        Token xsp;
        block3: {
            if (this.jj_3R_51()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3_10()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_370() {
        if (this.jj_scan_token(84)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_293()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_139() {
        if (this.jj_scan_token(79)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_248()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_249()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(80)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_182() {
        if (this.jj_scan_token(30)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_173() {
        Token xsp;
        block8: {
            xsp = this.jj_scanpos;
            if (this.jj_3R_182()) {
                this.jj_scanpos = xsp;
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            if (this.jj_3R_63()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            if (this.jj_3R_293()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_370()) break block8;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_104() {
        if (this.jj_3R_60()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_103() {
        if (this.jj_3R_139()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_51() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_103()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_104()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_62() {
        if (this.jj_scan_token(30)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_102() {
        if (this.jj_scan_token(64)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_29() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_62()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_63()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(74)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_95() {
        if (this.jj_scan_token(64)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_164() {
        if (this.jj_3R_176()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_354() {
        if (this.jj_scan_token(81)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(82)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_163() {
        if (this.jj_3R_175()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_162() {
        if (this.jj_3R_174()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_157() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_161()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_162()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_163()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_164()) {
                        return true;
                    }
                    if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_161() {
        if (this.jj_3R_173()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(83)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_342() {
        Token xsp;
        block3: {
            if (this.jj_scan_token(74)) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_354()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_101() {
        if (this.jj_scan_token(46)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_94() {
        if (this.jj_scan_token(46)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_129() {
        if (this.jj_3R_157()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_64() {
        Token xsp;
        block5: {
            if (this.jj_scan_token(79)) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_129()) break block5;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        if (this.jj_scan_token(80)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_343() {
        if (this.jj_scan_token(86)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_51()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_293() {
        if (this.jj_3R_342()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_343()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_100() {
        if (this.jj_scan_token(47)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_93() {
        if (this.jj_scan_token(47)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_61() {
        if (this.jj_scan_token(74)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(92)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_174()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_99() {
        if (this.jj_scan_token(48)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_294() {
        if (this.jj_scan_token(84)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_293()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_197() {
        if (this.jj_3R_227()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_92() {
        if (this.jj_scan_token(48)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_26() {
        if (this.jj_scan_token(81)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(82)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_196() {
        if (this.jj_3R_226()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_195() {
        if (this.jj_3R_225()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_194() {
        if (this.jj_3R_224()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_98() {
        if (this.jj_scan_token(30)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_193() {
        if (this.jj_3R_223()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_192() {
        if (this.jj_3R_222()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_91() {
        if (this.jj_scan_token(30)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_191() {
        if (this.jj_3R_221()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_190() {
        if (this.jj_3R_220()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_341() {
        if (this.jj_scan_token(62)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_340() {
        if (this.jj_scan_token(58)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_189() {
        if (this.jj_3R_219()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_339() {
        if (this.jj_scan_token(30)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_338() {
        if (this.jj_scan_token(51)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_188() {
        if (this.jj_3R_218()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_337() {
        if (this.jj_scan_token(46)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_336() {
        if (this.jj_scan_token(47)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_187() {
        if (this.jj_3R_217()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_335() {
        if (this.jj_scan_token(48)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_97() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_292() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_335()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_336()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_337()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_338()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_339()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_340()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_341()) {
                                    return true;
                                }
                                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                    return false;
                                }
                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_186() {
        if (this.jj_3R_216()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_90() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_185() {
        if (this.jj_3R_215()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(83)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_270() {
        Token xsp;
        block9: {
            block8: {
                do {
                    xsp = this.jj_scanpos;
                    if (this.jj_3R_292()) break block8;
                } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
                return false;
            }
            this.jj_scanpos = xsp;
            if (this.jj_3R_63()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            if (this.jj_3R_293()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_294()) break block9;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        if (this.jj_scan_token(83)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_184() {
        if (this.jj_3R_214()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_138() {
        if (this.jj_scan_token(64)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_183() {
        if (this.jj_3R_64()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_9() {
        if (this.jj_3R_48()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_28() {
        if (this.jj_3R_61()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_174() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_28()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_183()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_184()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_185()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_186()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_187()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_188()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_189()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_190()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_191()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3R_192()) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_3R_193()) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_3R_194()) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_3R_195()) {
                                                                this.jj_scanpos = xsp;
                                                                if (this.jj_3R_196()) {
                                                                    this.jj_scanpos = xsp;
                                                                    if (this.jj_3R_197()) {
                                                                        return true;
                                                                    }
                                                                    if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                        return false;
                                                                    }
                                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                    return false;
                                                                }
                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                return false;
                                                            }
                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                            return false;
                                                        }
                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                        return false;
                                                    }
                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                    return false;
                                                }
                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                return false;
                                            }
                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                            return false;
                                        }
                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                        return false;
                                    }
                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                    return false;
                                }
                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_96() {
        if (this.jj_scan_token(51)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_50() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_96()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_97()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_98()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_99()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_100()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_101()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_102()) {
                                    return true;
                                }
                                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                    return false;
                                }
                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_8() {
        Token xsp;
        block3: {
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_50()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        if (this.jj_scan_token(40)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_366() {
        if (this.jj_scan_token(83)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_89() {
        if (this.jj_scan_token(51)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_49() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_89()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_90()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_91()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_92()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_93()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_94()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_95()) {
                                    return true;
                                }
                                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                    return false;
                                }
                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_7() {
        Token xsp;
        block3: {
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_49()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        if (this.jj_scan_token(21)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_365() {
        if (this.jj_3R_270()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_244() {
        if (this.jj_scan_token(81)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(82)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_364() {
        if (this.jj_3R_269()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_25() {
        if (this.jj_scan_token(81)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_60()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(82)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_240() {
        Token xsp;
        block5: {
            if (this.jj_3R_244()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_244()) break block5;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        if (this.jj_3R_139()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_363() {
        if (this.jj_3R_267()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_137() {
        if (this.jj_scan_token(54)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_27() {
        Token xsp;
        block5: {
            block4: {
                if (this.jj_3_25()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
                do {
                    xsp = this.jj_scanpos;
                    if (this.jj_3_25()) break block4;
                } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
                return false;
            }
            this.jj_scanpos = xsp;
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3_26()) break block5;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_233() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_27()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_240()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_362() {
        if (this.jj_3R_266()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_350() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_362()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_363()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_364()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_365()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_366()) {
                            return true;
                        }
                        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_136() {
        if (this.jj_scan_token(42)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_319() {
        if (this.jj_3R_350()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_318() {
        if (this.jj_scan_token(28)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_324()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_241() {
        if (this.jj_3R_245()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_84() {
        if (this.jj_scan_token(64)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_135() {
        if (this.jj_scan_token(30)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_77() {
        if (this.jj_scan_token(64)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_235() {
        if (this.jj_3R_54()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_241()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_159() {
        if (this.jj_scan_token(84)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_60()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_234() {
        if (this.jj_3R_233()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_124() {
        if (this.jj_scan_token(43)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_47()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_234()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_235()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_83() {
        if (this.jj_scan_token(46)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_24() {
        if (this.jj_scan_token(43)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_56()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_233()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_59() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_24()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_124()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_176() {
        Token xsp;
        block12: {
            if (this.jj_scan_token(40)) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            if (this.jj_scan_token(74)) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            xsp = this.jj_scanpos;
            if (this.jj_3R_318()) {
                this.jj_scanpos = xsp;
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            if (this.jj_scan_token(79)) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_319()) break block12;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        if (this.jj_scan_token(80)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_76() {
        if (this.jj_scan_token(46)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_134() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_147() {
        Token xsp;
        block3: {
            if (this.jj_3R_60()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_159()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_108() {
        if (this.jj_3R_147()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_317() {
        if (this.jj_scan_token(64)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_316() {
        if (this.jj_scan_token(46)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_315() {
        if (this.jj_scan_token(47)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_82() {
        if (this.jj_scan_token(47)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_54() {
        if (this.jj_scan_token(77)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_108()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(78)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_314() {
        if (this.jj_scan_token(48)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_133() {
        if (this.jj_scan_token(51)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_313() {
        if (this.jj_scan_token(30)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_312() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_75() {
        if (this.jj_scan_token(47)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_311() {
        if (this.jj_scan_token(51)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_281() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_311()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_312()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_313()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_314()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_315()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_316()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_317()) {
                                    return true;
                                }
                                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                    return false;
                                }
                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_178() {
        if (this.jj_scan_token(44)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_267() {
        Token xsp;
        block3: {
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_281()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        if (this.jj_3R_176()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_81() {
        if (this.jj_scan_token(48)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_199() {
        if (this.jj_scan_token(29)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_132() {
        if (this.jj_scan_token(46)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_74() {
        if (this.jj_scan_token(48)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_177() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_198()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_199()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_198() {
        if (this.jj_scan_token(59)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_87() {
        if (this.jj_scan_token(46)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_170() {
        if (this.jj_3R_178()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_80() {
        if (this.jj_scan_token(30)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_169() {
        if (this.jj_3R_177()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_73() {
        if (this.jj_scan_token(30)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_168() {
        if (this.jj_scan_token(73)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_131() {
        if (this.jj_scan_token(47)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_167() {
        if (this.jj_scan_token(72)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    public JavaCodingStandardChecker(InputStream stream) {
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new JavaCodingStandardCheckerTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 115) {
            this.jj_la1[i] = -1;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[i2] = new JJCalls();
            ++i2;
        }
    }

    public void ReInit(InputStream stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 115) {
            this.jj_la1[i] = -1;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[i2] = new JJCalls();
            ++i2;
        }
    }

    public JavaCodingStandardChecker(Reader stream) {
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new JavaCodingStandardCheckerTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 115) {
            this.jj_la1[i] = -1;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[i2] = new JJCalls();
            ++i2;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 115) {
            this.jj_la1[i] = -1;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[i2] = new JJCalls();
            ++i2;
        }
    }

    public JavaCodingStandardChecker(JavaCodingStandardCheckerTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 115) {
            this.jj_la1[i] = -1;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[i2] = new JJCalls();
            ++i2;
        }
    }

    public void ReInit(JavaCodingStandardCheckerTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 115) {
            this.jj_la1[i] = -1;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[i2] = new JJCalls();
            ++i2;
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                int i = 0;
                while (i < this.jj_2_rtns.length) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                    ++i;
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        return this.jj_scanpos.kind != kind;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        int i = 0;
        while (i < index) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
            ++i;
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            int i = 0;
            while (i < this.jj_endpos) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
                ++i;
            }
            boolean exists = false;
            Enumeration enumeration = this.jj_expentries.elements();
            while (enumeration.hasMoreElements()) {
                int[] oldentry = (int[])enumeration.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                int i2 = 0;
                while (i2 < this.jj_expentry.length) {
                    if (oldentry[i2] != this.jj_expentry[i2]) {
                        exists = false;
                        break;
                    }
                    ++i2;
                }
                if (exists) break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public final ParseException generateParseException() {
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[123];
        int i = 0;
        while (i < 123) {
            la1tokens[i] = false;
            ++i;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        int i2 = 0;
        while (i2 < 115) {
            if (this.jj_la1[i2] == this.jj_gen) {
                int j = 0;
                while (j < 32) {
                    if ((this.jj_la1_0[i2] & 1 << j) != 0) {
                        la1tokens[j] = true;
                    }
                    if ((this.jj_la1_1[i2] & 1 << j) != 0) {
                        la1tokens[32 + j] = true;
                    }
                    if ((this.jj_la1_2[i2] & 1 << j) != 0) {
                        la1tokens[64 + j] = true;
                    }
                    if ((this.jj_la1_3[i2] & 1 << j) != 0) {
                        la1tokens[96 + j] = true;
                    }
                    ++j;
                }
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < 123) {
            if (la1tokens[i3]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = i3;
                this.jj_expentries.addElement(this.jj_expentry);
            }
            ++i3;
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        int i4 = 0;
        while (i4 < this.jj_expentries.size()) {
            exptokseq[i4] = (int[])this.jj_expentries.elementAt(i4);
            ++i4;
        }
        return new ParseException(this.token, exptokseq, JavaCodingStandardCheckerConstants.tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        int i = 0;
        while (i < 36) {
            JJCalls p = this.jj_2_rtns[i];
            do {
                if (p.gen <= this.jj_gen) continue;
                this.jj_la = p.arg;
                this.jj_lastpos = this.jj_scanpos = p.first;
                switch (i) {
                    case 0: {
                        this.jj_3_1();
                        break;
                    }
                    case 1: {
                        this.jj_3_2();
                        break;
                    }
                    case 2: {
                        this.jj_3_3();
                        break;
                    }
                    case 3: {
                        this.jj_3_4();
                        break;
                    }
                    case 4: {
                        this.jj_3_5();
                        break;
                    }
                    case 5: {
                        this.jj_3_6();
                        break;
                    }
                    case 6: {
                        this.jj_3_7();
                        break;
                    }
                    case 7: {
                        this.jj_3_8();
                        break;
                    }
                    case 8: {
                        this.jj_3_9();
                        break;
                    }
                    case 9: {
                        this.jj_3_10();
                        break;
                    }
                    case 10: {
                        this.jj_3_11();
                        break;
                    }
                    case 11: {
                        this.jj_3_12();
                        break;
                    }
                    case 12: {
                        this.jj_3_13();
                        break;
                    }
                    case 13: {
                        this.jj_3_14();
                        break;
                    }
                    case 14: {
                        this.jj_3_15();
                        break;
                    }
                    case 15: {
                        this.jj_3_16();
                        break;
                    }
                    case 16: {
                        this.jj_3_17();
                        break;
                    }
                    case 17: {
                        this.jj_3_18();
                        break;
                    }
                    case 18: {
                        this.jj_3_19();
                        break;
                    }
                    case 19: {
                        this.jj_3_20();
                        break;
                    }
                    case 20: {
                        this.jj_3_21();
                        break;
                    }
                    case 21: {
                        this.jj_3_22();
                        break;
                    }
                    case 22: {
                        this.jj_3_23();
                        break;
                    }
                    case 23: {
                        this.jj_3_24();
                        break;
                    }
                    case 24: {
                        this.jj_3_25();
                        break;
                    }
                    case 25: {
                        this.jj_3_26();
                        break;
                    }
                    case 26: {
                        this.jj_3_27();
                        break;
                    }
                    case 27: {
                        this.jj_3_28();
                        break;
                    }
                    case 28: {
                        this.jj_3_29();
                        break;
                    }
                    case 29: {
                        this.jj_3_30();
                        break;
                    }
                    case 30: {
                        this.jj_3_31();
                        break;
                    }
                    case 31: {
                        this.jj_3_32();
                        break;
                    }
                    case 32: {
                        this.jj_3_33();
                        break;
                    }
                    case 33: {
                        this.jj_3_34();
                        break;
                    }
                    case 34: {
                        this.jj_3_35();
                        break;
                    }
                    case 35: {
                        this.jj_3_36();
                    }
                }
            } while ((p = p.next) != null);
            ++i;
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        sAuthors = new ArrayList();
        sViolations = new ArrayList();
        sMethodMetrics = new ArrayList();
        sJVMVersion = null;
        sLastJavaDoc = "";
        sLastComment = new StringBuffer();
        sReturn = false;
        sNewLine = false;
        sLineCount = 0;
        sSavedStates = new Stack();
        sCurrentState = null;
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    class CurrentState {
        boolean isInterface = false;
        boolean isClass = false;
        boolean isAbstractClass = false;
        boolean isAnonymousClass = false;
        int mFieldBlockPlace = 0;
        int mMethodBlockPlace = 0;
        int mNestedTypeBlockPlace = 0;
        boolean mHasHandledPubFieldDeclararion = false;
        boolean mHasHandledProFieldDeclararion = false;
        boolean mHasHandledPacFieldDeclararion = false;
        boolean mHasHandledPriFieldDeclararion = false;
        boolean mHasHandledStatFinFieldDeclaration = false;
        boolean mHasHandledStatFieldDeclaration = false;
        boolean mHasHandledInsFieldDeclaration = false;
        boolean mHasHandledPubMethodDeclararion = false;
        boolean mHasHandledProMethodDeclararion = false;
        boolean mHasHandledPacMethodDeclararion = false;
        boolean mHasHandledPriMethodDeclararion = false;
        boolean mHasHandledCtorMethodDeclaration = false;
        boolean mHasHandledInsMethodDeclaration = false;
        boolean mHasHandledStatMethodDeclaration = false;
        boolean mHasHandledStaticInitializer = false;
        boolean mHasHandledFieldDeclaration = false;
        boolean mHasHandledMethodDeclaration = false;
        boolean mHasHandledNestedTypeDeclaration = false;
        boolean mInNoAssignmentExpression = false;
        boolean mInFieldDeclaration = false;
        boolean mInForInitBlock = false;
        boolean mInLoopExpressionBlock = false;
        String mName = null;

        CurrentState() {
        }

        String type() {
            if (this.isInterface) {
                return "interface";
            }
            if (this.isClass) {
                return "class";
            }
            if (this.isAbstractClass) {
                return "abstract class";
            }
            return "";
        }
    }
}

