package TestUtilities;

/* Class Name           : TestSupport
* Version information   : Version 0.1
* Date                  : 07/02/1999
* Copyright Notice      : see below
* Edit history:
*   09 Jan 2000     Tom VanCourt    Initial coding.
*/

/*
    Copyright (C) 2000 Eric J. Braude and Thomas D. Van Court. 
 
    This program is the implementation of the case study specified in 
    "Software Engineering: an Object-Oriented Perspective," Wiley 2001,   
    by Eric J. Braude.

    The program is free software; you can redistribute it and/or modify it 
    under the terms of the GNU General Public License as published by the 
    Free Software Foundation; either version 2 of the License, or any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    For the GNU General Public License, see http://www.gnu.org/copyleft/gpl.txt 
    or write to the Free Software Foundation, Inc., 
    59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Eric Braude can be reached at ebraude@bu.edu and: Boston University,       
    MET Computer Science Department, 808 Commonwealth Avenue, Boston, MA 02215. 
    Tom Van Court can be reached at tvancour@hotmail.com
*/

import java.io.*;

/** This class contains support functions that help client classes use the 
* TestDriver test control program
*
* @author   Tom VanCourt
* @version  0.1
*/

public class TestSupport
{
    /*----------------------------------------------------------------------*\
    ** Published interface 
    ** The following may be used by selfTest methods in client classes.
    \*----------------------------------------------------------------------*/
    
    /** Use at least this much indentation for each test case's output. */
    public static final String INDENT_MESSAGE = "     ";
    
    /** Selftest may print a one-line message to indicate success of all 
    * test cases. The success message should start with this string.
    */
    public static final String OK_MESSAGE = INDENT_MESSAGE + "OK";
    
    /** If a non-failing test needs to generate output, precede 
    * the output with a line that starts with "NOTE". 
    */    
    public static final String NOTE_MESSAGE = INDENT_MESSAGE + "NOTE";
    
    /** If a non-failing test needs to generate output, follow 
    * the output with a line that starts with "ENDNOTE". 
    */    
    public static final String ENDNOTE_MESSAGE = INDENT_MESSAGE + "ENDNOTE";
    
    /** Output file for test results. */
    private static PrintStream outputS = System.out;
    
    /** If the expected value doesn't match the actual, generate
    * an output message describing the discrepancy.
    *
    * @param    msgP        Text describing test.
    * @param    expectedP   The answer that was expected.
    * @param    actualP     The actual answer.
    * @return               <tt>true</tt> iff the actual matched the expected.
    */
    public static boolean matchResult(String msgP,
        String expectedP, String actualP)
    {
        if (!expectedP.equals(actualP)) {
            outputS.println(INDENT_MESSAGE + msgP + 
                "expected: \"" + expectedP + 
                "\", actual: \"" + actualP + "\"");
                
            return false;
        }
        return true;
    }
    
    /** If the expected value doesn't match the actual, generate
    * an output message describing the discrepancy.
    *
    * @param    msgP        Text describing test.
    * @param    expectedP   The answer that was expected.
    * @param    actualP     The actual answer.
    * @return               <tt>true</tt> iff the actual matched the expected.
    */
    public static boolean matchResult(String msgP,
        long expectedP, long actualP)
    {
        if (expectedP != actualP) {
            outputS.println(INDENT_MESSAGE + msgP + 
                "expected: \"" + expectedP + 
                "\", actual: \"" + actualP + "\"");
                
            return false;
        }       
        return true;
    }
    
    /** Set the log file to use for output.
    *
    * @param    logP        New output file.
    *                       If null, close the file and revert
    *                       to stdOut.
    */
    public static void setLog(PrintStream logP)
    {
        outputS.flush();
        if (outputS != System.out)      // Unless it's stdout, 
            outputS.close();            //  close the output file.
            
        if (logP == null)               // If no valid file is given,
            outputS = System.out;       //  revert to stdout.
        else
            outputS = logP;             // Otherwise use the given file.
    }
    
    /** Set the log file to use for output.
    *
    * @param    logNameP    String name of new output file.
    *                       If null, close the file and revert
    *                       to stdOut.
    */
    public static void setLog(String logNameP)
    {
        outputS.flush();
        if (outputS != System.out)      // Unless it's stdout, 
            outputS.close();            //  close the output file.
            
        outputS = System.out;           // Use stdout while new file opens.
        
        if (logNameP == null)           // Null name means stdout
            return;                     //  by default. 
                
        try {
            // The assignment never happens if the file-open fails.
            outputS = new PrintStream(new FileOutputStream(logNameP));
        } catch (IOException ioex) {
            // Print file name, exception type, exception message. 
            outputS.println("Problem opening "+ logNameP + ":"
                + ioex.getClass().getName() + " " + ioex.getMessage() );
        }
    }
    
}
