/* Class Name           : TestDriver
*  Version information  : Version 0.1
*  Date                 : 02/11/2000
*  Copyright Notice     : see below
*  Edit history:
*   18 Feb 2000     Tom VanCourt    Initial coding.
*/


/*
    Copyright (C) 2000 Eric J. Braude and Thomas D. Van Court. 
 
    This program is the implementation of the case study specified in 
    "Software Engineering: an Object-Oriented Perspective," Wiley 2001,   
    by Eric J. Braude.

    The program is free software; you can redistribute it and/or modify it 
    under the terms of the GNU General Public License as published by the 
    Free Software Foundation; either version 2 of the License, or any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    For the GNU General Public License, see http://www.gnu.org/copyleft/gpl.txt 
    or write to the Free Software Foundation, Inc., 
    59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Eric Braude can be reached at ebraude@bu.edu and: Boston University,       
    MET Computer Science Department, 808 Commonwealth Avenue, Boston, MA 02215. 
    Tom Van Court can be reached at tvancour@hotmail.com
*/


import TestUtilities.TestExecution;

/** Not elegant, but it runs tests for all registered classes.
* This is organized as a TestDriver class in every package. Each TestDriver
* works fine as a standalone program. It can also be called from a higher
* level, though. Putting one test driver in each package allows proper
* class scoping. Classes under test don't have to be made abnormally public
* just so the test entry points are visible.
*
* <p> This test driver, in the default package, is the root of the tree
* of test driver programs.
*
* @author   Tom VanCourt
* @version  0.1
*/

public class TestDriver
{
    // Inspected 17 Feb 2000
    /** To test all registered classes.
    *   @param  argsP   One string: file name for test log. 
    *                   Use default log file if no name provided.
    */
    public static void main( String[] argsP ) 
    {
        boolean openedM = false;                    // Assume no log file.
        
        if ( argsP != null && argsP.length > 0 ) {  // If log file is specified, 
            TestExecution.openTestLog( argsP[0] );  // then open it.
            openedM = true;
        }
        
        Encounter.TestDriver.main( null );
        FrameworkRPG.TestDriver.main( null );
    
        if ( openedM )                              // If we opened a file,
            TestExecution.closeTestLog();           // close it. 
    } 
}
