package FrameworkRPG.RolePlayingGame;

/* Class Name           : RPGame
* Version information   : Version 0.1
* Date                  : 07/02/1999
* Copyright Notice      : see below
* Edit history:
*   13 May 2000     Tom VanCourt    Added clean exit from previous state
*   08 Jan 2000     Tom VanCourt    Change to meet coding standards.
*/

/*
    Copyright (C) 2000 Eric J. Braude and Thomas D. Van Court. 
 
    This program is the implementation of the case study specified in 
    "Software Engineering: an Object-Oriented Perspective," Wiley 2001,   
    by Eric J. Braude.

    The program is free software; you can redistribute it and/or modify it 
    under the terms of the GNU General Public License as published by the 
    Free Software Foundation; either version 2 of the License, or any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    For the GNU General Public License, see http://www.gnu.org/copyleft/gpl.txt 
    or write to the Free Software Foundation, Inc., 
    59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Eric Braude can be reached at ebraude@bu.edu and: Boston University,       
    MET Computer Science Department, 808 Commonwealth Avenue, Boston, MA 02215. 
    Tom Van Court can be reached at tvancour@hotmail.com
*/

import java.awt.*;

/** Generic class handling states of role playing games.
* <p> Design: SDD 3.1.1
* <br> SDD 6.1.1 Detailed design of <i>RolePlayingGame</i> package
*
* @author   Dr. Eric Braude
* @version  0.1
*/

public abstract class RPGame
{
    /** Current state of the game. 
    * <p> Design: SDD 6.1.1 Detailed design of 
    *   <i>RolePlayingGame</i> package
    */
    protected GameState gameStateI;

    /*----------------------------------------------------------------------*\
    ** Constructors
    \*----------------------------------------------------------------------*/

    /** Default Constructor
    */
    public RPGame()
        { super(); }

    /*----------------------------------------------------------------------*\
    ** Own interface
    \*----------------------------------------------------------------------*/

    /** Return the present state of the game.
    * <p> Design:   SDD 5.1.1
    * @return       the current state of the game.
    */
    public GameState getState()
        { return gameStateI; }

    /** Handles event depending on the state the game is in.
    * <p> Design:   SDD 5.1.1
    * <br> SDD 6.1.1 Detailed design of <i>RolePlayingGame</i> package
    *
    * @param        anEventP    The current event being handled.
    */
    public void handleEvent( AWTEvent anEventP )
        { gameStateI.handleEvent( anEventP ); }

    /** Sets the state of the game object.
    * <p> Design:   SDD paragraph 5.1.1
    *
    * @param        aGameStateP     The state to put the game in.
    */
    public void setState( GameState aGameStateP )
    {
        if ( gameStateI != null )       // Let old state (if any)
            gameStateI.exitCleanup();   // shut itself down.

        gameStateI = aGameStateP;       // Switch to new state.
        gameStateI.entryActions();      // Let new state start itself.

        gameStateI.reportState();
    }
}
