package FrameworkRPG.RolePlayingGame;

/* Class Name           : RPGMouseEventListener
* Version information   : Version 0.1
* Date                  : 07/02/1999
* Copyright Notice      : see below
* Edit history:
*   08 Jan 2000     Tom VanCourt    Change to meet coding standards.
*/

/*
    Copyright (C) 2000 Eric J. Braude and Thomas D. Van Court. 
 
    This program is the implementation of the case study specified in 
    "Software Engineering: an Object-Oriented Perspective," Wiley 2001,   
    by Eric J. Braude.

    The program is free software; you can redistribute it and/or modify it 
    under the terms of the GNU General Public License as published by the 
    Free Software Foundation; either version 2 of the License, or any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    For the GNU General Public License, see http://www.gnu.org/copyleft/gpl.txt 
    or write to the Free Software Foundation, Inc., 
    59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Eric Braude can be reached at ebraude@bu.edu and: Boston University,       
    MET Computer Science Department, 808 Commonwealth Avenue, Boston, MA 02215. 
    Tom Van Court can be reached at tvancour@hotmail.com
*/

import java.awt.event.*;

/** The RPGMouseEventListener class handles mouse events.
* <p> Design: SDD 6.1.1 Detailed design of <i>RolePlayingGame</i> package
*
* @author   Dr. Eric Braude
* @version  0.1
*/

public class RPGMouseEventListener implements MouseListener 
{
    /** The game for which this processes mouse events. 
    * <p> Design: SDD 6.1.1 Detailed design of 
    *   <i>RolePlayingGame</i> package
    */
    protected RPGame RPGameI;

    /*----------------------------------------------------------------------*\
    ** Constructors
    \*----------------------------------------------------------------------*/

    /** Default Constructor
    */
    public RPGMouseEventListener() 
        { this(null); }

    /** Constructor 
    *
    * @param        anRPGameP   An RPGame reference.
    */
    public RPGMouseEventListener( RPGame anRPGameP ) 
    { 
        super();
        RPGameI = anRPGameP; 
    }

    /*----------------------------------------------------------------------*\
    ** MouseListener interface
    \*----------------------------------------------------------------------*/

    /** Handles the MouseClicked event.
    *
    * @param        eP      Current event to be handled.
    */
    public void mouseClicked( MouseEvent eP ) 
        { RPGameI.handleEvent(eP); }

    /** Handles the MouseEntered event.
    *
    * @param        eP      Current event to be handled.
    */
    public void mouseEntered( MouseEvent eP ){}

    /** Handles the MouseExited event.
    *
    * @param        eP      Current event to be handled.
    */
    public void mouseExited( MouseEvent eP ){}

    /** Handles the MousePressed event.
    *
    * @param        eP      Current event to be handled.
    */
    public void mousePressed( MouseEvent eP ){}

    /** Handles the MouseReleased event.
    *
    * @param        eP      Current event to be handled.
    */
    public void mouseReleased(MouseEvent eP){}
}
