package FrameworkRPG.RolePlayingGame;

/* Class Name           : GameState
* Version information   : Version 0.1
* Date                  : 07/02/1999
* Copyright Notice      : see below
* Edit history:
*   13 May 2000     Tom VanCourt    Added entryActions, exitCleanup
*   08 Jan 2000     Tom VanCourt    Change to meet coding standards.
*/

/*
    Copyright (C) 2000 Eric J. Braude and Thomas D. Van Court. 
 
    This program is the implementation of the case study specified in 
    "Software Engineering: an Object-Oriented Perspective," Wiley 2001,   
    by Eric J. Braude.

    The program is free software; you can redistribute it and/or modify it 
    under the terms of the GNU General Public License as published by the 
    Free Software Foundation; either version 2 of the License, or any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    For the GNU General Public License, see http://www.gnu.org/copyleft/gpl.txt 
    or write to the Free Software Foundation, Inc., 
    59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Eric Braude can be reached at ebraude@bu.edu and: Boston University,       
    MET Computer Science Department, 808 Commonwealth Avenue, Boston, MA 02215. 
    Tom Van Court can be reached at tvancour@hotmail.com
*/

import java.awt.*;

import FrameworkRPG.Debug;

/** State of role playing game
* <p> Design: SDD 3.1.1
* <br> SDD 6.1.1 Detailed design of <i>RolePlayingGame</i> package
*
* <p> Design issues: <ul>
* <li> entryActions and exitCleanup were added but are not mentioned
*   in the design spec.
* </ul>
*
* @author   Dr. Eric Braude
* @version  0.1
*/

public abstract class GameState
{
    /** Perform any actions that need to happen upon entry into the state.
    */
    public void entryActions(){}

    /** Shut down any state-dependent activities, release
    * any state-dependent resources. This is the last method called
    * before transitioning to another state.
    */
    public void exitCleanup(){}

    /** Reverts to event handling in the particular state.
    * <p> Design: SDD 6.1.1 Detailed design of 
    *   <i>RolePlayingGame</i> package
    *
    * @param        anEventP The current event being handled.
    */
    public void handleEvent( AWTEvent anEventP )
        { Debug.log( this + " handles event " + anEventP ); }

    /** Output the fact that we have transitioned into some state.
    */
    public void reportState()
        { Debug.log( "Transitioned into " + this ); }

    /*----------------------------------------------------------------------*\
    ** java.Object interface
    \*----------------------------------------------------------------------*/

    /** Generate a printable string summarizing the object.
    * Java defines this method as the type-coercion method for
    * converting this object to a String.
    *
    * @return       Printable string representing this object.
    */
    public String toString()
        { return getClass().getName(); }
}
