package FrameworkRPG.GameEnvironment;

/* Class Name           : GameAreaConnection
* Version information   : Version 0.1
* Date                  : 07/02/1999
* Copyright Notice      : see below
* Edit history:
*   03 Feb 2000     Tom VanCourt    Added getOtherGameArea
*   08 Jan 2000     Tom VanCourt    Change to meet coding standards.
*/

/*
    Copyright (C) 2000 Eric J. Braude and Thomas D. Van Court. 
 
    This program is the implementation of the case study specified in 
    "Software Engineering: an Object-Oriented Perspective," Wiley 2001,   
    by Eric J. Braude.

    The program is free software; you can redistribute it and/or modify it 
    under the terms of the GNU General Public License as published by the 
    Free Software Foundation; either version 2 of the License, or any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    For the GNU General Public License, see http://www.gnu.org/copyleft/gpl.txt 
    or write to the Free Software Foundation, Inc., 
    59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Eric Braude can be reached at ebraude@bu.edu and: Boston University,       
    MET Computer Science Department, 808 Commonwealth Avenue, Boston, MA 02215. 
    Tom Van Court can be reached at tvancour@hotmail.com
*/

import java.io.*;

/** Connection between two areas.
* <p>Requirements: SRS 3.2.1.2 <i>Travel</i> use case.
* <br> SRS 3.2.CO
* <p> Design SDD 3.1.3
*
* <p> Design issues: <ul>
* <li> SDD 3.1.3 mandates a <tt>GameLayout</tt> class, for which 
*   no reason arose in implementation.
* </ul>
*
* @author   Dr. Eric Braude
* @version  0.1
*/

public abstract class GameAreaConnection 
{
    /** First of the two areas connected. 
    * <p> Requirement: SRS 3.2.CO.1.1
    * <p> Design: SDD 3.1.3
    */
    private GameArea gameArea1I;

    /** Second of the two areas connected. 
    * <p> Requirement: SRS 3.2.CO.1.1
    * <p> Design: SDD 3.1.3
    */
    private GameArea gameArea2I;

    /*----------------------------------------------------------------------*\
    ** Constructors
    \*----------------------------------------------------------------------*/

    /** Default Constructor, called from <tt>super()</tt> 
    *   in subclass constructors.
    */
    public GameAreaConnection() 
        { this( null, null ); }

    /** Constructor, called from <tt>super()</tt> in subclass constructors.
    *
    * @param        aFirstGameAreaP    The first game area to connect
    *                                  to this game area connection.
    * @param        aSecondGameAreaP   The second game area to connect
    *                                  to this game area connection.
    */
    public GameAreaConnection(GameArea firstGameAreaP, 
        GameArea secondGameAreaP) 
    {
        gameArea1I = firstGameAreaP;
        gameArea2I = secondGameAreaP;
    }

    /*----------------------------------------------------------------------*\
    ** Own interface
    \*----------------------------------------------------------------------*/

    /** Returns the first of the two connected game areas. 
    *
    * @return       The first game area.
    */
    public GameArea getGameArea1() 
        { return gameArea1I; }

    /** Returns the second of the two connected game areas. 
    *
    * @return       The second game area.
    */
    public GameArea getGameArea2() 
        { return gameArea2I; }
        
    /** Returns the other of the two connected game areas. 
    *
    * @param        startAreaP  One connected game area
    * @return                   The other connected game area.
    */
    public GameArea getOtherGameArea( GameArea startAreaP ) 
    {
        return getOtherGameArea( startAreaP.getName() );
    }
    
    /** Returns the other of the two connected game areas. 
    * This is not <tt>synchronized</tt> because it's assumed that
    * no subclass allows changes to either endpoint area. 
    *
    * @param        startAreaP  Name, assumed to be of one conected game area
    * @return                   The other connected game area.
    */
    public GameArea getOtherGameArea( String startAreaP ) 
    {
        // By default, return first area. 
        GameArea returnAreaM = gameArea1I;

        // If we're starting in area 1, then 2 is the other area.
        if( gameArea1I.getName().equalsIgnoreCase( startAreaP ) )   
            returnAreaM = gameArea2I;
            
        return returnAreaM; 
    }
}
